/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.commonmark.internal.blocks;

import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.commonmark.internal.Line;
import org.eclipse.mylyn.wikitext.commonmark.internal.LineSequence;
import org.eclipse.mylyn.wikitext.commonmark.internal.ProcessingContext;
import org.eclipse.mylyn.wikitext.commonmark.internal.SourceBlock;
import org.eclipse.mylyn.wikitext.commonmark.internal.TextSegment;
import org.eclipse.mylyn.wikitext.commonmark.internal.inlines.InlineParser;
import org.eclipse.mylyn.wikitext.parser.Attributes;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.HeadingAttributes;
import org.eclipse.mylyn.wikitext.util.Preconditions;

public class AtxHeaderBlock
extends SourceBlock {
    private static final Pattern PATTERN = Pattern.compile(" {0,3}(#{1,6})(?:[ \t]+?(.+?))??(?:[ \t]+#+)?[ \t]*");

    @Override
    public void process(ProcessingContext context, DocumentBuilder builder, LineSequence lineSequence) {
        Line currentLine = lineSequence.getCurrentLine();
        Matcher matcher = PATTERN.matcher(currentLine.getText());
        Preconditions.checkState((boolean)matcher.matches());
        lineSequence.advance();
        builder.setLocator(currentLine.toLocator());
        int contentOffset = matcher.start(2);
        int contentEnd = matcher.end(2);
        int headingLevel = this.headingLevel(matcher);
        if (contentEnd > contentOffset) {
            Line headerContent = currentLine.segment(contentOffset, contentEnd - contentOffset);
            TextSegment textSegment = new TextSegment(Collections.singletonList(headerContent));
            HeadingAttributes attributes = new HeadingAttributes();
            InlineParser inlineParser = context.getInlineParser();
            String headingText = inlineParser.toStringContent(context, textSegment);
            attributes.setId(context.generateHeadingId(headingLevel, headingText));
            builder.beginHeading(headingLevel, (Attributes)attributes);
            inlineParser.emit(context, builder, textSegment);
            builder.endHeading();
        } else {
            builder.beginHeading(headingLevel, (Attributes)new HeadingAttributes());
            builder.endHeading();
        }
    }

    private int headingLevel(Matcher matcher) {
        return matcher.group(1).length();
    }

    @Override
    public boolean canStart(LineSequence lineSequence) {
        Line line = lineSequence.getCurrentLine();
        return line != null && PATTERN.matcher(line.getText()).matches();
    }
}

