/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.requestfactory.client.impl.messages;

import com.google.gwt.core.client.JsonUtils;
import com.google.gwt.requestfactory.shared.WriteOperation;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestContentData {
    private final Map<WriteOperation, StringBuilder> payloads = new EnumMap<WriteOperation, StringBuilder>(WriteOperation.class);

    public static String flattenKeysToExpressions(Map<String, String> keysToExpressions) {
        if (keysToExpressions.isEmpty()) {
            return "{}";
        }
        StringBuilder flattenedProperties = new StringBuilder();
        for (Map.Entry<String, String> entry : keysToExpressions.entrySet()) {
            flattenedProperties.append(",").append(JsonUtils.escapeValue(entry.getKey())).append(":").append(entry.getValue());
        }
        RequestContentData.capMap(flattenedProperties);
        return flattenedProperties.toString();
    }

    private static void addToMap(Map<WriteOperation, StringBuilder> map, WriteOperation op, String typeToken, Map<String, String> toFlatten) {
        String flattenedProperties = RequestContentData.flattenKeysToExpressions(toFlatten);
        StringBuilder sb = map.get((Object)op);
        if (sb == null) {
            sb = new StringBuilder();
            map.put(op, sb);
        }
        sb.append(",").append("{\"").append(typeToken).append("\":").append(flattenedProperties.toString()).append("}");
    }

    private static void capList(StringBuilder properties) {
        properties.deleteCharAt(0).insert(0, "[").append("]");
    }

    private static void capMap(StringBuilder sb) {
        sb.deleteCharAt(0).insert(0, "{").append("}");
    }

    public void addPersist(String typeToken, Map<String, String> encoded) {
        RequestContentData.addToMap(this.payloads, WriteOperation.PERSIST, typeToken, encoded);
    }

    public void addUpdate(String typeToken, Map<String, String> encoded) {
        RequestContentData.addToMap(this.payloads, WriteOperation.UPDATE, typeToken, encoded);
    }

    public String toJson() {
        LinkedHashMap<String, String> toReturn = new LinkedHashMap<String, String>();
        this.addToReturn(toReturn, WriteOperation.PERSIST);
        this.addToReturn(toReturn, WriteOperation.UPDATE);
        return RequestContentData.flattenKeysToExpressions(toReturn);
    }

    public String toString() {
        return this.toJson();
    }

    private void addToReturn(Map<String, String> toReturn, WriteOperation op) {
        StringBuilder sb = this.payloads.get((Object)op);
        if (sb != null) {
            RequestContentData.capList(sb);
            toReturn.put(op.getUnObfuscatedEnumName(), sb.toString());
        }
    }
}

