/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.commonmark.internal.inlines;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.mylyn.wikitext.commonmark.internal.ProcessingContext;
import org.eclipse.mylyn.wikitext.commonmark.internal.ProcessingContextBuilder;
import org.eclipse.mylyn.wikitext.commonmark.internal.TextSegment;
import org.eclipse.mylyn.wikitext.commonmark.internal.inlines.Cursor;
import org.eclipse.mylyn.wikitext.commonmark.internal.inlines.Inline;
import org.eclipse.mylyn.wikitext.commonmark.internal.inlines.InlinesSubstitution;
import org.eclipse.mylyn.wikitext.commonmark.internal.inlines.SourceSpan;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.builder.EntityReferences;
import org.eclipse.mylyn.wikitext.parser.builder.NoOpDocumentBuilder;

public class InlineParser {
    private final List<SourceSpan> spans;

    InlineParser(SourceSpan ... spans) {
        this(Arrays.asList(spans));
    }

    public InlineParser(List<SourceSpan> spans) {
        this.spans = List.copyOf(spans);
    }

    public void emit(ProcessingContext context, DocumentBuilder builder, TextSegment textSegment) {
        List<Inline> inlines = this.parse(context, textSegment);
        InlineParser.emit(builder, inlines);
    }

    public String toStringContent(ProcessingContext context, TextSegment textSegment) {
        List<Inline> inlines = this.parse(context, textSegment);
        return InlineParser.toStringContent(inlines);
    }

    public static void emit(DocumentBuilder builder, List<Inline> inlines) {
        for (Inline inline : inlines) {
            builder.setLocator(inline.getLocator());
            inline.emit(builder);
        }
    }

    public void createContext(ProcessingContextBuilder contextBuilder, TextSegment textSegment) {
        for (Inline inline : this.parse(contextBuilder.build(), textSegment)) {
            inline.createContext(contextBuilder);
        }
    }

    public List<Inline> parse(ProcessingContext context, TextSegment segment) {
        Cursor cursor = new Cursor(segment);
        ArrayList<Inline> inlines = new ArrayList<Inline>();
        while (cursor.hasChar()) {
            this.consumeOne(context, inlines, cursor);
        }
        return InlineParser.secondPass(inlines);
    }

    static List<Inline> secondPass(List<Inline> inlines) {
        List<Inline> processedInlines = List.copyOf(inlines);
        Optional<Object> substitution = Optional.empty();
        block0: do {
            for (Inline inline : processedInlines) {
                substitution = inline.secondPass(processedInlines);
                if (!substitution.isPresent()) continue;
                processedInlines = ((InlinesSubstitution)substitution.get()).apply(processedInlines);
                continue block0;
            }
        } while (substitution.isPresent());
        return processedInlines;
    }

    static String toStringContent(List<Inline> contents) {
        final StringBuilder stringBuilder = new StringBuilder();
        NoOpDocumentBuilder altDocumentBuilder = new NoOpDocumentBuilder(){

            public void characters(String text) {
                stringBuilder.append(text);
            }

            public void entityReference(String entity) {
                stringBuilder.append(Objects.requireNonNullElse(EntityReferences.instance().equivalentString(entity), ""));
            }
        };
        for (Inline inline : contents) {
            inline.emit((DocumentBuilder)altDocumentBuilder);
        }
        return stringBuilder.toString();
    }

    private void consumeOne(ProcessingContext context, List<Inline> inlines, Cursor cursor) {
        for (SourceSpan span : this.spans) {
            Optional<? extends Inline> inline = span.createInline(cursor);
            if (!inline.isPresent()) continue;
            inline.get().apply(context, inlines, cursor);
            return;
        }
        throw new IllegalStateException();
    }
}

