/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.tests.ui;

import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import junit.framework.TestCase;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.mylyn.commons.sdk.util.UiTestUtil;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.DateRange;
import org.eclipse.mylyn.internal.tasks.core.LocalTask;
import org.eclipse.mylyn.internal.tasks.core.TaskActivityUtil;
import org.eclipse.mylyn.internal.tasks.core.TaskCategory;
import org.eclipse.mylyn.internal.tasks.core.TaskList;
import org.eclipse.mylyn.internal.tasks.ui.AbstractTaskListFilter;
import org.eclipse.mylyn.internal.tasks.ui.TaskWorkingSetFilter;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListInterestFilter;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListView;
import org.eclipse.mylyn.internal.tasks.ui.workingsets.TaskWorkingSetUpdater;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.tests.TaskTestUtil;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.internal.Workbench;

public class TaskListFilterTest
extends TestCase {
    private TaskListView view;
    private Set<AbstractTaskListFilter> previousFilters;
    private AbstractTask taskCompleted;
    private AbstractTask taskIncomplete;
    private AbstractTask taskOverdue;
    private AbstractTask taskDueToday;
    private AbstractTask taskCompletedToday;
    private AbstractTask taskScheduledLastWeek;
    private AbstractTask taskCompleteAndOverdue;
    private TaskList taskList;

    protected void setUp() throws Exception {
        TaskTestUtil.resetTaskListAndRepositories();
        this.view = (TaskListView)TasksUiUtil.openTasksViewInActivePerspective();
        TaskListFilterTest.assertNotNull((Object)this.view);
        this.previousFilters = this.view.getFilters();
        this.view.clearFilters();
        this.taskList = TasksUiPlugin.getTaskList();
        this.taskCompleted = new LocalTask("1", "completed");
        this.taskCompleted.setCompletionDate(TaskActivityUtil.snapForwardNumDays((Calendar)Calendar.getInstance(), (int)-1).getTime());
        this.taskList.addTask((ITask)this.taskCompleted);
        this.taskIncomplete = new LocalTask("2", "t-incomplete");
        this.taskList.addTask((ITask)this.taskIncomplete);
        this.taskOverdue = new LocalTask("3", "t-overdue");
        this.taskOverdue.setScheduledForDate((DateRange)TaskActivityUtil.getCurrentWeek().getToday().previous());
        this.taskList.addTask((ITask)this.taskOverdue);
        this.taskDueToday = new LocalTask("4", "t-today");
        this.taskDueToday.setScheduledForDate((DateRange)TaskActivityUtil.getCurrentWeek().getToday());
        this.taskList.addTask((ITask)this.taskDueToday);
        this.taskCompletedToday = new LocalTask("5", "t-donetoday");
        this.taskCompletedToday.setScheduledForDate((DateRange)TaskActivityUtil.getCurrentWeek().getToday());
        this.taskCompletedToday.setCompletionDate(new Date());
        this.taskList.addTask((ITask)this.taskCompletedToday);
        this.taskScheduledLastWeek = new LocalTask("6", "t-scheduledLastWeek");
        this.taskList.addTask((ITask)this.taskScheduledLastWeek);
        TasksUiPlugin.getTaskActivityManager().setScheduledFor(this.taskScheduledLastWeek, (DateRange)TaskActivityUtil.getCurrentWeek().previous());
        this.taskCompleteAndOverdue = new LocalTask("7", "t-completeandoverdue");
        this.taskList.addTask((ITask)this.taskCompleteAndOverdue);
        Calendar cal = TaskActivityUtil.getCalendar();
        cal.add(5, -1);
        TasksUiPlugin.getTaskActivityManager().setDueDate((ITask)this.taskCompleteAndOverdue, cal.getTime());
        this.taskCompleteAndOverdue.setCompletionDate(cal.getTime());
    }

    protected void tearDown() throws Exception {
        TaskWorkingSetUpdater.applyWorkingSetsToAllWindows(new HashSet(0));
        this.view.clearFilters();
        for (AbstractTaskListFilter filter : this.previousFilters) {
            this.view.addFilter(filter);
        }
    }

    public void testSearchScheduledWorkingSet() throws InterruptedException {
        TaskCategory category = new TaskCategory("category");
        this.taskList.addCategory(category);
        this.taskList.addTask((ITask)this.taskOverdue, (AbstractTaskContainer)category);
        this.taskList.addTask((ITask)this.taskIncomplete, (AbstractTaskContainer)category);
        this.view.getViewer().refresh();
        this.view.getViewer().expandAll();
        List items = UiTestUtil.getAllData((Tree)this.view.getViewer().getTree());
        TaskListFilterTest.assertTrue((boolean)items.contains(this.taskCompleted));
        TaskListFilterTest.assertTrue((boolean)items.contains(this.taskOverdue));
        IWorkingSetManager workingSetManager = Workbench.getInstance().getWorkingSetManager();
        IWorkingSet workingSet = workingSetManager.createWorkingSet("Task Working Set", new IAdaptable[]{category});
        workingSet.setId(TaskWorkingSetUpdater.ID_TASK_WORKING_SET);
        TaskListFilterTest.assertTrue((boolean)Arrays.asList(workingSet.getElements()).contains(category));
        workingSetManager.addWorkingSet(workingSet);
        TaskWorkingSetFilter workingSetFilter = new TaskWorkingSetFilter();
        this.view.addFilter((AbstractTaskListFilter)workingSetFilter);
        HashSet<IWorkingSet> workingSets = new HashSet<IWorkingSet>(1);
        workingSets.add(workingSet);
        TaskWorkingSetUpdater.applyWorkingSetsToAllWindows(workingSets);
        this.view.getFilteredTree().setFilterText("over");
        this.view.getFilteredTree().getRefreshPolicy().internalForceRefresh();
        items = UiTestUtil.getAllData((Tree)this.view.getViewer().getTree());
        TaskListFilterTest.assertFalse((boolean)items.contains(this.taskCompleted));
        TaskListFilterTest.assertTrue((boolean)items.contains(this.taskOverdue));
        workingSets = new HashSet(0);
        this.view.removeFilter((AbstractTaskListFilter)workingSetFilter);
        TaskWorkingSetUpdater.applyWorkingSetsToAllWindows(workingSets);
        this.taskList.removeFromContainer((AbstractTaskContainer)category, (ITask)this.taskOverdue);
        this.taskList.removeFromContainer((AbstractTaskContainer)category, (ITask)this.taskIncomplete);
        this.view.getFilteredTree().setFilterText("");
        this.view.getFilteredTree().getRefreshPolicy().internalForceRefresh();
    }

    public void testInterestFilter() {
        TaskListInterestFilter interestFilter = new TaskListInterestFilter();
        this.view.addFilter((AbstractTaskListFilter)interestFilter);
        this.view.getViewer().refresh();
        this.view.getViewer().expandAll();
        List items = UiTestUtil.getAllData((Tree)this.view.getViewer().getTree());
        TaskListFilterTest.assertFalse((boolean)items.contains(this.taskCompleted));
        TaskListFilterTest.assertFalse((boolean)items.contains(this.taskIncomplete));
        TaskListFilterTest.assertTrue((boolean)items.contains(this.taskOverdue));
        TaskListFilterTest.assertTrue((boolean)items.contains(this.taskDueToday));
        TaskListFilterTest.assertTrue((boolean)items.contains(this.taskCompletedToday));
        TaskListFilterTest.assertTrue((boolean)items.contains(this.taskScheduledLastWeek));
        TaskListFilterTest.assertFalse((boolean)items.contains(this.taskCompleteAndOverdue));
        this.view.removeFilter((AbstractTaskListFilter)interestFilter);
    }

    public void testNoFilters() {
        TaskListFilterTest.assertEquals((String)("should have working set filter and orphan/archive filter: " + String.valueOf(this.view.getFilters())), (int)2, (int)this.view.getFilters().size());
        this.view.getViewer().refresh();
        TaskListFilterTest.assertEquals((String)("should only have Uncategorized folder present in stock task list: " + String.valueOf(this.view.getViewer().getTree().getItems())), (int)1, (int)this.view.getViewer().getTree().getItemCount());
    }
}

