/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable;

import org.eclipse.rap.json.JsonObject;
import org.eclipse.rap.json.JsonValue;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetUtil;
import org.eclipse.rap.rwt.internal.protocol.ProtocolUtil;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.events.EventLCAUtil;
import org.eclipse.swt.internal.widgets.canvaskit.CanvasOperationHandler;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Widget;

public class NatTableOperationHandler
extends CanvasOperationHandler {
    private final Canvas canvas;

    public NatTableOperationHandler(Canvas canvas) {
        super(canvas);
        this.canvas = canvas;
    }

    public void handleNotify(String eventName, JsonObject properties) {
        if ("MouseDown".equals(eventName)) {
            this.handleNotifyMouseDown(properties);
        } else if ("MouseDoubleClick".equals(eventName)) {
            this.handleNotifyMouseDoubleClick(properties);
        } else if ("MouseUp".equals(eventName)) {
            this.handleNotifyMouseUp(properties);
        } else if ("MouseWheel".equals(eventName)) {
            this.handleNotifyMouseWheel(properties);
        } else if ("MouseMove".equals(eventName)) {
            this.handleNotifyMouseMove(properties);
        } else {
            this.handleNotify((Control)this.canvas, eventName, properties);
        }
    }

    public void handleNotifyMouseDown(JsonObject properties) {
        Event event = NatTableOperationHandler.createMouseEvent(3, (Control)this.canvas, properties);
        if (this.allowMouseEvent(this.canvas, event.x, event.y)) {
            this.canvas.notifyListeners(event.type, event);
        }
    }

    public void handleNotifyMouseDoubleClick(JsonObject properties) {
        Event event = NatTableOperationHandler.createMouseEvent(8, (Control)this.canvas, properties);
        if (this.allowMouseEvent(this.canvas, event.x, event.y)) {
            this.canvas.notifyListeners(event.type, event);
        }
    }

    public void handleNotifyMouseUp(JsonObject properties) {
        Event event = NatTableOperationHandler.createMouseEvent(4, (Control)this.canvas, properties);
        if (this.allowMouseEvent(this.canvas, event.x, event.y)) {
            this.canvas.notifyListeners(event.type, event);
        }
    }

    public void handleNotifyMouseWheel(JsonObject properties) {
        Event event = NatTableOperationHandler.createMouseEvent(37, (Control)this.canvas, properties);
        if (this.allowMouseEvent(this.canvas, event.x, event.y)) {
            event.count = properties.get("count").asInt();
            this.canvas.notifyListeners(event.type, event);
        }
    }

    public void handleNotifyMouseMove(JsonObject properties) {
        Event event = NatTableOperationHandler.createMouseEvent(5, (Control)this.canvas, properties);
        if (this.allowMouseEvent(this.canvas, event.x, event.y)) {
            this.canvas.notifyListeners(event.type, event);
        }
    }

    static Event createMouseEvent(int eventType, Control control, JsonObject properties) {
        Event event = new Event();
        event.type = eventType;
        event.widget = control;
        event.button = properties.get("button").asInt();
        int x = properties.get("x").asInt();
        int y = properties.get("y").asInt();
        Point point = control.getDisplay().map(null, control, x, y);
        event.x = point.x;
        event.y = point.y;
        event.time = properties.get("time").asInt();
        event.stateMask = NatTableOperationHandler.readStateMask((JsonObject)properties);
        switch (eventType) {
            case 4: {
                event.stateMask |= EventLCAUtil.translateButton((int)event.button);
            }
        }
        event.count = NatTableOperationHandler.determineCount(eventType, control);
        JsonValue data = properties.get("data");
        if (data != null) {
            event.data = data.asString();
        }
        return event;
    }

    private static int determineCount(int eventType, Control control) {
        if (eventType == 8 || ProtocolUtil.wasEventSent((String)WidgetUtil.getId((Widget)control), (String)"MouseDoubleClick")) {
            return 2;
        }
        return 1;
    }

    protected boolean allowMouseEvent(Canvas control, int x, int y) {
        Point size = control.getSize();
        int borderWidth = control.getBorderWidth();
        Rectangle outerBounds = new Rectangle(-borderWidth, -borderWidth, size.x, size.y);
        Rectangle innerBounds = new Rectangle(0, 0, size.x - 2 * borderWidth, size.y - 2 * borderWidth);
        return !outerBounds.contains(x, y) || innerBounds.contains(x, y);
    }
}

