/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.hideshow;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.impl.factory.primitive.IntSets;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.data.IRowDataProvider;
import org.eclipse.nebula.widgets.nattable.data.IRowIdAccessor;
import org.eclipse.nebula.widgets.nattable.data.convert.IDisplayConverter;
import org.eclipse.nebula.widgets.nattable.hideshow.AbstractRowHideShowLayer;
import org.eclipse.nebula.widgets.nattable.hideshow.IRowHideShowLayer;
import org.eclipse.nebula.widgets.nattable.hideshow.command.HideRowByIndexCommandHandler;
import org.eclipse.nebula.widgets.nattable.hideshow.command.MultiRowHideCommandHandler;
import org.eclipse.nebula.widgets.nattable.hideshow.command.MultiRowShowCommandHandler;
import org.eclipse.nebula.widgets.nattable.hideshow.command.RowHideCommandHandler;
import org.eclipse.nebula.widgets.nattable.hideshow.command.RowPositionHideCommandHandler;
import org.eclipse.nebula.widgets.nattable.hideshow.command.RowShowCommandHandler;
import org.eclipse.nebula.widgets.nattable.hideshow.command.ShowAllRowsCommandHandler;
import org.eclipse.nebula.widgets.nattable.hideshow.event.HideRowPositionsEvent;
import org.eclipse.nebula.widgets.nattable.hideshow.event.ShowRowPositionsEvent;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.sort.command.SortColumnCommand;

public class RowIdHideShowLayer<T>
extends AbstractRowHideShowLayer
implements IRowHideShowLayer {
    public static final String PERSISTENCE_KEY_HIDDEN_ROW_IDS = ".hiddenRowIDs";
    protected final IRowDataProvider<T> rowDataProvider;
    protected final IRowIdAccessor<T> rowIdAccessor;
    protected Map<Serializable, T> hiddenRows = new TreeMap<Serializable, T>();
    protected IDisplayConverter idConverter;

    public RowIdHideShowLayer(IUniqueIndexLayer underlyingLayer, IRowDataProvider<T> rowDataProvider, IRowIdAccessor<T> rowIdAccessor) {
        super(underlyingLayer);
        this.rowDataProvider = rowDataProvider;
        this.rowIdAccessor = rowIdAccessor;
        this.registerCommandHandler(new MultiRowHideCommandHandler(this));
        this.registerCommandHandler(new RowHideCommandHandler(this));
        this.registerCommandHandler(new ShowAllRowsCommandHandler(this));
        this.registerCommandHandler(new MultiRowShowCommandHandler(this));
        this.registerCommandHandler(new RowPositionHideCommandHandler(this));
        this.registerCommandHandler(new RowShowCommandHandler(this));
        this.registerCommandHandler(new HideRowByIndexCommandHandler(this));
    }

    @Override
    public boolean doCommand(ILayerCommand command) {
        if (command instanceof SortColumnCommand) {
            this.invalidateCache();
        }
        return super.doCommand(command);
    }

    @Override
    public void saveState(String prefix, Properties properties) {
        if (this.hiddenRows.size() > 0) {
            StringBuilder strBuilder = new StringBuilder();
            for (Serializable id : this.hiddenRows.keySet()) {
                if (this.idConverter != null) {
                    strBuilder.append(this.idConverter.canonicalToDisplayValue(id));
                } else {
                    strBuilder.append(id.toString());
                }
                strBuilder.append(",");
            }
            properties.setProperty(String.valueOf(prefix) + PERSISTENCE_KEY_HIDDEN_ROW_IDS, strBuilder.toString());
        }
        super.saveState(prefix, properties);
    }

    @Override
    public void loadState(String prefix, Properties properties) {
        this.hiddenRows.clear();
        String property = properties.getProperty(String.valueOf(prefix) + PERSISTENCE_KEY_HIDDEN_ROW_IDS);
        if (property != null) {
            StringTokenizer tok = new StringTokenizer(property, ",");
            HashSet<Object> ids = new HashSet<Object>();
            while (tok.hasMoreTokens()) {
                String id = tok.nextToken();
                if (this.idConverter != null) {
                    ids.add((Serializable)this.idConverter.displayToCanonicalValue(id));
                    continue;
                }
                ids.add(id);
            }
            int row = 0;
            while (row < this.rowDataProvider.getRowCount()) {
                T rowObject = this.rowDataProvider.getRowObject(row);
                Serializable rowId = this.rowIdAccessor.getRowId(rowObject);
                if (ids.contains(rowId)) {
                    ids.remove(rowId);
                    this.hiddenRows.put(rowId, rowObject);
                }
                if (ids.isEmpty()) break;
                ++row;
            }
        }
        super.loadState(prefix, properties);
    }

    @Override
    public LabelStack getConfigLabelsByPosition(int columnPosition, int rowPosition) {
        int downRowIndex;
        LabelStack configLabels = super.getConfigLabelsByPosition(columnPosition, rowPosition);
        int underlyingPosition = this.localToUnderlyingRowPosition(rowPosition);
        int upRowIndex = this.underlyingLayer.getRowIndexByPosition(underlyingPosition - 1);
        if (this.isRowIndexHidden(upRowIndex)) {
            configLabels.addLabel("ROW_TOP_HIDDEN");
        }
        if (this.isRowIndexHidden(downRowIndex = this.underlyingLayer.getRowIndexByPosition(underlyingPosition + 1))) {
            configLabels.addLabel("ROW_BOTTOM_HIDDEN");
        }
        return configLabels;
    }

    @Override
    public int getRowCount() {
        return this.underlyingLayer.getRowCount() - this.hiddenRows.size();
    }

    @Override
    public boolean isRowIndexHidden(int rowIndex) {
        if (rowIndex >= 0) {
            T rowObject = this.getRowObjectByIndex(rowIndex);
            return this.hiddenRows.containsKey(this.rowIdAccessor.getRowId(rowObject));
        }
        return false;
    }

    @Override
    public Collection<Integer> getHiddenRowIndexes() {
        return this.hiddenRows.entrySet().stream().map(entry -> this.getRowIndexById((Serializable)entry.getKey())).collect(Collectors.toSet());
    }

    @Override
    public int[] getHiddenRowIndexesArray() {
        return this.hiddenRows.entrySet().stream().mapToInt(entry -> this.getRowIndexById((Serializable)entry.getKey())).sorted().toArray();
    }

    @Override
    public boolean hasHiddenRows() {
        return !this.hiddenRows.isEmpty();
    }

    @Override
    public void hideRowPositions(int ... rowPositions) {
        HashMap<Serializable, T> toHide = new HashMap<Serializable, T>();
        int[] nArray = rowPositions;
        int n = rowPositions.length;
        int n2 = 0;
        while (n2 < n) {
            int rowPosition = nArray[n2];
            T rowObject = this.getRowObjectByPosition(rowPosition);
            toHide.put(this.rowIdAccessor.getRowId(rowObject), rowObject);
            ++n2;
        }
        this.hiddenRows.putAll(toHide);
        this.invalidateCache();
        this.fireLayerEvent(new HideRowPositionsEvent((ILayer)this, rowPositions));
    }

    @Override
    public void hideRowPositions(Collection<Integer> rowPositions) {
        this.hideRowPositions(rowPositions.stream().mapToInt(Integer::intValue).toArray());
    }

    @Override
    public void hideRowIndexes(int ... rowIndexes) {
        MutableIntSet rowPositions = IntSets.mutable.empty();
        int[] nArray = rowIndexes;
        int n = rowIndexes.length;
        int n2 = 0;
        while (n2 < n) {
            int rowIndex = nArray[n2];
            rowPositions.add(this.getRowPositionByIndex(rowIndex));
            T rowObject = this.getRowObjectByIndex(rowIndex);
            this.hiddenRows.put(this.rowIdAccessor.getRowId(rowObject), rowObject);
            ++n2;
        }
        this.invalidateCache();
        this.fireLayerEvent(new HideRowPositionsEvent((ILayer)this, rowPositions.toArray()));
    }

    @Override
    public void hideRowIndexes(Collection<Integer> rowIndexes) {
        this.hideRowIndexes(rowIndexes.stream().mapToInt(Integer::intValue).toArray());
    }

    @Override
    public void showRowIndexes(int ... rowIndexes) {
        int[] nArray = rowIndexes;
        int n = rowIndexes.length;
        int n2 = 0;
        while (n2 < n) {
            int rowIndex = nArray[n2];
            T rowObject = this.getRowObjectByIndex(rowIndex);
            this.hiddenRows.remove(this.rowIdAccessor.getRowId(rowObject));
            ++n2;
        }
        this.invalidateCache();
        this.fireLayerEvent(new ShowRowPositionsEvent((ILayer)this, this.getRowPositionsByIndexes(rowIndexes)));
    }

    @Override
    public void showRowIndexes(Collection<Integer> rowIndexes) {
        this.showRowIndexes(rowIndexes.stream().mapToInt(Integer::intValue).toArray());
    }

    @Override
    public void showRowPosition(int rowPosition, boolean showToTop, boolean showAll) {
        MutableIntSet rowIndexes = IntSets.mutable.empty();
        int underlyingPosition = this.localToUnderlyingRowPosition(rowPosition);
        if (showToTop) {
            int topRowIndex = this.underlyingLayer.getRowIndexByPosition(underlyingPosition - 1);
            if (showAll) {
                int move = 1;
                while (this.isRowIndexHidden(topRowIndex)) {
                    rowIndexes.add(topRowIndex);
                    topRowIndex = this.underlyingLayer.getRowIndexByPosition(underlyingPosition - ++move);
                }
            } else if (this.isRowIndexHidden(topRowIndex)) {
                rowIndexes.add(topRowIndex);
            }
        } else {
            int bottomRowIndex = this.underlyingLayer.getRowIndexByPosition(underlyingPosition + 1);
            if (showAll) {
                int move = 1;
                while (this.isRowIndexHidden(bottomRowIndex)) {
                    rowIndexes.add(bottomRowIndex);
                    bottomRowIndex = this.underlyingLayer.getRowIndexByPosition(underlyingPosition + ++move);
                }
            } else if (this.isRowIndexHidden(bottomRowIndex)) {
                rowIndexes.add(bottomRowIndex);
            }
        }
        if (!rowIndexes.isEmpty()) {
            this.showRowIndexes(rowIndexes.toArray());
        }
    }

    @Override
    public void showAllRows() {
        int[] hidden = this.getHiddenRowIndexesArray();
        this.hiddenRows.clear();
        this.invalidateCache();
        this.fireLayerEvent(new ShowRowPositionsEvent((ILayer)this, hidden));
    }

    @Override
    public Collection<String> getProvidedLabels() {
        Collection<String> result = super.getProvidedLabels();
        result.add("ROW_TOP_HIDDEN");
        result.add("ROW_BOTTOM_HIDDEN");
        return result;
    }

    private T getRowObjectByPosition(int rowPosition) {
        int rowIndex = this.getRowIndexByPosition(rowPosition);
        return this.getRowObjectByIndex(rowIndex);
    }

    private T getRowObjectByIndex(int rowIndex) {
        if (rowIndex >= 0) {
            try {
                return this.rowDataProvider.getRowObject(rowIndex);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private int getRowIndexById(Serializable rowId) {
        T rowObject = this.hiddenRows.get(rowId);
        int rowIndex = this.rowDataProvider.indexOfRowObject(rowObject);
        if (rowIndex == -1) {
            return -1;
        }
        return rowIndex;
    }

    public IDisplayConverter getIdConverter() {
        return this.idConverter;
    }

    public void setIdConverter(IDisplayConverter idConverter) {
        this.idConverter = idConverter;
    }
}

