/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.filterrow.combobox;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.nebula.widgets.nattable.Messages;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.style.HorizontalAlignmentEnum;
import org.eclipse.nebula.widgets.nattable.style.IStyle;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.nebula.widgets.nattable.widget.NatCombo;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class FilterNatCombo
extends NatCombo {
    protected CheckboxTableViewer selectAllItemViewer;
    private String filterText;
    private List<ICheckStateListener> checkStateListener = new ArrayList<ICheckStateListener>();
    private Runnable filterModifyAction;
    private boolean filterActive = false;
    private int baseStyle;
    protected CheckboxTableViewer addToFilterItemViewer;
    protected String[] initialSelection;

    public FilterNatCombo(Composite parent, IStyle cellStyle, int style) {
        this(parent, cellStyle, 5, style, GUIHelper.getImage("down_2"));
    }

    public FilterNatCombo(Composite parent, IStyle cellStyle, int maxVisibleItems, int style) {
        this(parent, cellStyle, maxVisibleItems, style, GUIHelper.getImage("down_2"));
    }

    public FilterNatCombo(Composite parent, IStyle cellStyle, int maxVisibleItems, int style, boolean showDropdownFilter) {
        this(parent, cellStyle, maxVisibleItems, style, GUIHelper.getImage("down_2"), showDropdownFilter);
    }

    public FilterNatCombo(Composite parent, IStyle cellStyle, int maxVisibleItems, int style, Image iconImage) {
        this(parent, cellStyle, maxVisibleItems, style, iconImage, false);
    }

    public FilterNatCombo(Composite parent, IStyle cellStyle, int maxVisibleItems, int style, Image iconImage, boolean showDropdownFilter) {
        super(parent, cellStyle, maxVisibleItems, style, iconImage, showDropdownFilter);
    }

    @Override
    protected void calculateBounds() {
        if (this.dropdownShell != null && !this.dropdownShell.isDisposed()) {
            Point size = this.getSize();
            int gridLineAdjustment = this.dropdownTable.getGridLineWidth() * 2;
            int listHeight = this.getVisibleItemCount() * this.dropdownTable.getItemHeight() + gridLineAdjustment;
            this.dropdownTable.getColumn(0).pack();
            this.selectAllItemViewer.getTable().getColumn(0).pack();
            int listWidth = Math.max(this.dropdownTable.computeSize((int)-1, (int)listHeight, (boolean)true).x, size.x);
            int selectAllViewerHeight = this.selectAllItemViewer.getTable().getItemHeight();
            listWidth = Math.max(this.selectAllItemViewer.getTable().computeSize((int)-1, (int)selectAllViewerHeight, (boolean)true).x, listWidth);
            int addViewerHeight = 0;
            if (this.addToFilterItemViewer != null && this.addToFilterItemViewer.getTable().isVisible()) {
                this.addToFilterItemViewer.getTable().getColumn(0).pack();
                addViewerHeight = this.addToFilterItemViewer.getTable().getItemHeight();
                listWidth = Math.max(this.addToFilterItemViewer.getTable().computeSize((int)-1, (int)addViewerHeight, (boolean)true).x, listWidth);
            }
            Point textPosition = this.text.toDisplay(this.text.getLocation());
            int filterTextBoxHeight = this.showDropdownFilter ? this.filterBox.computeSize((int)-1, (int)-1).y : 0;
            this.dropdownShell.setBounds(textPosition.x, textPosition.y + this.text.getBounds().height, listWidth + this.dropdownTable.getGridLineWidth() * 2, listHeight + selectAllViewerHeight + addViewerHeight + filterTextBoxHeight);
            this.calculateColumnWidth();
        }
    }

    @Override
    protected void calculateColumnWidth() {
        super.calculateColumnWidth();
        this.selectAllItemViewer.getTable().getColumn(0).setWidth(this.dropdownTable.getColumn(0).getWidth());
        if (this.addToFilterItemViewer != null) {
            this.addToFilterItemViewer.getTable().getColumn(0).setWidth(this.dropdownTable.getColumn(0).getWidth());
        }
    }

    @Override
    protected void createDropdownControl(int style) {
        super.createDropdownControl(style);
        this.baseStyle = style;
        int dropdownListStyle = style | 0x10 | HorizontalAlignmentEnum.getSWTStyle(this.cellStyle) | 0x10000;
        this.selectAllItemViewer = CheckboxTableViewer.newCheckList((Composite)this.dropdownShell, (int)dropdownListStyle);
        new TableColumn(this.selectAllItemViewer.getTable(), 0);
        FormData data = new FormData();
        data.top = this.showDropdownFilter ? new FormAttachment((Control)this.filterBox, 0, 1024) : new FormAttachment((Control)this.dropdownShell, 0, 128);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        this.selectAllItemViewer.getTable().setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment(this.selectAllItemViewer.getControl(), 0, 1024);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        data.bottom = new FormAttachment(100);
        this.dropdownTable.setLayoutData((Object)data);
        this.selectAllItemViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.selectAllItemViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }
        });
        ArrayList<String> input = new ArrayList<String>();
        input.add(this.getSelectAllLabel());
        this.selectAllItemViewer.setInput(input);
        this.selectAllItemViewer.getTable().setBackground(this.cellStyle.getAttributeValue(CellStyleAttributes.BACKGROUND_COLOR));
        this.selectAllItemViewer.getTable().setForeground(this.cellStyle.getAttributeValue(CellStyleAttributes.FOREGROUND_COLOR));
        this.selectAllItemViewer.getTable().setFont(this.cellStyle.getAttributeValue(CellStyleAttributes.FONT));
        this.selectAllItemViewer.getTable().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                FilterNatCombo.this.showDropdownControl();
            }
        });
        this.selectAllItemViewer.addCheckStateListener(event -> {
            int n;
            boolean grayed;
            boolean performCheck = event.getChecked();
            boolean bl = grayed = this.getSelectionCount() < this.itemList.size();
            if (!performCheck && grayed) {
                boolean allVisibleUnchecked = true;
                TableItem[] tableItemArray = this.dropdownTable.getItems();
                int n2 = tableItemArray.length;
                n = 0;
                while (n < n2) {
                    TableItem tableItem = tableItemArray[n];
                    if (tableItem.getChecked()) {
                        allVisibleUnchecked = false;
                    }
                    ++n;
                }
                if (allVisibleUnchecked) {
                    performCheck = true;
                }
            }
            TableItem[] tableItemArray = this.dropdownTable.getItems();
            n = tableItemArray.length;
            int n3 = 0;
            while (n3 < n) {
                TableItem tableItem = tableItemArray[n3];
                tableItem.setChecked(performCheck);
                ++n3;
            }
            if (this.addToFilterItemViewer != null) {
                this.updateAddToFilterVisibility(null);
            }
            tableItemArray = this.dropdownTable.getItems();
            n = tableItemArray.length;
            n3 = 0;
            while (n3 < n) {
                TableItem tableItem = tableItemArray[n3];
                this.selectionStateMap.put(tableItem.getText(), performCheck);
                ++n3;
            }
            this.updateTextControl(!this.multiselect);
            this.selectAllItemViewer.refresh();
        });
        for (ICheckStateListener l : this.checkStateListener) {
            this.selectAllItemViewer.addCheckStateListener(l);
        }
        this.selectAllItemViewer.setCheckStateProvider(new ICheckStateProvider(){

            public boolean isGrayed(Object element) {
                TableItem[] tableItemArray = FilterNatCombo.this.dropdownTable.getItems();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem tableItem = tableItemArray[n2];
                    if (!tableItem.getChecked()) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }

            public boolean isChecked(Object element) {
                TableItem[] tableItemArray = FilterNatCombo.this.dropdownTable.getItems();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem tableItem = tableItemArray[n2];
                    if (tableItem.getChecked()) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }
        });
        this.dropdownTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FilterNatCombo.this.selectAllItemViewer.refresh();
            }
        });
    }

    @Override
    protected void setDropdownSelection(String[] selection) {
        super.setDropdownSelection(selection);
        if (this.selectAllItemViewer != null) {
            this.selectAllItemViewer.refresh();
        }
    }

    public void addCheckStateListener(ICheckStateListener listener) {
        if (listener != null) {
            if (this.selectAllItemViewer != null) {
                this.selectAllItemViewer.addCheckStateListener(listener);
            }
            this.checkStateListener.add(listener);
        }
    }

    @Override
    protected void updateTextControl(boolean hideDropdown) {
        this.filterText = this.getTransformedTextForSelection();
        if (hideDropdown) {
            this.hideDropdownControl();
        }
    }

    @Override
    public int getSelectionIndex() {
        if (!this.getDropdownTable().isDisposed()) {
            return this.getDropdownTable().getSelectionIndex();
        }
        if (this.filterText != null && this.filterText.length() > 0) {
            return this.itemList.indexOf(this.filterText);
        }
        return -1;
    }

    @Override
    public String[] getSelection() {
        String[] result = this.getTransformedSelection();
        if (result == null || result.length == 0 && this.filterText != null) {
            result = this.getTextAsArray();
        }
        return result;
    }

    @Override
    public void setSelection(String[] items) {
        String textValue = "";
        if (items != null) {
            if (!this.getDropdownTable().isDisposed()) {
                this.setDropdownSelection(items);
                textValue = this.freeEdit && this.getDropdownTable().getSelectionCount() == 0 ? this.getTransformedText(items) : this.getTransformedTextForSelection();
            } else {
                textValue = this.getTransformedText(items);
            }
        }
        this.filterText = textValue;
        if (this.filterModifyAction != null && this.selectAllItemViewer != null && this.selectionStateMap.entrySet().stream().anyMatch(entry -> (Boolean)entry.getValue() == false) && this.addToFilterItemViewer == null) {
            this.initialSelection = this.getSelection();
            this.createAddToFilterItemViewer();
        }
    }

    protected void createAddToFilterItemViewer() {
        int dropdownListStyle = this.baseStyle | 0x10 | HorizontalAlignmentEnum.getSWTStyle(this.cellStyle) | 0x10000;
        this.addToFilterItemViewer = CheckboxTableViewer.newCheckList((Composite)this.dropdownShell, (int)dropdownListStyle);
        new TableColumn(this.addToFilterItemViewer.getTable(), 0);
        this.addToFilterItemViewer.getTable().addListener(11, event -> this.calculateColumnWidth());
        FormData data = new FormData();
        data.top = new FormAttachment(this.selectAllItemViewer.getControl(), 0, 1024);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        this.addToFilterItemViewer.getTable().setLayoutData((Object)data);
        this.addToFilterItemViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.addToFilterItemViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }
        });
        ArrayList<String> input = new ArrayList<String>();
        input.add(this.getAddToFilterLabel());
        this.addToFilterItemViewer.setInput(input);
        this.addToFilterItemViewer.getTable().setBackground(this.cellStyle.getAttributeValue(CellStyleAttributes.BACKGROUND_COLOR));
        this.addToFilterItemViewer.getTable().setForeground(this.cellStyle.getAttributeValue(CellStyleAttributes.FOREGROUND_COLOR));
        this.addToFilterItemViewer.getTable().setFont(this.cellStyle.getAttributeValue(CellStyleAttributes.FONT));
        this.addToFilterItemViewer.getTable().setVisible(this.filterActive);
        this.addToFilterItemViewer.getTable().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                FilterNatCombo.this.showDropdownControl();
            }
        });
        this.addToFilterItemViewer.addCheckStateListener(event -> {
            boolean performCheck = event.getChecked();
            if (performCheck) {
                TableItem[] tableItemArray = this.dropdownTableViewer.getTable().getItems();
                int i = 0;
                while (i < tableItemArray.length) {
                    TableItem item = tableItemArray[i];
                    this.selectionStateMap.put(item.getText(), item.getChecked());
                    ++i;
                }
            } else {
                for (Map.Entry entry : this.selectionStateMap.entrySet()) {
                    entry.setValue(Boolean.FALSE);
                }
                String[] stringArray = this.initialSelection;
                int n = this.initialSelection.length;
                int n2 = 0;
                while (n2 < n) {
                    String string = stringArray[n2];
                    this.selectionStateMap.put(string, Boolean.TRUE);
                    ++n2;
                }
            }
            if (this.filterModifyAction != null) {
                this.filterActive = false;
                String[] stringArray = this.initialSelection;
                this.filterModifyAction.run();
                this.initialSelection = stringArray;
                this.filterActive = true;
            }
            this.selectAllItemViewer.refresh();
        });
        this.dropdownTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean selected;
                boolean bl = selected = e.detail != 32;
                if (!selected) {
                    TableItem clickedItem = (TableItem)e.item;
                    FilterNatCombo.this.updateAddToFilterVisibility(clickedItem);
                }
            }
        });
    }

    protected void updateAddToFilterVisibility(TableItem clickedItem) {
        if (this.initialSelection != null && this.filterActive) {
            boolean selectionChanged = false;
            TableItem[] tableItemArray = this.getDropdownTable().getItems();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                if (item.getChecked() && !Arrays.stream(this.initialSelection).anyMatch(s -> s.equals(item.getText())) || !item.getChecked() && Arrays.stream(this.initialSelection).anyMatch(s -> s.equals(item.getText()))) {
                    selectionChanged = true;
                }
                ++n2;
            }
            if (this.addToFilterItemViewer.getCheckedElements().length <= 0 || selectionChanged) {
                this.addToFilterItemViewer.getTable().setVisible(selectionChanged);
                ((FormData)this.dropdownTable.getLayoutData()).top = new FormAttachment(selectionChanged ? this.addToFilterItemViewer.getControl() : this.selectAllItemViewer.getControl(), 0, 1024);
            }
            this.resetAddToFilter(clickedItem);
            this.calculateBounds();
            this.selectAllItemViewer.refresh();
        }
    }

    protected void resetAddToFilter(TableItem clickedItem) {
        if (this.addToFilterItemViewer.getCheckedElements().length > 0) {
            this.addToFilterItemViewer.setAllChecked(false);
            if (clickedItem != null) {
                if (!clickedItem.getChecked()) {
                    this.selectionStateMap.put(clickedItem.getText(), Boolean.TRUE);
                } else {
                    this.selectionStateMap.put(clickedItem.getText(), Boolean.FALSE);
                }
            }
            this.initialSelection = this.getSelection();
        }
    }

    @Override
    public void select(int index) {
        if (!this.getDropdownTable().isDisposed()) {
            this.getDropdownTable().select(index);
            this.filterText = this.getTransformedTextForSelection();
        } else if (index >= 0) {
            this.filterText = (String)this.itemList.get(index);
        }
    }

    @Override
    public void select(int[] indeces) {
        if (!this.getDropdownTable().isDisposed()) {
            this.getDropdownTable().select(indeces);
            this.filterText = this.getTransformedTextForSelection();
        } else {
            String[] selectedItems = new String[indeces.length];
            int i = 0;
            while (i < indeces.length) {
                if (indeces[i] >= 0) {
                    selectedItems[i] = (String)this.itemList.get(indeces[i]);
                }
                ++i;
            }
            this.filterText = this.getTransformedText(selectedItems);
        }
    }

    @Override
    protected String getTransformedText(String[] values) {
        String result = "";
        if (this.multiselect) {
            int i = 0;
            while (i < values.length) {
                String selection = values[i];
                result = String.valueOf(result) + selection;
                if (i + 1 < values.length) {
                    result = String.valueOf(result) + this.multiselectValueSeparator;
                }
                ++i;
            }
            if (values.length > 0) {
                result = String.valueOf(this.multiselectTextPrefix) + result + this.multiselectTextSuffix;
            }
        } else if (values.length > 0) {
            result = values[0];
        }
        return result;
    }

    @Override
    protected String[] getTextAsArray() {
        if (this.filterText != null && this.filterText.length() > 0) {
            String transform = this.filterText;
            int prefixLength = this.multiselectTextPrefix.length();
            int suffixLength = this.multiselectTextSuffix.length();
            transform = transform.substring(prefixLength, transform.length() - suffixLength);
            return transform.split(this.multiselectValueSeparator);
        }
        return new String[0];
    }

    public void setFilterModifyAction(Runnable action) {
        this.filterModifyAction = action;
        this.setDropdownFilterModifyListener(new FilterDropDownFilterModifyListener());
    }

    public boolean isFilterActive() {
        return this.filterActive;
    }

    protected String getSelectAllLabel() {
        return Messages.getString("FilterNatCombo.selectAll");
    }

    protected String getAddToFilterLabel() {
        return Messages.getString("FilterNatCombo.addToFilter");
    }

    public class FilterDropDownFilterModifyListener
    extends NatCombo.DropDownFilterModifyListener {
        public FilterDropDownFilterModifyListener() {
            super(FilterNatCombo.this);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected void setSelection() {
            void var3_4;
            String[] selection = null;
            TableItem[] items = FilterNatCombo.this.dropdownTableViewer.getTable().getItems();
            selection = new String[items.length];
            boolean bl = false;
            while (var3_4 < items.length) {
                TableItem item = items[var3_4];
                selection[var3_4] = item.getText();
                ++var3_4;
            }
            if (FilterNatCombo.this.initialSelection != null) {
                boolean bl2;
                FilterNatCombo.this.initialSelection = FilterNatCombo.this.getSelection();
                FilterNatCombo.this.filterActive = !FilterNatCombo.this.filterBox.getText().isEmpty();
                boolean bl3 = FilterNatCombo.this.filterActive;
                if (FilterNatCombo.this.filterActive) {
                    boolean allAlreadySelected = true;
                    TableItem[] tableItemArray = FilterNatCombo.this.getDropdownTable().getItems();
                    int n = tableItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TableItem item = tableItemArray[n2];
                        item.setChecked(true);
                        if (allAlreadySelected) {
                            allAlreadySelected = Arrays.stream(FilterNatCombo.this.initialSelection).anyMatch(s -> s.equals(item.getText()));
                        }
                        ++n2;
                    }
                    bl2 = !allAlreadySelected;
                } else {
                    FilterNatCombo.this.setDropdownSelection(FilterNatCombo.this.getSelection());
                }
                FilterNatCombo.this.addToFilterItemViewer.getTable().setVisible(bl2);
                ((FormData)((FilterNatCombo)FilterNatCombo.this).dropdownTable.getLayoutData()).top = new FormAttachment(bl2 ? FilterNatCombo.this.addToFilterItemViewer.getControl() : FilterNatCombo.this.selectAllItemViewer.getControl(), 0, 1024);
                FilterNatCombo.this.resetAddToFilter(null);
                if (FilterNatCombo.this.selectAllItemViewer != null) {
                    FilterNatCombo.this.selectAllItemViewer.refresh();
                }
            } else {
                FilterNatCombo.this.getDropdownTable().deselectAll();
                for (Map.Entry entry : FilterNatCombo.this.selectionStateMap.entrySet()) {
                    entry.setValue(Boolean.FALSE);
                }
                FilterNatCombo.this.setDropdownSelection(selection);
                FilterNatCombo.this.updateTextControl(false);
                if (FilterNatCombo.this.filterModifyAction != null) {
                    FilterNatCombo.this.filterModifyAction.run();
                }
            }
        }
    }
}

