/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.DNDEvent;
import org.eclipse.swt.dnd.DNDListener;
import org.eclipse.swt.dnd.DragSourceEffect;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TableDragSourceEffect;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.dnd.TreeDragSourceEffect;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.cocoa.NSApplication;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSData;
import org.eclipse.swt.internal.cocoa.NSEvent;
import org.eclipse.swt.internal.cocoa.NSFileManager;
import org.eclipse.swt.internal.cocoa.NSImage;
import org.eclipse.swt.internal.cocoa.NSMutableArray;
import org.eclipse.swt.internal.cocoa.NSObject;
import org.eclipse.swt.internal.cocoa.NSPasteboard;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSURL;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTDragSourceDelegate;
import org.eclipse.swt.internal.cocoa.objc_super;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

public class DragSource
extends Widget {
    static byte[] types = new byte[]{42, 0};
    static int size = C.PTR_SIZEOF;
    static int align = C.PTR_SIZEOF == 4 ? 2 : 3;
    static Callback dragSource2Args;
    static Callback dragSource3Args;
    static Callback dragSource4Args;
    static Callback dragSource5Args;
    static Callback dragSource6Args;
    static final byte[] SWT_OBJECT;
    static int proc2;
    static int proc3;
    static int proc4;
    static int proc5;
    static int proc6;
    String[] paths;
    boolean[] exist;
    Control control;
    Listener controlListener;
    Transfer[] transferAgents = new Transfer[0];
    DragSourceEffect dragEffect;
    Image dragImageFromListener;
    private int dragOperations;
    SWTDragSourceDelegate dragSourceDelegate;
    static final String DEFAULT_DRAG_SOURCE_EFFECT = "DEFAULT_DRAG_SOURCE_EFFECT";
    private int delegateJniRef;
    private Point dragOffset;
    static /* synthetic */ Class class$org$eclipse$swt$dnd$DragSource;

    public DragSource(Control control, int n) {
        super(control, DragSource.checkStyle(n));
        this.control = control;
        if (control.getData("DragSource") != null) {
            DND.error(2000);
        }
        control.setData("DragSource", this);
        this.controlListener = new Listener(){

            public void handleEvent(Event event) {
                if (event.type == 12 && !DragSource.this.isDisposed()) {
                    DragSource.this.dispose();
                }
                if (event.type == 29 && !DragSource.this.isDisposed()) {
                    if (event.widget instanceof Table || event.widget instanceof Tree) {
                        DragSource.this.dragOutlineViewStart(event);
                    } else {
                        DragSource.this.drag(event);
                    }
                }
            }
        };
        control.addListener(12, this.controlListener);
        control.addListener(29, this.controlListener);
        this.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                DragSource.this.onDispose();
            }
        });
        Object object = control.getData(DEFAULT_DRAG_SOURCE_EFFECT);
        if (object instanceof DragSourceEffect) {
            this.dragEffect = (DragSourceEffect)object;
        } else if (control instanceof Tree) {
            this.dragEffect = new TreeDragSourceEffect((Tree)control);
        } else if (control instanceof Table) {
            this.dragEffect = new TableDragSourceEffect((Table)control);
        }
        this.delegateJniRef = OS.NewGlobalRef(this);
        if (this.delegateJniRef == 0) {
            SWT.error(2);
        }
        this.dragSourceDelegate = (SWTDragSourceDelegate)new SWTDragSourceDelegate().alloc().init();
        OS.object_setInstanceVariable(this.dragSourceDelegate.id, SWT_OBJECT, this.delegateJniRef);
        if (control instanceof Tree || control instanceof Table) {
            int n2;
            int n3 = OS.object_getClass(control.view.id);
            if (n3 == 0) {
                DND.error(2000);
            }
            if ((n2 = OS.class_getMethodImplementation(n3, OS.sel_draggingSourceOperationMaskForLocal_)) == proc3) {
                return;
            }
            int n4 = OS.CALLBACK_draggedImage_endedAt_operation_(proc5);
            OS.class_addMethod(n3, OS.sel_draggingSourceOperationMaskForLocal_, proc3, "@:I");
            OS.class_addMethod(n3, OS.sel_draggedImage_beganAt_, proc4, "@:@{NSPoint=ff}");
            OS.class_addMethod(n3, OS.sel_draggedImage_endedAt_operation_, n4, "@:@{NSPoint=ff}I");
            OS.class_addMethod(n3, OS.sel_ignoreModifierKeysWhileDragging, proc3, "@:");
            OS.class_addMethod(n3, OS.sel_dragImageForRowsWithIndexes_tableColumns_event_offset_, proc6, "@:@@@^NSPoint");
        }
    }

    public void addDragListener(DragSourceListener dragSourceListener) {
        if (dragSourceListener == null) {
            DND.error(4);
        }
        DNDListener dNDListener = new DNDListener(dragSourceListener);
        dNDListener.dndWidget = this;
        this.addListener(2008, dNDListener);
        this.addListener(2001, dNDListener);
        this.addListener(2000, dNDListener);
    }

    void dndCallSuper(int n, int n2, int n3, NSPoint nSPoint, int n4) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = n;
        objc_super2.super_class = OS.objc_msgSend(n, OS.sel_superclass);
        OS.objc_msgSendSuper(objc_super2, n2, n3, nSPoint, n4);
    }

    void dndCallSuper(int n, int n2, int n3, int n4) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = n;
        objc_super2.super_class = OS.objc_msgSend(n, OS.sel_superclass);
        OS.objc_msgSendSuper(objc_super2, n2, n3, n4);
    }

    int dndCallSuperObject(int n, int n2, int n3, int n4, int n5, int n6) {
        objc_super objc_super2 = new objc_super();
        objc_super2.receiver = n;
        objc_super2.super_class = OS.objc_msgSend(n, OS.sel_superclass);
        return OS.objc_msgSendSuper(objc_super2, n2, n3, n4, n5, n6);
    }

    protected void checkSubclass() {
        String string = this.getClass().getName();
        String string2 = (class$org$eclipse$swt$dnd$DragSource == null ? (class$org$eclipse$swt$dnd$DragSource = DragSource.class$("org.eclipse.swt.dnd.DragSource")) : class$org$eclipse$swt$dnd$DragSource).getName();
        if (!string2.equals(string)) {
            DND.error(43);
        }
    }

    static int checkStyle(int n) {
        if (n == 0) {
            return 2;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void drag(Event event) {
        DNDEvent dNDEvent = this.startDrag(event);
        if (dNDEvent == null) {
            return;
        }
        NSEvent nSEvent = NSApplication.sharedApplication().currentEvent();
        NSPoint nSPoint = nSEvent.locationInWindow();
        NSPoint nSPoint2 = this.control.view.convertPoint_fromView_(nSPoint, null);
        NSImage nSImage = null;
        Resource resource = null;
        try {
            void var8_10;
            Image image = dNDEvent.image;
            if (image == null) {
                int n = 20;
                int n2 = 20;
                Image image2 = new Image((Device)Display.getCurrent(), n, n2);
                GC gC = new GC(image2);
                Color color = new Color(Display.getCurrent(), 50, 50, 50);
                gC.setForeground(color);
                gC.drawRectangle(0, 0, 19, 19);
                gC.dispose();
                ImageData imageData = image2.getImageData();
                imageData.alpha = 102;
                resource = new Image((Device)Display.getCurrent(), imageData);
                image2.dispose();
                color.dispose();
                Resource resource2 = resource;
                dNDEvent.offsetX = n / 2;
                dNDEvent.offsetY = n2 / 2;
            }
            nSImage = var8_10.handle;
            NSSize nSSize = nSImage.size();
            nSPoint2.x -= (float)dNDEvent.offsetX;
            nSPoint2.y = this.control.view.isFlipped() ? (nSPoint2.y += nSSize.height - (float)dNDEvent.offsetY) : (nSPoint2.y -= (float)dNDEvent.offsetY);
            NSSize nSSize2 = new NSSize();
            this.control.view.dragImage(nSImage, nSPoint2, nSSize2, NSApplication.sharedApplication().currentEvent(), NSPasteboard.pasteboardWithName(OS.NSDragPboard), this.dragSourceDelegate, true);
            Object var16_19 = null;
            if (resource == null) return;
        }
        catch (Throwable throwable) {
            Object var16_20 = null;
            if (resource == null) throw throwable;
            resource.dispose();
            throw throwable;
        }
        resource.dispose();
    }

    void dragOutlineViewStart(Event event) {
        DNDEvent dNDEvent = this.startDrag(event);
        if (dNDEvent == null) {
            return;
        }
        this.dragImageFromListener = dNDEvent.image;
        this.dragOffset = new Point(dNDEvent.offsetX, dNDEvent.offsetY);
    }

    void draggedImage_beganAt(int n, int n2, int n3, int n4) {
        if (new NSObject(n).isKindOfClass(OS.class_NSTableView)) {
            this.dndCallSuper(n, n2, n3, n4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void draggedImage_endedAt_operation(int n, int n2, int n3, NSPoint nSPoint, int n4) {
        Object object;
        int n5 = this.osOpToOp(n4);
        if (this.paths != null) {
            object = NSFileManager.defaultManager();
            for (int i = 0; i < this.paths.length; ++i) {
                if (this.paths[i] == null || !this.exist[i] || ((NSFileManager)object).fileExistsAtPath(NSString.stringWith(this.paths[i]))) continue;
                n5 &= 0xFFFFFFFD;
                n5 |= 8;
            }
            this.paths = null;
            this.exist = null;
        }
        OS.objc_msgSend(n, OS.sel_retain);
        try {
            object = new DNDEvent();
            ((Event)object).widget = this;
            ((Event)object).time = (int)System.currentTimeMillis();
            ((Event)object).doit = n5 != 0;
            ((Event)object).detail = n5;
            this.notifyListeners(2000, (Event)object);
            this.dragImageFromListener = null;
            if (new NSObject(n).isKindOfClass(OS.class_NSTableView)) {
                this.dndCallSuper(n, n2, n3, nSPoint, n4);
            }
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            OS.objc_msgSend(n, OS.sel_release);
            throw throwable;
        }
        OS.objc_msgSend(n, OS.sel_release);
    }

    int dragImageForRowsWithIndexes_tableColumns_event_offset(int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.dragImageFromListener != null) {
            NSPoint nSPoint = new NSPoint();
            nSPoint.x = this.dragOffset.x;
            nSPoint.y = this.dragOffset.y;
            OS.memmove(n6, nSPoint, NSPoint.sizeof);
            return this.dragImageFromListener.handle.id;
        }
        return this.dndCallSuperObject(n, n2, n3, n4, n5, n6);
    }

    int draggingSourceOperationMaskForLocal(int n, int n2, int n3) {
        return this.dragOperations;
    }

    static int dragSourceProc(int n, int n2) {
        Display display = Display.findDisplay(Thread.currentThread());
        if (display == null || display.isDisposed()) {
            return 0;
        }
        Widget widget = display.findWidget(n);
        if (widget == null) {
            return 0;
        }
        DragSource dragSource = null;
        dragSource = widget instanceof DragSource ? (DragSource)widget : (DragSource)widget.getData("DragSource");
        if (dragSource == null) {
            return 0;
        }
        if (n2 == OS.sel_ignoreModifierKeysWhileDragging) {
            return dragSource.ignoreModifierKeysWhileDragging(n, n2) ? 1 : 0;
        }
        return 0;
    }

    static int dragSourceProc(int n, int n2, int n3) {
        Display display = Display.findDisplay(Thread.currentThread());
        if (display == null || display.isDisposed()) {
            return 0;
        }
        Widget widget = display.findWidget(n);
        if (widget == null) {
            return 0;
        }
        DragSource dragSource = null;
        dragSource = widget instanceof DragSource ? (DragSource)widget : (DragSource)widget.getData("DragSource");
        if (dragSource == null) {
            return 0;
        }
        if (n2 == OS.sel_draggingSourceOperationMaskForLocal_) {
            return dragSource.draggingSourceOperationMaskForLocal(n, n2, n3);
        }
        return 0;
    }

    static int dragSourceProc(int n, int n2, int n3, int n4) {
        Display display = Display.findDisplay(Thread.currentThread());
        if (display == null || display.isDisposed()) {
            return 0;
        }
        Widget widget = display.findWidget(n);
        if (widget == null) {
            return 0;
        }
        DragSource dragSource = null;
        dragSource = widget instanceof DragSource ? (DragSource)widget : (DragSource)widget.getData("DragSource");
        if (dragSource == null) {
            return 0;
        }
        if (n2 == OS.sel_draggedImage_beganAt_) {
            dragSource.draggedImage_beganAt(n, n2, n3, n4);
        } else if (n2 == OS.sel_pasteboard_provideDataForType_) {
            dragSource.pasteboard_provideDataForType(n, n2, n3, n4);
        }
        return 0;
    }

    static int dragSourceProc(int n, int n2, int n3, int n4, int n5) {
        Display display = Display.findDisplay(Thread.currentThread());
        if (display == null || display.isDisposed()) {
            return 0;
        }
        Widget widget = display.findWidget(n);
        if (widget == null) {
            return 0;
        }
        DragSource dragSource = null;
        dragSource = widget instanceof DragSource ? (DragSource)widget : (DragSource)widget.getData("DragSource");
        if (dragSource == null) {
            return 0;
        }
        if (n2 == OS.sel_draggedImage_endedAt_operation_) {
            NSPoint nSPoint = new NSPoint();
            OS.memmove(nSPoint, n4, NSPoint.sizeof);
            dragSource.draggedImage_endedAt_operation(n, n2, n3, nSPoint, n5);
        }
        return 0;
    }

    static int dragSourceProc(int n, int n2, int n3, int n4, int n5, int n6) {
        Display display = Display.findDisplay(Thread.currentThread());
        if (display == null || display.isDisposed()) {
            return 0;
        }
        Widget widget = display.findWidget(n);
        if (widget == null) {
            return 0;
        }
        DragSource dragSource = null;
        dragSource = widget instanceof DragSource ? (DragSource)widget : (DragSource)widget.getData("DragSource");
        if (dragSource == null) {
            return 0;
        }
        if (n2 == OS.sel_dragImageForRowsWithIndexes_tableColumns_event_offset_) {
            return dragSource.dragImageForRowsWithIndexes_tableColumns_event_offset(n, n2, n3, n4, n5, n6);
        }
        return 0;
    }

    public Control getControl() {
        return this.control;
    }

    public DragSourceListener[] getDragListeners() {
        Listener[] listenerArray = this.getListeners(2008);
        int n = listenerArray.length;
        DragSourceListener[] dragSourceListenerArray = new DragSourceListener[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            Listener listener = listenerArray[i];
            if (!(listener instanceof DNDListener)) continue;
            dragSourceListenerArray[n2] = (DragSourceListener)((DNDListener)listener).getEventListener();
            ++n2;
        }
        if (n2 == n) {
            return dragSourceListenerArray;
        }
        DragSourceListener[] dragSourceListenerArray2 = new DragSourceListener[n2];
        System.arraycopy(dragSourceListenerArray, 0, dragSourceListenerArray2, 0, n2);
        return dragSourceListenerArray2;
    }

    public DragSourceEffect getDragSourceEffect() {
        return this.dragEffect;
    }

    public Transfer[] getTransfer() {
        return this.transferAgents;
    }

    boolean ignoreModifierKeysWhileDragging(int n, int n2) {
        return false;
    }

    void onDispose() {
        if (this.control == null) {
            return;
        }
        if (this.controlListener != null) {
            this.control.removeListener(12, this.controlListener);
            this.control.removeListener(29, this.controlListener);
        }
        this.controlListener = null;
        this.control.setData("DragSource", null);
        this.control = null;
        this.transferAgents = null;
        if (this.delegateJniRef != 0) {
            OS.DeleteGlobalRef(this.delegateJniRef);
        }
        this.delegateJniRef = 0;
        if (this.dragSourceDelegate != null) {
            OS.object_setInstanceVariable(this.dragSourceDelegate.id, SWT_OBJECT, 0);
            this.dragSourceDelegate.release();
        }
    }

    int opToOsOp(int n) {
        int n2 = 0;
        if ((n & 1) != 0) {
            n2 |= 1;
        }
        if ((n & 4) != 0) {
            n2 |= 2;
        }
        if ((n & 2) != 0) {
            n2 |= 0x10;
        }
        if ((n & 8) != 0) {
            n2 |= 0x20;
        }
        return n2;
    }

    int osOpToOp(int n) {
        int n2 = 0;
        if ((n & 1) != 0) {
            n2 |= 1;
        }
        if ((n & 2) != 0) {
            n2 |= 4;
        }
        if ((n & 0x20) != 0) {
            n2 |= 8;
        }
        if ((n & 0x10) != 0) {
            n2 |= 2;
        }
        if (n == -1) {
            n2 = 7;
        }
        return n2;
    }

    void pasteboard_provideDataForType(int n, int n2, int n3, int n4) {
        Object object;
        NSPasteboard nSPasteboard = new NSPasteboard(n3);
        NSString nSString = new NSString(n4);
        if (nSPasteboard == null || nSString == null) {
            return;
        }
        TransferData transferData = new TransferData();
        transferData.type = Transfer.registerType(nSString.getString());
        DNDEvent dNDEvent = new DNDEvent();
        dNDEvent.widget = this;
        dNDEvent.time = (int)System.currentTimeMillis();
        dNDEvent.dataType = transferData;
        this.notifyListeners(2001, dNDEvent);
        if (!dNDEvent.doit) {
            return;
        }
        Transfer transfer = null;
        for (int i = 0; i < this.transferAgents.length; ++i) {
            object = this.transferAgents[i];
            if (object == null || !((Transfer)object).isSupportedType(transferData)) continue;
            transfer = object;
            break;
        }
        if (transfer == null) {
            return;
        }
        transfer.javaToNative(dNDEvent.data, transferData);
        if (transferData.data == null) {
            return;
        }
        NSObject nSObject = transferData.data;
        if (nSString.isEqual(OS.NSStringPboardType) || nSString.isEqual(OS.NSHTMLPboardType) || nSString.isEqual(OS.NSRTFPboardType)) {
            nSPasteboard.setString((NSString)nSObject, nSString);
        } else if (nSString.isEqual(OS.NSURLPboardType) || nSString.isEqual(OS.kUTTypeURL)) {
            object = (NSURL)nSObject;
            ((NSURL)object).writeToPasteboard(nSPasteboard);
        } else if (nSString.isEqual(OS.NSFilenamesPboardType) || nSString.isEqual(OS.kUTTypeFileURL)) {
            object = (NSArray)transferData.data;
            int n5 = ((NSArray)object).count();
            this.paths = new String[n5];
            this.exist = new boolean[n5];
            NSFileManager nSFileManager = NSFileManager.defaultManager();
            for (int i = 0; i < n5; ++i) {
                NSString nSString2 = new NSString(((NSArray)object).objectAtIndex(i));
                this.paths[i] = nSString2.getString();
                this.exist[i] = nSFileManager.fileExistsAtPath(nSString2);
            }
            nSPasteboard.setPropertyList((NSArray)nSObject, OS.NSFilenamesPboardType);
        } else {
            nSPasteboard.setData((NSData)nSObject, nSString);
        }
    }

    public void removeDragListener(DragSourceListener dragSourceListener) {
        if (dragSourceListener == null) {
            DND.error(4);
        }
        this.removeListener(2008, dragSourceListener);
        this.removeListener(2001, dragSourceListener);
        this.removeListener(2000, dragSourceListener);
    }

    public void setDragSourceEffect(DragSourceEffect dragSourceEffect) {
        this.dragEffect = dragSourceEffect;
    }

    public void setTransfer(Transfer[] transferArray) {
        this.transferAgents = transferArray;
    }

    DNDEvent startDrag(Event event) {
        DNDEvent dNDEvent = new DNDEvent();
        dNDEvent.widget = this;
        dNDEvent.x = event.x;
        dNDEvent.y = event.y;
        dNDEvent.time = event.time;
        dNDEvent.doit = true;
        this.notifyListeners(2008, dNDEvent);
        if (!dNDEvent.doit || this.transferAgents == null || this.transferAgents.length == 0) {
            return null;
        }
        NSPasteboard nSPasteboard = NSPasteboard.pasteboardWithName(OS.NSDragPboard);
        NSMutableArray nSMutableArray = NSMutableArray.arrayWithCapacity(10);
        for (int i = 0; i < this.transferAgents.length; ++i) {
            Transfer transfer = this.transferAgents[i];
            if (transfer == null) continue;
            String[] stringArray = transfer.getTypeNames();
            for (int j = 0; j < stringArray.length; ++j) {
                nSMutableArray.addObject(NSString.stringWith(stringArray[j]));
            }
        }
        nSPasteboard.declareTypes(nSMutableArray, this.dragSourceDelegate);
        this.dragOperations = this.opToOsOp(this.getStyle());
        return dNDEvent;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        SWT_OBJECT = new byte[]{83, 87, 84, 95, 79, 66, 74, 69, 67, 84, 0};
        proc2 = 0;
        proc3 = 0;
        proc4 = 0;
        proc5 = 0;
        proc6 = 0;
        String string = "SWTDragSourceDelegate";
        Class clazz = class$org$eclipse$swt$dnd$DragSource == null ? (class$org$eclipse$swt$dnd$DragSource = DragSource.class$("org.eclipse.swt.dnd.DragSource")) : class$org$eclipse$swt$dnd$DragSource;
        dragSource2Args = new Callback(clazz, "dragSourceProc", 2);
        proc2 = dragSource2Args.getAddress();
        if (proc2 == 0) {
            SWT.error(3);
        }
        if ((proc3 = (dragSource3Args = new Callback(clazz, "dragSourceProc", 3)).getAddress()) == 0) {
            SWT.error(3);
        }
        if ((proc4 = (dragSource4Args = new Callback(clazz, "dragSourceProc", 4)).getAddress()) == 0) {
            SWT.error(3);
        }
        if ((proc5 = (dragSource5Args = new Callback(clazz, "dragSourceProc", 5)).getAddress()) == 0) {
            SWT.error(3);
        }
        if ((proc6 = (dragSource6Args = new Callback(clazz, "dragSourceProc", 6)).getAddress()) == 0) {
            SWT.error(3);
        }
        int n = OS.objc_allocateClassPair(OS.class_NSObject, string, 0);
        OS.class_addIvar(n, SWT_OBJECT, size, (byte)align, types);
        int n2 = OS.CALLBACK_draggedImage_endedAt_operation_(proc5);
        OS.class_addMethod(n, OS.sel_draggingSourceOperationMaskForLocal_, proc3, "@:I");
        OS.class_addMethod(n, OS.sel_draggedImage_beganAt_, proc4, "@:@{NSPoint=ff}");
        OS.class_addMethod(n, OS.sel_draggedImage_endedAt_operation_, n2, "@:@{NSPoint=ff}I");
        OS.class_addMethod(n, OS.sel_ignoreModifierKeysWhileDragging, proc3, "@:");
        OS.class_addMethod(n, OS.sel_pasteboard_provideDataForType_, proc4, "@:@@");
        OS.objc_registerClassPair(n);
    }
}

