/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.cocoa.NSAffineTransform;
import org.eclipse.swt.internal.cocoa.NSApplication;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSAttributedString;
import org.eclipse.swt.internal.cocoa.NSBezierPath;
import org.eclipse.swt.internal.cocoa.NSButton;
import org.eclipse.swt.internal.cocoa.NSButtonCell;
import org.eclipse.swt.internal.cocoa.NSCell;
import org.eclipse.swt.internal.cocoa.NSColor;
import org.eclipse.swt.internal.cocoa.NSDictionary;
import org.eclipse.swt.internal.cocoa.NSEvent;
import org.eclipse.swt.internal.cocoa.NSFont;
import org.eclipse.swt.internal.cocoa.NSGraphicsContext;
import org.eclipse.swt.internal.cocoa.NSImage;
import org.eclipse.swt.internal.cocoa.NSIndexSet;
import org.eclipse.swt.internal.cocoa.NSMutableArray;
import org.eclipse.swt.internal.cocoa.NSMutableAttributedString;
import org.eclipse.swt.internal.cocoa.NSMutableDictionary;
import org.eclipse.swt.internal.cocoa.NSMutableIndexSet;
import org.eclipse.swt.internal.cocoa.NSMutableParagraphStyle;
import org.eclipse.swt.internal.cocoa.NSNotification;
import org.eclipse.swt.internal.cocoa.NSNumber;
import org.eclipse.swt.internal.cocoa.NSObject;
import org.eclipse.swt.internal.cocoa.NSOutlineView;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRange;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSScrollView;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSTableColumn;
import org.eclipse.swt.internal.cocoa.NSTableHeaderCell;
import org.eclipse.swt.internal.cocoa.NSTableHeaderView;
import org.eclipse.swt.internal.cocoa.NSTableView;
import org.eclipse.swt.internal.cocoa.NSTextFieldCell;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTImageTextCell;
import org.eclipse.swt.internal.cocoa.SWTOutlineView;
import org.eclipse.swt.internal.cocoa.SWTScrollView;
import org.eclipse.swt.internal.cocoa.SWTTableHeaderCell;
import org.eclipse.swt.internal.cocoa.SWTTableHeaderView;
import org.eclipse.swt.internal.cocoa.SWTTreeItem;
import org.eclipse.swt.internal.cocoa.id;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Tree
extends Composite {
    NSTableColumn firstColumn;
    NSTableColumn checkColumn;
    NSTextFieldCell dataCell;
    NSButtonCell buttonCell;
    NSTableHeaderView headerView;
    TreeItem[] items;
    int itemCount;
    TreeColumn[] columns;
    TreeColumn sortColumn;
    int columnCount;
    int sortDirection;
    int selectedRowIndex = -1;
    boolean ignoreExpand;
    boolean ignoreSelect;
    boolean ignoreRedraw;
    boolean reloadPending;
    boolean drawExpansion;
    boolean didSelect;
    boolean preventSelect;
    boolean dragDetected;
    Rectangle imageBounds;
    TreeItem insertItem;
    boolean insertBefore;
    boolean shouldExpand = true;
    boolean shouldScroll = true;
    static int NEXT_ID;
    static final int FIRST_COLUMN_MINIMUM_WIDTH = 5;
    static final int IMAGE_GAP = 3;
    static final int TEXT_GAP = 2;
    static final int CELL_GAP = 1;

    public Tree(Composite composite, int n) {
        super(composite, Tree.checkStyle(n));
    }

    void _addListener(int n, Listener listener) {
        super._addListener(n, listener);
        this.clearCachedWidth(this.items);
    }

    TreeItem _getItem(TreeItem treeItem, int n, boolean bl) {
        TreeItem[] treeItemArray;
        int n2;
        if (treeItem != null) {
            n2 = treeItem.itemCount;
            treeItemArray = treeItem.items;
        } else {
            n2 = this.itemCount;
            treeItemArray = this.items;
        }
        if (n < 0 || n >= n2) {
            return null;
        }
        TreeItem treeItem2 = treeItemArray[n];
        if (treeItem2 != null || (this.style & 0x10000000) == 0 || !bl) {
            return treeItem2;
        }
        treeItemArray[n] = treeItem2 = new TreeItem(this, treeItem, 0, n, false);
        return treeItem2;
    }

    boolean acceptsFirstResponder(int n, int n2) {
        return true;
    }

    int accessibilityAttributeValue(int n, int n2, int n3) {
        int n4;
        int n5 = 0;
        NSString nSString = new NSString(n3);
        if ((nSString.isEqualToString(OS.NSAccessibilityColumnsAttribute) || nSString.isEqualToString(OS.NSAccessibilityVisibleColumnsAttribute)) && (this.style & 0x20) != 0 && (n4 = super.accessibilityAttributeValue(n, n2, n3)) != 0) {
            NSArray nSArray = new NSArray(n4);
            NSMutableArray nSMutableArray = NSMutableArray.arrayWithCapacity(nSArray.count() - 1);
            nSMutableArray.addObjectsFromArray(nSArray);
            nSMutableArray.removeObjectAtIndex(0);
            n5 = nSMutableArray.id;
        }
        if (n5 != 0) {
            return n5;
        }
        return super.accessibilityAttributeValue(n, n2, n3);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void addTreeListener(TreeListener treeListener) {
        this.checkWidget();
        if (treeListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(treeListener);
        this.addListener(17, typedListener);
        this.addListener(18, typedListener);
    }

    int calculateWidth(TreeItem[] treeItemArray, int n, GC gC, boolean bl) {
        if (treeItemArray == null) {
            return 0;
        }
        int n2 = 0;
        for (int i = 0; i < treeItemArray.length; ++i) {
            TreeItem treeItem = treeItemArray[i];
            if (treeItem == null) continue;
            int n3 = treeItem.calculateWidth(n, gC);
            n2 = Math.max(n2, n3);
            if (!bl || !treeItem.getExpanded()) continue;
            n2 = Math.max(n2, this.calculateWidth(treeItem.items, n, gC, bl));
        }
        return n2;
    }

    NSSize cellSize(int n, int n2) {
        NSSize nSSize = super.cellSize(n, n2);
        NSCell nSCell = new NSCell(n);
        NSImage nSImage = nSCell.image();
        if (nSImage != null) {
            nSSize.width += (float)(this.imageBounds.width + 3);
        }
        if (this.hooks(41)) {
            int[] nArray = new int[1];
            OS.object_getInstanceVariable(n, Display.SWT_ROW, nArray);
            TreeItem treeItem = (TreeItem)this.display.getWidget(nArray[0]);
            OS.object_getInstanceVariable(n, Display.SWT_COLUMN, nArray);
            int n3 = nArray[0];
            int n4 = 0;
            for (int i = 0; i < this.columnCount; ++i) {
                if (this.columns[i].nsColumn.id != n3) continue;
                n4 = i;
                break;
            }
            this.sendMeasureItem(treeItem, nSCell.isHighlighted(), n4, nSSize);
        }
        return nSSize;
    }

    boolean canDragRowsWithIndexes_atPoint(int n, int n2, int n3, NSPoint nSPoint) {
        boolean bl;
        if (!super.canDragRowsWithIndexes_atPoint(n, n2, n3, nSPoint)) {
            return false;
        }
        NSTableView nSTableView = (NSTableView)this.view;
        int n4 = nSTableView.rowAtPoint(nSPoint);
        int n5 = NSApplication.sharedApplication().currentEvent().modifierFlags();
        boolean bl2 = bl = (this.state & 0x40000) != 0 && this.hooks(29);
        if (bl && !nSTableView.isRowSelected(n4) && (n5 & 0x1E0000) == 0) {
            NSIndexSet nSIndexSet = (NSIndexSet)new NSIndexSet().alloc();
            nSIndexSet = nSIndexSet.initWithIndex(n4);
            nSTableView.selectRowIndexes(nSIndexSet, false);
            nSIndexSet.release();
        }
        return nSTableView.isRowSelected(n4) && bl || !this.hasFocus();
    }

    boolean checkData(TreeItem treeItem) {
        if (treeItem.cached) {
            return true;
        }
        if ((this.style & 0x10000000) != 0) {
            treeItem.cached = true;
            Event event = new Event();
            TreeItem treeItem2 = treeItem.getParentItem();
            event.item = treeItem;
            event.index = treeItem2 == null ? this.indexOf(treeItem) : treeItem2.indexOf(treeItem);
            this.ignoreRedraw = true;
            this.sendEvent(36, event);
            this.ignoreRedraw = false;
            if (this.isDisposed() || treeItem.isDisposed()) {
                return false;
            }
            if (!this.setScrollWidth(treeItem)) {
                treeItem.redraw(-1);
            }
        }
        return true;
    }

    static int checkStyle(int n) {
        if ((n & 0x10) == 0) {
            n |= 0x300;
        }
        return Tree.checkBits(n |= 0x10000, 4, 2, 0, 0, 0, 0);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void checkItems() {
        if (!this.reloadPending) {
            return;
        }
        this.reloadPending = false;
        TreeItem[] treeItemArray = this.getSelection();
        ((NSOutlineView)this.view).reloadData();
        this.selectItems(treeItemArray, true);
        this.ignoreExpand = true;
        for (int i = 0; i < this.itemCount; ++i) {
            if (this.items[i] == null) continue;
            this.items[i].updateExpanded();
        }
        this.ignoreExpand = false;
    }

    void clear(TreeItem treeItem, int n, boolean bl) {
        TreeItem treeItem2 = this._getItem(treeItem, n, false);
        if (treeItem2 != null) {
            treeItem2.clear();
            treeItem2.redraw(-1);
            if (bl) {
                this.clearAll(treeItem2, true);
            }
        }
    }

    void clearAll(TreeItem treeItem, boolean bl) {
        int n = this.getItemCount(treeItem);
        if (n == 0) {
            return;
        }
        TreeItem[] treeItemArray = treeItem == null ? this.items : treeItem.items;
        for (int i = 0; i < n; ++i) {
            TreeItem treeItem2 = treeItemArray[i];
            if (treeItem2 == null) continue;
            treeItem2.clear();
            treeItem2.redraw(-1);
            if (!bl) continue;
            this.clearAll(treeItem2, true);
        }
    }

    public void clear(int n, boolean bl) {
        this.checkWidget();
        int n2 = this.getItemCount();
        if (n < 0 || n >= n2) {
            this.error(6);
        }
        this.clear(null, n, bl);
    }

    public void clearAll(boolean bl) {
        this.checkWidget();
        this.clearAll(null, bl);
    }

    void clearCachedWidth(TreeItem[] treeItemArray) {
        TreeItem treeItem;
        if (treeItemArray == null) {
            return;
        }
        for (int i = 0; i < treeItemArray.length && (treeItem = treeItemArray[i]) != null; ++i) {
            treeItem.width = -1;
            this.clearCachedWidth(treeItem.items);
        }
    }

    void collapseItem_collapseChildren(int n, int n2, int n3, boolean bl) {
        TreeItem treeItem = (TreeItem)this.display.getWidget(n3);
        if (treeItem == null) {
            return;
        }
        if (!this.ignoreExpand) {
            treeItem.sendExpand(false, bl);
        }
        this.ignoreExpand = true;
        super.collapseItem_collapseChildren(n, n2, n3, bl);
        this.ignoreExpand = false;
        if (this.isDisposed() || treeItem.isDisposed()) {
            return;
        }
        this.setScrollWidth();
    }

    int columnAtPoint(int n, int n2, NSPoint nSPoint) {
        if ((this.style & 0x20) != 0 && nSPoint.x <= (float)this.getCheckColumnWidth() && nSPoint.y < this.headerView.frame().height) {
            return 1;
        }
        return super.columnAtPoint(n, n2, nSPoint);
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        int n3 = 0;
        int n4 = 0;
        if (n == -1) {
            if (this.columnCount != 0) {
                for (int i = 0; i < this.columnCount; ++i) {
                    n3 += this.columns[i].getWidth();
                }
            } else {
                GC gC = new GC(this);
                n3 = this.calculateWidth(this.items, 0, gC, true) + 1;
                gC.dispose();
            }
            if ((this.style & 0x20) != 0) {
                n3 += this.getCheckColumnWidth();
            }
        } else {
            n3 = n;
        }
        n4 = n2 == -1 ? ((NSOutlineView)this.view).numberOfRows() * this.getItemHeight() + this.getHeaderHeight() : n2;
        if (n3 <= 0) {
            n3 = 64;
        }
        if (n4 <= 0) {
            n4 = 64;
        }
        Rectangle rectangle = this.computeTrim(0, 0, n3, n4);
        return new Point(rectangle.width, rectangle.height);
    }

    void createColumn(TreeItem treeItem, int n) {
        Resource[] resourceArray;
        Color[] colorArray;
        Resource[] resourceArray2;
        Object[] objectArray;
        String[] stringArray;
        if (treeItem.items != null) {
            for (int i = 0; i < treeItem.items.length; ++i) {
                if (treeItem.items[i] == null) continue;
                this.createColumn(treeItem.items[i], n);
            }
        }
        if ((stringArray = treeItem.strings) != null) {
            objectArray = new String[this.columnCount];
            System.arraycopy(stringArray, 0, objectArray, 0, n);
            System.arraycopy(stringArray, n, objectArray, n + 1, this.columnCount - n - 1);
            objectArray[n] = "";
            treeItem.strings = objectArray;
        }
        if (n == 0) {
            treeItem.text = "";
        }
        if ((objectArray = treeItem.images) != null) {
            resourceArray2 = new Image[this.columnCount];
            System.arraycopy(objectArray, 0, resourceArray2, 0, n);
            System.arraycopy(objectArray, n, resourceArray2, n + 1, this.columnCount - n - 1);
            treeItem.images = resourceArray2;
        }
        if (n == 0) {
            treeItem.image = null;
        }
        if ((resourceArray2 = treeItem.cellBackground) != null) {
            colorArray = new Color[this.columnCount];
            System.arraycopy(resourceArray2, 0, colorArray, 0, n);
            System.arraycopy(resourceArray2, n, colorArray, n + 1, this.columnCount - n - 1);
            treeItem.cellBackground = colorArray;
        }
        if ((colorArray = treeItem.cellForeground) != null) {
            resourceArray = new Color[this.columnCount];
            System.arraycopy(colorArray, 0, resourceArray, 0, n);
            System.arraycopy(colorArray, n, resourceArray, n + 1, this.columnCount - n - 1);
            treeItem.cellForeground = resourceArray;
        }
        if ((resourceArray = treeItem.cellFont) != null) {
            Font[] fontArray = new Font[this.columnCount];
            System.arraycopy(resourceArray, 0, fontArray, 0, n);
            System.arraycopy(resourceArray, n, fontArray, n + 1, this.columnCount - n - 1);
            treeItem.cellFont = fontArray;
        }
    }

    void createHandle() {
        NSString nSString;
        NSScrollView nSScrollView = (NSScrollView)new SWTScrollView().alloc();
        nSScrollView.init();
        nSScrollView.setHasHorizontalScroller((this.style & 0x100) != 0);
        nSScrollView.setHasVerticalScroller((this.style & 0x200) != 0);
        nSScrollView.setAutohidesScrollers(true);
        nSScrollView.setBorderType(this.hasBorder() ? 2 : 0);
        NSOutlineView nSOutlineView = (NSOutlineView)new SWTOutlineView().alloc();
        nSOutlineView.initWithFrame(new NSRect());
        nSOutlineView.setAllowsMultipleSelection((this.style & 2) != 0);
        nSOutlineView.setAutoresizesOutlineColumn(false);
        nSOutlineView.setAutosaveExpandedItems(true);
        nSOutlineView.setDataSource(nSOutlineView);
        nSOutlineView.setDelegate(nSOutlineView);
        nSOutlineView.setColumnAutoresizingStyle(0);
        NSSize nSSize = new NSSize();
        nSSize.height = 1.0f;
        nSSize.width = 1.0f;
        nSOutlineView.setIntercellSpacing(nSSize);
        nSOutlineView.setDoubleAction(OS.sel_sendDoubleSelection);
        if (!this.hasBorder()) {
            nSOutlineView.setFocusRingType(1);
        }
        this.headerView = (NSTableHeaderView)new SWTTableHeaderView().alloc().init();
        nSOutlineView.setHeaderView(null);
        NSString nSString2 = NSString.string();
        if ((this.style & 0x20) != 0) {
            this.checkColumn = (NSTableColumn)new NSTableColumn().alloc();
            nSString = (NSString)new NSString().alloc();
            nSString = nSString.initWithString(String.valueOf(++NEXT_ID));
            this.checkColumn = this.checkColumn.initWithIdentifier(nSString);
            nSString.release();
            this.checkColumn.headerCell().setTitle(nSString2);
            nSOutlineView.addTableColumn(this.checkColumn);
            nSOutlineView.setOutlineTableColumn(this.checkColumn);
            this.checkColumn.setResizingMask(0);
            this.checkColumn.setEditable(false);
            int n = NSButton.cellClass();
            this.buttonCell = new NSButtonCell(OS.class_createInstance(n, 0));
            this.buttonCell.init();
            this.checkColumn.setDataCell(this.buttonCell);
            this.buttonCell.setButtonType(3);
            this.buttonCell.setControlSize(1);
            this.buttonCell.setImagePosition(1);
            this.buttonCell.setAllowsMixedState(true);
            this.checkColumn.setWidth(this.getCheckColumnWidth());
        }
        this.firstColumn = (NSTableColumn)new NSTableColumn().alloc();
        nSString = (NSString)new NSString().alloc();
        nSString = nSString.initWithString(String.valueOf(++NEXT_ID));
        this.firstColumn = this.firstColumn.initWithIdentifier(nSString);
        nSString.release();
        this.firstColumn.setMinWidth(5.0f);
        this.firstColumn.setWidth(0.0f);
        this.firstColumn.setResizingMask(0);
        this.firstColumn.headerCell().setTitle(nSString2);
        nSOutlineView.addTableColumn(this.firstColumn);
        nSOutlineView.setOutlineTableColumn(this.firstColumn);
        this.dataCell = (NSTextFieldCell)new SWTImageTextCell().alloc().init();
        this.dataCell.setLineBreakMode(4);
        this.firstColumn.setDataCell(this.dataCell);
        this.scrollView = nSScrollView;
        this.view = nSOutlineView;
    }

    void createItem(TreeColumn treeColumn, int n) {
        Object object;
        NSObject nSObject;
        Object object2;
        if (0 > n || n > this.columnCount) {
            this.error(6);
        }
        if (n == 0) {
            treeColumn.style &= 0xFEFDBFFF;
            treeColumn.style |= 0x4000;
        }
        if (this.columnCount == this.columns.length) {
            object2 = new TreeColumn[this.columnCount + 4];
            System.arraycopy(this.columns, 0, object2, 0, this.columns.length);
            this.columns = object2;
        }
        if (this.columnCount == 0) {
            object2 = this.firstColumn;
            ((NSTableColumn)object2).setMinWidth(0.0f);
            ((NSTableColumn)object2).setResizingMask(2);
            this.firstColumn = null;
        } else {
            nSObject = (NSOutlineView)this.view;
            NSString nSString = NSString.string();
            object2 = (NSTableColumn)new NSTableColumn().alloc();
            object = (NSString)new NSString().alloc();
            object = ((NSString)object).initWithString(String.valueOf(++NEXT_ID));
            object2 = ((NSTableColumn)object2).initWithIdentifier((NSString)object);
            ((NSObject)object).release();
            ((NSTableColumn)object2).setMinWidth(0.0f);
            ((NSTableColumn)object2).headerCell().setTitle(nSString);
            ((NSTableView)nSObject).addTableColumn((NSTableColumn)object2);
            int n2 = (this.style & 0x20) != 0 ? 1 : 0;
            ((NSTableView)nSObject).moveColumn(this.columnCount + n2, n + n2);
            ((NSTableColumn)object2).setDataCell(this.dataCell);
            if (n == 0) {
                ((NSOutlineView)nSObject).setOutlineTableColumn((NSTableColumn)object2);
            }
        }
        treeColumn.createJNIRef();
        nSObject = (NSTableHeaderCell)new SWTTableHeaderCell().alloc().init();
        ((NSTableColumn)object2).setHeaderCell((NSCell)nSObject);
        this.display.addWidget(nSObject, treeColumn);
        treeColumn.nsColumn = object2;
        ((NSTableColumn)object2).setWidth(0.0f);
        System.arraycopy(this.columns, n, this.columns, n + 1, this.columnCount++ - n);
        this.columns[n] = treeColumn;
        for (int i = 0; i < this.itemCount; ++i) {
            object = this.items[i];
            if (object == null || this.columnCount <= 1) continue;
            this.createColumn((TreeItem)object, n);
        }
    }

    void createItem(TreeItem treeItem, TreeItem treeItem2, int n) {
        Object object;
        TreeItem[] treeItemArray;
        int n2;
        if (treeItem2 != null) {
            n2 = treeItem2.itemCount;
            treeItemArray = treeItem2.items;
        } else {
            n2 = this.itemCount;
            treeItemArray = this.items;
        }
        if (n == -1) {
            n = n2;
        }
        if (0 > n || n > n2) {
            this.error(6);
        }
        if (n2 == treeItemArray.length) {
            object = new TreeItem[treeItemArray.length + 4];
            System.arraycopy(treeItemArray, 0, object, 0, treeItemArray.length);
            treeItemArray = object;
            if (treeItem2 != null) {
                treeItem2.items = treeItemArray;
            } else {
                this.items = treeItemArray;
            }
        }
        System.arraycopy(treeItemArray, n, treeItemArray, n + 1, n2++ - n);
        treeItemArray[n] = treeItem;
        treeItem.items = new TreeItem[4];
        treeItem.handle = object = (SWTTreeItem)new SWTTreeItem().alloc().init();
        treeItem.createJNIRef();
        treeItem.register();
        if (treeItem2 != null) {
            treeItem2.itemCount = n2;
        } else {
            this.itemCount = n2;
        }
        this.ignoreExpand = true;
        NSOutlineView nSOutlineView = (NSOutlineView)this.view;
        if (this.getDrawing()) {
            TreeItem[] treeItemArray2 = this.getSelection();
            if (treeItem2 != null) {
                nSOutlineView.reloadItem(treeItem2.handle, true);
            } else {
                nSOutlineView.reloadData();
            }
            this.selectItems(treeItemArray2, true);
        } else {
            this.reloadPending = true;
        }
        if (treeItem2 != null && treeItem2.itemCount == 1 && treeItem2.expanded) {
            nSOutlineView.expandItem(treeItem2.handle);
        }
        this.ignoreExpand = false;
    }

    void createWidget() {
        super.createWidget();
        this.items = new TreeItem[4];
        this.columns = new TreeColumn[4];
    }

    Color defaultBackground() {
        return this.display.getWidgetColor(25);
    }

    NSFont defaultNSFont() {
        return this.display.outlineViewFont;
    }

    Color defaultForeground() {
        return this.display.getWidgetColor(24);
    }

    void deselectAll(int n, int n2, int n3) {
        if (this.preventSelect && !this.ignoreSelect) {
            return;
        }
        if ((this.style & 4) != 0 && !this.ignoreSelect && ((NSTableView)this.view).selectedRow() != -1) {
            return;
        }
        super.deselectAll(n, n2, n3);
    }

    void deselectRow(int n, int n2, int n3) {
        if (this.preventSelect && !this.ignoreSelect) {
            return;
        }
        if ((this.style & 4) != 0 && !this.ignoreSelect && ((NSTableView)this.view).selectedRow() == n3) {
            return;
        }
        super.deselectRow(n, n2, n3);
    }

    public void deselectAll() {
        this.checkWidget();
        NSOutlineView nSOutlineView = (NSOutlineView)this.view;
        this.ignoreSelect = true;
        nSOutlineView.deselectAll(null);
        this.ignoreSelect = false;
    }

    void deregister() {
        super.deregister();
        this.display.removeWidget(this.headerView);
        this.display.removeWidget(this.dataCell);
        if (this.buttonCell != null) {
            this.display.removeWidget(this.buttonCell);
        }
    }

    public void deselect(TreeItem treeItem) {
        this.checkWidget();
        if (treeItem == null) {
            this.error(4);
        }
        if (treeItem.isDisposed()) {
            this.error(5);
        }
        NSOutlineView nSOutlineView = (NSOutlineView)this.view;
        int n = nSOutlineView.rowForItem(treeItem.handle);
        this.ignoreSelect = true;
        nSOutlineView.deselectRow(n);
        this.ignoreSelect = false;
    }

    void destroyItem(TreeColumn treeColumn) {
        Object object;
        int n;
        int n2;
        for (n2 = 0; n2 < this.columnCount && this.columns[n2] != treeColumn; ++n2) {
        }
        for (n = 0; n < this.items.length; ++n) {
            Object[] objectArray;
            Object[] objectArray2;
            object = this.items[n];
            if (object == null) continue;
            if (this.columnCount <= 1) {
                ((TreeItem)object).strings = null;
                ((TreeItem)object).images = null;
                ((TreeItem)object).cellBackground = null;
                ((TreeItem)object).cellForeground = null;
                ((TreeItem)object).cellFont = null;
                continue;
            }
            if (((TreeItem)object).strings != null) {
                objectArray2 = ((TreeItem)object).strings;
                if (n2 == 0) {
                    ((TreeItem)object).text = objectArray2[1] != null ? objectArray2[1] : "";
                }
                objectArray = new String[this.columnCount - 1];
                System.arraycopy(objectArray2, 0, objectArray, 0, n2);
                System.arraycopy(objectArray2, n2 + 1, objectArray, n2, this.columnCount - 1 - n2);
                ((TreeItem)object).strings = objectArray;
            } else if (n2 == 0) {
                ((TreeItem)object).text = "";
            }
            if (((TreeItem)object).images != null) {
                objectArray2 = ((TreeItem)object).images;
                if (n2 == 0) {
                    ((TreeItem)object).image = objectArray2[1];
                }
                objectArray = new Image[this.columnCount - 1];
                System.arraycopy(objectArray2, 0, objectArray, 0, n2);
                System.arraycopy(objectArray2, n2 + 1, objectArray, n2, this.columnCount - 1 - n2);
                ((TreeItem)object).images = objectArray;
            } else if (n2 == 0) {
                ((TreeItem)object).image = null;
            }
            if (((TreeItem)object).cellBackground != null) {
                objectArray2 = ((TreeItem)object).cellBackground;
                objectArray = new Color[this.columnCount - 1];
                System.arraycopy(objectArray2, 0, objectArray, 0, n2);
                System.arraycopy(objectArray2, n2 + 1, objectArray, n2, this.columnCount - 1 - n2);
                ((TreeItem)object).cellBackground = objectArray;
            }
            if (((TreeItem)object).cellForeground != null) {
                objectArray2 = ((TreeItem)object).cellForeground;
                objectArray = new Color[this.columnCount - 1];
                System.arraycopy(objectArray2, 0, objectArray, 0, n2);
                System.arraycopy(objectArray2, n2 + 1, objectArray, n2, this.columnCount - 1 - n2);
                ((TreeItem)object).cellForeground = objectArray;
            }
            if (((TreeItem)object).cellFont == null) continue;
            objectArray2 = ((TreeItem)object).cellFont;
            objectArray = new Font[this.columnCount - 1];
            System.arraycopy(objectArray2, 0, objectArray, 0, n2);
            System.arraycopy(objectArray2, n2 + 1, objectArray, n2, this.columnCount - 1 - n2);
            ((TreeItem)object).cellFont = objectArray;
        }
        n = this.indexOf(treeColumn.nsColumn);
        System.arraycopy(this.columns, n2 + 1, this.columns, n2, --this.columnCount - n2);
        this.columns[this.columnCount] = null;
        if (this.columnCount == 0) {
            this.firstColumn = treeColumn.nsColumn;
            this.firstColumn.retain();
            this.firstColumn.setMinWidth(5.0f);
            this.firstColumn.setResizingMask(0);
            this.setScrollWidth();
        } else {
            if (n2 == 0) {
                ((NSOutlineView)this.view).setOutlineTableColumn(this.columns[0].nsColumn);
            }
            ((NSOutlineView)this.view).removeTableColumn(treeColumn.nsColumn);
        }
        object = ((NSOutlineView)this.view).tableColumns();
        int n3 = ((NSArray)object).count();
        block2: for (int i = n; i < n3; ++i) {
            int n4 = ((NSArray)object).objectAtIndex((int)i).id;
            for (int j = 0; j < this.columnCount; ++j) {
                if (this.columns[j].nsColumn.id != n4) continue;
                this.columns[j].sendEvent(10);
                continue block2;
            }
        }
    }

    void destroyItem(TreeItem treeItem) {
        int n;
        TreeItem[] treeItemArray;
        int n2;
        TreeItem treeItem2 = treeItem.parentItem;
        if (treeItem2 != null) {
            n2 = treeItem2.itemCount;
            treeItemArray = treeItem2.items;
        } else {
            n2 = this.itemCount;
            treeItemArray = this.items;
        }
        for (n = 0; n < n2 && treeItemArray[n] != treeItem; ++n) {
        }
        System.arraycopy(treeItemArray, n + 1, treeItemArray, n, --n2 - n);
        treeItemArray[n2] = null;
        if (treeItem2 != null) {
            treeItem2.itemCount = n2;
        } else {
            this.itemCount = n2;
        }
        NSOutlineView nSOutlineView = (NSOutlineView)this.view;
        if (this.getDrawing()) {
            if (treeItem2 != null) {
                nSOutlineView.reloadItem(treeItem2.handle, true);
            } else {
                nSOutlineView.reloadData();
            }
        } else {
            this.reloadPending = true;
        }
        this.setScrollWidth();
        if (this.itemCount == 0) {
            this.imageBounds = null;
        }
        if (this.insertItem == treeItem) {
            this.insertItem = null;
        }
    }

    boolean dragDetect(int n, int n2, boolean bl, boolean[] blArray) {
        return false;
    }

    void drawBackgroundInClipRect(int n, int n2, NSRect nSRect) {
        super.drawViewBackgroundInRect(n, n2, nSRect);
        if (n != this.view.id) {
            return;
        }
        this.fillBackground(this.view, NSGraphicsContext.currentContext(), nSRect, -1);
    }

    void drawInteriorWithFrame_inView(int n, int n2, NSRect nSRect, int n3) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        boolean bl;
        Color color;
        boolean bl2 = this.hooks(40);
        boolean bl3 = this.hooks(42);
        boolean bl4 = this.hooks(41);
        NSTextFieldCell nSTextFieldCell = new NSTextFieldCell(n);
        NSOutlineView nSOutlineView = (NSOutlineView)this.view;
        int[] nArray = new int[1];
        OS.object_getInstanceVariable(n, Display.SWT_ROW, nArray);
        TreeItem treeItem = (TreeItem)this.display.getWidget(nArray[0]);
        if (treeItem == null) {
            return;
        }
        int n4 = nSOutlineView.rowForItem(treeItem.handle);
        OS.object_getInstanceVariable(n, Display.SWT_COLUMN, nArray);
        int n5 = nArray[0];
        int n6 = nSOutlineView.tableColumns().indexOfObjectIdenticalTo(new id(n5));
        int n7 = 0;
        for (int i = 0; i < this.columnCount; ++i) {
            if (this.columns[i].nsColumn.id != n5) continue;
            n7 = i;
            break;
        }
        Color color2 = color = treeItem.cellBackground != null ? treeItem.cellBackground[n7] : null;
        if (color == null) {
            color = treeItem.background;
        }
        boolean bl5 = color != null;
        boolean bl6 = true;
        boolean bl7 = bl = nSTextFieldCell.isHighlighted();
        boolean bl8 = this.hasFocus();
        Color color3 = null;
        Color color4 = null;
        if (bl && (bl2 || bl3)) {
            color4 = Color.cocoa_new(this.display, bl8 ? this.display.alternateSelectedControlTextColor : this.display.selectedControlTextColor);
            color3 = Color.cocoa_new(this.display, bl8 ? this.display.alternateSelectedControlColor : this.display.secondarySelectedControlColor);
        }
        NSSize nSSize = super.cellSize(n, OS.sel_cellSize);
        NSImage nSImage = nSTextFieldCell.image();
        if (nSImage != null) {
            nSSize.width += (float)(this.imageBounds.width + 3);
        }
        int n8 = (int)Math.ceil(nSSize.width);
        NSSize nSSize2 = nSOutlineView.intercellSpacing();
        int n9 = (int)Math.ceil(nSOutlineView.rowHeight() + nSSize2.height);
        NSRect nSRect2 = nSOutlineView.rectOfColumn(n6);
        nSRect2.y = nSRect.y;
        nSRect2.height = nSRect.height + nSSize2.height;
        if (this.columnCount == 0) {
            NSRect nSRect3 = nSOutlineView.rectOfRow(n4);
            nSRect2.width = nSRect3.width;
        }
        float f = 0.0f;
        float f2 = 0.0f;
        if (bl3 || bl2) {
            NSRect nSRect4 = nSOutlineView.frameOfCellAtColumn(n6, n4);
            f = nSRect.x - nSRect4.x;
            f2 = nSRect.y - nSRect4.y;
            if (this.drawExpansion) {
                f -= 0.5f;
                f2 -= 0.5f;
            }
        }
        int n10 = (int)(nSRect.x - f);
        int n11 = (int)(nSRect.y - f2);
        NSGraphicsContext nSGraphicsContext = NSGraphicsContext.currentContext();
        if (bl4) {
            this.sendMeasureItem(treeItem, nSTextFieldCell.isHighlighted(), n7, nSSize);
        }
        Color color5 = null;
        if (bl2) {
            nSGraphicsContext.saveGraphicsState();
            object5 = NSAffineTransform.transform();
            ((NSAffineTransform)object5).translateXBy(f, f2);
            ((NSAffineTransform)object5).concat();
            object4 = new GCData();
            ((GCData)object4).paintRect = nSRect2;
            object3 = GC.cocoa_new(this, (GCData)object4);
            ((GC)object3).setFont(treeItem.getFont(n7));
            if (bl && ((this.style & 0x8000) == 0 || bl8)) {
                object2 = color4;
                ((GC)object3).setBackground(color3);
            } else {
                object2 = treeItem.getForeground(n7);
                ((GC)object3).setBackground(treeItem.getBackground(n7));
            }
            ((GC)object3).setForeground((Color)object2);
            if (!this.drawExpansion) {
                ((GC)object3).setClipping((int)(nSRect2.x - f), (int)(nSRect2.y - f2), (int)nSRect2.width, (int)nSRect2.height);
            }
            object = new Event();
            ((Event)object).item = treeItem;
            ((Event)object).gc = object3;
            ((Event)object).index = n7;
            ((Event)object).detail = 16;
            if (bl5) {
                ((Event)object).detail |= 8;
            }
            if (bl && ((this.style & 0x8000) == 0 || bl8)) {
                ((Event)object).detail |= 2;
            }
            ((Event)object).x = (int)nSRect2.x;
            ((Event)object).y = (int)nSRect2.y;
            ((Event)object).width = (int)nSRect2.width;
            ((Event)object).height = (int)nSRect2.height;
            this.sendEvent(40, (Event)object);
            if (!((Event)object).doit) {
                bl7 = false;
                bl5 = false;
                bl6 = false;
            } else {
                bl5 = bl5 && (((Event)object).detail & 8) != 0;
                bl6 = (((Event)object).detail & 0x10) != 0;
                boolean bl9 = bl7 = bl7 && (((Event)object).detail & 2) != 0;
            }
            if (!bl7 && bl) {
                color5 = Color.cocoa_new(this.display, ((GC)object3).getForeground().handle);
            }
            ((Resource)object3).dispose();
            nSGraphicsContext.restoreGraphicsState();
            if (this.isDisposed()) {
                return;
            }
            if (treeItem.isDisposed()) {
                return;
            }
            if (bl7 && ((this.style & 0x8000) == 0 || bl8)) {
                nSRect2.height -= nSSize2.height;
                this.callSuper(nSOutlineView.id, OS.sel_highlightSelectionInClipRect_, nSRect2);
                nSRect2.height += nSSize2.height;
            }
        } else if (bl && (this.style & 0x8000) != 0 && !bl8) {
            color5 = treeItem.getForeground(n7);
        }
        if (bl5 && !bl7) {
            nSGraphicsContext.saveGraphicsState();
            object5 = color.handle;
            object4 = NSColor.colorWithDeviceRed((float)object5[0], (float)object5[1], (float)object5[2], 1.0f);
            ((NSColor)object4).setFill();
            NSBezierPath.fillRect(nSRect2);
            nSGraphicsContext.restoreGraphicsState();
        }
        if (treeItem == this.insertItem && this.insertItem != null && !this.insertItem.isDisposed()) {
            nSGraphicsContext.saveGraphicsState();
            object5 = nSTextFieldCell.titleRectForBounds(nSRect);
            object4 = new GCData();
            ((GCData)object4).paintRect = object5;
            object3 = GC.cocoa_new(this, (GCData)object4);
            ((GC)object3).setClipping((int)(((NSRect)object5).x - f), (int)(((NSRect)object5).y - f2), (int)((NSRect)object5).width, (int)((NSRect)object5).height);
            object2 = this.insertItem.getImageBounds(0).union(this.insertItem.getBounds());
            object = this.getClientArea();
            int n12 = ((Rectangle)object).x + ((Rectangle)object).width;
            int n13 = this.insertBefore ? ((Rectangle)object2).y : ((Rectangle)object2).y + ((Rectangle)object2).height - 1;
            ((GC)object3).drawLine(((Rectangle)object2).x, n13, n12, n13);
            ((Resource)object3).dispose();
            nSGraphicsContext.restoreGraphicsState();
        }
        if (bl6) {
            if ((!this.drawExpansion || bl4) && nSImage != null) {
                object5 = new NSRect();
                ((NSRect)object5).x = nSRect.x + 3.0f;
                ((NSRect)object5).y = nSRect.y + (float)Math.ceil((nSRect.height - (float)this.imageBounds.height) / 2.0f);
                ((NSRect)object5).width = this.imageBounds.width;
                ((NSRect)object5).height = this.imageBounds.height;
                object4 = new NSRect();
                object3 = nSImage.size();
                ((NSRect)object4).width = ((NSSize)object3).width;
                ((NSRect)object4).height = ((NSSize)object3).height;
                nSGraphicsContext.saveGraphicsState();
                NSBezierPath.bezierPathWithRect(nSRect).addClip();
                object2 = NSAffineTransform.transform();
                ((NSAffineTransform)object2).scaleXBy(1.0f, -1.0f);
                ((NSAffineTransform)object2).translateXBy(0.0f, -(((NSRect)object5).height + 2.0f * ((NSRect)object5).y));
                ((NSAffineTransform)object2).concat();
                nSImage.drawInRect((NSRect)object5, (NSRect)object4, 2, 1.0f);
                nSGraphicsContext.restoreGraphicsState();
                int n14 = this.imageBounds.width + 3;
                nSRect.x += (float)n14;
                nSRect.width -= (float)n14;
            }
            nSTextFieldCell.setHighlighted(false);
            boolean bl10 = false;
            if (color5 != null) {
                object4 = color5.handle;
                if (object4[0] == 0.0f && object4[1] == 0.0f && object4[2] == 0.0f && object4[3] == 1.0f) {
                    object3 = new NSMutableAttributedString(nSTextFieldCell.attributedStringValue().mutableCopy());
                    object2 = new NSRange();
                    ((NSRange)object2).length = ((NSAttributedString)object3).length();
                    ((NSMutableAttributedString)object3).removeAttribute(OS.NSForegroundColorAttributeName, (NSRange)object2);
                    int n15 = this.columnCount == 0 ? 16384 : this.columns[n7].style & 0x1024000;
                    NSSize nSSize3 = ((NSAttributedString)object3).size();
                    NSRect nSRect5 = new NSRect();
                    nSRect5.x = nSRect.x + 2.0f;
                    nSRect5.y = nSRect.y;
                    nSRect5.width = nSRect.width - 2.0f;
                    switch (n15) {
                        case 0x1000000: {
                            nSRect5.width -= 2.0f;
                            break;
                        }
                        case 131072: {
                            if (!(nSRect.width > nSSize3.width)) break;
                            nSRect5.width -= 2.0f;
                        }
                    }
                    nSRect5.height = nSRect.height;
                    if (nSRect5.height > nSSize3.height) {
                        nSRect5.y += (nSRect5.height - nSSize3.height) / 2.0f;
                        nSRect5.height = nSSize3.height;
                    }
                    ((NSAttributedString)object3).drawInRect(nSRect5);
                    ((NSObject)object3).release();
                } else {
                    object3 = NSColor.colorWithDeviceRed((float)object4[0], (float)object4[1], (float)object4[2], (float)object4[3]);
                    nSTextFieldCell.setTextColor((NSColor)object3);
                    bl10 = true;
                }
            } else {
                bl10 = true;
            }
            if (bl10) {
                object4 = nSTextFieldCell.attributedStringValue();
                object3 = ((NSAttributedString)object4).size();
                if (nSRect.height > ((NSSize)object3).height) {
                    nSRect.y += (nSRect.height - ((NSSize)object3).height) / 2.0f;
                    nSRect.height = ((NSSize)object3).height;
                }
                super.drawInteriorWithFrame_inView(n, n2, nSRect, n3);
            }
        }
        if (bl3) {
            nSGraphicsContext.saveGraphicsState();
            NSAffineTransform nSAffineTransform = NSAffineTransform.transform();
            nSAffineTransform.translateXBy(f, f2);
            nSAffineTransform.concat();
            object4 = new GCData();
            ((GCData)object4).paintRect = nSRect2;
            object3 = GC.cocoa_new(this, (GCData)object4);
            ((GC)object3).setFont(treeItem.getFont(n7));
            if (bl7) {
                ((GC)object3).setForeground(color4);
                ((GC)object3).setBackground(color3);
            } else {
                ((GC)object3).setForeground(color5 != null ? color5 : treeItem.getForeground(n7));
                ((GC)object3).setBackground(treeItem.getBackground(n7));
            }
            if (!this.drawExpansion) {
                ((GC)object3).setClipping((int)(nSRect2.x - f), (int)(nSRect2.y - f2), (int)nSRect2.width, (int)nSRect2.height);
            }
            object2 = new Event();
            ((Event)object2).item = treeItem;
            ((Event)object2).gc = object3;
            ((Event)object2).index = n7;
            if (bl6) {
                ((Event)object2).detail |= 0x10;
            }
            if (bl5) {
                ((Event)object2).detail |= 8;
            }
            if (bl) {
                ((Event)object2).detail |= 2;
            }
            ((Event)object2).x = n10;
            ((Event)object2).y = n11;
            ((Event)object2).width = n8;
            ((Event)object2).height = n9;
            this.sendEvent(42, (Event)object2);
            ((Resource)object3).dispose();
            nSGraphicsContext.restoreGraphicsState();
        }
    }

    void drawWithExpansionFrame_inView(int n, int n2, NSRect nSRect, int n3) {
        this.drawExpansion = true;
        super.drawWithExpansionFrame_inView(n, n2, nSRect, n3);
        this.drawExpansion = false;
    }

    void expandItem_expandChildren(int n, int n2, int n3, boolean bl) {
        TreeItem treeItem = (TreeItem)this.display.getWidget(n3);
        if (treeItem == null) {
            return;
        }
        if (!this.ignoreExpand) {
            treeItem.sendExpand(true, bl);
        }
        this.ignoreExpand = true;
        super.expandItem_expandChildren(n, n2, n3, bl);
        this.ignoreExpand = false;
        if (this.isDisposed() || treeItem.isDisposed()) {
            return;
        }
        if (!bl) {
            this.ignoreExpand = true;
            TreeItem[] treeItemArray = treeItem.items;
            for (int i = 0; i < treeItem.itemCount; ++i) {
                if (treeItemArray[i] == null) continue;
                treeItemArray[i].updateExpanded();
            }
            this.ignoreExpand = false;
        }
        this.setScrollWidth(false, treeItem.items, true);
    }

    NSRect expansionFrameWithFrame_inView(int n, int n2, NSRect nSRect, int n3) {
        if (this.toolTipText == null) {
            NSRect nSRect2;
            NSRect nSRect3 = super.expansionFrameWithFrame_inView(n, n2, nSRect, n3);
            NSCell nSCell = new NSCell(n);
            NSAttributedString nSAttributedString = nSCell.attributedStringValue();
            NSSize nSSize = nSAttributedString.size();
            if (nSRect3.width != 0.0f && nSRect3.height != 0.0f) {
                if (this.hooks(41)) {
                    nSRect2 = nSRect;
                    NSSize nSSize2 = nSCell.cellSize();
                    nSRect2.width = nSSize2.width;
                } else {
                    nSRect2 = nSRect3;
                }
                if (nSSize.height > nSRect2.height) {
                    nSRect2.height = nSSize.height;
                }
            } else {
                Object object;
                if (this.hooks(41)) {
                    nSRect2 = nSRect;
                    object = nSCell.cellSize();
                    nSRect2.width = ((NSSize)object).width;
                } else {
                    nSRect2 = nSCell.titleRectForBounds(nSRect);
                    object = super.cellSize(n, OS.sel_cellSize);
                    nSRect2.width = ((NSSize)object).width;
                }
                if (nSSize.height > nSRect2.height) {
                    nSRect2.height = nSSize.height;
                } else {
                    object = this.scrollView.contentView().bounds();
                    OS.NSIntersectionRect((NSRect)object, nSRect2, (NSRect)object);
                    if (OS.NSEqualRects(nSRect2, (NSRect)object)) {
                        return new NSRect();
                    }
                }
            }
            return nSRect2;
        }
        return new NSRect();
    }

    Widget findTooltip(NSPoint nSPoint) {
        int n;
        NSTableView nSTableView = (NSTableView)this.view;
        NSTableHeaderView nSTableHeaderView = nSTableView.headerView();
        if (nSTableHeaderView != null && (n = nSTableHeaderView.columnAtPoint(nSPoint = nSTableHeaderView.convertPoint_fromView_(nSPoint, null))) != -1) {
            NSArray nSArray = nSTableView.tableColumns();
            id id2 = nSArray.objectAtIndex(n);
            for (int i = 0; i < this.columnCount; ++i) {
                TreeColumn treeColumn = this.columns[i];
                if (treeColumn.nsColumn.id != id2.id) continue;
                return treeColumn;
            }
        }
        return super.findTooltip(nSPoint);
    }

    int getCheckColumnWidth() {
        return (int)this.checkColumn.dataCell().cellSize().width;
    }

    public Rectangle getClientArea() {
        this.checkWidget();
        Rectangle rectangle = super.getClientArea();
        NSTableHeaderView nSTableHeaderView = ((NSTableView)this.view).headerView();
        if (nSTableHeaderView != null) {
            int n = (int)nSTableHeaderView.bounds().height;
            rectangle.y -= n;
            rectangle.height += n;
        }
        return rectangle;
    }

    TreeColumn getColumn(id id2) {
        for (int i = 0; i < this.columnCount; ++i) {
            if (this.columns[i].nsColumn.id != id2.id) continue;
            return this.columns[i];
        }
        return null;
    }

    public TreeColumn getColumn(int n) {
        this.checkWidget();
        if (0 > n || n >= this.columnCount) {
            this.error(6);
        }
        return this.columns[n];
    }

    public int getColumnCount() {
        this.checkWidget();
        return this.columnCount;
    }

    public int[] getColumnOrder() {
        this.checkWidget();
        int[] nArray = new int[this.columnCount];
        int n = 0;
        while (n < this.columnCount) {
            TreeColumn treeColumn = this.columns[n];
            int n2 = this.indexOf(treeColumn.nsColumn);
            if ((this.style & 0x20) != 0) {
                --n2;
            }
            nArray[n2] = n++;
        }
        return nArray;
    }

    public TreeColumn[] getColumns() {
        this.checkWidget();
        TreeColumn[] treeColumnArray = new TreeColumn[this.columnCount];
        System.arraycopy(this.columns, 0, treeColumnArray, 0, this.columnCount);
        return treeColumnArray;
    }

    public int getGridLineWidth() {
        this.checkWidget();
        return 0;
    }

    public int getHeaderHeight() {
        this.checkWidget();
        NSTableHeaderView nSTableHeaderView = ((NSOutlineView)this.view).headerView();
        if (nSTableHeaderView == null) {
            return 0;
        }
        return (int)nSTableHeaderView.bounds().height;
    }

    public boolean getHeaderVisible() {
        this.checkWidget();
        return ((NSOutlineView)this.view).headerView() != null;
    }

    public TreeItem getItem(int n) {
        this.checkWidget();
        int n2 = this.getItemCount();
        if (n < 0 || n >= n2) {
            this.error(6);
        }
        return this._getItem(null, n, true);
    }

    public TreeItem getItem(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        this.checkItems();
        NSOutlineView nSOutlineView = (NSOutlineView)this.view;
        NSPoint nSPoint = new NSPoint();
        nSPoint.x = point.x;
        nSPoint.y = point.y;
        int n = nSOutlineView.rowAtPoint(nSPoint);
        if (n == -1) {
            return null;
        }
        NSRect nSRect = nSOutlineView.frameOfOutlineCellAtRow(n);
        if (OS.NSPointInRect(nSPoint, nSRect)) {
            return null;
        }
        id id2 = nSOutlineView.itemAtRow(n);
        Widget widget = this.display.getWidget(id2.id);
        if (widget != null && widget instanceof TreeItem) {
            return (TreeItem)widget;
        }
        return null;
    }

    public int getItemCount() {
        this.checkWidget();
        return this.itemCount;
    }

    int getItemCount(TreeItem treeItem) {
        return treeItem == null ? this.itemCount : treeItem.itemCount;
    }

    public int getItemHeight() {
        this.checkWidget();
        return (int)((NSOutlineView)this.view).rowHeight() + 1;
    }

    public TreeItem[] getItems() {
        this.checkWidget();
        TreeItem[] treeItemArray = new TreeItem[this.itemCount];
        for (int i = 0; i < this.itemCount; ++i) {
            treeItemArray[i] = this._getItem(null, i, true);
        }
        return treeItemArray;
    }

    public boolean getLinesVisible() {
        this.checkWidget();
        return ((NSOutlineView)this.view).usesAlternatingRowBackgroundColors();
    }

    public TreeItem getParentItem() {
        this.checkWidget();
        return null;
    }

    public TreeItem[] getSelection() {
        this.checkWidget();
        NSOutlineView nSOutlineView = (NSOutlineView)this.view;
        if (nSOutlineView.numberOfSelectedRows() == 0) {
            return new TreeItem[0];
        }
        NSIndexSet nSIndexSet = nSOutlineView.selectedRowIndexes();
        int n = nSIndexSet.count();
        int[] nArray = new int[n];
        nSIndexSet.getIndexes(nArray, n, 0);
        TreeItem[] treeItemArray = new TreeItem[n];
        for (int i = 0; i < n; ++i) {
            id id2 = nSOutlineView.itemAtRow(nArray[i]);
            Widget widget = this.display.getWidget(id2.id);
            if (widget == null || !(widget instanceof TreeItem)) continue;
            treeItemArray[i] = (TreeItem)widget;
        }
        return treeItemArray;
    }

    public int getSelectionCount() {
        this.checkWidget();
        return ((NSOutlineView)this.view).numberOfSelectedRows();
    }

    public TreeColumn getSortColumn() {
        this.checkWidget();
        return this.sortColumn;
    }

    public int getSortDirection() {
        this.checkWidget();
        return this.sortDirection;
    }

    public TreeItem getTopItem() {
        this.checkWidget();
        NSRect nSRect = this.scrollView.documentVisibleRect();
        NSPoint nSPoint = new NSPoint();
        nSPoint.x = nSRect.x;
        nSPoint.y = nSRect.y;
        NSOutlineView nSOutlineView = (NSOutlineView)this.view;
        int n = nSOutlineView.rowAtPoint(nSPoint);
        if (n == -1) {
            return null;
        }
        id id2 = nSOutlineView.itemAtRow(n);
        return (TreeItem)this.display.getWidget(id2.id);
    }

    NSRect headerRectOfColumn(int n, int n2, int n3) {
        if ((this.style & 0x20) == 0) {
            return this.callSuperRect(n, n2, n3);
        }
        if (n3 == 0) {
            NSRect nSRect = this.callSuperRect(n, n2, n3);
            nSRect.width = 0.0f;
            return nSRect;
        }
        if (n3 == 1) {
            NSRect nSRect = this.callSuperRect(n, n2, n3);
            nSRect.width += this.checkColumn.width() + 1.0f;
            nSRect.x -= this.checkColumn.width() + 1.0f;
            return nSRect;
        }
        return this.callSuperRect(n, n2, n3);
    }

    void highlightSelectionInClipRect(int n, int n2, int n3) {
        if (this.hooks(40)) {
            return;
        }
        if ((this.style & 0x8000) != 0 && !this.hasFocus()) {
            return;
        }
        NSRect nSRect = new NSRect();
        OS.memmove(nSRect, n3, NSRect.sizeof);
        this.callSuper(n, n2, nSRect);
    }

    int hitTestForEvent(int n, int n2, int n3, NSRect nSRect, int n4) {
        return this.callSuper(n, n2, n3, nSRect, n4);
    }

    int image(int n, int n2) {
        int[] nArray = new int[1];
        OS.object_getInstanceVariable(n, Display.SWT_IMAGE, nArray);
        return nArray[0];
    }

    NSRect imageRectForBounds(int n, int n2, NSRect nSRect) {
        NSImage nSImage = new NSCell(n).image();
        if (nSImage != null) {
            nSRect.x += 3.0f;
            nSRect.width = this.imageBounds.width;
            nSRect.height = this.imageBounds.height;
        }
        return nSRect;
    }

    int indexOf(NSTableColumn nSTableColumn) {
        return ((NSTableView)this.view).tableColumns().indexOfObjectIdenticalTo(nSTableColumn);
    }

    public int indexOf(TreeColumn treeColumn) {
        this.checkWidget();
        if (treeColumn == null) {
            this.error(4);
        }
        if (treeColumn.isDisposed()) {
            this.error(5);
        }
        for (int i = 0; i < this.columnCount; ++i) {
            if (this.columns[i] != treeColumn) continue;
            return i;
        }
        return -1;
    }

    public int indexOf(TreeItem treeItem) {
        this.checkWidget();
        if (treeItem == null) {
            this.error(4);
        }
        if (treeItem.isDisposed()) {
            this.error(5);
        }
        if (treeItem.parentItem != null) {
            return -1;
        }
        for (int i = 0; i < this.itemCount; ++i) {
            if (treeItem != this.items[i]) continue;
            return i;
        }
        return -1;
    }

    boolean isTransparent() {
        return true;
    }

    boolean isTrim(NSView nSView) {
        if (super.isTrim(nSView)) {
            return true;
        }
        return nSView.id == this.headerView.id;
    }

    void keyDown(int n, int n2, int n3) {
        this.preventSelect = false;
        this.ignoreSelect = false;
        super.keyDown(n, n2, n3);
    }

    int menuForEvent(int n, int n2, int n3) {
        if (n != this.headerView.id) {
            NSPoint nSPoint;
            int n4;
            NSEvent nSEvent = new NSEvent(n3);
            NSOutlineView nSOutlineView = (NSOutlineView)this.view;
            NSIndexSet nSIndexSet = nSOutlineView.selectedRowIndexes();
            if (!nSIndexSet.containsIndex(n4 = nSOutlineView.rowAtPoint(nSPoint = this.view.convertPoint_fromView_(nSEvent.locationInWindow(), null)))) {
                NSIndexSet nSIndexSet2 = (NSIndexSet)new NSIndexSet().alloc();
                nSIndexSet2 = nSIndexSet2.initWithIndex(n4);
                nSOutlineView.selectRowIndexes(nSIndexSet2, false);
                nSIndexSet2.release();
            }
        }
        return super.menuForEvent(n, n2, n3);
    }

    void mouseDown(int n, int n2, int n3) {
        NSEvent nSEvent;
        if (n == this.view.id && ((nSEvent = new NSEvent(n3)).modifierFlags() & 0x40000) != 0) {
            return;
        }
        super.mouseDown(n, n2, n3);
    }

    void mouseDownSuper(int n, int n2, int n3) {
        NSRect nSRect;
        NSRect nSRect2;
        int n4;
        NSCell nSCell;
        this.preventSelect = false;
        this.ignoreSelect = false;
        boolean bl = false;
        NSEvent nSEvent = new NSEvent(n3);
        NSOutlineView nSOutlineView = (NSOutlineView)this.view;
        NSPoint nSPoint = this.view.convertPoint_fromView_(nSEvent.locationInWindow(), null);
        int n5 = nSOutlineView.rowAtPoint(nSPoint);
        NSObject nSObject = null;
        if (n5 != -1) {
            nSObject = new NSObject(nSOutlineView.itemAtRow(n5));
        }
        if (n5 != -1 && (this.style & 0x20) != 0 && (nSCell = nSOutlineView.preparedCellAtColumn(n4 = nSOutlineView.columnAtPoint(nSPoint), n5)) != null && nSCell.isKindOfClass(OS.class_NSButtonCell) && nSCell.isEnabled() && OS.NSPointInRect(nSPoint, nSRect2 = nSCell.imageRectForBounds(nSOutlineView.frameOfCellAtColumn(n4, n5)))) {
            this.preventSelect = true;
            bl = true;
        }
        if (!bl && n5 != -1 && ((long)nSEvent.modifierFlags() & 0xFFFF0000L) == 0L && nSEvent.clickCount() == 1 && nSOutlineView.isRowSelected(n5) && !OS.NSPointInRect(nSPoint, nSRect = nSOutlineView.frameOfOutlineCellAtRow(n5))) {
            NSCell nSCell2 = nSCell = nSObject != null ? this.display.getWidget(nSObject.id) : null;
            if (nSCell != null && nSCell instanceof TreeItem) {
                this.selectedRowIndex = this.indexOf((TreeItem)((Object)nSCell));
            }
        }
        this.didSelect = false;
        if (nSObject != null) {
            nSObject.retain();
        }
        super.mouseDownSuper(n, n2, n3);
        if (nSObject != null) {
            nSObject.release();
        }
        this.didSelect = false;
    }

    boolean needsPanelToBecomeKey(int n, int n2) {
        return false;
    }

    int nextState(int n, int n2) {
        NSOutlineView nSOutlineView = (NSOutlineView)this.view;
        int n3 = nSOutlineView.clickedRow();
        if (n3 == -1) {
            n3 = nSOutlineView.selectedRow();
        }
        TreeItem treeItem = (TreeItem)this.display.getWidget(nSOutlineView.itemAtRow((int)n3).id);
        if (treeItem.grayed) {
            return treeItem.checked ? 0 : -1;
        }
        return treeItem.checked ? 0 : 1;
    }

    int outlineView_child_ofItem(int n, int n2, int n3, int n4, int n5) {
        TreeItem treeItem = (TreeItem)this.display.getWidget(n5);
        TreeItem treeItem2 = this._getItem(treeItem, n4, true);
        return treeItem2.handle.id;
    }

    void outlineView_didClickTableColumn(int n, int n2, int n3, int n4) {
        TreeColumn treeColumn = this.getColumn(new id(n4));
        if (treeColumn == null) {
            return;
        }
        treeColumn.sendSelectionEvent(13);
    }

    int outlineView_objectValueForTableColumn_byItem(int n, int n2, int n3, int n4, int n5) {
        TreeItem treeItem = (TreeItem)this.display.getWidget(n5);
        this.checkData(treeItem);
        if (this.checkColumn != null && n4 == this.checkColumn.id) {
            NSNumber nSNumber = treeItem.checked && treeItem.grayed ? NSNumber.numberWithInt(-1) : NSNumber.numberWithInt(treeItem.checked ? 1 : 0);
            return nSNumber.id;
        }
        for (int i = 0; i < this.columnCount; ++i) {
            if (this.columns[i].nsColumn.id != n4) continue;
            return treeItem.createString((int)i).id;
        }
        return treeItem.createString((int)0).id;
    }

    boolean outlineView_isItemExpandable(int n, int n2, int n3, int n4) {
        if (n4 == 0) {
            return true;
        }
        return ((TreeItem)this.display.getWidget((int)n4)).itemCount != 0;
    }

    int outlineView_numberOfChildrenOfItem(int n, int n2, int n3, int n4) {
        if (n4 == 0) {
            return this.itemCount;
        }
        return ((TreeItem)this.display.getWidget((int)n4)).itemCount;
    }

    boolean outlineView_shouldExpandItem_item(int n, int n2, int n3, int n4) {
        return this.shouldExpand;
    }

    boolean outlineView_shouldReorderColumn_toColumn(int n, int n2, int n3, int n4, int n5) {
        if ((this.style & 0x20) != 0) {
            if (n4 == 0) {
                return false;
            }
            if (n5 == 0) {
                return false;
            }
        }
        NSOutlineView nSOutlineView = new NSOutlineView(n3);
        id id2 = nSOutlineView.tableColumns().objectAtIndex(n4);
        for (int i = 0; i < this.columnCount; ++i) {
            if (this.columns[i].nsColumn.id != id2.id) continue;
            return this.columns[i].movable;
        }
        return true;
    }

    boolean outlineView_shouldTrackCell_forTableColumn_item(int n, int n2, int n3, int n4, int n5, int n6) {
        if ((this.style & 0x20) != 0 && new NSCell(n4).isKindOfClass(OS.class_NSButtonCell)) {
            return true;
        }
        NSOutlineView nSOutlineView = (NSOutlineView)this.view;
        int n7 = nSOutlineView.rowForItem(new id(n6));
        return nSOutlineView.isRowSelected(n7);
    }

    void outlineView_willDisplayCell_forTableColumn_item(int n, int n2, int n3, int n4, int n5, int n6) {
        Font font;
        NSColor nSColor;
        if (this.checkColumn != null && n5 == this.checkColumn.id) {
            return;
        }
        TreeItem treeItem = (TreeItem)this.display.getWidget(n6);
        int n7 = 0;
        for (int i = 0; i < this.columnCount; ++i) {
            if (this.columns[i].nsColumn.id != n5) continue;
            n7 = i;
            break;
        }
        NSTextFieldCell nSTextFieldCell = new NSTextFieldCell(n4);
        OS.object_setInstanceVariable(n4, Display.SWT_ROW, n6);
        OS.object_setInstanceVariable(n4, Display.SWT_COLUMN, n5);
        Image image = n7 == 0 ? treeItem.image : (treeItem.images == null ? null : treeItem.images[n7]);
        nSTextFieldCell.setImage(image != null ? image.handle : null);
        if (nSTextFieldCell.isEnabled()) {
            if (nSTextFieldCell.isHighlighted()) {
                nSColor = NSColor.selectedControlTextColor();
            } else {
                Color color;
                Color color2 = color = treeItem.cellForeground != null ? treeItem.cellForeground[n7] : null;
                if (color == null) {
                    color = treeItem.foreground;
                }
                if (color == null) {
                    color = this.getForegroundColor();
                }
                nSColor = NSColor.colorWithDeviceRed(color.handle[0], color.handle[1], color.handle[2], 1.0f);
            }
        } else {
            nSColor = NSColor.disabledControlTextColor();
        }
        int n8 = (this.style & 0x4000000) != 0 ? 1 : 0;
        int n9 = 0;
        if (this.columnCount > 0) {
            int n10 = this.columns[n7].style;
            if ((n10 & 0x1000000) != 0) {
                n9 = 2;
            } else if ((n10 & 0x20000) != 0) {
                n9 = 1;
            }
        }
        Font font2 = font = treeItem.cellFont != null ? treeItem.cellFont[n7] : null;
        if (font == null) {
            font = treeItem.font;
        }
        if (font == null) {
            font = this.font;
        }
        if (font == null) {
            font = this.defaultFont();
        }
        if (font.extraTraits != 0) {
            NSMutableDictionary nSMutableDictionary = ((NSMutableDictionary)new NSMutableDictionary().alloc()).initWithCapacity(5);
            nSMutableDictionary.setObject(nSColor, OS.NSForegroundColorAttributeName);
            nSMutableDictionary.setObject(font.handle, OS.NSFontAttributeName);
            this.addTraits(nSMutableDictionary, font);
            NSMutableParagraphStyle nSMutableParagraphStyle = (NSMutableParagraphStyle)new NSMutableParagraphStyle().alloc().init();
            nSMutableParagraphStyle.setLineBreakMode(2);
            nSMutableParagraphStyle.setAlignment(n9);
            nSMutableParagraphStyle.setBaseWritingDirection(n8);
            nSMutableDictionary.setObject(nSMutableParagraphStyle, OS.NSParagraphStyleAttributeName);
            nSMutableParagraphStyle.release();
            NSAttributedString nSAttributedString = ((NSAttributedString)new NSAttributedString().alloc()).initWithString(nSTextFieldCell.title(), nSMutableDictionary);
            nSTextFieldCell.setAttributedStringValue(nSAttributedString);
            nSAttributedString.release();
            nSMutableDictionary.release();
        } else {
            nSTextFieldCell.setFont(font.handle);
            nSTextFieldCell.setTextColor(nSColor);
            nSTextFieldCell.setAlignment(n9);
            nSTextFieldCell.setBaseWritingDirection(n8);
        }
    }

    void outlineViewColumnDidMove(int n, int n2, int n3) {
        NSNotification nSNotification = new NSNotification(n3);
        NSDictionary nSDictionary = nSNotification.userInfo();
        NSString nSString = (NSString)new NSString().alloc();
        nSString = nSString.initWithString("NSOldColumn");
        id id2 = nSDictionary.valueForKey(nSString);
        nSString.release();
        nSString = (NSString)new NSString().alloc();
        nSString = nSString.initWithString("NSNewColumn");
        id id3 = nSDictionary.valueForKey(nSString);
        nSString.release();
        int n4 = new NSNumber(id2).intValue();
        int n5 = new NSNumber(id3).intValue();
        NSOutlineView nSOutlineView = (NSOutlineView)this.view;
        int n6 = Math.min(n4, n5);
        int n7 = Math.max(n4, n5);
        NSArray nSArray = nSOutlineView.tableColumns();
        for (int i = n6; i <= n7; ++i) {
            id id4 = nSArray.objectAtIndex(i);
            TreeColumn treeColumn = this.getColumn(id4);
            if (treeColumn == null) continue;
            treeColumn.sendEvent(10);
            if (!this.isDisposed()) continue;
            return;
        }
        this.headerView.setNeedsDisplay(true);
    }

    void outlineViewColumnDidResize(int n, int n2, int n3) {
        NSNotification nSNotification = new NSNotification(n3);
        NSDictionary nSDictionary = nSNotification.userInfo();
        NSString nSString = (NSString)new NSString().alloc();
        nSString = nSString.initWithString("NSTableColumn");
        id id2 = nSDictionary.valueForKey(nSString);
        nSString.release();
        TreeColumn treeColumn = this.getColumn(id2);
        if (treeColumn == null) {
            return;
        }
        treeColumn.sendEvent(11);
        if (this.isDisposed()) {
            return;
        }
        NSOutlineView nSOutlineView = (NSOutlineView)this.view;
        int n4 = this.indexOf(treeColumn.nsColumn);
        if (n4 == -1) {
            return;
        }
        NSArray nSArray = nSOutlineView.tableColumns();
        int n5 = nSOutlineView.numberOfColumns();
        for (int i = n4 + 1; i < n5; ++i) {
            id2 = nSArray.objectAtIndex(i);
            treeColumn = this.getColumn(id2);
            if (treeColumn == null) continue;
            treeColumn.sendEvent(10);
            if (!this.isDisposed()) continue;
            return;
        }
    }

    void scrollClipViewToPoint(int n, int n2, int n3, NSPoint nSPoint) {
        if (this.shouldScroll) {
            super.scrollClipViewToPoint(n, n2, n3, nSPoint);
            if ((this.style & 0x20) != 0 && this.columnCount > 0 && ((NSOutlineView)this.view).headerView() != null && nSPoint.x <= (float)this.getCheckColumnWidth()) {
                this.headerView.setNeedsDisplayInRect(this.headerView.headerRectOfColumn(1));
            }
        }
    }

    void sendSelection() {
        if (this.ignoreSelect) {
            return;
        }
        NSOutlineView nSOutlineView = (NSOutlineView)this.view;
        int n = nSOutlineView.selectedRow();
        if (n == -1) {
            this.sendSelectionEvent(13);
        } else {
            id id2 = nSOutlineView.itemAtRow(n);
            TreeItem treeItem = (TreeItem)this.display.getWidget(id2.id);
            Event event = new Event();
            event.item = treeItem;
            event.index = n;
            this.sendSelectionEvent(13, event, false);
        }
    }

    void outlineViewSelectionDidChange(int n, int n2, int n3) {
        if (this.didSelect) {
            return;
        }
        this.sendSelection();
    }

    void outlineViewSelectionIsChanging(int n, int n2, int n3) {
        this.didSelect = true;
        this.sendSelection();
    }

    void outlineView_setObjectValue_forTableColumn_byItem(int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.checkColumn != null && n5 == this.checkColumn.id) {
            TreeItem treeItem = (TreeItem)this.display.getWidget(n6);
            treeItem.checked = !treeItem.checked;
            Event event = new Event();
            event.detail = 32;
            event.item = treeItem;
            this.sendSelectionEvent(13, event, false);
            treeItem.redraw(-1);
        }
    }

    boolean outlineView_writeItems_toPasteboard(int n, int n2, int n3, int n4, int n5) {
        return this.sendMouseEvent(NSApplication.sharedApplication().currentEvent(), 29, true);
    }

    void register() {
        super.register();
        this.display.addWidget(this.headerView, this);
        this.display.addWidget(this.dataCell, this);
        if (this.buttonCell != null) {
            this.display.addWidget(this.buttonCell, this);
        }
    }

    void releaseChildren(boolean bl) {
        Item item;
        int n;
        for (n = 0; n < this.items.length; ++n) {
            item = this.items[n];
            if (item == null || item.isDisposed()) continue;
            ((TreeItem)item).release(false);
        }
        this.items = null;
        if (this.columns != null) {
            for (n = 0; n < this.columnCount; ++n) {
                item = this.columns[n];
                if (item == null || item.isDisposed()) continue;
                item.release(false);
            }
            this.columns = null;
        }
        super.releaseChildren(bl);
    }

    void releaseHandle() {
        super.releaseHandle();
        if (this.headerView != null) {
            this.headerView.release();
        }
        this.headerView = null;
        if (this.firstColumn != null) {
            this.firstColumn.release();
        }
        this.firstColumn = null;
        if (this.checkColumn != null) {
            this.checkColumn.release();
        }
        this.checkColumn = null;
        if (this.dataCell != null) {
            this.dataCell.release();
        }
        this.dataCell = null;
        if (this.buttonCell != null) {
            this.buttonCell.release();
        }
        this.buttonCell = null;
    }

    void releaseWidget() {
        super.releaseWidget();
        this.sortColumn = null;
    }

    public void removeAll() {
        this.checkWidget();
        for (int i = 0; i < this.items.length; ++i) {
            TreeItem treeItem = this.items[i];
            if (treeItem == null || treeItem.isDisposed()) continue;
            treeItem.release(false);
        }
        this.items = new TreeItem[4];
        this.itemCount = 0;
        this.imageBounds = null;
        this.insertItem = null;
        this.ignoreSelect = true;
        ((NSOutlineView)this.view).reloadData();
        this.ignoreSelect = false;
        this.setScrollWidth();
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void removeTreeListener(TreeListener treeListener) {
        this.checkWidget();
        if (treeListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(17, treeListener);
        this.eventTable.unhook(18, treeListener);
    }

    void reskinChildren(int n) {
        Item item;
        int n2;
        if (this.items != null) {
            for (n2 = 0; n2 < this.items.length; ++n2) {
                item = this.items[n2];
                if (item == null) continue;
                item.reskinChildren(n);
            }
        }
        if (this.columns != null) {
            for (n2 = 0; n2 < this.columns.length; ++n2) {
                item = this.columns[n2];
                if (item == null) continue;
                item.reskinChildren(n);
            }
        }
        super.reskinChildren(n);
    }

    void setImage(int n, int n2, int n3) {
        OS.object_setInstanceVariable(n, Display.SWT_IMAGE, n3);
    }

    public void setInsertMark(TreeItem treeItem, boolean bl) {
        this.checkWidget();
        if (treeItem != null && treeItem.isDisposed()) {
            this.error(5);
        }
        TreeItem treeItem2 = this.insertItem;
        this.insertItem = treeItem;
        this.insertBefore = bl;
        if (treeItem2 != null && !treeItem2.isDisposed()) {
            treeItem2.redraw(-1);
        }
        if (treeItem != null) {
            treeItem.redraw(-1);
        }
    }

    public void selectAll() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        this.checkItems();
        NSOutlineView nSOutlineView = (NSOutlineView)this.view;
        this.ignoreSelect = true;
        nSOutlineView.selectAll(null);
        this.ignoreSelect = false;
    }

    public void select(TreeItem treeItem) {
        this.checkWidget();
        if (treeItem == null) {
            this.error(4);
        }
        if (treeItem.isDisposed()) {
            this.error(5);
        }
        this.checkItems();
        this.showItem(treeItem);
        NSOutlineView nSOutlineView = (NSOutlineView)this.view;
        int n = nSOutlineView.rowForItem(treeItem.handle);
        NSIndexSet nSIndexSet = (NSIndexSet)new NSIndexSet().alloc();
        nSIndexSet = nSIndexSet.initWithIndex(n);
        this.ignoreSelect = true;
        nSOutlineView.selectRowIndexes(nSIndexSet, (this.style & 2) != 0);
        this.ignoreSelect = false;
        nSIndexSet.release();
    }

    void selectRowIndexes_byExtendingSelection(int n, int n2, int n3, boolean bl) {
        NSIndexSet nSIndexSet;
        if (this.preventSelect && !this.ignoreSelect) {
            return;
        }
        if ((this.style & 4) != 0 && !this.ignoreSelect && (nSIndexSet = new NSIndexSet(n3)).count() == 0) {
            return;
        }
        super.selectRowIndexes_byExtendingSelection(n, n2, n3, bl);
    }

    void sendDoubleSelection() {
        NSOutlineView nSOutlineView = (NSOutlineView)this.view;
        int n = nSOutlineView.clickedRow();
        if (n == -1) {
            n = nSOutlineView.selectedRow();
        }
        if (n != -1) {
            Object object;
            if ((this.style & 0x20) != 0) {
                object = nSOutlineView.tableColumns();
                int n2 = nSOutlineView.clickedColumn();
                if (n2 != -1) {
                    id id2 = ((NSArray)object).objectAtIndex(n2);
                    if (id2.id == this.checkColumn.id) {
                        return;
                    }
                }
            }
            object = (TreeItem)this.display.getWidget(nSOutlineView.itemAtRow((int)n).id);
            Event event = new Event();
            event.item = object;
            this.sendSelectionEvent(14, event, false);
        }
    }

    boolean sendKeyEvent(NSEvent nSEvent, int n) {
        boolean bl = super.sendKeyEvent(nSEvent, n);
        if (!bl) {
            return bl;
        }
        if (n != 1) {
            return bl;
        }
        short s = nSEvent.keyCode();
        switch (s) {
            case 36: 
            case 76: {
                this.sendDoubleSelection();
            }
        }
        return bl;
    }

    void sendMeasureItem(TreeItem treeItem, boolean bl, int n, NSSize nSSize) {
        NSOutlineView nSOutlineView = (NSOutlineView)this.view;
        int n2 = (int)Math.ceil(nSSize.width);
        NSSize nSSize2 = nSOutlineView.intercellSpacing();
        int n3 = (int)Math.ceil(nSOutlineView.rowHeight() + nSSize2.height);
        GCData gCData = new GCData();
        gCData.paintRect = nSOutlineView.frame();
        GC gC = GC.cocoa_new(this, gCData);
        gC.setFont(treeItem.getFont(n));
        Event event = new Event();
        event.item = treeItem;
        event.gc = gC;
        event.index = n;
        event.width = n2;
        event.height = n3;
        if (bl && ((this.style & 0x8000) == 0 || this.hasFocus())) {
            event.detail |= 2;
        }
        this.sendEvent(41, event);
        gC.dispose();
        if (!this.isDisposed() && !treeItem.isDisposed()) {
            nSSize.width = event.width;
            nSSize.height = event.height;
            if (n3 < event.height) {
                nSOutlineView.setRowHeight(event.height);
            }
            if (n2 != event.width && this.columnCount == 0 && n == 0) {
                treeItem.width = event.width;
                treeItem.width = (int)((float)treeItem.width + nSOutlineView.indentationPerLevel() * (float)(1 + nSOutlineView.levelForItem(treeItem.handle)));
                if (this.setScrollWidth(treeItem)) {
                    nSOutlineView.setNeedsDisplay(true);
                }
            }
        }
    }

    boolean sendMouseEvent(NSEvent nSEvent, int n, boolean bl) {
        if (n == 29) {
            this.dragDetected = true;
        } else if (n == 4) {
            if (!this.dragDetected && this.selectedRowIndex != -1) {
                NSTableView nSTableView = (NSTableView)this.view;
                NSIndexSet nSIndexSet = nSTableView.selectedRowIndexes();
                int n2 = nSIndexSet.count();
                int[] nArray = new int[n2];
                nSIndexSet.getIndexes(nArray, n2, 0);
                for (int i = 0; i < n2; ++i) {
                    if (nArray[i] == this.selectedRowIndex) continue;
                    this.ignoreSelect = true;
                    nSTableView.deselectRow(nArray[i]);
                    this.ignoreSelect = false;
                }
                Event event = new Event();
                event.item = this._getItem(null, this.selectedRowIndex, true);
                this.selectedRowIndex = -1;
                this.sendSelectionEvent(13, event, false);
                this.ignoreSelect = true;
            }
            this.dragDetected = false;
        }
        return super.sendMouseEvent(nSEvent, n, bl);
    }

    void selectItems(TreeItem[] treeItemArray, boolean bl) {
        NSOutlineView nSOutlineView = (NSOutlineView)this.view;
        NSMutableIndexSet nSMutableIndexSet = (NSMutableIndexSet)new NSMutableIndexSet().alloc().init();
        int n = treeItemArray.length;
        for (int i = 0; i < n; ++i) {
            if (treeItemArray[i] == null) continue;
            if (treeItemArray[i].isDisposed()) {
                if (bl) continue;
                this.error(5);
            }
            TreeItem treeItem = treeItemArray[i];
            if (!bl) {
                this.showItem(treeItemArray[i], false);
            }
            nSMutableIndexSet.addIndex(nSOutlineView.rowForItem(treeItem.handle));
        }
        this.ignoreSelect = true;
        nSOutlineView.selectRowIndexes(nSMutableIndexSet, false);
        this.ignoreSelect = false;
        nSMutableIndexSet.release();
    }

    NSRect titleRectForBounds(int n, int n2, NSRect nSRect) {
        NSImage nSImage = new NSCell(n).image();
        if (nSImage != null) {
            int n3 = this.imageBounds.width + 3;
            nSRect.x += (float)n3;
            nSRect.width -= (float)n3;
        }
        return nSRect;
    }

    void setBackgroundColor(NSColor nSColor) {
        ((NSTableView)this.view).setBackgroundColor(nSColor);
    }

    public void setColumnOrder(int[] nArray) {
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        if (this.columnCount == 0) {
            if (nArray.length != 0) {
                this.error(5);
            }
            return;
        }
        if (nArray.length != this.columnCount) {
            this.error(5);
        }
        int[] nArray2 = this.getColumnOrder();
        boolean bl = false;
        boolean[] blArray = new boolean[this.columnCount];
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            if (n < 0 || n >= this.columnCount) {
                this.error(5);
            }
            if (blArray[n]) {
                this.error(5);
            }
            blArray[n] = true;
            if (nArray[i] == nArray2[i]) continue;
            bl = true;
        }
        if (bl) {
            TreeColumn treeColumn;
            int n;
            int n2;
            NSOutlineView nSOutlineView = (NSOutlineView)this.view;
            int[] nArray3 = new int[nArray2.length];
            int n3 = (this.style & 0x20) != 0 ? 1 : 0;
            for (int i = 0; i < nArray2.length; ++i) {
                n2 = nArray2[i];
                nArray3[n2] = (int)nSOutlineView.rectOfColumn((int)(i + n3)).x;
            }
            int[] nArray4 = new int[nArray.length];
            for (n2 = 0; n2 < nArray.length; ++n2) {
                n = nArray[n2];
                treeColumn = this.columns[n];
                int n4 = this.indexOf(treeColumn.nsColumn);
                int n5 = n2 + n3;
                nSOutlineView.moveColumn(n4, n5);
                nArray4[n] = (int)nSOutlineView.rectOfColumn((int)n5).x;
            }
            TreeColumn[] treeColumnArray = new TreeColumn[this.columnCount];
            System.arraycopy(this.columns, 0, treeColumnArray, 0, this.columnCount);
            for (n = 0; n < this.columnCount; ++n) {
                treeColumn = treeColumnArray[n];
                if (treeColumn.isDisposed() || nArray4[n] == nArray3[n]) continue;
                treeColumn.sendEvent(10);
            }
        }
    }

    void setFont(NSFont nSFont) {
        super.setFont(nSFont);
        this.setItemHeight(null, nSFont, !this.hooks(41));
        this.view.setNeedsDisplay(true);
        this.clearCachedWidth(this.items);
        this.setScrollWidth();
    }

    public void setHeaderVisible(boolean bl) {
        this.checkWidget();
        ((NSOutlineView)this.view).setHeaderView(bl ? this.headerView : null);
        this.scrollView.tile();
    }

    public void setItemCount(int n) {
        this.checkWidget();
        this.checkItems();
        n = Math.max(0, n);
        this.setItemCount(null, n);
    }

    void setItemCount(TreeItem treeItem, int n) {
        boolean bl;
        int n2 = this.getItemCount(treeItem);
        if (n == n2) {
            return;
        }
        NSOutlineView nSOutlineView = (NSOutlineView)this.view;
        int n3 = Math.max(4, (n + 3) / 4 * 4);
        TreeItem[] treeItemArray = treeItem == null ? this.items : treeItem.items;
        boolean bl2 = bl = treeItem == null || treeItem.getExpanded();
        if (n < n2) {
            if (treeItem == null) {
                this.itemCount = n;
            } else {
                treeItem.itemCount = n;
            }
            TreeItem[] treeItemArray2 = this.getSelection();
            nSOutlineView.reloadItem(treeItem != null ? treeItem.handle : null, bl);
            for (int i = n; i < n2; ++i) {
                TreeItem treeItem2 = treeItemArray[i];
                if (treeItem2 == null || treeItem2.isDisposed()) continue;
                treeItem2.release(false);
            }
            this.selectItems(treeItemArray2, true);
            TreeItem[] treeItemArray3 = new TreeItem[n3];
            if (treeItemArray != null) {
                System.arraycopy(treeItemArray, 0, treeItemArray3, 0, n);
            }
            treeItemArray = treeItemArray3;
            if (treeItem == null) {
                this.items = treeItemArray3;
            } else {
                treeItem.items = treeItemArray3;
            }
        } else if ((this.style & 0x10000000) == 0) {
            for (int i = n2; i < n; ++i) {
                new TreeItem(this, treeItem, 0, i, true);
            }
        } else {
            TreeItem[] treeItemArray4 = new TreeItem[n3];
            if (treeItemArray != null) {
                System.arraycopy(treeItemArray, 0, treeItemArray4, 0, n2);
            }
            treeItemArray = treeItemArray4;
            if (treeItem == null) {
                this.items = treeItemArray4;
                this.itemCount = n;
            } else {
                treeItem.items = treeItemArray4;
                treeItem.itemCount = n;
            }
            TreeItem[] treeItemArray5 = this.getSelection();
            nSOutlineView.reloadItem(treeItem != null ? treeItem.handle : null, bl);
            this.selectItems(treeItemArray5, true);
            if (treeItem != null && n2 == 0 && treeItem.expanded) {
                this.ignoreExpand = true;
                nSOutlineView.expandItem(treeItem.handle);
                this.ignoreExpand = false;
            }
        }
    }

    void setItemHeight(int n) {
        this.checkWidget();
        if (n < -1) {
            this.error(5);
        }
        if (n == -1) {
            this.setItemHeight(null, null, true);
        } else {
            ((NSOutlineView)this.view).setRowHeight(n);
        }
    }

    void setItemHeight(Image image, NSFont nSFont, boolean bl) {
        Rectangle rectangle;
        if (nSFont == null) {
            nSFont = this.getFont().handle;
        }
        float f = nSFont.ascender();
        float f2 = -nSFont.descender() + nSFont.leading();
        int n = (int)Math.ceil(f + f2) + 1;
        Rectangle rectangle2 = rectangle = image != null ? image.getBounds() : this.imageBounds;
        if (rectangle != null) {
            this.imageBounds = rectangle;
            n = Math.max(n, rectangle.height);
        }
        NSTableView nSTableView = (NSTableView)this.view;
        if (bl || nSTableView.rowHeight() < (float)n) {
            nSTableView.setRowHeight(n);
        }
    }

    public void setLinesVisible(boolean bl) {
        this.checkWidget();
        ((NSOutlineView)this.view).setUsesAlternatingRowBackgroundColors(bl);
        ((NSOutlineView)this.view).setGridStyleMask(bl ? 1 : 0);
    }

    public void setRedraw(boolean bl) {
        this.checkWidget();
        super.setRedraw(bl);
        if (bl && this.drawCount == 0) {
            this.checkItems();
            this.setScrollWidth();
        }
    }

    boolean setScrollWidth() {
        return this.setScrollWidth(true, this.items, true);
    }

    boolean setScrollWidth(boolean bl, TreeItem[] treeItemArray, boolean bl2) {
        int n;
        if (treeItemArray == null) {
            return false;
        }
        if (this.ignoreRedraw || !this.getDrawing()) {
            return false;
        }
        if (this.columnCount != 0) {
            return false;
        }
        GC gC = new GC(this);
        int n2 = this.calculateWidth(treeItemArray, 0, gC, bl2);
        gC.dispose();
        if (!bl && (n = (int)this.firstColumn.width()) >= n2) {
            return false;
        }
        this.firstColumn.setWidth(n2);
        if (this.horizontalBar != null && this.horizontalBar.view != null) {
            this.redrawWidget(this.horizontalBar.view, false);
        }
        return true;
    }

    boolean setScrollWidth(TreeItem treeItem) {
        if (this.ignoreRedraw || !this.getDrawing()) {
            return false;
        }
        if (this.columnCount != 0) {
            return false;
        }
        TreeItem treeItem2 = treeItem.parentItem;
        if (treeItem2 != null && !treeItem2.getExpanded()) {
            return false;
        }
        GC gC = new GC(this);
        int n = treeItem.calculateWidth(0, gC);
        gC.dispose();
        int n2 = (int)this.firstColumn.width();
        if (n2 < n) {
            this.firstColumn.setWidth(n);
            if (this.horizontalBar != null && this.horizontalBar.view != null) {
                this.redrawWidget(this.horizontalBar.view, false);
            }
            return true;
        }
        return false;
    }

    void setShouldExpandItem(int n, int n2, boolean bl) {
        this.shouldExpand = bl;
    }

    void setShouldScrollClipView(int n, int n2, boolean bl) {
        this.shouldScroll = bl;
    }

    public void setSelection(TreeItem treeItem) {
        this.checkWidget();
        if (treeItem == null) {
            this.error(4);
        }
        this.setSelection(new TreeItem[]{treeItem});
    }

    public void setSelection(TreeItem[] treeItemArray) {
        this.checkWidget();
        if (treeItemArray == null) {
            this.error(4);
        }
        this.checkItems();
        this.deselectAll();
        int n = treeItemArray.length;
        if (n == 0 || (this.style & 4) != 0 && n > 1) {
            return;
        }
        this.selectItems(treeItemArray, false);
        if (treeItemArray.length > 0) {
            for (int i = 0; i < treeItemArray.length; ++i) {
                TreeItem treeItem = treeItemArray[i];
                if (treeItem == null) continue;
                this.showItem(treeItem, true);
                break;
            }
        }
    }

    public void setSortColumn(TreeColumn treeColumn) {
        this.checkWidget();
        if (treeColumn != null && treeColumn.isDisposed()) {
            this.error(5);
        }
        if (treeColumn == this.sortColumn) {
            return;
        }
        this.setSort(treeColumn, this.sortDirection);
    }

    public void setSortDirection(int n) {
        this.checkWidget();
        if (n != 128 && n != 1024 && n != 0) {
            return;
        }
        if (n == this.sortDirection) {
            return;
        }
        this.setSort(this.sortColumn, n);
    }

    void setSort(TreeColumn treeColumn, int n) {
        NSImage nSImage = null;
        NSTableColumn nSTableColumn = null;
        if (treeColumn != null) {
            nSTableColumn = treeColumn.nsColumn;
            if (n == 1024) {
                nSImage = NSImage.imageNamed(NSString.stringWith("NSDescendingSortIndicator"));
            }
            if (n == 128) {
                nSImage = NSImage.imageNamed(NSString.stringWith("NSAscendingSortIndicator"));
            }
        }
        NSTableView nSTableView = (NSTableView)this.view;
        if (this.sortColumn != null && this.sortColumn != treeColumn) {
            nSTableView.setIndicatorImage(null, this.sortColumn.nsColumn);
        }
        nSTableView.setHighlightedTableColumn(nSTableColumn);
        nSTableView.setIndicatorImage(nSImage, nSTableColumn);
        this.sortDirection = n;
        this.sortColumn = treeColumn;
    }

    public void setTopItem(TreeItem treeItem) {
        this.checkWidget();
        if (treeItem == null) {
            this.error(4);
        }
        if (treeItem.isDisposed()) {
            this.error(5);
        }
        this.checkItems();
        this.showItem(treeItem, false);
        NSOutlineView nSOutlineView = (NSOutlineView)this.view;
        int n = nSOutlineView.rowForItem(treeItem.handle);
        if (n == -1) {
            return;
        }
        NSPoint nSPoint = new NSPoint();
        nSPoint.x = this.scrollView.contentView().bounds().x;
        nSPoint.y = nSOutlineView.frameOfCellAtColumn((int)0, (int)n).y;
        this.view.scrollPoint(nSPoint);
    }

    public void showColumn(TreeColumn treeColumn) {
        this.checkWidget();
        if (treeColumn == null) {
            this.error(4);
        }
        if (treeColumn.isDisposed()) {
            this.error(5);
        }
        if (treeColumn.parent != this) {
            return;
        }
        if (this.columnCount <= 1) {
            return;
        }
        int n = this.indexOf(treeColumn.nsColumn);
        if (0 > n || n >= this.columnCount + ((this.style & 0x20) != 0 ? 1 : 0)) {
            return;
        }
        ((NSOutlineView)this.view).scrollColumnToVisible(n);
    }

    public void showItem(TreeItem treeItem) {
        this.checkWidget();
        if (treeItem == null) {
            this.error(4);
        }
        if (treeItem.isDisposed()) {
            this.error(5);
        }
        this.checkItems();
        this.showItem(treeItem, true);
    }

    void showItem(TreeItem treeItem, boolean bl) {
        Object object;
        TreeItem treeItem2 = treeItem.parentItem;
        if (treeItem2 != null) {
            this.showItem(treeItem2, false);
            if (!treeItem2.getExpanded()) {
                treeItem2.setExpanded(true);
                object = new Event();
                ((Event)object).item = treeItem2;
                this.sendEvent(17, (Event)object);
            }
        }
        if (bl) {
            object = (NSOutlineView)this.view;
            ((NSTableView)object).scrollRowToVisible(((NSOutlineView)object).rowForItem(treeItem.handle));
        }
    }

    public void showSelection() {
        this.checkWidget();
        this.checkItems();
        TreeItem[] treeItemArray = this.getSelection();
        if (treeItemArray.length > 0) {
            this.checkData(treeItemArray[0]);
            this.showItem(treeItemArray[0], true);
        }
    }

    void updateCursorRects(boolean bl) {
        super.updateCursorRects(bl);
        if (this.headerView == null) {
            return;
        }
        this.updateCursorRects(bl, this.headerView);
    }
}

