/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.text.DateFormatSymbols;
import java.util.Calendar;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TypedListener;

public class DateTime
extends Composite {
    int day;
    int month;
    int year;
    int hours;
    int minutes;
    int seconds;
    Calendar calendar;
    DateFormatSymbols formatSymbols;
    Button down;
    Button up;
    Text text;
    String format;
    Point[] fieldIndices;
    int[] fieldNames;
    int fieldCount;
    int currentField = 0;
    int characterCount = 0;
    boolean ignoreVerify = false;
    Color fg;
    Color bg;
    boolean hasFocus;
    boolean monthChanged;
    boolean calendarDisplayed;
    int savedYear;
    int savedMonth;
    int savedDay;
    Shell popupShell;
    DateTime popupCalendar;
    Listener popupListener;
    Listener popupFilter;
    Listener clickListener;
    static final String DEFAULT_SHORT_DATE_FORMAT = "MM/YYYY";
    static final String DEFAULT_MEDIUM_DATE_FORMAT = "MM/DD/YYYY";
    static final String DEFAULT_LONG_DATE_FORMAT = "MM/DD/YYYY";
    static final String DEFAULT_SHORT_TIME_FORMAT = "HH:MM AM";
    static final String DEFAULT_MEDIUM_TIME_FORMAT = "HH:MM:SS AM";
    static final String DEFAULT_LONG_TIME_FORMAT = "HH:MM:SS AM";
    static final int MIN_YEAR = 1752;
    static final int MAX_YEAR = 9999;

    public DateTime(Composite composite, int n) {
        super(composite, DateTime.checkStyle(n));
        if ((this.style & 0x400) == 0) {
            this.createText((this.style & 4) != 0);
        }
        this.initAccessible();
    }

    void createText(boolean bl) {
        this.calendar = Calendar.getInstance();
        this.formatSymbols = new DateFormatSymbols();
        this.text = new Text(this, 4);
        OS.gtk_drag_dest_unset(this.text.handle);
        if ((this.style & 0x20) != 0) {
            this.setFormat((this.style & 0x8000) != 0 ? DEFAULT_SHORT_DATE_FORMAT : ((this.style & 0x10000000) != 0 ? "MM/DD/YYYY" : "MM/DD/YYYY"));
        } else {
            this.setFormat((this.style & 0x8000) != 0 ? DEFAULT_SHORT_TIME_FORMAT : ((this.style & 0x10000000) != 0 ? "HH:MM:SS AM" : "HH:MM:SS AM"));
        }
        this.text.setText(this.getFormattedString(this.style));
        this.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                DateTime.this.onResize(event);
            }
        });
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 1: {
                        DateTime.this.onTextKeyDown(event);
                        break;
                    }
                    case 15: {
                        DateTime.this.onTextFocusIn(event);
                        break;
                    }
                    case 16: {
                        DateTime.this.onTextFocusOut(event);
                        break;
                    }
                    case 3: 
                    case 4: {
                        DateTime.this.onTextMouseClick(event);
                        break;
                    }
                    case 35: {
                        DateTime.this.notifyListeners(35, event);
                        break;
                    }
                    case 25: {
                        DateTime.this.onTextVerify(event);
                    }
                }
            }
        };
        int[] nArray = new int[]{1, 15, 16, 3, 4, 35, 25};
        for (int i = 0; i < nArray.length; ++i) {
            this.text.addListener(nArray[i], listener);
        }
        if ((this.style & 0x20) != 0 && bl) {
            this.createDropDownButton();
            this.createPopupShell(-1, -1, -1);
        } else {
            this.up = new Button(this, 132);
            this.gtk_widget_set_can_focus(this.up.handle, false);
            this.down = new Button(this, 1028);
            this.gtk_widget_set_can_focus(this.down.handle, false);
            this.up.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    DateTime.this.incrementField(1);
                    DateTime.this.text.setFocus();
                }
            });
            this.down.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    DateTime.this.incrementField(-1);
                    DateTime.this.text.setFocus();
                }
            });
        }
    }

    void createDropDownButton() {
        this.down = new Button(this, 1028);
        this.gtk_widget_set_can_focus(this.down.handle, false);
        this.down.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                boolean bl = DateTime.this.isDropped();
                DateTime.this.popupCalendar.calendarDisplayed = !bl;
                DateTime.this.setFocus();
                DateTime.this.dropDownCalendar(!bl);
            }
        });
        this.popupListener = new Listener(){

            public void handleEvent(Event event) {
                if (event.widget == DateTime.this.popupShell) {
                    DateTime.this.popupShellEvent(event);
                    return;
                }
                if (event.widget == DateTime.this.popupCalendar) {
                    DateTime.this.popupCalendarEvent(event);
                    return;
                }
                if (event.widget == DateTime.this) {
                    DateTime.this.onDispose(event);
                    return;
                }
                if (event.widget == DateTime.this.getShell()) {
                    DateTime.this.getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            if (DateTime.this.isDisposed()) {
                                return;
                            }
                            DateTime.this.handleFocus(16);
                        }
                    });
                }
            }
        };
        this.popupFilter = new Listener(){

            public void handleEvent(Event event) {
                Shell shell = ((Control)event.widget).getShell();
                if (shell == DateTime.this.getShell()) {
                    DateTime.this.handleFocus(16);
                }
            }
        };
    }

    void createPopupShell(int n, int n2, int n3) {
        int n4;
        this.popupShell = new Shell(this.getShell(), 16392);
        this.popupCalendar = new DateTime(this.popupShell, 1024);
        if (this.font != null) {
            this.popupCalendar.setFont(this.font);
        }
        if (this.fg != null) {
            this.popupCalendar.setForeground(this.fg);
        }
        if (this.bg != null) {
            this.popupCalendar.setBackground(this.bg);
        }
        this.clickListener = new Listener(){

            public void handleEvent(Event event) {
                Control control;
                if (event.widget instanceof Control && (control = (Control)event.widget) != DateTime.this.down && control.getShell() != DateTime.this.popupShell) {
                    DateTime.this.dropDownCalendar(false);
                }
            }
        };
        int[] nArray = new int[]{21, 4, 9};
        for (n4 = 0; n4 < nArray.length; ++n4) {
            this.popupShell.addListener(nArray[n4], this.popupListener);
        }
        nArray = new int[]{3, 4, 13, 31, 1, 2, 15, 16, 12};
        for (n4 = 0; n4 < nArray.length; ++n4) {
            this.popupCalendar.addListener(nArray[n4], this.popupListener);
        }
        this.addListener(12, this.popupListener);
        if (n != -1) {
            this.popupCalendar.setDate(n, n2, n3);
        }
    }

    static int checkStyle(int n) {
        n &= 0xFFFFFCFF;
        if (((n = DateTime.checkBits(n, 32, 128, 1024, 0, 0, 0)) & 0x20) == 0) {
            n &= 0xFFFFFFFB;
        }
        return DateTime.checkBits(n, 65536, 32768, 0x10000000, 0, 0, 0);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        int n3 = 0;
        int n4 = 0;
        if (n == -1 || n2 == -1) {
            Object object;
            if ((this.style & 0x400) != 0) {
                object = this.computeNativeSize(this.handle, n, n2, bl);
                n3 = ((Point)object).x;
                n4 = ((Point)object).y;
            } else {
                object = new GC(this.text);
                Point point = ((GC)object).stringExtent(this.getComputeSizeString(this.style));
                ((Resource)object).dispose();
                Rectangle rectangle = this.text.computeTrim(0, 0, point.x, point.y);
                Point point2 = this.down.computeSize(-1, -1, bl);
                n3 = rectangle.width + point2.x;
                n4 = Math.max(rectangle.height, point2.y);
            }
        }
        if (n3 == 0) {
            n3 = 64;
        }
        if (n4 == 0) {
            n4 = 64;
        }
        if (n != -1) {
            n3 = n;
        }
        if (n2 != -1) {
            n4 = n2;
        }
        int n5 = this.getBorderWidth();
        return new Point(n3 + 2 * n5, n4 + 2 * n5);
    }

    void createHandle(int n) {
        if ((this.style & 0x400) != 0) {
            this.state |= 8;
            this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0);
            if (this.fixedHandle == 0) {
                this.error(2);
            }
            this.gtk_widget_set_has_window(this.fixedHandle, true);
            this.handle = OS.gtk_calendar_new();
            if (this.handle == 0) {
                this.error(2);
            }
            OS.gtk_container_add(this.fixedHandle, this.handle);
            OS.gtk_calendar_set_display_options(this.handle, 3);
        } else {
            super.createHandle(n);
        }
    }

    boolean checkSubwindow() {
        return false;
    }

    void createWidget(int n) {
        super.createWidget(n);
        if ((this.style & 0x400) != 0) {
            this.getDate();
        }
    }

    void commitCurrentField() {
        if (this.characterCount > 0) {
            int n;
            this.characterCount = 0;
            int n2 = this.fieldNames[this.currentField];
            int n3 = this.fieldIndices[this.currentField].x;
            int n4 = this.fieldIndices[this.currentField].y;
            String string = this.text.getText(n3, n4 - 1);
            int n5 = string.lastIndexOf(32);
            if (n5 != -1) {
                string = string.substring(n5 + 1);
            }
            if ((n = this.unformattedIntValue(n2, string, this.characterCount == 0, this.calendar.getActualMaximum(n2))) != -1) {
                this.setTextField(n2, n, true, true);
            }
        }
    }

    void onDispose(Event event) {
        if (this.popupShell != null && !this.popupShell.isDisposed()) {
            this.popupCalendar.removeListener(12, this.popupListener);
            this.popupShell.dispose();
        }
        Shell shell = this.getShell();
        shell.removeListener(27, this.popupListener);
        Display display = this.getDisplay();
        display.removeFilter(15, this.popupFilter);
        this.popupShell = null;
        this.text = null;
        this.popupCalendar = null;
        this.down = null;
        this.up = null;
    }

    void dropDownCalendar(boolean bl) {
        if (bl == this.isDropped()) {
            return;
        }
        if (!bl) {
            this.popupShell.setVisible(false);
            OS.gtk_calendar_clear_marks(this.popupCalendar.handle);
            this.display.removeFilter(3, this.clickListener);
            return;
        }
        this.savedYear = this.getYear();
        this.savedMonth = this.getMonth();
        this.savedDay = this.getDay();
        if (this.getShell() != this.popupShell.getParent()) {
            int n = this.popupCalendar.getYear();
            int n2 = this.popupCalendar.getMonth();
            int n3 = this.popupCalendar.getDay();
            this.popupCalendar.removeListener(12, this.popupListener);
            this.popupShell.dispose();
            this.popupShell = null;
            this.popupCalendar = null;
            this.createPopupShell(n, n2, n3);
        }
        Point point = this.getSize();
        Point point2 = this.popupCalendar.computeSize(-1, -1, false);
        this.popupCalendar.setBounds(1, 1, Math.max(point.x - 2, point2.x), point2.y);
        this.popupCalendar.setDate(this.savedYear, this.savedMonth, this.savedDay);
        if (this.savedYear == Calendar.getInstance().get(1) && this.savedMonth == Calendar.getInstance().get(2)) {
            OS.gtk_calendar_mark_day(this.popupCalendar.handle, Calendar.getInstance().get(5));
        }
        Display display = this.getDisplay();
        Rectangle rectangle = display.map((Control)this.getParent(), null, this.getBounds());
        Rectangle rectangle2 = this.getMonitor().getClientArea();
        int n = Math.max(point.x, point2.x + 2);
        int n4 = point2.y + 2;
        int n5 = rectangle.x;
        int n6 = rectangle.y + point.y;
        if (n6 + n4 > rectangle2.y + rectangle2.height) {
            n6 = rectangle.y - n4;
        }
        if (n5 + n > rectangle2.x + rectangle2.width) {
            n5 = rectangle2.x + rectangle2.width - point2.x;
        }
        this.popupShell.setBounds(n5, n6, n, n4);
        this.popupShell.setVisible(true);
        if (this.isFocusControl()) {
            this.popupCalendar.setFocus();
        }
        display.addFilter(3, this.clickListener);
    }

    int focusHandle() {
        if (this.text != null) {
            return this.text.handle;
        }
        return super.focusHandle();
    }

    String formattedStringValue(int n, int n2, boolean bl) {
        if (n == 9) {
            String[] stringArray = this.formatSymbols.getAmPmStrings();
            return stringArray[n2];
        }
        if (bl) {
            if (n == 10 && n2 == 0) {
                return String.valueOf(12);
            }
            if (n == 2) {
                return String.valueOf(n2 + 1);
            }
        }
        return String.valueOf(n2);
    }

    GdkColor getBackgroundColor() {
        if ((this.style & 0x400) != 0) {
            return this.getBaseColor();
        }
        return super.getBackgroundColor();
    }

    String getComputeSizeString(int n) {
        if ((n & 0x20) != 0) {
            return (n & 0x8000) != 0 ? DEFAULT_SHORT_DATE_FORMAT : ((n & 0x10000000) != 0 ? "MM/DD/YYYY" : "MM/DD/YYYY");
        }
        return (n & 0x8000) != 0 ? DEFAULT_SHORT_TIME_FORMAT : ((n & 0x10000000) != 0 ? "HH:MM:SS AM" : "HH:MM:SS AM");
    }

    int getFieldIndex(int n) {
        for (int i = 0; i < this.fieldCount; ++i) {
            if (this.fieldNames[i] != n) continue;
            return i;
        }
        return -1;
    }

    String getFormattedString(int n) {
        if ((n & 0x80) != 0) {
            String[] stringArray = this.formatSymbols.getAmPmStrings();
            int n2 = this.calendar.get(10);
            if (n2 == 0) {
                n2 = 12;
            }
            int n3 = this.calendar.get(12);
            int n4 = this.calendar.get(13);
            int n5 = this.calendar.get(9);
            if ((n & 0x8000) != 0) {
                return "" + (n2 < 10 ? " " : "") + n2 + ":" + (n3 < 10 ? "0" : "") + n3 + " " + stringArray[n5];
            }
            return "" + (n2 < 10 ? " " : "") + n2 + ":" + (n3 < 10 ? "0" : "") + n3 + ":" + (n4 < 10 ? "0" : "") + n4 + " " + stringArray[n5];
        }
        int n6 = this.calendar.get(1);
        int n7 = this.calendar.get(2) + 1;
        int n8 = this.calendar.get(5);
        if ((n & 0x8000) != 0) {
            return "" + (n7 < 10 ? " " : "") + n7 + "/" + n6;
        }
        return "" + (n7 < 10 ? " " : "") + n7 + "/" + (n8 < 10 ? " " : "") + n8 + "/" + n6;
    }

    void getDate() {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        OS.gtk_calendar_get_date(this.handle, nArray, nArray2, nArray3);
        this.year = nArray[0];
        this.month = nArray2[0];
        this.day = nArray3[0];
    }

    public int getDay() {
        this.checkWidget();
        if ((this.style & 0x400) != 0) {
            this.getDate();
            return this.day;
        }
        return this.calendar.get(5);
    }

    public int getHours() {
        this.checkWidget();
        if ((this.style & 0x400) != 0) {
            return this.hours;
        }
        return this.calendar.get(11);
    }

    public int getMinutes() {
        this.checkWidget();
        if ((this.style & 0x400) != 0) {
            return this.minutes;
        }
        return this.calendar.get(12);
    }

    public int getMonth() {
        this.checkWidget();
        if ((this.style & 0x400) != 0) {
            this.getDate();
            return this.month;
        }
        return this.calendar.get(2);
    }

    String getNameText() {
        return (this.style & 0x80) != 0 ? this.getHours() + ":" + this.getMinutes() + ":" + this.getSeconds() : this.getMonth() + 1 + "/" + this.getDay() + "/" + this.getYear();
    }

    public int getSeconds() {
        this.checkWidget();
        if ((this.style & 0x400) != 0) {
            return this.seconds;
        }
        return this.calendar.get(13);
    }

    String getSpokenText() {
        StringBuffer stringBuffer = new StringBuffer();
        if ((this.style & 0x80) != 0) {
            int n = this.calendar.get(10);
            if (n == 0) {
                n = 12;
            }
            stringBuffer.append(n);
            int n2 = this.calendar.get(12);
            stringBuffer.append(":" + (n2 < 10 ? "0" : "") + n2);
            if ((this.style & 0x8000) == 0) {
                int n3 = this.calendar.get(13);
                stringBuffer.append(":" + (n3 < 10 ? "0" : "") + n3);
            }
            stringBuffer.append(" " + this.formatSymbols.getAmPmStrings()[this.calendar.get(9)]);
        } else {
            Calendar calendar = this.calendar;
            if ((this.style & 0x400) != 0) {
                this.formatSymbols = new DateFormatSymbols();
                calendar = Calendar.getInstance();
                this.getDate();
                calendar.set(this.year, this.month, this.day);
            }
            if ((this.style & 0x8000) == 0) {
                stringBuffer.append(this.formatSymbols.getWeekdays()[calendar.get(7)] + ", ");
            }
            stringBuffer.append(this.formatSymbols.getMonths()[calendar.get(2)] + " ");
            if ((this.style & 0x8000) == 0) {
                stringBuffer.append(calendar.get(5) + ", ");
            }
            stringBuffer.append(calendar.get(1));
        }
        return stringBuffer.toString();
    }

    public int getYear() {
        this.checkWidget();
        if ((this.style & 0x400) != 0) {
            this.getDate();
            return this.year;
        }
        return this.calendar.get(1);
    }

    int gtk_day_selected(int n) {
        this.sendSelectionEvent();
        return 0;
    }

    int gtk_day_selected_double_click(int n) {
        this.sendSelectionEvent(14);
        return 0;
    }

    int gtk_month_changed(int n) {
        if (this.calendarDisplayed) {
            this.calendarDisplayed = false;
        } else {
            this.monthChanged = true;
        }
        this.sendSelectionEvent();
        return 0;
    }

    boolean hasFocus() {
        if (super.hasFocus()) {
            return true;
        }
        Control control = this.display.getFocusControl();
        return control != null && control == this.text;
    }

    void hookEvents() {
        super.hookEvents();
        if ((this.style & 0x400) != 0) {
            OS.g_signal_connect_closure(this.handle, OS.day_selected, this.display.closures[61], false);
            OS.g_signal_connect_closure(this.handle, OS.day_selected_double_click, this.display.closures[66], false);
            OS.g_signal_connect_closure(this.handle, OS.month_changed, this.display.closures[62], false);
        }
    }

    void incrementField(int n) {
        int n2 = this.fieldNames[this.currentField];
        int n3 = this.calendar.get(n2);
        if (n2 == 10) {
            int n4 = this.calendar.getMaximum(10);
            int n5 = this.calendar.getMinimum(10);
            if (n3 == n4 && n == 1 || n3 == n5 && n == -1) {
                int n6 = this.currentField;
                this.currentField = this.getFieldIndex(9);
                this.setTextField(9, (this.calendar.get(9) + 1) % 2, true, true);
                this.currentField = n6;
            }
        }
        this.setTextField(n2, n3 + n, true, true);
    }

    boolean isDropped() {
        return this.popupShell.getVisible();
    }

    public boolean isFocusControl() {
        this.checkWidget();
        if ((this.style & 4) != 0 && (this.text.isFocusControl() || this.popupShell.isFocusControl() || this.popupCalendar.isFocusControl())) {
            return true;
        }
        return super.isFocusControl();
    }

    void initAccessible() {
        Accessible accessible = this.getAccessible();
        accessible.addAccessibleListener(new AccessibleAdapter(){

            public void getName(AccessibleEvent accessibleEvent) {
                accessibleEvent.result = DateTime.this.getSpokenText();
            }

            public void getHelp(AccessibleEvent accessibleEvent) {
                accessibleEvent.result = DateTime.this.getToolTipText();
            }
        });
        accessible.addAccessibleControlListener(new AccessibleControlAdapter(){

            public void getChildAtPoint(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.childID = -1;
            }

            public void getLocation(AccessibleControlEvent accessibleControlEvent) {
                Rectangle rectangle = DateTime.this.display.map((Control)DateTime.this.getParent(), null, DateTime.this.getBounds());
                accessibleControlEvent.x = rectangle.x;
                accessibleControlEvent.y = rectangle.y;
                accessibleControlEvent.width = rectangle.width;
                accessibleControlEvent.height = rectangle.height;
            }

            public void getChildCount(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.detail = 0;
            }

            public void getRole(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.detail = (DateTime.this.style & 0x400) != 0 ? 41 : 42;
            }

            public void getState(AccessibleControlEvent accessibleControlEvent) {
                accessibleControlEvent.detail = 0x100000;
                if (DateTime.this.hasFocus()) {
                    accessibleControlEvent.detail |= 4;
                }
            }

            public void getSelection(AccessibleControlEvent accessibleControlEvent) {
                if (DateTime.this.hasFocus()) {
                    accessibleControlEvent.childID = -1;
                }
            }

            public void getFocus(AccessibleControlEvent accessibleControlEvent) {
                if (DateTime.this.hasFocus()) {
                    accessibleControlEvent.childID = -1;
                }
            }
        });
    }

    boolean isValidTime(int n, int n2) {
        Calendar calendar = (this.style & 0x400) != 0 ? Calendar.getInstance() : this.calendar;
        int n3 = calendar.getActualMinimum(n);
        int n4 = calendar.getActualMaximum(n);
        return n2 >= n3 && n2 <= n4;
    }

    boolean isValidDate(int n, int n2, int n3) {
        if (n < 1752 || n > 9999) {
            return false;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.set(n, n2, n3);
        return calendar.get(1) == n && calendar.get(2) == n2 && calendar.get(5) == n3;
    }

    void popupCalendarEvent(Event event) {
        switch (event.type) {
            case 12: {
                if (this.popupShell == null || this.popupShell.isDisposed() || this.isDisposed() || this.getShell() == this.popupShell.getParent()) break;
                int n = this.popupCalendar.getYear();
                int n2 = this.popupCalendar.getMonth();
                int n3 = this.popupCalendar.getDay();
                this.popupShell = null;
                this.popupCalendar = null;
                this.createPopupShell(n, n2, n3);
                break;
            }
            case 15: {
                this.handleFocus(15);
                break;
            }
            case 16: {
                Point point = this.down.toControl(this.getDisplay().getCursorLocation());
                Point point2 = this.down.getSize();
                Rectangle rectangle = new Rectangle(0, 0, point2.x, point2.y);
                if (rectangle.contains(point)) {
                    boolean bl;
                    boolean bl2 = bl = this.getDisplay().getActiveShell() == this.getShell();
                    if (bl) break;
                    this.dropDownCalendar(false);
                    break;
                }
                this.dropDownCalendar(false);
                break;
            }
            case 4: {
                if (event.button != 1) {
                    return;
                }
                if (this.popupCalendar.monthChanged) {
                    this.popupCalendar.monthChanged = false;
                    OS.gtk_calendar_clear_marks(this.popupCalendar.handle);
                    break;
                }
                this.dropDownCalendar(false);
                break;
            }
            case 13: {
                int n = this.popupCalendar.getYear();
                int n4 = this.popupCalendar.getMonth();
                int n5 = this.popupCalendar.getDay();
                this.setDate(n, n4, n5);
                Event event2 = new Event();
                event2.time = event.time;
                event2.stateMask = event.stateMask;
                event2.doit = event.doit;
                this.notifyListeners(13, event2);
                event.doit = event2.doit;
                break;
            }
            case 31: {
                switch (event.detail) {
                    case 2: 
                    case 4: 
                    case 32: 
                    case 64: {
                        event.doit = false;
                        break;
                    }
                    case 8: 
                    case 16: {
                        event.doit = this.text.traverse(event.detail);
                        event.detail = 0;
                        if (event.doit) {
                            this.dropDownCalendar(false);
                        }
                        return;
                    }
                    case 256: 
                    case 512: {
                        return;
                    }
                }
                Event event3 = new Event();
                event3.time = event.time;
                event3.detail = event.detail;
                event3.doit = event.doit;
                event3.character = event.character;
                event3.keyCode = event.keyCode;
                this.notifyListeners(31, event3);
                event.doit = event3.doit;
                event.detail = event3.detail;
                break;
            }
            case 2: {
                Event event4 = new Event();
                event4.time = event.time;
                event4.character = event.character;
                event4.keyCode = event.keyCode;
                event4.stateMask = event.stateMask;
                this.notifyListeners(2, event4);
                break;
            }
            case 1: {
                if (event.character == '\u001b') {
                    this.popupCalendar.setDate(this.savedYear, this.savedMonth, this.savedDay);
                    this.setDate(this.savedYear, this.savedMonth, this.savedDay);
                    this.dropDownCalendar(false);
                }
                if (event.keyCode == 13 || (event.stateMask & 0x10000) != 0 && (event.keyCode == 0x1000001 || event.keyCode == 0x1000002)) {
                    this.dropDownCalendar(false);
                }
                if (event.keyCode == 32) {
                    this.dropDownCalendar(false);
                }
                if (this.isDisposed()) break;
                Event event5 = new Event();
                event5.time = event.time;
                event5.character = event.character;
                event5.keyCode = event.keyCode;
                event5.stateMask = event.stateMask;
                this.notifyListeners(1, event5);
                break;
            }
        }
    }

    void handleFocus(int n) {
        if (this.isDisposed()) {
            return;
        }
        switch (n) {
            case 15: {
                if (this.hasFocus) {
                    return;
                }
                this.text.selectAll();
                this.hasFocus = true;
                Shell shell = this.getShell();
                shell.removeListener(27, this.popupListener);
                shell.addListener(27, this.popupListener);
                Display display = this.getDisplay();
                display.removeFilter(15, this.popupFilter);
                display.addFilter(15, this.popupFilter);
                Event event = new Event();
                this.notifyListeners(15, event);
                break;
            }
            case 16: {
                if (!this.hasFocus) {
                    return;
                }
                Control control = this.getDisplay().getFocusControl();
                if (control == this.down || control == this.popupCalendar || control == this.text) {
                    return;
                }
                this.hasFocus = false;
                Shell shell = this.getShell();
                shell.removeListener(27, this.popupListener);
                Display display = this.getDisplay();
                display.removeFilter(15, this.popupFilter);
                display.removeFilter(3, this.clickListener);
                Event event = new Event();
                this.notifyListeners(16, event);
                break;
            }
        }
    }

    void popupShellEvent(Event event) {
        switch (event.type) {
            case 9: {
                Rectangle rectangle = this.popupCalendar.getBounds();
                Color color = this.getDisplay().getSystemColor(2);
                event.gc.setForeground(color);
                event.gc.drawRectangle(0, 0, rectangle.width + 1, rectangle.height + 1);
                break;
            }
            case 21: {
                event.doit = false;
                this.dropDownCalendar(false);
                break;
            }
            case 4: {
                this.dropDownCalendar(false);
            }
        }
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    void selectField(int n) {
        if (n != this.currentField) {
            this.commitCurrentField();
        }
        final int n2 = this.fieldIndices[n].x;
        final int n3 = this.fieldIndices[n].y;
        Point point = this.text.getSelection();
        if (n == this.currentField && n2 == point.x && n3 == point.y) {
            return;
        }
        this.currentField = n;
        this.display.asyncExec(new Runnable(){

            public void run() {
                if (!DateTime.this.text.isDisposed()) {
                    String string = DateTime.this.text.getText(n2, n3 - 1);
                    int n = string.lastIndexOf(32);
                    n = n == -1 ? n2 : n2 + n + 1;
                    DateTime.this.text.setSelection(n, n3);
                }
            }
        });
    }

    void sendSelectionEvent() {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        OS.gtk_calendar_get_date(this.handle, nArray, nArray2, nArray3);
        if (nArray3[0] != this.day || nArray2[0] != this.month || nArray[0] != this.year) {
            this.year = nArray[0];
            this.month = nArray2[0];
            this.day = nArray3[0];
            this.sendSelectionEvent(13);
        }
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        if (!OS.GTK3 && (this.style & 0x400) != 0 && color == null) {
            OS.gtk_widget_modify_base(this.handle, 0, null);
        }
        this.bg = color;
        if (this.text != null) {
            this.text.setBackground(color);
        }
        if (this.popupCalendar != null) {
            this.popupCalendar.setBackground(color);
        }
    }

    void setBackgroundColor(GdkColor gdkColor) {
        if ((this.style & 0x400) != 0 && !OS.GTK3) {
            OS.gtk_widget_modify_base(this.handle, 0, gdkColor);
        } else {
            super.setBackgroundColor(gdkColor);
        }
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if ((this.style & 0x400) == 0) {
            this.text.setEnabled(bl);
            this.down.setEnabled(bl);
            if (this.up != null) {
                this.up.setEnabled(bl);
            }
        }
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.font = font;
        if (this.text != null) {
            this.text.setFont(font);
        }
        if (this.popupCalendar != null) {
            this.popupCalendar.setFont(font);
        }
        this.redraw();
    }

    void setForegroundColor(GdkColor gdkColor) {
        this.setForegroundColor(this.handle, gdkColor, false);
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.fg = color;
        if (this.text != null) {
            this.text.setForeground(color);
        }
        if (this.popupCalendar != null) {
            this.popupCalendar.setForeground(color);
        }
    }

    void setFormat(String string) {
        this.fieldCount = (this.style & 0x20) != 0 ? ((this.style & 0x8000) != 0 ? 2 : 3) : ((this.style & 0x8000) != 0 ? 3 : 4);
        this.fieldIndices = new Point[this.fieldCount];
        this.fieldNames = new int[this.fieldCount];
        if ((this.style & 0x20) != 0) {
            this.fieldNames[0] = 2;
            this.fieldIndices[0] = new Point(0, 2);
            if ((this.style & 0x8000) != 0) {
                this.fieldNames[1] = 1;
                this.fieldIndices[1] = new Point(3, 7);
            } else {
                this.fieldNames[1] = 5;
                this.fieldIndices[1] = new Point(3, 5);
                this.fieldNames[2] = 1;
                this.fieldIndices[2] = new Point(6, 10);
            }
        } else {
            this.fieldNames[0] = 10;
            this.fieldIndices[0] = new Point(0, 2);
            this.fieldNames[1] = 12;
            this.fieldIndices[1] = new Point(3, 5);
            if ((this.style & 0x8000) != 0) {
                this.fieldNames[2] = 9;
                this.fieldIndices[2] = new Point(6, 8);
            } else {
                this.fieldNames[2] = 13;
                this.fieldIndices[2] = new Point(6, 8);
                this.fieldNames[3] = 9;
                this.fieldIndices[3] = new Point(9, 11);
            }
        }
    }

    void setField(int n, int n2) {
        if (this.calendar.get(n) == n2) {
            return;
        }
        if (n == 9) {
            this.calendar.roll(11, 12);
        }
        this.calendar.set(n, n2);
        this.sendSelectionEvent(13);
    }

    void setTextField(int n, int n2, boolean bl, boolean bl2) {
        int n3;
        int n4;
        if (bl) {
            n4 = this.calendar.getActualMaximum(n);
            n3 = this.calendar.getActualMinimum(n);
            if (n == 1) {
                n4 = 9999;
                n3 = 1752;
                int n5 = Calendar.getInstance().get(1);
                int n6 = n5 / 100 * 100;
                if (n2 < (n5 + 30) % 100) {
                    n2 += n6;
                } else if (n2 < 100) {
                    n2 += n6 - 100;
                }
            }
            if (n2 > n4) {
                n2 = n3;
            }
            if (n2 < n3) {
                n2 = n4;
            }
        }
        n4 = this.fieldIndices[this.currentField].x;
        n3 = this.fieldIndices[this.currentField].y;
        this.text.setSelection(n4, n3);
        String string = this.formattedStringValue(n, n2, bl2);
        StringBuffer stringBuffer = new StringBuffer(string);
        int n7 = n3 - n4 - stringBuffer.length();
        block3: for (int i = 0; i < n7; ++i) {
            switch (n) {
                case 12: 
                case 13: {
                    stringBuffer.insert(0, 0);
                    continue block3;
                }
                default: {
                    stringBuffer.insert(0, ' ');
                }
            }
        }
        string = stringBuffer.toString();
        this.ignoreVerify = true;
        this.text.insert(string);
        this.ignoreVerify = false;
        this.selectField(this.currentField);
        if (bl) {
            this.setField(n, n2);
        }
    }

    public void setDate(int n, int n2, int n3) {
        this.checkWidget();
        if (!this.isValidDate(n, n2, n3)) {
            return;
        }
        if ((this.style & 0x400) != 0) {
            this.year = n;
            this.month = n2;
            this.day = n3;
            OS.gtk_calendar_select_month(this.handle, n2, n);
            OS.gtk_calendar_select_day(this.handle, n3);
        } else {
            this.calendar.set(n, n2, n3);
            this.updateControl();
        }
    }

    public void setDay(int n) {
        this.checkWidget();
        if (!this.isValidDate(this.getYear(), this.getMonth(), n)) {
            return;
        }
        if ((this.style & 0x400) != 0) {
            this.day = n;
            OS.gtk_calendar_select_day(this.handle, n);
        } else {
            this.calendar.set(5, n);
            this.updateControl();
        }
    }

    public void setHours(int n) {
        this.checkWidget();
        if (!this.isValidTime(11, n)) {
            return;
        }
        if ((this.style & 0x400) != 0) {
            this.hours = n;
        } else {
            this.calendar.set(11, n);
            this.updateControl();
        }
    }

    public void setMenu(Menu menu) {
        super.setMenu(menu);
        if (this.up != null) {
            this.up.setMenu(menu);
        }
        if (this.down != null) {
            this.down.setMenu(menu);
        }
        if (this.text != null) {
            this.text.setMenu(menu);
        }
    }

    public void setMinutes(int n) {
        this.checkWidget();
        if (!this.isValidTime(12, n)) {
            return;
        }
        if ((this.style & 0x400) != 0) {
            this.minutes = n;
        } else {
            this.calendar.set(12, n);
            this.updateControl();
        }
    }

    public void setMonth(int n) {
        this.checkWidget();
        if (!this.isValidDate(this.getYear(), n, this.getDay())) {
            return;
        }
        if ((this.style & 0x400) != 0) {
            this.month = n;
            OS.gtk_calendar_select_month(this.handle, n, this.year);
        } else {
            this.calendar.set(2, n);
            this.updateControl();
        }
    }

    public void setSeconds(int n) {
        this.checkWidget();
        if (!this.isValidTime(13, n)) {
            return;
        }
        if ((this.style & 0x400) != 0) {
            this.seconds = n;
        } else {
            this.calendar.set(13, n);
            this.updateControl();
        }
    }

    public void setTime(int n, int n2, int n3) {
        this.checkWidget();
        if (!this.isValidTime(11, n)) {
            return;
        }
        if (!this.isValidTime(12, n2)) {
            return;
        }
        if (!this.isValidTime(13, n3)) {
            return;
        }
        if ((this.style & 0x400) != 0) {
            this.hours = n;
            this.minutes = n2;
            this.seconds = n3;
        } else {
            this.calendar.set(11, n);
            this.calendar.set(12, n2);
            this.calendar.set(13, n3);
            this.updateControl();
        }
    }

    public void setYear(int n) {
        this.checkWidget();
        if (!this.isValidDate(n, this.getMonth(), this.getDay())) {
            return;
        }
        if ((this.style & 0x400) != 0) {
            this.year = n;
            OS.gtk_calendar_select_month(this.handle, this.month, n);
        } else {
            this.calendar.set(1, n);
            this.updateControl();
        }
    }

    void onTextFocusIn(Event event) {
        this.selectField(this.currentField);
        if ((this.style & 4) == 0) {
            this.sendFocusEvent(15);
        } else {
            this.handleFocus(15);
        }
    }

    void onTextFocusOut(Event event) {
        this.commitCurrentField();
        if ((this.style & 4) == 0) {
            this.sendFocusEvent(16);
        } else {
            this.handleFocus(16);
        }
    }

    void onTextKeyDown(Event event) {
        if ((this.style & 4) != 0 && (event.stateMask & 0x10000) != 0 && (event.keyCode == 0x1000001 || event.keyCode == 0x1000002)) {
            boolean bl = this.isDropped();
            if (!bl) {
                this.popupCalendar.calendarDisplayed = true;
                this.setFocus();
            }
            this.dropDownCalendar(!bl);
            return;
        }
        block0 : switch (event.keyCode) {
            case 0x1000004: 
            case 16777263: {
                this.selectField((this.currentField + 1) % this.fieldCount);
                this.sendEvent(31);
                break;
            }
            case 0x1000003: {
                int n = this.currentField - 1;
                this.selectField(n < 0 ? this.fieldCount - 1 : n);
                this.sendEvent(31);
                break;
            }
            case 0x1000001: 
            case 16777259: {
                this.commitCurrentField();
                this.incrementField(1);
                break;
            }
            case 0x1000002: 
            case 16777261: {
                this.commitCurrentField();
                this.incrementField(-1);
                break;
            }
            case 0x1000007: {
                int n = this.fieldNames[this.currentField];
                this.setTextField(n, this.calendar.getActualMinimum(n), true, true);
                break;
            }
            case 0x1000008: {
                int n = this.fieldNames[this.currentField];
                this.setTextField(n, this.calendar.getActualMaximum(n), true, true);
                break;
            }
            default: {
                switch (event.character) {
                    case '-': 
                    case '.': 
                    case '/': 
                    case ':': {
                        this.selectField((this.currentField + 1) % this.fieldCount);
                        this.sendEvent(31);
                        break block0;
                    }
                    case '\r': {
                        this.postEvent(14);
                    }
                }
            }
        }
    }

    void onTextMouseClick(Event event) {
        if (event.button != 1) {
            return;
        }
        Point point = this.text.getSelection();
        for (int i = 0; i < this.fieldCount; ++i) {
            if (point.x < this.fieldIndices[i].x || point.x > this.fieldIndices[i].y) continue;
            this.currentField = i;
            break;
        }
        this.selectField(this.currentField);
    }

    void onResize(Event event) {
        Rectangle rectangle = this.getClientArea();
        int n = rectangle.width;
        int n2 = rectangle.height;
        Point point = this.down.computeSize(-1, n2);
        this.text.setBounds(0, 0, n - point.x, n2);
        if ((this.style & 4) != 0) {
            this.down.setBounds(n - point.x, 0, point.x, n2);
        } else {
            int n3 = n2 / 2;
            this.up.setBounds(n - point.x, 0, point.x, n3);
            this.down.setBounds(n - point.x, n3, point.x, n3);
        }
    }

    void onTextVerify(Event event) {
        int n;
        if (this.ignoreVerify) {
            return;
        }
        event.doit = false;
        int n2 = this.fieldNames[this.currentField];
        int n3 = this.fieldIndices[this.currentField].x;
        int n4 = this.fieldIndices[this.currentField].y;
        int n5 = n4 - n3;
        String string = event.text;
        if (n2 == 9) {
            String[] stringArray = this.formatSymbols.getAmPmStrings();
            if (string.equalsIgnoreCase(stringArray[0].substring(0, 1)) || string.equalsIgnoreCase(stringArray[0])) {
                this.setTextField(n2, 0, true, false);
            } else if (string.equalsIgnoreCase(stringArray[1].substring(0, 1)) || string.equalsIgnoreCase(stringArray[1])) {
                this.setTextField(n2, 1, true, false);
            }
            return;
        }
        if (this.characterCount > 0) {
            try {
                Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                return;
            }
            String string2 = this.text.getText(n3, n4 - 1);
            n = string2.lastIndexOf(32);
            if (n != -1) {
                string2 = string2.substring(n + 1);
            }
            string = "" + string2 + string;
        }
        int n6 = string.length();
        n = this.characterCount == 0 ? 1 : 0;
        this.characterCount = n6 < n5 ? n6 : 0;
        int n7 = this.calendar.getActualMaximum(n2);
        int n8 = this.calendar.getActualMinimum(n2);
        int n9 = this.unformattedIntValue(n2, string, this.characterCount == 0, n7);
        if (n9 == -1) {
            this.characterCount = 0;
            return;
        }
        if (n != 0 && n9 == 0 && n5 > 1) {
            this.setTextField(n2, n9, false, false);
        } else if (n8 <= n9 && n9 <= n7) {
            this.setTextField(n2, n9, this.characterCount == 0, this.characterCount == 0);
        } else if (n6 >= n5 && (n9 = this.unformattedIntValue(n2, string = string.substring(n6 - n5 + 1), this.characterCount == 0, n7)) != -1) {
            this.characterCount = n5 - 1;
            if (n8 <= n9 && n9 <= n7) {
                this.setTextField(n2, n9, this.characterCount == 0, true);
            }
        }
    }

    int unformattedIntValue(int n, String string, boolean bl, int n2) {
        int n3;
        try {
            n3 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
        if (n == 2 && bl && --n3 == -1) {
            n3 = n2;
        }
        if (n == 10 && bl && n3 == 12) {
            n3 = 0;
        }
        return n3;
    }

    void updateControl() {
        if (this.text != null) {
            String string = this.getFormattedString(this.style);
            this.ignoreVerify = true;
            this.text.setText(string);
            this.ignoreVerify = false;
        }
        this.redraw();
    }
}

