/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal;

import org.eclipse.swt.internal.motif.OS;

public final class Converter {
    static final byte[] NULL_BYTE_ARRAY;
    static final byte[] EMPTY_BYTE_ARRAY;
    static final char[] EMPTY_CHAR_ARRAY;
    static String CodePage;
    static final byte[] UCS2;
    static final byte[] UTF8;
    static final Object LOCK;
    static boolean LastMbcsToUCS2Failed;
    static boolean LastUCS2ToMbcsFailed;
    static String LastMbcsToUCS2CodePage;
    static String LastUCS2ToMbcsCodePage;
    static int LastUCS2ToMbcs;
    static int LastUTF8ToMbcs;
    static int LastMbcsToUCS2;
    static int LastMbcsToUTF8;
    static int UTF8ToUCS2;
    static int UCS2ToUTF8;
    static int BufferSize;
    static int MbcsBuffer;
    static int Ucs2Buffer;
    static int Utf8Buffer;

    static {
        int n;
        NULL_BYTE_ARRAY = new byte[1];
        EMPTY_BYTE_ARRAY = new byte[0];
        EMPTY_CHAR_ARRAY = new char[0];
        LOCK = new Object();
        LastUCS2ToMbcs = -1;
        LastUTF8ToMbcs = -1;
        LastMbcsToUCS2 = -1;
        LastMbcsToUTF8 = -1;
        UTF8ToUCS2 = -1;
        UCS2ToUTF8 = -1;
        if (OS.IsHPUX) {
            UCS2 = Converter.getAsciiBytes("ucs2");
            UTF8 = Converter.getAsciiBytes("utf8");
        } else {
            UCS2 = Converter.getAsciiBytes("UCS-2");
            UTF8 = Converter.getAsciiBytes("UTF-8");
        }
        int n2 = OS.nl_langinfo(OS.CODESET);
        if (n2 != 0 && (n = OS.strlen(n2)) > 0) {
            byte[] byArray = new byte[n];
            OS.memmove(byArray, n2, n);
            CodePage = new String(byArray);
            if (OS.IsSunOS && n > 3 && CodePage.indexOf("ISO") == 0) {
                CodePage = CodePage.substring(3, n);
            }
        } else {
            CodePage = OS.IsLinux ? "ISO-8859-1" : (OS.IsAIX ? "ISO8859-1" : (OS.IsSunOS ? "8859-1" : (OS.IsHPUX ? "iso88591" : "iso8859_1")));
        }
        BufferSize = 512;
        Ucs2Buffer = OS.XtMalloc(BufferSize * 2);
        Utf8Buffer = OS.XtMalloc(BufferSize * 6);
        MbcsBuffer = OS.XtMalloc(BufferSize * 6);
    }

    public static String defaultCodePage() {
        return CodePage;
    }

    static byte[] getAsciiBytes(String string) {
        int n = string.length();
        byte[] byArray = new byte[n + 1];
        int n2 = 0;
        while (n2 < n) {
            byArray[n2] = (byte)string.charAt(n2);
            ++n2;
        }
        return byArray;
    }

    static String getAsciiString(byte[] byArray) {
        int n = byArray.length;
        char[] cArray = new char[n];
        int n2 = 0;
        while (n2 < n) {
            cArray[n2] = (char)byArray[n2];
            ++n2;
        }
        return new String(cArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static char[] mbcsToWcs(String string, byte[] byArray) {
        if (byArray == null) {
            return EMPTY_CHAR_ARRAY;
        }
        int n = byArray.length;
        if (n == 0) {
            return EMPTY_CHAR_ARRAY;
        }
        char[] cArray = new char[n];
        int n2 = 0;
        while (n2 < n) {
            if ((byArray[n2] & 0xFF) > 127) {
                Object object = LOCK;
                synchronized (object) {
                    int n3;
                    String string2;
                    String string3 = string2 = string != null ? string : CodePage;
                    if (string2 != LastMbcsToUCS2CodePage && !string2.equals(LastMbcsToUCS2CodePage)) {
                        if (LastMbcsToUCS2 != -1) {
                            OS.iconv_close(LastMbcsToUCS2);
                        }
                        if (LastMbcsToUTF8 != -1) {
                            OS.iconv_close(LastMbcsToUTF8);
                        }
                        LastMbcsToUTF8 = -1;
                        LastMbcsToUCS2 = -1;
                        LastMbcsToUCS2CodePage = string2;
                        LastMbcsToUCS2Failed = false;
                    }
                    if ((n3 = LastMbcsToUCS2) == -1 && !LastMbcsToUCS2Failed) {
                        n3 = LastMbcsToUCS2 = OS.iconv_open(UCS2, Converter.getAsciiBytes(string2));
                    }
                    if (n3 == -1) {
                        LastMbcsToUCS2Failed = true;
                        n3 = UTF8ToUCS2;
                        if (n3 == -1) {
                            n3 = UTF8ToUCS2 = OS.iconv_open(UCS2, UTF8);
                        }
                        if (n3 == -1) {
                            return EMPTY_CHAR_ARRAY;
                        }
                        n3 = LastMbcsToUTF8;
                        if (n3 == -1) {
                            n3 = LastMbcsToUTF8 = OS.iconv_open(UTF8, Converter.getAsciiBytes(string2));
                        }
                    }
                    if (n3 == -1) {
                        return EMPTY_CHAR_ARRAY;
                    }
                    boolean bl = n3 == LastMbcsToUTF8;
                    int n4 = n;
                    int n5 = bl ? n * 6 : n * 2;
                    int n6 = 0;
                    int n7 = 0;
                    int n8 = 0;
                    if (n <= BufferSize) {
                        n6 = MbcsBuffer;
                        n7 = Utf8Buffer;
                        n8 = Ucs2Buffer;
                    } else {
                        n6 = OS.XtMalloc(n4);
                        if (bl) {
                            n7 = OS.XtMalloc(n * 6);
                        }
                        n8 = OS.XtMalloc(n * 2);
                    }
                    int n9 = bl ? n7 : n8;
                    int[] nArray = new int[]{n6};
                    int[] nArray2 = new int[]{n4};
                    int[] nArray3 = new int[]{n9};
                    int[] nArray4 = new int[]{n5};
                    OS.memmove(n6, byArray, n4);
                    OS.iconv(n3, nArray, nArray2, nArray3, nArray4);
                    n5 = nArray3[0] - n9;
                    if (bl) {
                        n3 = UTF8ToUCS2;
                        n4 = n5;
                        n5 = n * 2;
                        nArray[0] = n7;
                        nArray2[0] = n4;
                        nArray3[0] = n8;
                        nArray4[0] = n5;
                        OS.iconv(n3, nArray, nArray2, nArray3, nArray4);
                        n5 = nArray3[0] - n8;
                    }
                    cArray = new char[n5 / 2];
                    OS.memmove(cArray, n8, n5);
                    if (n6 != 0 && n6 != MbcsBuffer) {
                        OS.XtFree(n6);
                    }
                    if (n7 != 0 && n7 != Utf8Buffer) {
                        OS.XtFree(n7);
                    }
                    if (n8 != 0 && n8 != Ucs2Buffer) {
                        OS.XtFree(n8);
                    }
                }
                return cArray;
            }
            cArray[n2] = (char)byArray[n2];
            ++n2;
        }
        return cArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void release() {
        Object object = LOCK;
        synchronized (object) {
            if (Ucs2Buffer != 0) {
                OS.XtFree(Ucs2Buffer);
            }
            if (Utf8Buffer != 0) {
                OS.XtFree(Utf8Buffer);
            }
            if (MbcsBuffer != 0) {
                OS.XtFree(MbcsBuffer);
            }
            if (LastUCS2ToMbcs != -1) {
                OS.iconv_close(LastUCS2ToMbcs);
            }
            if (LastUTF8ToMbcs != -1) {
                OS.iconv_close(LastUTF8ToMbcs);
            }
            if (LastMbcsToUCS2 != -1) {
                OS.iconv_close(LastMbcsToUCS2);
            }
            if (LastMbcsToUTF8 != -1) {
                OS.iconv_close(LastMbcsToUTF8);
            }
            if (UTF8ToUCS2 != -1) {
                OS.iconv_close(UTF8ToUCS2);
            }
            if (UCS2ToUTF8 != -1) {
                OS.iconv_close(UCS2ToUTF8);
            }
            LastMbcsToUTF8 = UTF8ToUCS2 = UCS2ToUTF8 - 1;
            LastMbcsToUCS2 = UTF8ToUCS2;
            LastUTF8ToMbcs = UTF8ToUCS2;
            LastUCS2ToMbcs = UTF8ToUCS2;
            MbcsBuffer = 0;
            Utf8Buffer = 0;
            Ucs2Buffer = 0;
        }
    }

    public static byte[] wcsToMbcs(String string, char[] cArray) {
        return Converter.wcsToMbcs(string, cArray, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] wcsToMbcs(String string, char[] cArray, boolean bl) {
        if (cArray == null) {
            return bl ? NULL_BYTE_ARRAY : EMPTY_BYTE_ARRAY;
        }
        int n = cArray.length;
        if (n == 0) {
            return bl ? NULL_BYTE_ARRAY : EMPTY_BYTE_ARRAY;
        }
        byte[] byArray = new byte[bl ? n + 1 : n];
        int n2 = 0;
        while (n2 < n) {
            if ((cArray[n2] & 0xFFFF) > 127) {
                Object object = LOCK;
                synchronized (object) {
                    int n3;
                    String string2;
                    String string3 = string2 = string != null ? string : CodePage;
                    if (string2 != LastUCS2ToMbcsCodePage && !string2.equals(LastUCS2ToMbcsCodePage)) {
                        if (LastUCS2ToMbcs != -1) {
                            OS.iconv_close(LastUCS2ToMbcs);
                        }
                        if (LastUTF8ToMbcs != -1) {
                            OS.iconv_close(LastUTF8ToMbcs);
                        }
                        LastUTF8ToMbcs = -1;
                        LastUCS2ToMbcs = -1;
                        LastUCS2ToMbcsCodePage = string2;
                    }
                    if ((n3 = LastUCS2ToMbcs) == -1 && !LastUCS2ToMbcsFailed) {
                        n3 = LastUCS2ToMbcs = OS.iconv_open(Converter.getAsciiBytes(string2), UCS2);
                    }
                    if (n3 == -1) {
                        LastUCS2ToMbcsFailed = true;
                        n3 = LastUTF8ToMbcs;
                        if (n3 == -1) {
                            n3 = LastUTF8ToMbcs = OS.iconv_open(Converter.getAsciiBytes(string2), UTF8);
                        }
                        if (n3 == -1) {
                            return bl ? NULL_BYTE_ARRAY : EMPTY_BYTE_ARRAY;
                        }
                        n3 = UCS2ToUTF8;
                        if (n3 == -1) {
                            n3 = UCS2ToUTF8 = OS.iconv_open(UTF8, UCS2);
                        }
                    }
                    if (n3 == -1) {
                        return bl ? NULL_BYTE_ARRAY : EMPTY_BYTE_ARRAY;
                    }
                    boolean bl2 = n3 == UCS2ToUTF8;
                    int n4 = n * 2;
                    int n5 = n * 6;
                    int n6 = 0;
                    int n7 = 0;
                    int n8 = 0;
                    if (n <= BufferSize) {
                        n6 = Ucs2Buffer;
                        n7 = Utf8Buffer;
                        n8 = MbcsBuffer;
                    } else {
                        n6 = OS.XtMalloc(n4);
                        if (bl2) {
                            n7 = OS.XtMalloc(n5);
                        }
                        n8 = OS.XtMalloc(n5);
                    }
                    int n9 = bl2 ? n7 : n8;
                    int[] nArray = new int[]{n6};
                    int[] nArray2 = new int[]{n4};
                    int[] nArray3 = new int[]{n9};
                    int[] nArray4 = new int[]{n5};
                    OS.memmove(n6, cArray, n4);
                    while (nArray2[0] > 0) {
                        OS.iconv(n3, nArray, nArray2, nArray3, nArray4);
                        if (nArray2[0] == 0) continue;
                        nArray[0] = nArray[0] + 2;
                        nArray2[0] = nArray2[0] - 2;
                    }
                    n5 = nArray3[0] - n9;
                    if (bl2) {
                        n3 = LastUTF8ToMbcs;
                        n4 = n5;
                        n5 = n * 6;
                        nArray[0] = n7;
                        nArray2[0] = n4;
                        nArray3[0] = n8;
                        nArray4[0] = n5;
                        OS.iconv(n3, nArray, nArray2, nArray3, nArray4);
                        n5 = nArray3[0] - n8;
                    }
                    byArray = new byte[bl ? n5 + 1 : n5];
                    OS.memmove(byArray, n8, n5);
                    if (n6 != 0 && n6 != Ucs2Buffer) {
                        OS.XtFree(n6);
                    }
                    if (n7 != 0 && n7 != Utf8Buffer) {
                        OS.XtFree(n7);
                    }
                    if (n8 != 0 && n8 != MbcsBuffer) {
                        OS.XtFree(n8);
                    }
                }
                return byArray;
            }
            byArray[n2] = (byte)cArray[n2];
            ++n2;
        }
        return byArray;
    }

    public static byte[] wcsToMbcs(String string, String string2) {
        return Converter.wcsToMbcs(string, string2, false);
    }

    public static byte[] wcsToMbcs(String string, String string2, boolean bl) {
        if (bl) {
            if (string2 == null) {
                return NULL_BYTE_ARRAY;
            }
            int n = string2.length();
            char[] cArray = new char[n + 1];
            string2.getChars(0, n, cArray, 0);
            return Converter.wcsToMbcs(string, cArray, false);
        }
        if (string2 == null) {
            return EMPTY_BYTE_ARRAY;
        }
        int n = string2.length();
        char[] cArray = new char[n];
        string2.getChars(0, n, cArray, 0);
        return Converter.wcsToMbcs(string, cArray, false);
    }
}

