/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.internal.motif.XFocusChangeEvent;
import org.eclipse.swt.internal.motif.XKeyEvent;
import org.eclipse.swt.internal.motif.XtWidgetGeometry;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TypedListener;

public class Button
extends Control {
    String text = "";
    Image image;
    Image bitmap;
    Image disabled;
    boolean grayed;
    static final byte[] ARM_AND_ACTIVATE;

    static {
        String string = "ArmAndActivate";
        int n = string.length();
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        byte[] byArray = new byte[n + 1];
        int n2 = 0;
        while (n2 < n) {
            byArray[n2] = (byte)cArray[n2];
            ++n2;
        }
        ARM_AND_ACTIVATE = byArray;
    }

    public Button(Composite composite, int n) {
        super(composite, Button.checkStyle(n));
    }

    void _setImage(Image image) {
        Object object;
        int n = 2;
        int n2 = 2;
        if (this.bitmap != null) {
            this.bitmap.dispose();
        }
        if (this.disabled != null) {
            this.disabled.dispose();
        }
        this.disabled = null;
        this.bitmap = null;
        if (image != null) {
            if (image.isDisposed()) {
                this.error(5);
            }
            switch (image.type) {
                case 0: {
                    if (image.mask == 0) {
                        object = image.getImageData();
                        if (((ImageData)object).alpha == -1 && ((ImageData)object).alphaData == null && ((ImageData)object).transparentPixel == -1) {
                            n = image.pixmap;
                            this.disabled = new Image((Device)this.display, image, 1);
                            n2 = this.disabled.pixmap;
                            break;
                        }
                    }
                }
                case 1: {
                    Rectangle rectangle = image.getBounds();
                    this.bitmap = new Image((Device)this.display, rectangle.width, rectangle.height);
                    GC gC = new GC(this.bitmap);
                    gC.setBackground(this.getBackground());
                    gC.fillRectangle(rectangle);
                    gC.drawImage(image, 0, 0);
                    gC.dispose();
                    n = this.bitmap.pixmap;
                    this.disabled = new Image((Device)this.display, this.bitmap, 1);
                    n2 = this.disabled.pixmap;
                    break;
                }
                default: {
                    this.error(20);
                }
            }
        }
        object = new int[]{OS.XmNlabelType, image == null ? 2 : 1, OS.XmNlabelPixmap, n, OS.XmNlabelInsensitivePixmap, n2};
        OS.XtSetValues(this.handle, (int[])object, ((Object)object).length / 2);
    }

    void _setText(String string) {
        char[] cArray = new char[string.length()];
        string.getChars(0, cArray.length, cArray, 0);
        int n = Button.fixMnemonic(cArray);
        byte[] byArray = Converter.wcsToMbcs(this.getCodePage(), cArray, true);
        int n2 = OS.XmStringParseText(byArray, 0, OS.XmFONTLIST_DEFAULT_TAG, 0, null, 0, 0);
        if (n2 == 0) {
            this.error(13);
        }
        if (n == 0) {
            n = 0xFFFFFF;
        }
        int[] nArray = new int[]{OS.XmNlabelType, 2, OS.XmNlabelString, n2, OS.XmNmnemonic, n};
        OS.XtSetValues(this.handle, nArray, nArray.length / 2);
        if (n2 != 0) {
            OS.XmStringFree(n2);
        }
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int n) {
        if (((n = Button.checkBits(n, 8, 4, 32, 16, 2, 0)) & 0xA) != 0) {
            return Button.checkBits(n, 0x1000000, 16384, 131072, 0, 0, 0);
        }
        if ((n & 0x30) != 0) {
            return Button.checkBits(n, 16384, 131072, 0x1000000, 0, 0, 0);
        }
        if ((n & 4) != 0) {
            return Button.checkBits(n |= 0x80000, 128, 1024, 16384, 131072, 0, 0);
        }
        return n;
    }

    void click() {
        int n = OS.XtMalloc(96);
        OS.XtCallActionProc(this.handle, ARM_AND_ACTIVATE, n, null, 0);
        OS.XtFree(n);
    }

    public Point computeSize(int n, int n2, boolean bl) {
        int[] nArray;
        this.checkWidget();
        int n3 = this.getBorderWidth();
        int n4 = n3 * 2;
        int n5 = n3 * 2;
        if ((this.style & 4) != 0) {
            n4 += this.display.scrolledMarginX;
            n5 += this.display.scrolledMarginY;
            if (n != -1) {
                n4 = n + n3 * 2;
            }
            if (n2 != -1) {
                n5 = n2 + n3 * 2;
            }
            return new Point(n4, n5);
        }
        XtWidgetGeometry xtWidgetGeometry = new XtWidgetGeometry();
        xtWidgetGeometry.request_mode = 12;
        int[] nArray2 = new int[]{OS.XmNrecomputeSize, 1};
        OS.XtSetValues(this.handle, nArray2, nArray2.length / 2);
        OS.XtQueryGeometry(this.handle, null, xtWidgetGeometry);
        int[] nArray3 = new int[2];
        nArray3[0] = OS.XmNrecomputeSize;
        int[] nArray4 = nArray3;
        OS.XtSetValues(this.handle, nArray4, nArray4.length / 2);
        n4 += xtWidgetGeometry.width;
        n5 += xtWidgetGeometry.height;
        int[] nArray5 = new int[2];
        nArray5[0] = OS.XmNlabelType;
        int[] nArray6 = nArray5;
        OS.XtGetValues(this.handle, nArray6, nArray6.length / 2);
        if (nArray6[1] == 2) {
            int[] nArray7 = new int[2];
            nArray7[0] = OS.XmNlabelString;
            nArray = nArray7;
            OS.XtGetValues(this.handle, nArray, nArray.length / 2);
            int n6 = nArray[1];
            if (n6 != 0) {
                if (OS.XmStringEmpty(n6)) {
                    byte[] byArray = new byte[2];
                    byArray[0] = 32;
                    int n7 = OS.XmStringCreateLocalized(byArray);
                    if (n7 != 0) {
                        n5 += OS.XmStringHeight(this.font.handle, n7);
                        OS.XmStringFree(n7);
                    }
                }
                OS.XmStringFree(n6);
            }
        }
        if (n != -1 || n2 != -1) {
            int[] nArray8 = new int[8];
            nArray8[0] = OS.XmNmarginLeft;
            nArray8[2] = OS.XmNmarginRight;
            nArray8[4] = OS.XmNmarginTop;
            nArray8[6] = OS.XmNmarginBottom;
            nArray = nArray8;
            OS.XtGetValues(this.handle, nArray, nArray.length / 2);
            if (n != -1) {
                n4 = n + nArray[1] + nArray[3] + n3 * 2;
            }
            if (n2 != -1) {
                n5 = n2 + nArray[5] + nArray[7] + n3 * 2;
            }
        }
        return new Point(n4, n5);
    }

    void createHandle(int n) {
        if ((this.style & 8) == 0) {
            this.state |= 0x80;
        }
        int n2 = (this.style & 0x800) != 0 ? 1 : 0;
        int n3 = this.parent.handle;
        if ((this.style & 4) != 0) {
            int n4 = 0;
            if ((this.style & 0x80) != 0) {
                n4 = 0;
            }
            if ((this.style & 0x400) != 0) {
                n4 = 1;
            }
            if ((this.style & 0x4000) != 0) {
                n4 = 2;
            }
            if ((this.style & 0x20000) != 0) {
                n4 = 3;
            }
            int[] nArray = new int[8];
            nArray[0] = OS.XmNtraversalOn;
            nArray[2] = OS.XmNarrowDirection;
            nArray[3] = n4;
            nArray[4] = OS.XmNborderWidth;
            nArray[5] = n2;
            nArray[6] = OS.XmNancestorSensitive;
            nArray[7] = 1;
            int[] nArray2 = nArray;
            this.handle = OS.XmCreateArrowButton(n3, null, nArray2, nArray2.length / 2);
            if (this.handle == 0) {
                this.error(2);
            }
            if ((this.style & 0x800000) != 0) {
                int[] nArray3 = new int[2];
                nArray3[0] = OS.XmNbottomShadowColor;
                int[] nArray4 = nArray3;
                OS.XtGetValues(this.handle, nArray4, nArray4.length / 2);
                int[] nArray5 = new int[]{OS.XmNshadowThickness, 1, OS.XmNtopShadowColor, nArray4[1]};
                OS.XtSetValues(this.handle, nArray5, nArray5.length / 2);
            }
            return;
        }
        int n5 = 0;
        if ((this.style & 0x1000000) != 0) {
            n5 = 1;
        }
        if ((this.style & 0x20000) != 0) {
            n5 = 2;
        }
        if ((this.style & 2) != 0) {
            int n6 = this.display.buttonShadowThickness;
            int[] nArray = new int[12];
            nArray[0] = OS.XmNancestorSensitive;
            nArray[1] = 1;
            nArray[2] = OS.XmNrecomputeSize;
            nArray[4] = OS.XmNindicatorOn;
            nArray[6] = OS.XmNshadowThickness;
            nArray[7] = (this.style & 0x800000) != 0 ? 1 : n6;
            nArray[8] = OS.XmNalignment;
            nArray[9] = n5;
            nArray[10] = OS.XmNborderWidth;
            nArray[11] = n2;
            int[] nArray6 = nArray;
            this.handle = OS.XmCreateToggleButton(n3, null, nArray6, nArray6.length / 2);
            if (this.handle == 0) {
                this.error(2);
            }
            if ((this.style & 0x800000) != 0) {
                int[] nArray7 = new int[2];
                nArray7[0] = OS.XmNbottomShadowColor;
                int[] nArray8 = nArray7;
                OS.XtGetValues(this.handle, nArray8, nArray8.length / 2);
                int[] nArray9 = new int[]{OS.XmNtopShadowColor, nArray8[1]};
                OS.XtSetValues(this.handle, nArray9, nArray9.length / 2);
            }
            return;
        }
        if ((this.style & 0x30) != 0) {
            int n7 = 2;
            if ((this.style & 0x20) != 0) {
                n7 = 1;
            }
            int[] nArray = new int[10];
            nArray[0] = OS.XmNancestorSensitive;
            nArray[1] = 1;
            nArray[2] = OS.XmNrecomputeSize;
            nArray[4] = OS.XmNindicatorType;
            nArray[5] = n7;
            nArray[6] = OS.XmNalignment;
            nArray[7] = n5;
            nArray[8] = OS.XmNborderWidth;
            nArray[9] = n2;
            int[] nArray10 = nArray;
            this.handle = OS.XmCreateToggleButton(n3, null, nArray10, nArray10.length / 2);
            if (this.handle == 0) {
                this.error(2);
            }
            return;
        }
        int[] nArray = new int[8];
        nArray[0] = OS.XmNancestorSensitive;
        nArray[1] = 1;
        nArray[2] = OS.XmNrecomputeSize;
        nArray[4] = OS.XmNalignment;
        nArray[5] = n5;
        nArray[6] = OS.XmNborderWidth;
        nArray[7] = n2;
        int[] nArray11 = nArray;
        this.handle = OS.XmCreatePushButton(n3, null, nArray11, nArray11.length / 2);
        if (this.handle == 0) {
            this.error(2);
        }
        if ((this.style & 0x800000) != 0) {
            int[] nArray12 = new int[2];
            nArray12[0] = OS.XmNbottomShadowColor;
            int[] nArray13 = nArray12;
            OS.XtGetValues(this.handle, nArray13, nArray13.length / 2);
            int[] nArray14 = new int[]{OS.XmNshadowThickness, 1, OS.XmNtopShadowColor, nArray13[1]};
            OS.XtSetValues(this.handle, nArray14, nArray14.length / 2);
        }
    }

    void createWidget(int n) {
        super.createWidget(n);
        if ((this.style & 8) == 0) {
            return;
        }
        if (this.getShell().parent == null) {
            return;
        }
        int[] nArray = new int[]{OS.XmNdefaultButtonShadowThickness, 1};
        OS.XtSetValues(this.handle, nArray, nArray.length / 2);
    }

    int defaultBackground() {
        return this.display.buttonBackground;
    }

    Font defaultFont() {
        return this.display.buttonFont;
    }

    int defaultForeground() {
        return this.display.buttonForeground;
    }

    public int getAlignment() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            int[] nArray = new int[2];
            nArray[0] = OS.XmNarrowDirection;
            int[] nArray2 = nArray;
            OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
            int n = nArray2[1];
            if (n == 0) {
                return 128;
            }
            if (n == 1) {
                return 1024;
            }
            if (n == 2) {
                return 16384;
            }
            if (n == 3) {
                return 131072;
            }
            return 128;
        }
        int[] nArray = new int[2];
        nArray[0] = OS.XmNalignment;
        int[] nArray3 = nArray;
        OS.XtGetValues(this.handle, nArray3, nArray3.length / 2);
        int n = nArray3[1];
        if (n == 0) {
            return 16384;
        }
        if (n == 1) {
            return 0x1000000;
        }
        if (n == 2) {
            return 131072;
        }
        return 0x1000000;
    }

    boolean getDefault() {
        if ((this.style & 8) == 0) {
            return false;
        }
        return this == this.menuShell().defaultButton;
    }

    public boolean getGrayed() {
        this.checkWidget();
        if ((this.style & 0x20) == 0) {
            return false;
        }
        return this.grayed;
    }

    public Image getImage() {
        this.checkWidget();
        return this.image;
    }

    String getNameText() {
        return this.getText();
    }

    public boolean getSelection() {
        this.checkWidget();
        if ((this.style & 0x32) == 0) {
            return false;
        }
        int[] nArray = new int[2];
        nArray[0] = OS.XmNset;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        return nArray2[1] != 0;
    }

    public String getText() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return "";
        }
        return this.text;
    }

    void hookEvents() {
        super.hookEvents();
        int n = this.display.windowProc;
        if ((this.style & 0x32) != 0) {
            OS.XtAddCallback(this.handle, OS.XmNvalueChangedCallback, n, 24);
        } else {
            OS.XtAddCallback(this.handle, OS.XmNactivateCallback, n, 9);
        }
    }

    boolean mnemonicHit(char c) {
        if (!this.setFocus()) {
            return false;
        }
        this.click();
        return true;
    }

    boolean mnemonicMatch(char c) {
        char c2 = this.findMnemonic(this.getText());
        if (c2 == '\u0000') {
            return false;
        }
        return Character.toUpperCase(c) == Character.toUpperCase(c2);
    }

    void releaseWidget() {
        super.releaseWidget();
        int[] nArray = new int[]{OS.XmNlabelPixmap, 2, OS.XmNlabelInsensitivePixmap, 2};
        OS.XtSetValues(this.handle, nArray, nArray.length / 2);
        if (this.bitmap != null) {
            this.bitmap.dispose();
        }
        if (this.disabled != null) {
            this.disabled.dispose();
        }
        this.disabled = null;
        this.bitmap = null;
        this.image = null;
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    void selectRadio() {
        Control[] controlArray = this.parent._getChildren();
        int n = 0;
        while (n < controlArray.length) {
            Control control = controlArray[n];
            if (this != control) {
                control.setRadioSelection(false);
            }
            ++n;
        }
        this.setSelection(true);
    }

    public void setAlignment(int n) {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            int[] nArray = new int[2];
            nArray[0] = OS.XmNarrowDirection;
            int[] nArray2 = nArray;
            if ((n & 0x80) != 0) {
                nArray2[1] = 0;
            }
            if ((n & 0x400) != 0) {
                nArray2[1] = 1;
            }
            if ((n & 0x4000) != 0) {
                nArray2[1] = 2;
            }
            if ((n & 0x20000) != 0) {
                nArray2[1] = 3;
            }
            OS.XtSetValues(this.handle, nArray2, nArray2.length / 2);
            return;
        }
        if ((n & 0x1024000) == 0) {
            return;
        }
        int[] nArray = new int[2];
        nArray[0] = OS.XmNalignment;
        int[] nArray3 = nArray;
        if ((n & 0x1000000) != 0) {
            nArray3[1] = 1;
        }
        if ((n & 0x20000) != 0) {
            nArray3[1] = 2;
        }
        OS.XtSetValues(this.handle, nArray3, nArray3.length / 2);
    }

    void setBackgroundPixel(int n) {
        int[] nArray;
        super.setBackgroundPixel(n);
        if ((this.style & 0x800000) != 0) {
            int[] nArray2 = new int[2];
            nArray2[0] = OS.XmNbottomShadowColor;
            nArray = nArray2;
            OS.XtGetValues(this.handle, nArray, nArray.length / 2);
            int[] nArray3 = new int[]{OS.XmNtopShadowColor, nArray[1]};
            OS.XtSetValues(this.handle, nArray3, nArray3.length / 2);
        }
        int[] nArray4 = new int[2];
        nArray4[0] = OS.XmNlabelType;
        nArray = nArray4;
        OS.XtGetValues(this.handle, nArray, nArray.length / 2);
        if (nArray[1] == 1) {
            this._setImage(this.image);
        }
    }

    void setDefault(boolean bl) {
        if ((this.style & 8) == 0) {
            return;
        }
        if (this.getShell().parent == null) {
            return;
        }
        int[] nArray = new int[]{OS.XmNshowAsDefault, bl ? 1 : 0};
        OS.XtSetValues(this.handle, nArray, nArray.length / 2);
    }

    public void setFont(Font font) {
        boolean bl;
        this.checkWidget();
        int[] nArray = new int[4];
        nArray[0] = OS.XmNlabelString;
        nArray[2] = OS.XmNlabelType;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        boolean bl2 = bl = OS.IsDBLocale && OS.XmStringEmpty(nArray2[1]);
        if (bl) {
            byte[] byArray = Converter.wcsToMbcs(this.getCodePage(), "string", true);
            int n = OS.XmStringCreateLocalized(byArray);
            int[] nArray3 = new int[]{OS.XmNlabelType, 2, OS.XmNlabelString, n};
            OS.XtSetValues(this.handle, nArray3, nArray3.length / 2);
            OS.XmStringFree(n);
        }
        super.setFont(font);
        if (bl) {
            OS.XtSetValues(this.handle, nArray2, nArray2.length / 2);
        }
    }

    public void setGrayed(boolean bl) {
        this.checkWidget();
        if ((this.style & 0x20) == 0) {
            return;
        }
        this.grayed = bl;
    }

    public void setImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        if ((this.style & 4) != 0) {
            return;
        }
        this.image = image;
        this._setImage(image);
    }

    boolean setRadioSelection(boolean bl) {
        if ((this.style & 0x10) == 0) {
            return false;
        }
        if (this.getSelection() != bl) {
            this.setSelection(bl);
            this.postEvent(13);
        }
        return true;
    }

    public void setSelection(boolean bl) {
        this.checkWidget();
        if ((this.style & 0x32) == 0) {
            return;
        }
        int[] nArray = new int[]{OS.XmNset, bl ? 1 : 0};
        OS.XtSetValues(this.handle, nArray, nArray.length / 2);
        this.updateShadows();
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 4) != 0) {
            return;
        }
        if (this.text.equals(string)) {
            return;
        }
        this.text = string;
        this._setText(string);
    }

    int traversalCode(int n, XKeyEvent xKeyEvent) {
        return super.traversalCode(n, xKeyEvent) | 0x80;
    }

    void updateShadows() {
        if ((this.style & 0x800000) != 0 && (this.style & 2) != 0) {
            int[] nArray = new int[2];
            nArray[0] = OS.XmNset;
            int[] nArray2 = nArray;
            OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
            int n = nArray2[1] == 0 ? this.display.compositeBottomShadow : this.display.compositeTopShadow;
            int[] nArray3 = new int[]{OS.XmNtopShadowColor, n};
            OS.XtSetValues(this.handle, nArray3, nArray3.length / 2);
        }
    }

    int xFocusIn(XFocusChangeEvent xFocusChangeEvent) {
        super.xFocusIn(xFocusChangeEvent);
        if (this.handle == 0) {
            return 0;
        }
        if ((this.style & 8) != 0) {
            this.menuShell().setDefaultButton(this, false);
        }
        return 0;
    }

    int xFocusOut(XFocusChangeEvent xFocusChangeEvent) {
        super.xFocusOut(xFocusChangeEvent);
        if (this.handle == 0) {
            return 0;
        }
        if ((this.style & 8) != 0 && this.getDefault()) {
            this.menuShell().setDefaultButton(null, false);
        }
        return 0;
    }

    int XmNactivateCallback(int n, int n2, int n3) {
        this.postEvent(13);
        return 0;
    }

    int XmNvalueChangedCallback(int n, int n2, int n3) {
        if ((this.style & 0x10) != 0 && (this.parent.getStyle() & 0x400000) == 0) {
            this.selectRadio();
        }
        this.updateShadows();
        this.postEvent(13);
        return 0;
    }
}

