/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.internal.motif.XKeyEvent;
import org.eclipse.swt.internal.motif.XtWidgetGeometry;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;

public class Decorations
extends Canvas {
    String label;
    Image image;
    Image[] images = new Image[0];
    int dialogHandle;
    boolean minimized;
    boolean maximized;
    Menu menuBar;
    Menu[] menus;
    Control savedFocus;
    Button defaultButton;
    Button saveDefault;

    Decorations() {
    }

    public Decorations(Composite composite, int n) {
        super(composite, Decorations.checkStyle(n));
    }

    void _setImages(Image[] imageArray) {
        Object object;
        Image[] imageArray2;
        if (imageArray != null && imageArray.length > 1) {
            imageArray2 = new Image[imageArray.length];
            System.arraycopy(imageArray, 0, imageArray2, 0, imageArray.length);
            this.sort(imageArray2);
            imageArray = imageArray2;
        }
        if (imageArray != null && imageArray.length > 0) {
            imageArray2 = imageArray[0];
            object = imageArray2;
        } else {
            object = null;
        }
        imageArray2 = object;
        int n = 0;
        int n2 = 0;
        if (imageArray2 != null) {
            switch (imageArray2.type) {
                case 0: {
                    n = imageArray2.pixmap;
                    break;
                }
                case 1: {
                    n = imageArray2.pixmap;
                    n2 = imageArray2.mask;
                }
            }
        }
        int[] nArray = new int[]{OS.XmNiconPixmap, n, OS.XmNiconMask, n2};
        int n3 = this.topHandle();
        OS.XtSetValues(n3, nArray, nArray.length / 2);
    }

    void addMenu(Menu menu) {
        if (this.menus == null) {
            this.menus = new Menu[4];
        }
        int n = 0;
        while (n < this.menus.length) {
            if (this.menus[n] == null) {
                this.menus[n] = menu;
                return;
            }
            ++n;
        }
        Menu[] menuArray = new Menu[this.menus.length + 4];
        menuArray[this.menus.length] = menu;
        System.arraycopy(this.menus, 0, menuArray, 0, this.menus.length);
        this.menus = menuArray;
    }

    void bringToTop(boolean bl) {
        this.moveAbove(null);
    }

    static int checkStyle(int n) {
        if ((n & 8) != 0) {
            n &= 0xFFFFF30F;
        }
        if ((n & 0x4C0) != 0) {
            n |= 0x20;
        }
        return n;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    int compare(ImageData imageData, ImageData imageData2) {
        int n;
        int n2 = imageData.getTransparencyType();
        if (n2 != (n = imageData2.getTransparencyType())) {
            if (n2 == 1) {
                return 1;
            }
            if (n == 1) {
                return -1;
            }
        }
        if (imageData.width == imageData2.width && imageData.height == imageData2.height) {
            if (n2 == 2) {
                return -1;
            }
            if (n == 2) {
                return 1;
            }
            if (n2 == 4) {
                return -1;
            }
            if (n == 4) {
                return 1;
            }
            return 0;
        }
        return imageData.width > imageData2.width || imageData.height > imageData2.height ? -1 : 1;
    }

    Control computeTabGroup() {
        return this;
    }

    Control computeTabRoot() {
        return this;
    }

    public Rectangle computeTrim(int n, int n2, int n3, int n4) {
        this.checkWidget();
        Rectangle rectangle = super.computeTrim(n, n2, n3, n4);
        if (this.menuBar != null) {
            XtWidgetGeometry xtWidgetGeometry = new XtWidgetGeometry();
            XtWidgetGeometry xtWidgetGeometry2 = new XtWidgetGeometry();
            xtWidgetGeometry.request_mode = 4;
            xtWidgetGeometry.width = rectangle.width;
            OS.XtQueryGeometry(this.menuBar.handle, xtWidgetGeometry, xtWidgetGeometry2);
            rectangle.height += xtWidgetGeometry2.height;
        }
        return rectangle;
    }

    void createHandle(int n) {
        this.state |= 2;
        this.createHandle(n, this.parent.handle, true);
    }

    void createWidget(int n) {
        super.createWidget(n);
        this.label = "";
    }

    int dialogHandle() {
        if (this.dialogHandle != 0) {
            return this.dialogHandle;
        }
        this.dialogHandle = OS.XmCreateDialogShell(this.handle, null, null, 0);
        return this.dialogHandle;
    }

    public Button getDefaultButton() {
        this.checkWidget();
        return this.defaultButton;
    }

    public Image getImage() {
        this.checkWidget();
        return this.image;
    }

    public Image[] getImages() {
        this.checkWidget();
        if (this.images == null) {
            return new Image[0];
        }
        Image[] imageArray = new Image[this.images.length];
        System.arraycopy(this.images, 0, imageArray, 0, this.images.length);
        return imageArray;
    }

    public boolean getMaximized() {
        this.checkWidget();
        return this.maximized;
    }

    public Menu getMenuBar() {
        this.checkWidget();
        return this.menuBar;
    }

    public boolean getMinimized() {
        this.checkWidget();
        return this.minimized;
    }

    String getNameText() {
        return this.getText();
    }

    public String getText() {
        this.checkWidget();
        return this.label;
    }

    boolean isTabGroup() {
        return true;
    }

    boolean isTabItem() {
        return false;
    }

    Decorations menuShell() {
        return this;
    }

    void propagateWidget(boolean bl) {
        super.propagateWidget(bl);
        int[] nArray = new int[2];
        nArray[0] = OS.XmNmenuBar;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.scrolledHandle, nArray2, nArray2.length / 2);
        if (nArray2[1] != 0) {
            this.propagateHandle(bl, nArray2[1], 0);
        }
    }

    void releaseChildren(boolean bl) {
        if (this.menuBar != null) {
            this.menuBar.release(false);
            this.menuBar = null;
        }
        super.releaseChildren(bl);
        if (this.menus != null) {
            int n = 0;
            while (n < this.menus.length) {
                Menu menu = this.menus[n];
                if (menu != null && !menu.isDisposed()) {
                    menu.release(false);
                }
                ++n;
            }
            this.menus = null;
        }
    }

    void releaseHandle() {
        super.releaseHandle();
        this.dialogHandle = 0;
    }

    void releaseWidget() {
        super.releaseWidget();
        this.image = null;
        this.images = null;
        this.savedFocus = null;
        this.saveDefault = null;
        this.defaultButton = null;
        this.label = null;
    }

    boolean restoreFocus() {
        if (this.savedFocus != null && this.savedFocus.isDisposed()) {
            this.savedFocus = null;
        }
        boolean bl = this.savedFocus != null && this.savedFocus.setFocus();
        this.savedFocus = null;
        return bl;
    }

    void removeMenu(Menu menu) {
        if (this.menus == null) {
            return;
        }
        int n = 0;
        while (n < this.menus.length) {
            if (this.menus[n] == menu) {
                this.menus[n] = null;
                return;
            }
            ++n;
        }
    }

    public void setDefaultButton(Button button) {
        this.checkWidget();
        if (button != null) {
            if (button.isDisposed()) {
                this.error(5);
            }
            if (button.menuShell() != this) {
                this.error(32);
            }
        }
        this.setDefaultButton(button, true);
    }

    void setDefaultButton(Button button, boolean bl) {
        if (button == null) {
            if (this.defaultButton == this.saveDefault) {
                if (bl) {
                    this.saveDefault = null;
                }
                return;
            }
        } else {
            if ((button.style & 8) == 0) {
                return;
            }
            if (button == this.defaultButton) {
                return;
            }
        }
        if (this.defaultButton != null && !this.defaultButton.isDisposed()) {
            this.defaultButton.setDefault(false);
        }
        if ((this.defaultButton = button) == null) {
            this.defaultButton = this.saveDefault;
        }
        if (this.defaultButton != null && !this.defaultButton.isDisposed()) {
            this.defaultButton.setDefault(true);
        }
        if (bl) {
            this.saveDefault = this.defaultButton;
        }
        if (this.saveDefault != null && this.saveDefault.isDisposed()) {
            this.saveDefault = null;
        }
    }

    public void setImage(Image image) {
        Image[] imageArray;
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        this.image = image;
        if (image != null) {
            Image[] imageArray2 = new Image[1];
            imageArray = imageArray2;
            imageArray2[0] = image;
        } else {
            imageArray = null;
        }
        this._setImages(imageArray);
    }

    public void setImages(Image[] imageArray) {
        this.checkWidget();
        if (imageArray == null) {
            this.error(5);
        }
        int n = 0;
        while (n < imageArray.length) {
            if (imageArray[n] == null || imageArray[n].isDisposed()) {
                this.error(5);
            }
            ++n;
        }
        this.images = imageArray;
        this._setImages(imageArray);
    }

    public void setMaximized(boolean bl) {
        this.checkWidget();
        this.maximized = bl;
    }

    public void setMenuBar(Menu menu) {
        int[] nArray;
        int n;
        this.checkWidget();
        if (this.menuBar == menu) {
            return;
        }
        if (menu != null) {
            if (menu.isDisposed()) {
                this.error(5);
            }
            if ((menu.style & 2) == 0) {
                this.error(33);
            }
            if (menu.parent != this) {
                this.error(32);
            }
        }
        if (this.menuBar != null) {
            if (!this.isEnabled() && this.menuBar.getEnabled()) {
                this.propagateHandle(true, this.menuBar.handle, 0);
            }
            this.menuBar.removeAccelerators();
        }
        if (menu != null) {
            if (!this.isEnabled()) {
                this.propagateHandle(false, menu.handle, 0);
            }
            menu.addAccelerators();
        }
        int[] nArray2 = new int[4];
        nArray2[0] = OS.XmNwidth;
        nArray2[2] = OS.XmNheight;
        int[] nArray3 = nArray2;
        OS.XtGetValues(this.handle, nArray3, nArray3.length / 2);
        int n2 = menu != null ? menu.handle : 0;
        int n3 = this.menuBar != null ? this.menuBar.handle : 0;
        this.menuBar = menu;
        int n4 = this.horizontalBar != null ? this.horizontalBar.handle : 0;
        int n5 = n = this.verticalBar != null ? this.verticalBar.handle : 0;
        if (n2 != 0) {
            OS.XtSetMappedWhenManaged(n2, false);
            OS.XtManageChild(n2);
        }
        int n6 = this.formHandle != 0 ? this.formHandle : this.handle;
        OS.XmMainWindowSetAreas(this.scrolledHandle, n2, 0, n4, n, n6);
        if (n3 != 0) {
            OS.XtUnmanageChild(n3);
        }
        if (n2 != 0) {
            OS.XtSetMappedWhenManaged(n2, true);
        }
        if (n2 == 0 && OS.XtIsRealized(this.scrolledHandle)) {
            int[] nArray4 = new int[6];
            nArray4[0] = OS.XmNwidth;
            nArray4[2] = OS.XmNheight;
            nArray4[4] = OS.XmNborderWidth;
            nArray = nArray4;
            OS.XtGetValues(this.scrolledHandle, nArray, nArray.length / 2);
            OS.XtResizeWidget(this.scrolledHandle, nArray[1] + 1, nArray[3], nArray[5]);
            OS.XtResizeWidget(this.scrolledHandle, nArray[1], nArray[3], nArray[5]);
        }
        int[] nArray5 = new int[4];
        nArray5[0] = OS.XmNwidth;
        nArray5[2] = OS.XmNheight;
        nArray = nArray5;
        OS.XtGetValues(this.handle, nArray, nArray.length / 2);
        if (nArray3[1] != nArray[1] || nArray3[3] != nArray[3]) {
            this.sendEvent(11);
            if (this.layout != null) {
                this.markLayout(false, false);
                this.updateLayout(false);
            }
        }
    }

    public void setMinimized(boolean bl) {
        this.checkWidget();
        this.minimized = bl;
    }

    void setSavedFocus(Control control) {
        if (this == control) {
            return;
        }
        this.savedFocus = control;
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        this.label = string;
    }

    void sort(Image[] imageArray) {
        int n = imageArray.length;
        if (n <= 1) {
            return;
        }
        ImageData[] imageDataArray = new ImageData[n];
        int n2 = 0;
        while (n2 < n) {
            imageDataArray[n2] = imageArray[n2].getImageData();
            ++n2;
        }
        n2 = n / 2;
        while (n2 > 0) {
            int n3 = n2;
            while (n3 < n) {
                int n4 = n3 - n2;
                while (n4 >= 0) {
                    if (this.compare(imageDataArray[n4], imageDataArray[n4 + n2]) >= 0) {
                        Image image = imageArray[n4];
                        imageArray[n4] = imageArray[n4 + n2];
                        imageArray[n4 + n2] = image;
                        ImageData imageData = imageDataArray[n4];
                        imageDataArray[n4] = imageDataArray[n4 + n2];
                        imageDataArray[n4 + n2] = imageData;
                    }
                    n4 -= n2;
                }
                ++n3;
            }
            n2 /= 2;
        }
    }

    boolean translateAccelerator(char c, int n, XKeyEvent xKeyEvent, boolean bl) {
        if (this.menuBar == null || !this.menuBar.getEnabled()) {
            return false;
        }
        int n2 = Display.translateKey(n);
        if (n2 == 0) {
            n2 = c;
        }
        if (n2 == 0) {
            return false;
        }
        if ((xKeyEvent.state & 8) != 0) {
            n2 |= 0x10000;
        }
        if ((xKeyEvent.state & 1) != 0) {
            n2 |= 0x20000;
        }
        if ((xKeyEvent.state & 4) != 0) {
            n2 |= 0x40000;
        }
        return this.menuBar.translateAccelerator(n2, bl);
    }

    boolean traverseItem(boolean bl) {
        return false;
    }

    boolean traverseReturn() {
        if (this.defaultButton == null || this.defaultButton.isDisposed()) {
            return false;
        }
        if (!this.defaultButton.isVisible() || !this.defaultButton.isEnabled()) {
            return false;
        }
        this.defaultButton.click();
        return true;
    }
}

