/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;

public class FileDialog
extends Dialog {
    int dialog;
    String[] filterNames = new String[0];
    String[] filterExtensions = new String[0];
    String[] fileNames = new String[0];
    String fileName = "";
    String filterPath = "";
    String fullPath;
    int filterIndex = -1;
    boolean overwrite = false;
    static final String FILTER = "*";
    static final char SEPARATOR = System.getProperty("file.separator").charAt(0);

    public FileDialog(Shell shell) {
        this(shell, 65536);
    }

    public FileDialog(Shell shell, int n) {
        super(shell, FileDialog.checkStyle(shell, n));
        this.checkSubclass();
    }

    int cancelPressed(int n, int n2, int n3) {
        OS.XtUnmanageChild(n);
        return 0;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String[] getFileNames() {
        return this.fileNames;
    }

    public String[] getFilterExtensions() {
        return this.filterExtensions;
    }

    public int getFilterIndex() {
        return this.filterIndex;
    }

    public String[] getFilterNames() {
        return this.filterNames;
    }

    public String getFilterPath() {
        return this.filterPath;
    }

    public boolean getOverwrite() {
        return this.overwrite;
    }

    int itemSelected(int n, int n2, int n3) {
        Object object;
        int n4 = OS.XmFileSelectionBoxGetChild(this.dialog, 8);
        if (n4 == 0) {
            return 0;
        }
        int n5 = OS.XmFileSelectionBoxGetChild(this.dialog, 13);
        if (n5 == 0) {
            return 0;
        }
        int[] nArray = new int[4];
        nArray[0] = OS.XmNselectedItems;
        nArray[2] = OS.XmNselectedItemCount;
        int[] nArray2 = nArray;
        OS.XtGetValues(n4, nArray2, nArray2.length / 2);
        int n6 = nArray2[1];
        int n7 = nArray2[3];
        int n8 = 0;
        if (n7 == 0) {
            int[] nArray3 = new int[2];
            nArray3[0] = OS.XmNdirectory;
            object = nArray3;
            OS.XtGetValues(this.dialog, object, ((int[])object).length / 2);
            n8 = object[1];
        } else {
            object = new int[1];
            OS.memmove(object, n6, 4);
            n8 = object[0];
        }
        if (n8 == 0) {
            return 0;
        }
        object = this.parent.getDisplay();
        int[] nArray4 = new int[]{object.tabMapping, object.crMapping};
        int n9 = OS.XmStringUnparse(n8, null, 0, 0, nArray4, nArray4.length, 0);
        if (n7 == 0) {
            OS.XmStringFree(n8);
        }
        if (n9 == 0) {
            return 0;
        }
        int n10 = OS.strlen(n9);
        byte[] byArray = new byte[n10 + 1];
        OS.memmove(byArray, n9, n10);
        OS.XtFree(n9);
        OS.XmTextSetString(n5, byArray);
        OS.XmTextSetInsertionPosition(n5, OS.XmTextGetLastPosition(n5));
        return 0;
    }

    int okPressed(int n, int n2, int n3) {
        Object[] objectArray;
        int n4;
        String string = null;
        String string2 = null;
        String[] stringArray = null;
        int[] nArray = new int[4];
        nArray[0] = OS.XmNdirSpec;
        nArray[2] = OS.XmNdirectory;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.dialog, nArray2, nArray2.length / 2);
        int n5 = nArray2[1];
        Display display = this.parent.getDisplay();
        int[] nArray3 = new int[]{display.tabMapping, display.crMapping};
        int n6 = OS.XmStringUnparse(n5, null, 0, 0, nArray3, nArray3.length, 0);
        if (n6 != 0) {
            n4 = OS.strlen(n6);
            objectArray = new byte[n4];
            OS.memmove(objectArray, n6, n4);
            OS.XtFree(n6);
            string = new String(Converter.mbcsToWcs(null, objectArray)).trim();
        }
        OS.XmStringFree(n5);
        int n7 = this.filterIndex = this.filterExtensions == null || this.filterExtensions.length == 0 ? -1 : 0;
        if ((this.style & 2) != 0) {
            n4 = OS.XmFileSelectionBoxGetChild(this.dialog, 8);
            if (n4 == 0) {
                return 0;
            }
            int[] nArray4 = new int[4];
            nArray4[0] = OS.XmNselectedItems;
            nArray4[2] = OS.XmNselectedItemCount;
            objectArray = nArray4;
            OS.XtGetValues(n4, objectArray, objectArray.length / 2);
            int n8 = objectArray[1];
            int n9 = objectArray[3];
            int[] nArray5 = new int[1];
            stringArray = new String[n9];
            boolean bl = false;
            int n10 = 0;
            while (n10 < n9) {
                OS.memmove(nArray5, n8, 4);
                n6 = nArray5[0];
                int n11 = OS.XmStringUnparse(n6, null, 0, 0, nArray3, nArray3.length, 0);
                if (n11 != 0) {
                    int n12 = OS.strlen(n11);
                    byte[] byArray = new byte[n12];
                    OS.memmove(byArray, n11, n12);
                    OS.XtFree(n11);
                    String string3 = new String(Converter.mbcsToWcs(null, byArray));
                    int n13 = string3.lastIndexOf(SEPARATOR);
                    stringArray[n10] = string3.substring(n13 + 1, string3.length());
                    if (string3.equals(string)) {
                        bl = true;
                    }
                }
                n8 += 4;
                ++n10;
            }
            if (bl) {
                string2 = stringArray[0];
            } else {
                n10 = string.lastIndexOf(SEPARATOR);
                string2 = string.substring(n10 + 1, string.length());
                stringArray = new String[]{string2};
            }
        } else {
            n4 = string.lastIndexOf(SEPARATOR);
            string2 = string.substring(n4 + 1, string.length());
            stringArray = new String[]{string2};
        }
        if (string2.equals("")) {
            int[] nArray6 = new int[2];
            nArray6[0] = OS.XmNdirMask;
            int[] nArray7 = nArray6;
            OS.XtGetValues(this.dialog, nArray7, nArray7.length / 2);
            int n14 = nArray7[1];
            int[] nArray8 = new int[]{OS.XmNpattern, n14};
            OS.XtSetValues(this.dialog, nArray8, nArray8.length / 2);
            OS.XmStringFree(n14);
            return 0;
        }
        n4 = nArray2[3];
        n6 = OS.XmStringUnparse(n4, null, 0, 0, nArray3, nArray3.length, 0);
        if (n6 != 0) {
            int n15 = OS.strlen(n6);
            byte[] byArray = new byte[n15];
            OS.memmove(byArray, n6, n15);
            OS.XtFree(n6);
            this.filterPath = new String(Converter.mbcsToWcs(null, byArray));
        }
        OS.XmStringFree(n4);
        int n16 = this.filterPath.length();
        if (n16 > 0 && this.filterPath.charAt(n16 - 1) == SEPARATOR) {
            this.filterPath = this.filterPath.substring(0, n16 - 1);
        }
        this.fullPath = string;
        this.fileName = string2;
        this.fileNames = stringArray;
        OS.XtUnmanageChild(n);
        return 0;
    }

    public String open() {
        int[] nArray;
        Object object;
        Object object2;
        int n;
        Object object3;
        int n2;
        Object object4;
        String string = this.title;
        if (string.length() == 0) {
            string = " ";
        }
        byte[] byArray = Converter.wcsToMbcs(null, string, true);
        int n3 = OS.XmStringParseText(byArray, 0, OS.XmFONTLIST_DEFAULT_TAG, 0, null, 0, 0);
        this.fullPath = null;
        this.fileNames = new String[0];
        Object object5 = FILTER;
        if (this.filterExtensions == null) {
            this.filterExtensions = new String[0];
        }
        if (this.filterNames == null) {
            this.filterNames = new String[0];
        }
        if (this.filterExtensions.length != 0 && this.filterExtensions.length == 1 && ((String)(object4 = (Object)this.filterExtensions[0])).indexOf(59, 0) == -1) {
            object5 = object4;
        }
        object4 = Converter.wcsToMbcs(null, (String)object5, true);
        int n4 = OS.XmStringParseText((byte[])object4, 0, OS.XmFONTLIST_DEFAULT_TAG, 0, null, 0, 0);
        if (this.filterPath == null) {
            this.filterPath = "";
        }
        if ((n2 = this.filterPath.length()) == 0 || this.filterPath.charAt(n2 - 1) != SEPARATOR) {
            this.filterPath = String.valueOf(this.filterPath) + SEPARATOR;
        }
        byte[] byArray2 = Converter.wcsToMbcs(null, this.filterPath, true);
        int n5 = OS.XmStringParseText(byArray2, 0, OS.XmFONTLIST_DEFAULT_TAG, 0, null, 0, 0);
        boolean bl = this.parent.isVisible();
        Display display = this.parent.display;
        int[] nArray2 = new int[16];
        nArray2[0] = OS.XmNresizePolicy;
        nArray2[2] = OS.XmNdialogStyle;
        nArray2[3] = 1;
        nArray2[4] = OS.XmNwidth;
        nArray2[5] = OS.XDisplayWidth(display.xDisplay, OS.XDefaultScreen(display.xDisplay)) * 4 / 9;
        nArray2[6] = OS.XmNpathMode;
        nArray2[8] = OS.XmNdialogTitle;
        nArray2[9] = n3;
        nArray2[10] = OS.XmNpattern;
        nArray2[11] = n4;
        nArray2[12] = OS.XmNdirMask;
        nArray2[13] = n5;
        nArray2[14] = OS.XmNdefaultPosition;
        nArray2[15] = bl ? 1 : 0;
        int[] nArray3 = nArray2;
        if (OS.IsAIX) {
            this.parent.realizeWidget();
        }
        int n6 = this.parent.shellHandle;
        byte[] byArray3 = new byte[1];
        this.dialog = OS.XmCreateFileSelectionDialog(n6, byArray3, nArray3, nArray3.length / 2);
        int n7 = OS.XmFileSelectionBoxGetChild(this.dialog, 7);
        if (n7 != 0) {
            OS.XtUnmanageChild(n7);
        }
        OS.XmStringFree(n3);
        OS.XmStringFree(n4);
        OS.XmStringFree(n5);
        if (this.fileName != null && this.fileName.length() > 0) {
            object3 = Converter.wcsToMbcs(null, this.fileName, true);
            n = OS.XmStringParseText((byte[])object3, 0, OS.XmFONTLIST_DEFAULT_TAG, 0, null, 0, 0);
            int[] nArray4 = new int[2];
            nArray4[0] = OS.XmNdirSpec;
            object2 = nArray4;
            OS.XtGetValues(this.dialog, (int[])object2, ((Object)object2).length / 2);
            object = object2[1];
            int n8 = OS.XmStringConcat(object, n);
            object2[1] = n8;
            OS.XtSetValues(this.dialog, (int[])object2, ((Object)object2).length / 2);
            OS.XmStringFree(n);
            OS.XmStringFree(object);
            OS.XmStringFree(n8);
        }
        if ((n = ((Callback)(object3 = new Callback(this, "cancelPressed", 3))).getAddress()) == 0) {
            SWT.error(3);
        }
        OS.XtAddCallback(this.dialog, OS.XmNcancelCallback, n, 0);
        object2 = new Callback(this, "okPressed", 3);
        object = ((Callback)object2).getAddress();
        if (object == 0) {
            SWT.error(3);
        }
        OS.XtAddCallback(this.dialog, OS.XmNokCallback, object, 0);
        Callback callback = null;
        if ((this.style & 2) != 0 && (n7 = OS.XmFileSelectionBoxGetChild(this.dialog, 8)) != 0) {
            nArray = new int[]{OS.XmNselectionPolicy, 2};
            OS.XtSetValues(n7, nArray, nArray.length / 2);
            callback = new Callback(this, "itemSelected", 3);
            int n9 = callback.getAddress();
            if (n9 == 0) {
                this.error(3);
            }
            OS.XtAddCallback(n7, OS.XmNextendedSelectionCallback, n9, 0);
        }
        if (!bl) {
            OS.XtRealizeWidget(this.dialog);
            int[] nArray5 = new int[4];
            nArray5[0] = OS.XmNwidth;
            nArray5[2] = OS.XmNheight;
            nArray = nArray5;
            OS.XtGetValues(this.dialog, nArray, nArray.length / 2);
            Monitor monitor = this.parent.getMonitor();
            Rectangle rectangle = monitor.getBounds();
            int n10 = rectangle.x + (rectangle.width - nArray[1]) / 2;
            int n11 = rectangle.y + (rectangle.height - nArray[3]) / 2;
            int[] nArray6 = new int[]{OS.XmNx, n10, OS.XmNy, n11};
            OS.XtSetValues(this.dialog, nArray6, nArray6.length / 2);
        }
        OS.XtManageChild(this.dialog);
        while (OS.XtIsRealized(this.dialog) && OS.XtIsManaged(this.dialog)) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        if (OS.XtIsRealized(this.dialog)) {
            OS.XtDestroyWidget(this.dialog);
        }
        ((Callback)object2).dispose();
        ((Callback)object3).dispose();
        if (callback != null) {
            callback.dispose();
        }
        return this.fullPath;
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public void setFilterExtensions(String[] stringArray) {
        this.filterExtensions = stringArray;
    }

    public void setFilterIndex(int n) {
        this.filterIndex = n;
    }

    public void setFilterNames(String[] stringArray) {
        this.filterNames = stringArray;
    }

    public void setFilterPath(String string) {
        this.filterPath = string;
    }

    public void setOverwrite(boolean bl) {
    }
}

