/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.internal.motif.XtWidgetGeometry;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.TypedListener;

public class List
extends Scrollable {
    public List(Composite composite, int n) {
        super(composite, List.checkStyle(n | 0x200));
    }

    public void add(String string) {
        byte[] byArray;
        int n;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((n = OS.XmStringCreateLocalized(byArray = Converter.wcsToMbcs(this.getCodePage(), string, true))) == 0) {
            this.error(14);
        }
        OS.XmListAddItemUnselected(this.handle, n, 0);
        OS.XmStringFree(n);
    }

    public void add(String string, int n) {
        byte[] byArray;
        int n2;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (n == -1) {
            this.error(6);
        }
        int[] nArray = new int[2];
        nArray[0] = OS.XmNitemCount;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        if (n < 0 || n > nArray2[1]) {
            this.error(6);
        }
        if ((n2 = OS.XmStringCreateLocalized(byArray = Converter.wcsToMbcs(this.getCodePage(), string, true))) == 0) {
            this.error(14);
        }
        OS.XmListAddItemUnselected(this.handle, n2, n + 1);
        OS.XmStringFree(n2);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int n) {
        return List.checkBits(n, 4, 2, 0, 0, 0, 0);
    }

    public Point computeSize(int n, int n2, boolean bl) {
        Object object;
        this.checkWidget();
        XtWidgetGeometry xtWidgetGeometry = new XtWidgetGeometry();
        xtWidgetGeometry.request_mode = 4;
        OS.XtQueryGeometry(this.handle, null, xtWidgetGeometry);
        int n3 = xtWidgetGeometry.width;
        int n4 = 0;
        if (n != -1) {
            n3 = n;
        }
        if (n2 != -1) {
            n4 = n2;
        }
        if (n2 == -1 || n == -1) {
            int[] nArray = new int[2];
            nArray[0] = OS.XmNitemCount;
            object = nArray;
            OS.XtGetValues(this.handle, object, ((int[])object).length / 2);
            int n5 = object[1];
            if (n2 == -1) {
                n4 = n5 == 0 ? 64 : this.getItemHeight() * n5;
            }
            if (n == -1 && n5 == 0) {
                n3 = 64;
            }
        }
        object = this.computeTrim(0, 0, n3, n4);
        return new Point(object.width, object.height);
    }

    public Rectangle computeTrim(int n, int n2, int n3, int n4) {
        int[] nArray;
        this.checkWidget();
        int n5 = this.getBorderWidth();
        int n6 = n - n5;
        int n7 = n2 - n5;
        int n8 = n3 + n5 * 2;
        int n9 = n4 + n5 * 2;
        if (this.horizontalBar != null) {
            int[] nArray2 = new int[2];
            nArray2[0] = OS.XmNheight;
            nArray = nArray2;
            OS.XtGetValues(this.horizontalBar.handle, nArray, nArray.length / 2);
            n9 += nArray[1] + 4;
            n7 -= this.display.scrolledInsetY;
            if (this.verticalBar != null) {
                n6 -= this.display.scrolledInsetX;
            }
        }
        if (this.verticalBar != null) {
            int[] nArray3 = new int[2];
            nArray3[0] = OS.XmNwidth;
            nArray = nArray3;
            OS.XtGetValues(this.verticalBar.handle, nArray, nArray.length / 2);
            n8 += nArray[1];
            n6 -= this.display.scrolledInsetX;
            if (this.horizontalBar != null) {
                n7 -= this.display.scrolledInsetY;
            }
        }
        int[] nArray4 = new int[8];
        nArray4[0] = OS.XmNhighlightThickness;
        nArray4[2] = OS.XmNshadowThickness;
        nArray4[4] = OS.XmNlistMarginWidth;
        nArray4[6] = OS.XmNlistMarginHeight;
        nArray = nArray4;
        OS.XtGetValues(this.handle, nArray, nArray.length / 2);
        int n10 = nArray[1] + nArray[3] * 2;
        return new Rectangle(n6 -= nArray[1] + nArray[3] + nArray[5], n7 -= nArray[1] + nArray[3] + nArray[7], n8 += n10 + nArray[5] + 1, n9 += n10 + nArray[7] + 1);
    }

    void createHandle(int n) {
        int n2 = this.parent.handle;
        int[] nArray = new int[]{OS.XmNancestorSensitive, 1};
        this.formHandle = OS.XmCreateForm(n2, null, nArray, nArray.length / 2);
        if (this.formHandle == 0) {
            this.error(2);
        }
        int n3 = 3;
        int n4 = 1;
        if ((this.style & 2) != 0) {
            n3 = 2;
            if ((this.style & 0x40) != 0) {
                n3 = 1;
            }
        }
        if ((this.style & 0x100) == 0) {
            n4 = 0;
        }
        int[] nArray2 = new int[14];
        nArray2[0] = OS.XmNlistSizePolicy;
        nArray2[1] = n4;
        nArray2[2] = OS.XmNselectionPolicy;
        nArray2[3] = n3;
        nArray2[4] = OS.XmNtopAttachment;
        nArray2[5] = 1;
        nArray2[6] = OS.XmNbottomAttachment;
        nArray2[7] = 1;
        nArray2[8] = OS.XmNleftAttachment;
        nArray2[9] = 1;
        nArray2[10] = OS.XmNrightAttachment;
        nArray2[11] = 1;
        nArray2[12] = OS.XmNresizable;
        int[] nArray3 = nArray2;
        if ((this.style & 0x300) == 0) {
            this.handle = OS.XmCreateList(this.formHandle, null, nArray3, nArray3.length / 2);
            if (this.handle == 0) {
                this.error(2);
            }
        } else {
            this.handle = OS.XmCreateScrolledList(this.formHandle, new byte[1], nArray3, nArray3.length / 2);
            if (this.handle == 0) {
                this.error(2);
            }
            this.scrolledHandle = OS.XtParent(this.handle);
        }
        if ((this.style & 0x800) == 0) {
            int[] nArray4 = new int[2];
            nArray4[0] = OS.XmNshadowThickness;
            int[] nArray5 = nArray4;
            OS.XtSetValues(this.handle, nArray5, nArray5.length / 2);
        }
    }

    ScrollBar createScrollBar(int n) {
        return this.createStandardBar(n);
    }

    int defaultBackground() {
        return this.display.listBackground;
    }

    Font defaultFont() {
        return this.display.listFont;
    }

    int defaultForeground() {
        return this.display.listForeground;
    }

    public void deselect(int n) {
        this.checkWidget();
        if (n != -1) {
            OS.XmListDeselectPos(this.handle, n + 1);
        }
    }

    public void deselect(int n, int n2) {
        this.checkWidget();
        if (n > n2) {
            return;
        }
        int n3 = n;
        while (n3 <= n2) {
            int n4 = n3 + 1;
            if (n4 != 0) {
                OS.XmListDeselectPos(this.handle, n4);
            }
            ++n3;
        }
    }

    public void deselect(int[] nArray) {
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        int n = 0;
        while (n < nArray.length) {
            int n2 = nArray[n] + 1;
            if (n2 != 0) {
                OS.XmListDeselectPos(this.handle, n2);
            }
            ++n;
        }
    }

    public void deselectAll() {
        this.checkWidget();
        OS.XmListDeselectAllItems(this.handle);
    }

    public int getFocusIndex() {
        this.checkWidget();
        return OS.XmListGetKbdItemPos(this.handle) - 1;
    }

    public String getItem(int n) {
        this.checkWidget();
        int[] nArray = new int[4];
        nArray[0] = OS.XmNitemCount;
        nArray[2] = OS.XmNitems;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        if (n < 0 || n >= nArray2[1]) {
            this.error(6);
        }
        if (nArray2[3] == 0) {
            this.error(8);
        }
        int n2 = nArray2[3] + n * 4;
        int[] nArray3 = new int[1];
        OS.memmove(nArray3, n2, 4);
        n2 = nArray3[0];
        int[] nArray4 = new int[]{this.display.tabMapping, this.display.crMapping};
        int n3 = OS.XmStringUnparse(n2, null, 0, 0, nArray4, nArray4.length, 0);
        if (n3 == 0) {
            this.error(8);
        }
        int n4 = OS.strlen(n3);
        byte[] byArray = new byte[n4];
        OS.memmove(byArray, n3, n4);
        OS.XtFree(n3);
        return new String(Converter.mbcsToWcs(this.getCodePage(), byArray));
    }

    public int getItemCount() {
        this.checkWidget();
        int[] nArray = new int[2];
        nArray[0] = OS.XmNitemCount;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        return nArray2[1];
    }

    public int getItemHeight() {
        this.checkWidget();
        int[] nArray = new int[4];
        nArray[0] = OS.XmNlistSpacing;
        nArray[2] = OS.XmNhighlightThickness;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        int n = nArray2[1];
        int n2 = nArray2[3];
        return this.getFontHeight(this.font.handle) + n + n2 + 1;
    }

    public String[] getItems() {
        this.checkWidget();
        int[] nArray = new int[4];
        nArray[0] = OS.XmNitems;
        nArray[2] = OS.XmNitemCount;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        int n = nArray2[1];
        int n2 = nArray2[3];
        int[] nArray3 = new int[1];
        String[] stringArray = new String[n2];
        String string = this.getCodePage();
        int n3 = 0;
        while (n3 < n2) {
            OS.memmove(nArray3, n, 4);
            int n4 = nArray3[0];
            int[] nArray4 = new int[]{this.display.tabMapping, this.display.crMapping};
            int n5 = OS.XmStringUnparse(n4, null, 0, 0, nArray4, nArray4.length, 0);
            if (n5 == 0) {
                this.error(8);
            }
            int n6 = OS.strlen(n5);
            byte[] byArray = new byte[n6];
            OS.memmove(byArray, n5, n6);
            OS.XtFree(n5);
            stringArray[n3] = new String(Converter.mbcsToWcs(string, byArray));
            n += 4;
            ++n3;
        }
        return stringArray;
    }

    public String[] getSelection() {
        this.checkWidget();
        int[] nArray = new int[4];
        nArray[0] = OS.XmNselectedItems;
        nArray[2] = OS.XmNselectedItemCount;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        int n = nArray2[1];
        int n2 = nArray2[3];
        int[] nArray3 = new int[1];
        String[] stringArray = new String[n2];
        String string = this.getCodePage();
        int n3 = 0;
        while (n3 < n2) {
            OS.memmove(nArray3, n, 4);
            int n4 = nArray3[0];
            int[] nArray4 = new int[]{this.display.tabMapping, this.display.crMapping};
            int n5 = OS.XmStringUnparse(n4, null, 0, 0, nArray4, nArray4.length, 0);
            if (n5 == 0) {
                this.error(8);
            }
            int n6 = OS.strlen(n5);
            byte[] byArray = new byte[n6];
            OS.memmove(byArray, n5, n6);
            OS.XtFree(n5);
            stringArray[n3] = new String(Converter.mbcsToWcs(string, byArray));
            n += 4;
            ++n3;
        }
        return stringArray;
    }

    public int getSelectionCount() {
        this.checkWidget();
        int[] nArray = new int[2];
        nArray[0] = OS.XmNselectedItemCount;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        return nArray2[1];
    }

    public int getSelectionIndex() {
        this.checkWidget();
        int n = OS.XmListGetKbdItemPos(this.handle);
        if (OS.XmListPosSelected(this.handle, n)) {
            return n - 1;
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        if (!OS.XmListGetSelectedPos(this.handle, nArray, nArray2)) {
            return -1;
        }
        if (nArray2[0] == 0) {
            return -1;
        }
        int n2 = nArray[0];
        int[] nArray3 = new int[1];
        OS.memmove(nArray3, n2, 4);
        OS.XtFree(n2);
        return nArray3[0] - 1;
    }

    public int[] getSelectionIndices() {
        this.checkWidget();
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.XmListGetSelectedPos(this.handle, nArray2, nArray);
        int[] nArray3 = new int[nArray[0]];
        OS.memmove(nArray3, nArray2[0], nArray[0] * 4);
        if (nArray2[0] != 0) {
            OS.XtFree(nArray2[0]);
        }
        int n = 0;
        while (n < nArray3.length) {
            int n2 = n++;
            nArray3[n2] = nArray3[n2] - 1;
        }
        return nArray3;
    }

    public int getTopIndex() {
        this.checkWidget();
        int[] nArray = new int[2];
        nArray[0] = OS.XmNtopItemPosition;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        return nArray2[1] - 1;
    }

    void hookEvents() {
        super.hookEvents();
        int n = this.display.windowProc;
        OS.XtAddCallback(this.handle, OS.XmNbrowseSelectionCallback, n, 11);
        OS.XtAddCallback(this.handle, OS.XmNextendedSelectionCallback, n, 16);
        OS.XtAddCallback(this.handle, OS.XmNmultipleSelectionCallback, n, 32);
        OS.XtAddCallback(this.handle, OS.XmNdefaultActionCallback, n, 14);
    }

    public int indexOf(String string) {
        byte[] byArray;
        int n;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((n = OS.XmStringCreateLocalized(byArray = Converter.wcsToMbcs(this.getCodePage(), string, true))) == 0) {
            return -1;
        }
        int n2 = OS.XmListItemPos(this.handle, n);
        OS.XmStringFree(n);
        return n2 - 1;
    }

    public int indexOf(String string, int n) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        int[] nArray = new int[4];
        nArray[0] = OS.XmNitems;
        nArray[2] = OS.XmNitemCount;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        int n2 = nArray2[1];
        int n3 = nArray2[3];
        if (n < 0 || n >= n3) {
            return -1;
        }
        byte[] byArray = Converter.wcsToMbcs(this.getCodePage(), string, true);
        int n4 = OS.XmStringCreateLocalized(byArray);
        if (n4 == 0) {
            return -1;
        }
        int n5 = n;
        n2 += n * 4;
        int[] nArray3 = new int[1];
        while (n5 < n3) {
            OS.memmove(nArray3, n2, 4);
            if (OS.XmStringCompare(nArray3[0], n4)) break;
            n2 += 4;
            ++n5;
        }
        OS.XmStringFree(n4);
        if (n5 == n3) {
            return -1;
        }
        return n5;
    }

    public boolean isSelected(int n) {
        this.checkWidget();
        if (n == -1) {
            return false;
        }
        return OS.XmListPosSelected(this.handle, n + 1);
    }

    void overrideTranslations() {
        OS.XtOverrideTranslations(this.handle, this.display.tabTranslations);
    }

    public void remove(int n) {
        this.checkWidget();
        if (n == -1) {
            this.error(6);
        }
        int[] nArray = new int[2];
        nArray[0] = OS.XmNitemCount;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        if (n < 0 || n >= nArray2[1]) {
            this.error(6);
        }
        OS.XmListDeletePos(this.handle, n + 1);
    }

    public void remove(int n, int n2) {
        this.checkWidget();
        if (n > n2) {
            return;
        }
        int[] nArray = new int[2];
        nArray[0] = OS.XmNitemCount;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        if (n < 0 || n > n2 || n2 >= nArray2[1]) {
            this.error(6);
        }
        int n3 = n2 - n + 1;
        OS.XmListDeleteItemsPos(this.handle, n3, n + 1);
    }

    public void remove(String string) {
        byte[] byArray;
        int n;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((n = OS.XmStringCreateLocalized(byArray = Converter.wcsToMbcs(this.getCodePage(), string, true))) == 0) {
            this.error(15);
        }
        int n2 = OS.XmListItemPos(this.handle, n);
        OS.XmStringFree(n);
        if (n2 == 0) {
            this.error(5);
        }
        OS.XmListDeletePos(this.handle, n2);
    }

    public void remove(int[] nArray) {
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        if (nArray.length == 0) {
            return;
        }
        int[] nArray2 = new int[2];
        nArray2[0] = OS.XmNitemCount;
        int[] nArray3 = nArray2;
        OS.XtGetValues(this.handle, nArray3, nArray3.length / 2);
        int[] nArray4 = new int[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            if (nArray[n] < 0 || nArray[n] >= nArray3[1]) {
                this.error(6);
            }
            nArray4[n] = nArray[n] + 1;
            ++n;
        }
        OS.XmListDeletePositions(this.handle, nArray4, nArray4.length);
    }

    public void removeAll() {
        this.checkWidget();
        OS.XmListDeselectAllItems(this.handle);
        OS.XmListDeleteAllItems(this.handle);
        if ((this.style & 0x100) != 0) {
            OS.XtResizeWindow(this.handle);
        }
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void select(int n) {
        this.checkWidget();
        if (n == -1) {
            return;
        }
        if (OS.XmListPosSelected(this.handle, n + 1)) {
            return;
        }
        int[] nArray = new int[2];
        nArray[0] = OS.XmNselectionPolicy;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        int n2 = nArray2[1];
        if (n2 == 2) {
            nArray2[1] = 1;
            OS.XtSetValues(this.handle, nArray2, nArray2.length / 2);
        }
        OS.XmListSelectPos(this.handle, n + 1, false);
        if (n2 == 2) {
            nArray2[1] = 2;
            OS.XtSetValues(this.handle, nArray2, nArray2.length / 2);
        }
    }

    public void select(int n, int n2) {
        this.checkWidget();
        if (n2 < 0 || n > n2 || (this.style & 4) != 0 && n != n2) {
            return;
        }
        int[] nArray = new int[2];
        nArray[0] = OS.XmNitemCount;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        int n3 = nArray2[1];
        if (n3 == 0 || n >= n3) {
            return;
        }
        n = Math.max(0, n);
        n2 = Math.min(n2, n3 - 1);
        if ((this.style & 4) != 0) {
            OS.XmListSelectPos(this.handle, n + 1, false);
            return;
        }
        int[] nArray3 = new int[2];
        nArray3[0] = OS.XmNselectionPolicy;
        nArray2 = nArray3;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        int n4 = nArray2[1];
        if (n4 == 2) {
            nArray2[1] = 1;
            OS.XtSetValues(this.handle, nArray2, nArray2.length / 2);
        }
        int n5 = n;
        while (n5 <= n2) {
            int n6 = n5 + 1;
            if (!OS.XmListPosSelected(this.handle, n6)) {
                OS.XmListSelectPos(this.handle, n6, false);
            }
            ++n5;
        }
        if (n4 == 2) {
            nArray2[1] = 2;
            OS.XtSetValues(this.handle, nArray2, nArray2.length / 2);
        }
    }

    public void select(int[] nArray) {
        int n;
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        if ((n = nArray.length) == 0 || (this.style & 4) != 0 && n > 1) {
            return;
        }
        if ((this.style & 4) != 0) {
            int[] nArray2 = new int[2];
            nArray2[0] = OS.XmNitemCount;
            int[] nArray3 = nArray2;
            OS.XtGetValues(this.handle, nArray3, nArray3.length / 2);
            int n2 = nArray3[1];
            int n3 = nArray[0];
            if (n3 >= 0 && n3 < n2) {
                this.select(n3);
            }
            return;
        }
        int[] nArray4 = new int[2];
        nArray4[0] = OS.XmNselectionPolicy;
        int[] nArray5 = nArray4;
        OS.XtGetValues(this.handle, nArray5, nArray5.length / 2);
        int n4 = nArray5[1];
        if (n4 == 2) {
            nArray5[1] = 1;
            OS.XtSetValues(this.handle, nArray5, nArray5.length / 2);
        }
        int n5 = 0;
        while (n5 < n) {
            int n6 = nArray[n5] + 1;
            if (n6 != 0 && !OS.XmListPosSelected(this.handle, n6)) {
                OS.XmListSelectPos(this.handle, n6, false);
            }
            ++n5;
        }
        if (n4 == 2) {
            nArray5[1] = 2;
            OS.XtSetValues(this.handle, nArray5, nArray5.length / 2);
        }
    }

    void select(String[] stringArray) {
        Object object;
        this.checkWidget();
        int[] nArray = new int[stringArray.length];
        String string = this.getCodePage();
        int n = 0;
        while (n < stringArray.length) {
            int n2;
            object = stringArray[n];
            byte[] byArray = Converter.wcsToMbcs(string, (String)object, true);
            nArray[n] = n2 = OS.XmStringCreateLocalized(byArray);
            ++n;
        }
        n = OS.XtMalloc(stringArray.length * 4);
        OS.memmove(n, nArray, stringArray.length * 4);
        object = new int[]{OS.XmNselectedItems, n, OS.XmNselectedItemCount, nArray.length};
        OS.XtSetValues(this.handle, (int[])object, ((Object)object).length / 2);
        int n3 = 0;
        while (n3 < nArray.length) {
            OS.XmStringFree(nArray[n3]);
            ++n3;
        }
        OS.XtFree(n);
        OS.XmListUpdateSelectedList(this.handle);
    }

    public void selectAll() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        int[] nArray = new int[4];
        nArray[0] = OS.XmNselectionPolicy;
        nArray[2] = OS.XmNitemCount;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        int n = nArray2[1];
        if (n == 2) {
            nArray2[1] = 1;
            OS.XtSetValues(this.handle, nArray2, nArray2.length / 2);
        }
        int n2 = 0;
        while (n2 < nArray2[3]) {
            int n3 = n2 + 1;
            if (!OS.XmListPosSelected(this.handle, n3)) {
                OS.XmListSelectPos(this.handle, n3, false);
            }
            ++n2;
        }
        if (n == 2) {
            nArray2[1] = 2;
            OS.XtSetValues(this.handle, nArray2, nArray2.length / 2);
        }
    }

    boolean setBounds(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        boolean bl3 = super.setBounds(n, n2, n3, n4, bl, bl2);
        if (bl3 && this.scrolledHandle != 0) {
            int[] nArray = new int[6];
            nArray[0] = OS.XmNwidth;
            nArray[2] = OS.XmNheight;
            nArray[4] = OS.XmNborderWidth;
            int[] nArray2 = nArray;
            OS.XtGetValues(this.scrolledHandle, nArray2, nArray2.length / 2);
            OS.XtResizeWidget(this.scrolledHandle, nArray2[1] + 1, nArray2[3], nArray2[5]);
            OS.XtResizeWidget(this.scrolledHandle, nArray2[1], nArray2[3], nArray2[5]);
        }
        return bl3;
    }

    void setFocusIndex(int n) {
        int[] nArray = new int[2];
        nArray[0] = OS.XmNitemCount;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        int n2 = nArray2[1];
        if (n < 0 || n >= n2) {
            return;
        }
        OS.XmListSetKbdItemPos(this.handle, n + 1);
    }

    public void setFont(Font font) {
        boolean bl;
        this.checkWidget();
        int[] nArray = new int[4];
        nArray[0] = OS.XmNitems;
        nArray[2] = OS.XmNitemCount;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        boolean bl2 = bl = OS.IsDBLocale && nArray2[3] == 0;
        if (bl) {
            byte[] byArray = Converter.wcsToMbcs(this.getCodePage(), "string", true);
            int n = OS.XmStringCreateLocalized(byArray);
            OS.XmListAddItemUnselected(this.handle, n, -1);
            OS.XmStringFree(n);
        }
        super.setFont(font);
        if (bl) {
            OS.XtSetValues(this.handle, nArray2, nArray2.length / 2);
        }
    }

    public void setItem(int n, String string) {
        byte[] byArray;
        int n2;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (n == -1) {
            this.error(6);
        }
        int[] nArray = new int[2];
        nArray[0] = OS.XmNitemCount;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        if (n < 0 || n >= nArray2[1]) {
            this.error(6);
        }
        if ((n2 = OS.XmStringCreateLocalized(byArray = Converter.wcsToMbcs(this.getCodePage(), string, true))) == 0) {
            this.error(14);
        }
        boolean bl = OS.XmListPosSelected(this.handle, n + 1);
        OS.XmListReplaceItemsPosUnselected(this.handle, new int[]{n2}, 1, n + 1);
        if (bl) {
            OS.XmListSelectPos(this.handle, n + 1, false);
        }
        OS.XmStringFree(n2);
    }

    public void setItems(String[] stringArray) {
        int n;
        Object[] objectArray;
        this.checkWidget();
        if (stringArray == null) {
            this.error(4);
        }
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (stringArray[n2] == null) {
                this.error(5);
            }
            ++n2;
        }
        OS.XmListSetPos(this.handle, 0);
        OS.XmListDeselectAllItems(this.handle);
        if ((this.style & 0x100) != 0) {
            OS.XmListDeleteAllItems(this.handle);
        }
        n2 = 0;
        int[] nArray = new int[stringArray.length];
        String string = this.getCodePage();
        while (n2 < stringArray.length) {
            String string2 = stringArray[n2];
            objectArray = Converter.wcsToMbcs(string, string2, true);
            n = OS.XmStringCreateLocalized(objectArray);
            if (n == 0) break;
            nArray[n2++] = n;
        }
        int n3 = OS.XtMalloc(n2 * 4);
        OS.memmove(n3, nArray, n2 * 4);
        objectArray = new int[]{OS.XmNitems, n3, OS.XmNitemCount, n2};
        OS.XtSetValues(this.handle, objectArray, objectArray.length / 2);
        n = 0;
        while (n < n2) {
            OS.XmStringFree(nArray[n]);
            ++n;
        }
        OS.XtFree(n3);
        if ((this.style & 0x100) != 0) {
            OS.XtResizeWindow(this.handle);
        }
        if (n2 < stringArray.length) {
            this.error(14);
        }
    }

    public void setSelection(int n) {
        this.checkWidget();
        this.deselectAll();
        this.select(n);
        this.showSelection();
        if ((this.style & 2) != 0 && n >= 0) {
            this.setFocusIndex(n);
        }
    }

    public void setSelection(int n, int n2) {
        this.checkWidget();
        if (n2 < 0 || n > n2 || (this.style & 4) != 0 && n != n2) {
            this.deselectAll();
            return;
        }
        int[] nArray = new int[2];
        nArray[0] = OS.XmNitemCount;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        int n3 = nArray2[1];
        if (n3 == 0 || n >= n3) {
            this.deselectAll();
            return;
        }
        n = Math.max(0, n);
        n2 = Math.min(n2, n3 - 1);
        if ((this.style & 2) != 0) {
            this.deselectAll();
        }
        this.select(n, n2);
        this.showSelection();
        if ((this.style & 2) != 0) {
            this.setFocusIndex(n);
        }
    }

    public void setSelection(int[] nArray) {
        int n;
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        this.deselectAll();
        int n2 = nArray.length;
        if (n2 == 0 || (this.style & 4) != 0 && n2 > 1) {
            return;
        }
        this.select(nArray);
        this.showSelection();
        if ((this.style & 2) != 0 && (n = nArray[0]) >= 0) {
            this.setFocusIndex(n);
        }
    }

    public void setSelection(String[] stringArray) {
        int n;
        Object object;
        int n2;
        this.checkWidget();
        if (stringArray == null) {
            this.error(4);
        }
        if ((n2 = stringArray.length) == 0 || (this.style & 4) != 0 && n2 > 1) {
            this.deselectAll();
            return;
        }
        String string = this.getCodePage();
        if ((this.style & 4) != 0) {
            byte[] byArray;
            int n3;
            String string2 = stringArray[0];
            if (string2 != null && (n3 = OS.XmStringCreateLocalized(byArray = Converter.wcsToMbcs(string, string2, true))) != 0) {
                int n4 = OS.XmListItemPos(this.handle, n3);
                if (n4 != 0) {
                    OS.XmListSelectPos(this.handle, n4, false);
                }
                OS.XmStringFree(n3);
                if (n4 != 0 && OS.XmListPosSelected(this.handle, n4)) {
                    this.showSelection();
                    return;
                }
            }
            this.deselectAll();
            return;
        }
        this.deselectAll();
        int n5 = 0;
        int[] nArray = new int[n2];
        int n6 = 0;
        while (n6 < n2) {
            byte[] byArray;
            object = stringArray[n6];
            if (object != null && (n = OS.XmStringCreateLocalized(byArray = Converter.wcsToMbcs(string, (String)object, true))) != 0) {
                nArray[n5++] = n;
            }
            ++n6;
        }
        n6 = OS.XtMalloc(n5 * 4);
        OS.memmove(n6, nArray, n5 * 4);
        object = new int[]{OS.XmNselectedItems, n6, OS.XmNselectedItemCount, n5};
        OS.XtSetValues(this.handle, (int[])object, ((Object)object).length / 2);
        boolean bl = false;
        n = 0;
        while (n < n5) {
            int n7;
            if (!bl && (n7 = OS.XmListItemPos(this.handle, nArray[n])) > 0) {
                bl = true;
                this.setFocusIndex(n7 - 1);
            }
            OS.XmStringFree(nArray[n]);
            ++n;
        }
        OS.XtFree(n6);
        OS.XmListUpdateSelectedList(this.handle);
        this.showSelection();
    }

    public void setTopIndex(int n) {
        this.checkWidget();
        int[] nArray = new int[4];
        nArray[0] = OS.XmNitemCount;
        nArray[2] = OS.XmNvisibleItemCount;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        int n2 = Math.max(1, Math.min(n + 1, nArray2[1]));
        int n3 = Math.max(1, nArray2[1] - nArray2[3] + 1);
        if (n2 > n3) {
            n2 = n3;
        }
        OS.XmListSetPos(this.handle, n2);
    }

    public void showSelection() {
        this.checkWidget();
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        if (!OS.XmListGetSelectedPos(this.handle, nArray2, nArray)) {
            return;
        }
        if (nArray[0] == 0) {
            return;
        }
        int n = nArray2[0];
        int[] nArray3 = new int[1];
        OS.memmove(nArray3, n, 4);
        OS.XtFree(n);
        int n2 = nArray3[0];
        int[] nArray4 = new int[6];
        nArray4[0] = OS.XmNtopItemPosition;
        nArray4[2] = OS.XmNvisibleItemCount;
        nArray4[4] = OS.XmNitemCount;
        int[] nArray5 = nArray4;
        OS.XtGetValues(this.handle, nArray5, nArray5.length / 2);
        int n3 = nArray5[1];
        int n4 = nArray5[3];
        int n5 = nArray5[5];
        int n6 = Math.min(n3 + n4 - 1, n5);
        if (n3 <= n2 && n2 <= n6) {
            return;
        }
        int n7 = Math.max(1, n5 - n4 + 1);
        int n8 = Math.min(Math.max(n2 - n4 / 2, 1), n7);
        OS.XmListSetPos(this.handle, n8);
    }

    int topHandle() {
        return this.formHandle;
    }

    int XmNbrowseSelectionCallback(int n, int n2, int n3) {
        this.postEvent(13);
        return 0;
    }

    int XmNdefaultActionCallback(int n, int n2, int n3) {
        this.postEvent(14);
        return 0;
    }

    int XmNextendedSelectionCallback(int n, int n2, int n3) {
        this.postEvent(13);
        return 0;
    }

    int XmNmultipleSelectionCallback(int n, int n2, int n3) {
        this.postEvent(13);
        return 0;
    }
}

