/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ProgressBar
extends Control {
    int timerId;
    static final int DELAY = 100;
    int foreground;

    public ProgressBar(Composite composite, int n) {
        super(composite, ProgressBar.checkStyle(n | 0x800));
    }

    static int checkStyle(int n) {
        return ProgressBar.checkBits(n |= 0x80000, 256, 512, 0, 0, 0, 0);
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        int n3 = this.getBorderWidth();
        int n4 = n3 * 2;
        int n5 = n3 * 2;
        int n6 = this.display.scrolledMarginX;
        int n7 = this.display.scrolledMarginY;
        if ((this.style & 0x100) != 0) {
            n4 += n6 * 10;
            n5 += n7;
        } else {
            n4 += n6;
            n5 += n7 * 10;
        }
        if (n != -1) {
            n4 = n + n3 * 2;
        }
        if (n2 != -1) {
            n5 = n2 + n3 * 2;
        }
        return new Point(n4, n5);
    }

    void createHandle(int n) {
        int n2 = this.defaultBackground();
        int n3 = this.parent.handle;
        int[] nArray = new int[26];
        nArray[0] = OS.XmNshowArrows;
        nArray[2] = OS.XmNsliderSize;
        nArray[3] = 1;
        nArray[4] = OS.XmNtraversalOn;
        nArray[6] = OS.XmNtroughColor;
        nArray[7] = n2;
        nArray[8] = OS.XmNtopShadowColor;
        nArray[9] = n2;
        nArray[10] = OS.XmNbottomShadowColor;
        nArray[11] = n2;
        nArray[12] = OS.XmNforeground;
        nArray[13] = n2;
        nArray[14] = OS.XmNshadowThickness;
        nArray[15] = 1;
        nArray[16] = OS.XmNborderWidth;
        nArray[17] = (this.style & 0x800) != 0 ? 1 : 0;
        nArray[18] = OS.XmNorientation;
        nArray[19] = (this.style & 0x100) != 0 ? 2 : 1;
        nArray[20] = OS.XmNprocessingDirection;
        nArray[21] = (this.style & 0x100) != 0 ? 3 : 0;
        nArray[22] = OS.XmNancestorSensitive;
        nArray[23] = 1;
        nArray[24] = OS.XmNsliderVisual;
        nArray[25] = 1;
        int[] nArray2 = nArray;
        this.handle = OS.XmCreateScrollBar(n3, null, nArray2, nArray2.length / 2);
        if (this.handle == 0) {
            this.error(2);
        }
        if ((this.style & 2) != 0) {
            this.createTimer();
        }
    }

    void createWidget(int n) {
        super.createWidget(n);
        this.foreground = this.defaultForeground();
    }

    void createTimer() {
        int n = this.display.xDisplay;
        int n2 = this.display.windowTimerProc;
        int n3 = OS.XtDisplayToApplicationContext(n);
        this.timerId = OS.XtAppAddTimeOut(n3, 100, n2, this.handle);
    }

    void destroyTimer() {
        if (this.timerId != 0) {
            OS.XtRemoveTimeOut(this.timerId);
        }
        this.timerId = 0;
    }

    int getForegroundPixel() {
        return this.foreground == -1 ? super.getForegroundPixel() : this.foreground;
    }

    public int getMaximum() {
        this.checkWidget();
        int[] nArray = new int[2];
        nArray[0] = OS.XmNmaximum;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        return nArray2[1];
    }

    public int getMinimum() {
        this.checkWidget();
        int[] nArray = new int[2];
        nArray[0] = OS.XmNminimum;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        return nArray2[1];
    }

    public int getSelection() {
        this.checkWidget();
        int[] nArray = new int[4];
        nArray[0] = OS.XmNminimum;
        nArray[2] = OS.XmNsliderSize;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        int n = nArray2[1];
        int n2 = nArray2[3];
        return n + (this.foreground != -1 ? 0 : n2);
    }

    public int getState() {
        this.checkWidget();
        return 0;
    }

    void releaseWidget() {
        super.releaseWidget();
        this.destroyTimer();
    }

    void setBackgroundPixel(int n) {
        this.checkWidget();
        super.setBackgroundPixel(n);
        if (this.foreground != -1) {
            super.setForegroundPixel(n);
        }
    }

    void setForegroundPixel(int n) {
        this.checkWidget();
        if (this.foreground == -1) {
            super.setForegroundPixel(n);
        } else {
            this.foreground = n;
        }
    }

    public void setMaximum(int n) {
        this.checkWidget();
        if (n < 0) {
            return;
        }
        int[] nArray = new int[4];
        nArray[0] = OS.XmNmaximum;
        nArray[1] = n;
        nArray[2] = OS.XmNvalue;
        int[] nArray2 = nArray;
        boolean bl = this.display.getWarnings();
        this.display.setWarnings(false);
        OS.XtSetValues(this.handle, nArray2, nArray2.length / 2);
        this.display.setWarnings(bl);
    }

    public void setMinimum(int n) {
        this.checkWidget();
        if (n < 0) {
            return;
        }
        int[] nArray = new int[8];
        nArray[0] = OS.XmNminimum;
        nArray[2] = OS.XmNmaximum;
        nArray[4] = OS.XmNsliderSize;
        nArray[6] = OS.XmNvalue;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        int n2 = nArray2[1];
        int n3 = nArray2[3];
        int n4 = nArray2[5];
        if (n >= n3) {
            return;
        }
        int n5 = n4 + n2;
        if (n > n5) {
            n5 = n;
        }
        nArray2[1] = n;
        nArray2[7] = n;
        boolean bl = this.display.getWarnings();
        this.display.setWarnings(false);
        OS.XtSetValues(this.handle, nArray2, nArray2.length / 2);
        this.display.setWarnings(bl);
        this.setThumb(n5 - n);
    }

    public void setSelection(int n) {
        this.checkWidget();
        int[] nArray = new int[4];
        nArray[0] = OS.XmNminimum;
        nArray[2] = OS.XmNmaximum;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        int n2 = nArray2[1];
        int n3 = nArray2[3];
        int n4 = n;
        if (n4 < n2) {
            n4 = n2;
        }
        if (n4 > n3) {
            n4 = n3;
        }
        this.setThumb(n4 - n2);
        this.update();
    }

    public void setState(int n) {
        this.checkWidget();
    }

    void setThumb(int n) {
        int[] nArray = new int[4];
        nArray[0] = OS.XmNtroughColor;
        nArray[2] = OS.XmNminimum;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        int n2 = nArray2[1];
        if (n == 0) {
            if (this.foreground == -1) {
                this.foreground = this.getForegroundPixel();
                super.setForegroundPixel(n2);
            }
        } else if (this.foreground != -1) {
            super.setForegroundPixel(this.foreground);
            this.foreground = -1;
        }
        int[] nArray3 = new int[]{OS.XmNsliderSize, n == 0 ? 1 : n, OS.XmNvalue, nArray2[3]};
        boolean bl = this.display.getWarnings();
        this.display.setWarnings(false);
        OS.XtSetValues(this.handle, nArray3, nArray3.length / 2);
        this.display.setWarnings(bl);
    }

    int timerProc(int n) {
        int n2 = this.getMinimum();
        int n3 = this.getMaximum() - n2 + 1;
        int n4 = this.getSelection() - n2 + 1;
        this.setSelection(n2 + n4 % n3);
        this.createTimer();
        return 0;
    }

    int XButtonPress(int n, int n2, int n3, int n4) {
        int n5 = super.XButtonPress(n, n2, n3, n4);
        int[] nArray = new int[2];
        nArray[0] = OS.XmNsensitive;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        if (nArray2[1] != 0) {
            OS.memmove(n4, new int[1], 4);
            return 1;
        }
        return n5;
    }

    int XButtonRelease(int n, int n2, int n3, int n4) {
        int n5 = super.XButtonRelease(n, n2, n3, n4);
        int[] nArray = new int[2];
        nArray[0] = OS.XmNsensitive;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        if (nArray2[1] != 0) {
            OS.memmove(n4, new int[1], 4);
            return 1;
        }
        return n5;
    }

    int XKeyPress(int n, int n2, int n3, int n4) {
        int n5 = super.XKeyPress(n, n2, n3, n4);
        int[] nArray = new int[2];
        nArray[0] = OS.XmNsensitive;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        if (nArray2[1] != 0) {
            OS.memmove(n4, new int[1], 4);
            return 1;
        }
        return n5;
    }

    int XKeyRelease(int n, int n2, int n3, int n4) {
        int n5 = super.XKeyRelease(n, n2, n3, n4);
        int[] nArray = new int[2];
        nArray[0] = OS.XmNsensitive;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        if (nArray2[1] != 0) {
            OS.memmove(n4, new int[1], 4);
            return 1;
        }
        return n5;
    }
}

