/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.internal.motif.XButtonEvent;
import org.eclipse.swt.internal.motif.XFocusChangeEvent;
import org.eclipse.swt.internal.motif.XKeyEvent;
import org.eclipse.swt.internal.motif.XMotionEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;

public class Sash
extends Control {
    boolean dragging;
    int startX;
    int startY;
    int lastX;
    int lastY;
    int cursor;
    private static final int INCREMENT = 1;
    private static final int PAGE_INCREMENT = 9;

    public Sash(Composite composite, int n) {
        super(composite, Sash.checkStyle(n));
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int n) {
        return Sash.checkBits(n, 256, 512, 0, 0, 0, 0);
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        int n3 = this.getBorderWidth();
        int n4 = n3 * 2;
        int n5 = n3 * 2;
        if ((this.style & 0x100) != 0) {
            n4 += 64;
            n5 += 3;
        } else {
            n4 += 3;
            n5 += 64;
        }
        if (n != -1) {
            n4 = n + n3 * 2;
        }
        if (n2 != -1) {
            n5 = n2 + n3 * 2;
        }
        return new Point(n4, n5);
    }

    void createHandle(int n) {
        this.state |= 0x80;
        int n2 = (this.style & 0x800) != 0 ? 1 : 0;
        int[] nArray = new int[12];
        nArray[0] = OS.XmNborderWidth;
        nArray[1] = n2;
        nArray[2] = OS.XmNmarginWidth;
        nArray[4] = OS.XmNmarginHeight;
        nArray[6] = OS.XmNresizePolicy;
        nArray[8] = OS.XmNancestorSensitive;
        nArray[9] = 1;
        nArray[10] = OS.XmNtraversalOn;
        int[] nArray2 = nArray;
        int n3 = this.parent.handle;
        this.handle = OS.XmCreateDrawingArea(n3, null, nArray2, nArray2.length / 2);
    }

    void drawBand(int n, int n2, int n3, int n4) {
        if ((this.style & 0x10000) != 0) {
            return;
        }
        int n5 = OS.XtDisplay(this.parent.handle);
        if (n5 == 0) {
            return;
        }
        int n6 = OS.XtWindow(this.parent.handle);
        if (n6 == 0) {
            return;
        }
        int n7 = this.parent.getForegroundPixel();
        Control control = this.parent.findBackgroundControl();
        if (control == null) {
            control = this.parent;
        }
        int n8 = control.getBackgroundPixel();
        int n9 = n7 ^ n8;
        byte[] byArray = new byte[]{-86, 85, -86, 85, -86, 85, -86, 85};
        int n10 = OS.XCreateBitmapFromData(n5, n6, byArray, 8, 8);
        int n11 = OS.XCreateGC(n5, n6, 0, null);
        OS.XSetForeground(n5, n11, n9);
        OS.XSetStipple(n5, n11, n10);
        OS.XSetSubwindowMode(n5, n11, 1);
        OS.XSetFillStyle(n5, n11, 2);
        OS.XSetFunction(n5, n11, 6);
        OS.XFillRectangle(n5, n6, n11, n, n2, n3, n4);
        OS.XFreePixmap(n5, n10);
        OS.XFreeGC(n5, n11);
    }

    void propagateWidget(boolean bl) {
        int n = bl && ((Control)this).cursor != null ? ((Control)this).cursor.handle : this.cursor;
        this.propagateHandle(bl, this.handle, n);
    }

    void realizeChildren() {
        super.realizeChildren();
        int n = OS.XtWindow(this.handle);
        if (n == 0) {
            return;
        }
        int n2 = OS.XtDisplay(this.handle);
        if (n2 == 0) {
            return;
        }
        this.cursor = (this.style & 0x100) != 0 ? OS.XCreateFontCursor(n2, 116) : OS.XCreateFontCursor(n2, 108);
        if (((Control)this).cursor == null && this.isEnabled()) {
            OS.XDefineCursor(n2, n, this.cursor);
            OS.XFlush(n2);
        }
    }

    void releaseWidget() {
        int n;
        super.releaseWidget();
        if (this.cursor != 0 && (n = OS.XtDisplay(this.handle)) != 0) {
            OS.XFreeCursor(n, this.cursor);
        }
        this.cursor = 0;
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void setCursor(Cursor cursor) {
        this.checkWidget();
        super.setCursor(cursor);
        if (cursor == null && this.cursor != 0) {
            int n = OS.XtWindow(this.handle);
            if (n == 0) {
                return;
            }
            int n2 = OS.XtDisplay(this.handle);
            if (n2 == 0) {
                return;
            }
            OS.XDefineCursor(n2, n, this.cursor);
            OS.XFlush(n2);
        }
    }

    public boolean setFocus() {
        this.checkWidget();
        return this.forceFocus();
    }

    int XButtonPress(int n, int n2, int n3, int n4) {
        int n5 = super.XButtonPress(n, n2, n3, n4);
        if (n5 != 0) {
            return n5;
        }
        XButtonEvent xButtonEvent = new XButtonEvent();
        OS.memmove(xButtonEvent, n3, 60);
        if (xButtonEvent.button != 1) {
            return n5;
        }
        short[] sArray = new short[1];
        short[] sArray2 = new short[1];
        OS.XtTranslateCoords(this.handle, (short)0, (short)0, sArray, sArray2);
        this.startX = xButtonEvent.x_root - sArray[0];
        this.startY = xButtonEvent.y_root - sArray2[0];
        int[] nArray = new int[10];
        nArray[0] = OS.XmNx;
        nArray[2] = OS.XmNy;
        nArray[4] = OS.XmNwidth;
        nArray[6] = OS.XmNheight;
        nArray[8] = OS.XmNborderWidth;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        int n6 = nArray2[9];
        int n7 = nArray2[5] + n6 * 2;
        int n8 = nArray2[7] + n6 * 2;
        this.lastX = (short)nArray2[1] - n6;
        this.lastY = (short)nArray2[3] - n6;
        Event event = new Event();
        event.time = xButtonEvent.time;
        event.x = this.lastX;
        event.y = this.lastY;
        event.width = n7;
        event.height = n8;
        if ((this.style & 0x10000) == 0) {
            event.detail = 1;
        }
        this.sendEvent(13, event);
        if (this.isDisposed()) {
            return n5;
        }
        if (event.doit) {
            this.dragging = true;
            this.lastX = event.x;
            this.lastY = event.y;
            this.parent.update(true);
            this.drawBand(event.x, event.y, n7, n8);
            if ((this.style & 0x10000) != 0) {
                this.setBounds(event.x, event.y, n7, n8);
            }
        }
        return n5;
    }

    int XButtonRelease(int n, int n2, int n3, int n4) {
        int n5 = super.XButtonRelease(n, n2, n3, n4);
        if (n5 != 0) {
            return n5;
        }
        XButtonEvent xButtonEvent = new XButtonEvent();
        OS.memmove(xButtonEvent, n3, 60);
        if (xButtonEvent.button != 1) {
            return n5;
        }
        if (!this.dragging) {
            return n5;
        }
        this.dragging = false;
        int[] nArray = new int[6];
        nArray[0] = OS.XmNwidth;
        nArray[2] = OS.XmNheight;
        nArray[4] = OS.XmNborderWidth;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        int n6 = nArray2[5];
        int n7 = nArray2[1] + n6 * 2;
        int n8 = nArray2[3] + n6 * 2;
        Event event = new Event();
        event.time = xButtonEvent.time;
        event.x = this.lastX;
        event.y = this.lastY;
        event.width = n7;
        event.height = n8;
        this.drawBand(this.lastX, this.lastY, n7, n8);
        this.sendEvent(13, event);
        if (this.isDisposed()) {
            return n5;
        }
        if (event.doit && (this.style & 0x10000) != 0) {
            this.setBounds(event.x, event.y, n7, n8);
        }
        return n5;
    }

    int xFocusIn(XFocusChangeEvent xFocusChangeEvent) {
        int n = super.xFocusIn(xFocusChangeEvent);
        if (this.handle == 0) {
            return n;
        }
        int[] nArray = new int[4];
        nArray[0] = OS.XmNx;
        nArray[2] = OS.XmNy;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        this.lastX = nArray2[1];
        this.lastY = nArray2[3];
        return n;
    }

    int XKeyPress(int n, int n2, int n3, int n4) {
        int n5 = super.XKeyPress(n, n2, n3, n4);
        if (n5 != 0) {
            return n5;
        }
        XKeyEvent xKeyEvent = new XKeyEvent();
        OS.memmove(xKeyEvent, n3, 60);
        byte[] byArray = new byte[1];
        int[] nArray = new int[1];
        OS.XLookupString(xKeyEvent, byArray, byArray.length, nArray, null);
        switch (nArray[0]) {
            case 65361: 
            case 65362: 
            case 65363: 
            case 65364: {
                int n6 = 0;
                int n7 = 0;
                int n8 = 9;
                if ((xKeyEvent.state & 4) != 0) {
                    n8 = 1;
                }
                if ((this.style & 0x200) != 0) {
                    if (nArray[0] == 65362 || nArray[0] == 65364) break;
                    n6 = nArray[0] == 65361 ? -n8 : n8;
                } else {
                    if (nArray[0] == 65361 || nArray[0] == 65363) break;
                    n7 = nArray[0] == 65362 ? -n8 : n8;
                }
                int[] nArray2 = new int[6];
                nArray2[0] = OS.XmNwidth;
                nArray2[2] = OS.XmNheight;
                nArray2[4] = OS.XmNborderWidth;
                int[] nArray3 = nArray2;
                OS.XtGetValues(this.handle, nArray3, nArray3.length / 2);
                int n9 = nArray3[5];
                int n10 = nArray3[1] + n9 * 2;
                int n11 = nArray3[3] + n9 * 2;
                int[] nArray4 = new int[6];
                nArray4[0] = OS.XmNwidth;
                nArray4[2] = OS.XmNheight;
                nArray4[4] = OS.XmNborderWidth;
                int[] nArray5 = nArray4;
                OS.XtGetValues(this.parent.handle, nArray5, nArray5.length / 2);
                int n12 = nArray5[5];
                int n13 = nArray5[1] + n12 * 2;
                int n14 = nArray5[3] + n12 * 2;
                int n15 = this.lastX;
                int n16 = this.lastY;
                if ((this.style & 0x200) != 0) {
                    n15 = Math.min(Math.max(0, this.lastX + n6 - n12 - this.startX), n13 - n10);
                } else {
                    n16 = Math.min(Math.max(0, this.lastY + n7 - n12 - this.startY), n14 - n11);
                }
                if (n15 == this.lastX && n16 == this.lastY) {
                    return n5;
                }
                int n17 = this.display.xDisplay;
                int n18 = OS.XtWindow(this.parent.handle);
                int n19 = OS.XGrabPointer(n17, n18, 1, 0, 1, 1, 0, this.cursor, 0);
                Event event = new Event();
                event.time = xKeyEvent.time;
                event.x = n15;
                event.y = n16;
                event.width = n10;
                event.height = n11;
                this.sendEvent(13, event);
                if (n19 == 0) {
                    OS.XUngrabPointer(n17, 0);
                }
                if (this.isDisposed() || !event.doit) break;
                this.lastX = event.x;
                this.lastY = event.y;
                if ((this.style & 0x10000) != 0) {
                    this.setBounds(event.x, event.y, n10, n11);
                    if (this.isDisposed()) break;
                }
                int n20 = event.x;
                int n21 = event.y;
                if ((this.style & 0x200) != 0) {
                    n21 += n11 / 2;
                } else {
                    n20 += n10 / 2;
                }
                OS.XWarpPointer(n17, 0, n18, 0, 0, 0, 0, n20, n21);
            }
        }
        return n5;
    }

    int XPointerMotion(int n, int n2, int n3, int n4) {
        int n5 = super.XPointerMotion(n, n2, n3, n4);
        if (n5 != 0) {
            return n5;
        }
        XMotionEvent xMotionEvent = new XMotionEvent();
        OS.memmove(xMotionEvent, n3, 60);
        if (!this.dragging || (xMotionEvent.state & 0x100) == 0) {
            return n5;
        }
        short[] sArray = new short[1];
        short[] sArray2 = new short[1];
        OS.XtTranslateCoords(this.handle, (short)0, (short)0, sArray, sArray2);
        int n6 = xMotionEvent.x_root - sArray[0];
        int n7 = xMotionEvent.y_root - sArray2[0];
        int[] nArray = new int[10];
        nArray[0] = OS.XmNx;
        nArray[2] = OS.XmNy;
        nArray[4] = OS.XmNwidth;
        nArray[6] = OS.XmNheight;
        nArray[8] = OS.XmNborderWidth;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
        int n8 = nArray2[9];
        int n9 = (short)nArray2[1] - n8;
        int n10 = (short)nArray2[3] - n8;
        int n11 = nArray2[5] + n8 * 2;
        int n12 = nArray2[7] + n8 * 2;
        int[] nArray3 = new int[6];
        nArray3[0] = OS.XmNwidth;
        nArray3[2] = OS.XmNheight;
        nArray3[4] = OS.XmNborderWidth;
        int[] nArray4 = nArray3;
        OS.XtGetValues(this.parent.handle, nArray4, nArray4.length / 2);
        int n13 = nArray4[5];
        int n14 = nArray4[1] + n13 * 2;
        int n15 = nArray4[3] + n13 * 2;
        int n16 = this.lastX;
        int n17 = this.lastY;
        if ((this.style & 0x200) != 0) {
            n16 = Math.min(Math.max(0, n6 + n9 - this.startX - n13), n14 - n11);
        } else {
            n17 = Math.min(Math.max(0, n7 + n10 - this.startY - n13), n15 - n12);
        }
        if (n16 == this.lastX && n17 == this.lastY) {
            return n5;
        }
        this.drawBand(this.lastX, this.lastY, n11, n12);
        Event event = new Event();
        event.time = xMotionEvent.time;
        event.x = n16;
        event.y = n17;
        event.width = n11;
        event.height = n12;
        if ((this.style & 0x10000) == 0) {
            event.detail = 1;
        }
        this.sendEvent(13, event);
        if (this.isDisposed()) {
            return n5;
        }
        if (event.doit) {
            this.lastX = event.x;
            this.lastY = event.y;
        }
        this.parent.update(true);
        this.drawBand(this.lastX, this.lastY, n11, n12);
        if ((this.style & 0x10000) != 0) {
            this.setBounds(this.lastX, this.lastY, n11, n12);
        }
        return n5;
    }
}

