/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tracker;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.TypedListener;

public class Tree
extends Composite {
    Canvas header;
    TreeColumn[] columns = new TreeColumn[0];
    TreeColumn[] orderedColumns;
    TreeItem[] items = NO_ITEMS;
    TreeItem[] availableItems = NO_ITEMS;
    TreeItem[] selectedItems = NO_ITEMS;
    TreeItem focusItem;
    TreeItem anchorItem;
    TreeItem insertMarkItem;
    TreeItem lastClickedItem;
    Event lastSelectionEvent;
    int availableItemsCount = 0;
    boolean insertMarkPrecedes = false;
    boolean linesVisible;
    boolean ignoreKey;
    boolean ignoreDispose;
    boolean customHeightSet;
    int topIndex = 0;
    int horizontalOffset = 0;
    int fontHeight = 0;
    int imageHeight = 0;
    int itemHeight = 0;
    int headerImageHeight = 0;
    int orderedCol0imageWidth = 0;
    TreeColumn resizeColumn;
    int resizeColumnX = -1;
    int drawCount = 0;
    boolean inExpand = false;
    TreeColumn sortColumn;
    int sortDirection = 0;
    Listener toolTipListener;
    Shell toolTipShell;
    Label toolTipLabel;
    Rectangle arrowBounds;
    Rectangle expanderBounds;
    Rectangle checkboxBounds;
    Rectangle clientArea;
    static final TreeItem[] NO_ITEMS = new TreeItem[0];
    static final int MARGIN_IMAGE = 3;
    static final int MARGIN_CELL = 1;
    static final int SIZE_HORIZONTALSCROLL = 5;
    static final int TOLLERANCE_COLUMNRESIZE = 2;
    static final int WIDTH_HEADER_SHADOW = 2;
    static final int WIDTH_CELL_HIGHLIGHT = 1;
    static final int[] toolTipEvents = new int[]{7, 32, 5, 3};
    static final String ELLIPSIS = "...";
    static final String ID_EXPANDED = "EXPANDED";
    static final String ID_COLLAPSED = "COLLAPSED";
    static final String ID_UNCHECKED = "UNCHECKED";
    static final String ID_GRAYUNCHECKED = "GRAYUNCHECKED";
    static final String ID_CHECKMARK = "CHECKMARK";
    static final String ID_CONNECTOR_COLOR = "CONNECTOR_COLOR";
    static final String ID_ARROWUP = "ARROWUP";
    static final String ID_ARROWDOWN = "ARROWDOWN";
    boolean hasFocus;

    public boolean isFocusControl() {
        return this.hasFocus;
    }

    public Tree(Composite composite, int n) {
        super(composite, Tree.checkStyle(n));
        ScrollBar scrollBar;
        this.setForeground(null);
        this.setBackground(null);
        GC gC = new GC(this);
        this.fontHeight = gC.getFontMetrics().getHeight();
        gC.dispose();
        this.itemHeight = this.fontHeight + 2 * this.getCellPadding();
        Tree.initImages(this.display);
        this.expanderBounds = this.getExpandedImage().getBounds();
        this.checkboxBounds = this.getUncheckedImage().getBounds();
        this.arrowBounds = this.getArrowDownImage().getBounds();
        this.clientArea = this.getClientArea();
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                Tree.this.handleEvents(event);
            }
        };
        this.addListener(9, listener);
        this.addListener(3, listener);
        this.addListener(4, listener);
        this.addListener(8, listener);
        this.addListener(12, listener);
        this.addListener(11, listener);
        this.addListener(1, listener);
        this.addListener(16, listener);
        this.addListener(15, listener);
        this.addListener(31, listener);
        this.header = new Canvas(this, 0x180000);
        this.header.setVisible(false);
        this.header.setBounds(0, 0, 0, this.fontHeight + 2 * this.getHeaderPadding());
        this.header.addListener(9, listener);
        this.header.addListener(3, listener);
        this.header.addListener(4, listener);
        this.header.addListener(32, listener);
        this.header.addListener(8, listener);
        this.header.addListener(5, listener);
        this.header.addListener(7, listener);
        this.header.addListener(35, listener);
        this.toolTipListener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 5: 
                    case 32: {
                        if (Tree.this.headerUpdateToolTip(event.x)) break;
                    }
                    case 3: 
                    case 7: {
                        Tree.this.headerHideToolTip();
                    }
                }
            }
        };
        ScrollBar scrollBar2 = this.getHorizontalBar();
        if (scrollBar2 != null) {
            scrollBar2.setValues(0, 0, 1, 1, 1, 1);
            scrollBar2.setVisible(false);
            scrollBar2.addListener(13, listener);
        }
        if ((scrollBar = this.getVerticalBar()) != null) {
            scrollBar.setValues(0, 0, 1, 1, 1, 1);
            scrollBar.setVisible(false);
            scrollBar.addListener(13, listener);
        }
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void addTreeListener(TreeListener treeListener) {
        this.checkWidget();
        if (treeListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(treeListener);
        this.addListener(17, typedListener);
        this.addListener(18, typedListener);
    }

    boolean checkData(TreeItem treeItem, boolean bl) {
        if (treeItem.cached) {
            return true;
        }
        if ((this.style & 0x10000000) != 0) {
            treeItem.cached = true;
            Event event = new Event();
            TreeItem treeItem2 = treeItem.getParentItem();
            event.item = treeItem;
            event.index = treeItem2 == null ? this.indexOf(treeItem) : treeItem2.indexOf(treeItem);
            this.sendEvent(36, event);
            if (this.isDisposed() || treeItem.isDisposed()) {
                return false;
            }
            if (bl) {
                this.redrawItem(treeItem.availableIndex, false);
            }
        }
        return true;
    }

    static int checkStyle(int n) {
        if ((n & 0x10) == 0) {
            n |= 0x300;
        }
        n |= 0x20140000;
        return Tree.checkBits(n |= 0x10000, 4, 2, 0, 0, 0, 0);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public void clear(int n, boolean bl) {
        Rectangle rectangle;
        this.checkWidget();
        if (n < 0 || n >= this.items.length) {
            this.error(6);
        }
        TreeItem treeItem = this.items[n];
        TreeItem[] treeItemArray = null;
        int n2 = 0;
        if (this.columns.length == 0) {
            if (bl) {
                treeItemArray = treeItem.computeAvailableDescendents();
                int n3 = 0;
                while (n3 < treeItemArray.length) {
                    rectangle = treeItemArray[n3].getBounds(false);
                    n2 = Math.max(n2, rectangle.x + rectangle.width);
                    ++n3;
                }
            } else {
                Rectangle rectangle2 = treeItem.getBounds(false);
                n2 = rectangle2.x + rectangle2.width;
            }
        }
        treeItem.clear();
        if (bl) {
            treeItem.clearAll(true, false);
        }
        if (this.columns.length == 0) {
            int n4 = 0;
            if (bl) {
                int n5 = 0;
                while (n5 < treeItemArray.length) {
                    Rectangle rectangle3 = treeItemArray[n5].getBounds(false);
                    n4 = Math.max(n4, rectangle3.x + rectangle3.width);
                    ++n5;
                }
            } else {
                rectangle = treeItem.getBounds(false);
                n4 = rectangle.x + rectangle.width;
            }
            this.updateHorizontalBar(n4, n4 - n2);
        }
        if (bl && treeItem.expanded) {
            int n6 = treeItemArray == null ? treeItem.computeAvailableDescendentCount() : treeItemArray.length;
            this.redrawItems(treeItem.availableIndex, treeItem.availableIndex + n6 - 1, false);
        } else {
            this.redrawItem(treeItem.availableIndex, false);
        }
    }

    public void clearAll(boolean bl) {
        int n;
        this.checkWidget();
        if (this.items.length == 0) {
            return;
        }
        int n2 = 0;
        if (this.columns.length == 0 && !bl) {
            n = 0;
            while (n < this.items.length) {
                Rectangle rectangle = this.items[n].getBounds(false);
                n2 = Math.max(n2, rectangle.x + rectangle.width);
                ++n;
            }
        }
        n = 0;
        while (n < this.items.length) {
            this.items[n].clear();
            if (bl) {
                this.items[n].clearAll(true, false);
            }
            ++n;
        }
        if (this.columns.length == 0) {
            if (bl) {
                this.updateHorizontalBar();
            } else {
                Rectangle rectangle = this.items[0].getBounds(false);
                int n3 = rectangle.x + rectangle.width;
                this.updateHorizontalBar(n3, n3 - n2);
            }
        }
        if (bl) {
            this.redrawItems(0, this.availableItemsCount - 1, false);
        } else {
            int n4 = 0;
            while (n4 < this.items.length) {
                this.redrawItem(this.items[n4].availableIndex, false);
                ++n4;
            }
        }
    }

    int computeColumnIntersect(int n, int n2) {
        TreeColumn[] treeColumnArray = this.getOrderedColumns();
        if (treeColumnArray.length - 1 < n2) {
            return -1;
        }
        int n3 = treeColumnArray[n2].getX();
        int n4 = n2;
        while (n4 < treeColumnArray.length) {
            if (n < (n3 += treeColumnArray[n4].width)) {
                return n4;
            }
            ++n4;
        }
        return -1;
    }

    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        int n3 = 0;
        int n4 = 0;
        if (n != -1) {
            n3 = n;
        } else if (this.columns.length == 0) {
            int n5 = 0;
            while (n5 < this.availableItemsCount) {
                Rectangle rectangle = this.availableItems[n5].getBounds(false);
                n3 = Math.max(n3, rectangle.x + rectangle.width);
                ++n5;
            }
        } else {
            TreeColumn[] treeColumnArray = this.getOrderedColumns();
            TreeColumn treeColumn = treeColumnArray[treeColumnArray.length - 1];
            n3 = treeColumn.getX() + treeColumn.width;
        }
        n4 = n2 != -1 ? n2 : this.getHeaderHeight() + this.availableItemsCount * this.itemHeight;
        Rectangle rectangle = this.computeTrim(0, 0, n3, n4);
        return new Point(rectangle.width, rectangle.height);
    }

    void createItem(TreeColumn treeColumn, int n) {
        int n2;
        TreeColumn[] treeColumnArray = new TreeColumn[this.columns.length + 1];
        System.arraycopy(this.columns, 0, treeColumnArray, 0, n);
        treeColumnArray[n] = treeColumn;
        System.arraycopy(this.columns, n, treeColumnArray, n + 1, this.columns.length - n);
        this.columns = treeColumnArray;
        if (this.orderedColumns != null) {
            n2 = 0;
            if (n > 0) {
                n2 = this.columns[n - 1].getOrderIndex() + 1;
            }
            TreeColumn[] treeColumnArray2 = new TreeColumn[this.orderedColumns.length + 1];
            System.arraycopy(this.orderedColumns, 0, treeColumnArray2, 0, n2);
            treeColumnArray2[n2] = treeColumn;
            System.arraycopy(this.orderedColumns, n2, treeColumnArray2, n2 + 1, this.orderedColumns.length - n2);
            this.orderedColumns = treeColumnArray2;
        }
        if (this.columns.length == 1) {
            treeColumn.itemImageWidth = this.orderedCol0imageWidth;
        } else if (treeColumn.getOrderIndex() == 0) {
            this.orderedCol0imageWidth = 0;
        }
        n2 = 0;
        while (n2 < this.items.length) {
            this.items[n2].addColumn(treeColumn);
            ++n2;
        }
        if (this.columns.length == 1 && this.availableItemsCount > 0) {
            this.redrawFromItemDownwards(this.topIndex);
        } else if (this.availableItemsCount > 0 && (this.style & 0x20) != 0 && n == 0 && treeColumn.getOrderIndex() == 0) {
            this.redrawFromItemDownwards(this.topIndex);
        }
    }

    void createItem(TreeItem treeItem, int n) {
        int n2;
        TreeItem[] treeItemArray = new TreeItem[this.items.length + 1];
        System.arraycopy(this.items, 0, treeItemArray, 0, n);
        treeItemArray[n] = treeItem;
        System.arraycopy(this.items, n, treeItemArray, n + 1, this.items.length - n);
        this.items = treeItemArray;
        int n3 = n == this.items.length - 1 ? this.availableItemsCount : this.items[n + 1].availableIndex;
        if (this.availableItemsCount == this.availableItems.length) {
            n2 = this.drawCount <= 0 ? 4 : Math.max(4, this.availableItems.length * 3 / 2);
            TreeItem[] treeItemArray2 = new TreeItem[this.availableItems.length + n2];
            System.arraycopy(this.availableItems, 0, treeItemArray2, 0, this.availableItems.length);
            this.availableItems = treeItemArray2;
        }
        if (n3 != this.availableItemsCount) {
            System.arraycopy(this.availableItems, n3, this.availableItems, n3 + 1, this.availableItemsCount - n3);
        }
        this.availableItems[n3] = treeItem;
        ++this.availableItemsCount;
        n2 = n3;
        while (n2 < this.availableItemsCount) {
            this.availableItems[n2].availableIndex = n2;
            ++n2;
        }
        this.updateVerticalBar();
        Rectangle rectangle = treeItem.getBounds(false);
        int n4 = rectangle.x + rectangle.width;
        this.updateHorizontalBar(n4, n4);
        if (treeItem.availableIndex < this.topIndex) {
            ++this.topIndex;
            ScrollBar scrollBar = this.getVerticalBar();
            if (scrollBar != null) {
                scrollBar.setSelection(this.topIndex);
            }
            return;
        }
        if (this.availableItemsCount == 1 && this.isFocusControl()) {
            this.focusItem = treeItem;
            this.redraw();
            return;
        }
        int n5 = n;
        if (n5 > 0 && treeItem.isLastChild()) {
            --n5;
        }
        this.redrawFromItemDownwards(this.items[n5].availableIndex);
    }

    public void deselect(TreeItem treeItem) {
        this.checkWidget();
        if (treeItem == null) {
            this.error(4);
        }
        if (treeItem.isDisposed()) {
            this.error(5);
        }
        this.deselectItem(treeItem);
        this.redrawItem(treeItem.availableIndex, true);
    }

    public void deselectAll() {
        this.checkWidget();
        TreeItem[] treeItemArray = this.selectedItems;
        this.selectedItems = NO_ITEMS;
        int n = 0;
        while (n < treeItemArray.length) {
            this.redrawItem(treeItemArray[n].availableIndex, true);
            ++n;
        }
    }

    void deselectItem(TreeItem treeItem) {
        int n = this.getSelectionIndex(treeItem);
        if (n == -1) {
            return;
        }
        TreeItem[] treeItemArray = new TreeItem[this.selectedItems.length - 1];
        System.arraycopy(this.selectedItems, 0, treeItemArray, 0, n);
        System.arraycopy(this.selectedItems, n + 1, treeItemArray, n, treeItemArray.length - n);
        this.selectedItems = treeItemArray;
    }

    void destroyItem(TreeColumn treeColumn) {
        TreeColumn[] treeColumnArray;
        int n;
        this.headerHideToolTip();
        int n2 = treeColumn.getIndex();
        int n3 = treeColumn.getOrderIndex();
        TreeColumn[] treeColumnArray2 = new TreeColumn[this.columns.length - 1];
        System.arraycopy(this.columns, 0, treeColumnArray2, 0, n2);
        System.arraycopy(this.columns, n2 + 1, treeColumnArray2, n2, treeColumnArray2.length - n2);
        this.columns = treeColumnArray2;
        if (this.orderedColumns != null) {
            if (this.columns.length < 2) {
                this.orderedColumns = null;
            } else {
                n = treeColumn.getOrderIndex();
                treeColumnArray = new TreeColumn[this.orderedColumns.length - 1];
                System.arraycopy(this.orderedColumns, 0, treeColumnArray, 0, n);
                System.arraycopy(this.orderedColumns, n + 1, treeColumnArray, n, treeColumnArray.length - n);
                this.orderedColumns = treeColumnArray;
            }
        }
        if (n3 == 0 && this.columns.length > 0) {
            this.orderedCol0imageWidth = this.columns[this.getColumnOrder()[0]].itemImageWidth;
        }
        n = 0;
        while (n < this.items.length) {
            this.items[n].removeColumn(treeColumn, n2, n3);
            ++n;
        }
        n = this.columns.length - 1;
        if (n < 0) {
            this.updateHorizontalBar();
        } else {
            int n4 = 0;
            int n5 = 0;
            while (n5 < this.columns.length) {
                n4 += this.columns[n5].width;
                ++n5;
            }
            ScrollBar scrollBar = this.getHorizontalBar();
            if (scrollBar != null) {
                scrollBar.setMaximum(n4);
                scrollBar.setVisible(this.clientArea.width < n4);
                int n6 = scrollBar.getSelection();
                if (n6 != this.horizontalOffset) {
                    this.horizontalOffset = n6;
                    this.redraw();
                    if (this.header.isVisible() && this.drawCount <= 0) {
                        this.header.redraw();
                    }
                }
            }
        }
        treeColumnArray = this.getOrderedColumns();
        int n7 = n3;
        while (n7 < treeColumnArray.length) {
            if (!treeColumnArray[n7].isDisposed()) {
                treeColumnArray[n7].sendEvent(10);
            }
            ++n7;
        }
        if (this.sortColumn == treeColumn) {
            this.sortColumn = null;
        }
    }

    void destroyItem(TreeItem treeItem) {
        int n;
        if (treeItem == this.focusItem) {
            this.reassignFocus();
        }
        if ((n = treeItem.availableIndex) != -1) {
            Rectangle rectangle = treeItem.getBounds(false);
            int n2 = rectangle.x + rectangle.width;
            if (n != this.availableItemsCount - 1) {
                System.arraycopy(this.availableItems, n + 1, this.availableItems, n, this.availableItemsCount - n - 1);
                this.availableItems[this.availableItemsCount - 1] = null;
            } else {
                this.availableItems[n] = null;
            }
            --this.availableItemsCount;
            if (this.drawCount <= 0 && this.availableItems.length - this.availableItemsCount == 4) {
                TreeItem[] treeItemArray = new TreeItem[this.availableItemsCount];
                System.arraycopy(this.availableItems, 0, treeItemArray, 0, treeItemArray.length);
                this.availableItems = treeItemArray;
            }
            int n3 = n;
            while (n3 < this.availableItemsCount) {
                this.availableItems[n3].availableIndex = n3;
                ++n3;
            }
            treeItem.availableIndex = -1;
            n3 = this.topIndex;
            this.updateVerticalBar();
            this.updateHorizontalBar(0, -n2);
            if (n < this.topIndex) {
                this.topIndex = n3 - 1;
                ScrollBar scrollBar = this.getVerticalBar();
                if (scrollBar != null) {
                    scrollBar.setSelection(this.topIndex);
                }
            }
        }
        if (treeItem.isSelected()) {
            int n4 = this.getSelectionIndex(treeItem);
            TreeItem[] treeItemArray = new TreeItem[this.selectedItems.length - 1];
            System.arraycopy(this.selectedItems, 0, treeItemArray, 0, n4);
            System.arraycopy(this.selectedItems, n4 + 1, treeItemArray, n4, treeItemArray.length - n4);
            this.selectedItems = treeItemArray;
        }
        if (treeItem.depth == 0) {
            int n5 = treeItem.getIndex();
            TreeItem[] treeItemArray = new TreeItem[this.items.length - 1];
            System.arraycopy(this.items, 0, treeItemArray, 0, n5);
            System.arraycopy(this.items, n5 + 1, treeItemArray, n5, treeItemArray.length - n5);
            this.items = treeItemArray;
        }
        if (treeItem == this.anchorItem) {
            this.anchorItem = null;
        }
        if (treeItem == this.insertMarkItem) {
            this.insertMarkItem = null;
        }
        if (treeItem == this.lastClickedItem) {
            this.lastClickedItem = null;
        }
        if (this.availableItemsCount == 0 && this.isFocusControl()) {
            this.redraw();
            return;
        }
    }

    Image getArrowDownImage() {
        return (Image)this.display.getData(ID_ARROWDOWN);
    }

    Image getArrowUpImage() {
        return (Image)this.display.getData(ID_ARROWUP);
    }

    int getCellPadding() {
        return 2;
    }

    Image getCheckmarkImage() {
        return (Image)this.display.getData(ID_CHECKMARK);
    }

    public Control[] getChildren() {
        this.checkWidget();
        Control[] controlArray = this._getChildren();
        if (this.header == null) {
            return controlArray;
        }
        Control[] controlArray2 = new Control[controlArray.length - 1];
        int n = 0;
        int n2 = 0;
        while (n2 < controlArray.length) {
            if (controlArray[n2] != this.header) {
                controlArray2[n++] = controlArray[n2];
            }
            ++n2;
        }
        return controlArray2;
    }

    Image getCollapsedImage() {
        return (Image)this.display.getData(ID_COLLAPSED);
    }

    public TreeColumn getColumn(int n) {
        this.checkWidget();
        if (n < 0 || n >= this.columns.length) {
            this.error(6);
        }
        return this.columns[n];
    }

    public int getColumnCount() {
        this.checkWidget();
        return this.columns.length;
    }

    public int[] getColumnOrder() {
        this.checkWidget();
        int[] nArray = new int[this.columns.length];
        if (this.orderedColumns != null) {
            int n = 0;
            while (n < nArray.length) {
                nArray[n] = this.orderedColumns[n].getIndex();
                ++n;
            }
        } else {
            int n = 0;
            while (n < this.columns.length) {
                nArray[n] = n;
                ++n;
            }
        }
        return nArray;
    }

    public TreeColumn[] getColumns() {
        this.checkWidget();
        TreeColumn[] treeColumnArray = new TreeColumn[this.columns.length];
        System.arraycopy(this.columns, 0, treeColumnArray, 0, this.columns.length);
        return treeColumnArray;
    }

    Color getConnectorColor() {
        return (Color)this.display.getData(ID_CONNECTOR_COLOR);
    }

    Image getExpandedImage() {
        return (Image)this.display.getData(ID_EXPANDED);
    }

    Image getGrayUncheckedImage() {
        return (Image)this.display.getData(ID_GRAYUNCHECKED);
    }

    public int getGridLineWidth() {
        this.checkWidget();
        return 1;
    }

    public int getHeaderHeight() {
        this.checkWidget();
        if (!this.header.getVisible()) {
            return 0;
        }
        return this.header.getSize().y;
    }

    int getHeaderPadding() {
        return 3;
    }

    public boolean getHeaderVisible() {
        this.checkWidget();
        return this.header.getVisible();
    }

    public TreeItem getItem(Point point) {
        int n;
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        if ((n = (point.y - this.getHeaderHeight()) / this.itemHeight + this.topIndex) < 0 || n >= this.availableItemsCount) {
            return null;
        }
        TreeItem treeItem = this.availableItems[n];
        if (!treeItem.getHitBounds().contains(point)) {
            return null;
        }
        return treeItem;
    }

    public TreeItem getItem(int n) {
        this.checkWidget();
        if (n < 0 || n >= this.items.length) {
            this.error(6);
        }
        return this.items[n];
    }

    public int getItemCount() {
        this.checkWidget();
        return this.items.length;
    }

    public int getItemHeight() {
        this.checkWidget();
        return this.itemHeight;
    }

    public TreeItem[] getItems() {
        this.checkWidget();
        TreeItem[] treeItemArray = new TreeItem[this.items.length];
        System.arraycopy(this.items, 0, treeItemArray, 0, this.items.length);
        return treeItemArray;
    }

    int getItemY(TreeItem treeItem) {
        int n = treeItem.availableIndex;
        if (n == -1) {
            return -1;
        }
        return (n - this.topIndex) * this.itemHeight + this.getHeaderHeight();
    }

    public boolean getLinesVisible() {
        this.checkWidget();
        return this.linesVisible;
    }

    TreeColumn[] getOrderedColumns() {
        if (this.orderedColumns != null) {
            return this.orderedColumns;
        }
        return this.columns;
    }

    public TreeItem getParentItem() {
        this.checkWidget();
        return null;
    }

    public TreeItem[] getSelection() {
        this.checkWidget();
        int n = this.selectedItems.length;
        TreeItem[] treeItemArray = new TreeItem[n];
        if (n > 0) {
            if (n == 1) {
                System.arraycopy(this.selectedItems, 0, treeItemArray, 0, n);
            } else {
                this.getSelection(treeItemArray, this.items, 0);
            }
        }
        return treeItemArray;
    }

    int getSelection(TreeItem[] treeItemArray, TreeItem[] treeItemArray2, int n) {
        int n2 = 0;
        while (n2 < treeItemArray2.length) {
            TreeItem treeItem = treeItemArray2[n2];
            if (treeItem.isSelected()) {
                treeItemArray[n++] = treeItem;
            }
            if (n == treeItemArray.length || (n = this.getSelection(treeItemArray, treeItemArray2[n2].items, n)) == treeItemArray.length) break;
            ++n2;
        }
        return n;
    }

    public int getSelectionCount() {
        this.checkWidget();
        return this.selectedItems.length;
    }

    int getSelectionIndex(TreeItem treeItem) {
        int n = 0;
        while (n < this.selectedItems.length) {
            if (this.selectedItems[n] == treeItem) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public TreeColumn getSortColumn() {
        this.checkWidget();
        return this.sortColumn;
    }

    public int getSortDirection() {
        this.checkWidget();
        return this.sortDirection;
    }

    public TreeItem getTopItem() {
        this.checkWidget();
        if (this.availableItemsCount == 0) {
            return null;
        }
        return this.availableItems[this.topIndex];
    }

    Image getUncheckedImage() {
        return (Image)this.display.getData(ID_UNCHECKED);
    }

    void handleEvents(Event event) {
        switch (event.type) {
            case 9: {
                if (event.widget == this.header) {
                    this.headerOnPaint(event);
                    break;
                }
                this.onPaint(event);
                break;
            }
            case 35: {
                this.notifyListeners(35, event);
                break;
            }
            case 3: {
                if (event.widget == this.header) {
                    this.headerOnMouseDown(event);
                    break;
                }
                this.onMouseDown(event);
                break;
            }
            case 4: {
                if (event.widget == this.header) {
                    this.headerOnMouseUp(event);
                    break;
                }
                this.onMouseUp(event);
                break;
            }
            case 32: {
                this.headerOnMouseHover(event);
                break;
            }
            case 5: {
                this.headerOnMouseMove(event);
                break;
            }
            case 8: {
                if (event.widget == this.header) {
                    this.headerOnMouseDoubleClick(event);
                    break;
                }
                this.onMouseDoubleClick(event);
                break;
            }
            case 7: {
                this.headerOnMouseExit();
                break;
            }
            case 12: {
                this.onDispose(event);
                break;
            }
            case 1: {
                this.onKeyDown(event);
                break;
            }
            case 11: {
                this.onResize(event);
                break;
            }
            case 13: {
                if (event.widget == this.getHorizontalBar()) {
                    this.onScrollHorizontal(event);
                }
                if (event.widget != this.getVerticalBar()) break;
                this.onScrollVertical(event);
                break;
            }
            case 16: {
                this.onFocusOut();
                break;
            }
            case 15: {
                this.onFocusIn();
                break;
            }
            case 31: {
                switch (event.detail) {
                    case 2: 
                    case 4: 
                    case 8: 
                    case 16: 
                    case 256: 
                    case 512: {
                        event.doit = true;
                    }
                }
            }
        }
    }

    String headerGetToolTip(int n) {
        int n2;
        if (this.resizeColumn != null) {
            return null;
        }
        int n3 = this.computeColumnIntersect(n, 0);
        if (n3 == -1) {
            return null;
        }
        TreeColumn[] treeColumnArray = this.getOrderedColumns();
        TreeColumn treeColumn = treeColumnArray[n3];
        if (treeColumn.toolTipText == null) {
            return null;
        }
        int n4 = treeColumn.getX();
        if (n3 > 0 && treeColumnArray[n3 - 1].resizable && n - n4 <= 2) {
            return null;
        }
        if (treeColumn.resizable && (n2 = n4 + treeColumn.width) - n <= 2) {
            return null;
        }
        return this.removeMnemonics(treeColumn.toolTipText);
    }

    void headerHideToolTip() {
        if (this.toolTipShell == null) {
            return;
        }
        int n = 0;
        while (n < toolTipEvents.length) {
            this.header.removeListener(toolTipEvents[n], this.toolTipListener);
            ++n;
        }
        this.toolTipShell.dispose();
        this.toolTipShell = null;
        this.toolTipLabel = null;
    }

    void headerOnMouseDoubleClick(Event event) {
        if (!this.isFocusControl()) {
            this.setFocus();
        }
        if (this.columns.length == 0) {
            return;
        }
        TreeColumn[] treeColumnArray = this.getOrderedColumns();
        int n = -this.horizontalOffset;
        int n2 = 0;
        while (n2 < treeColumnArray.length) {
            TreeColumn treeColumn = treeColumnArray[n2];
            if (event.x < (n += treeColumn.width)) {
                TreeColumn treeColumn2 = null;
                if (n - event.x <= 2) {
                    treeColumn2 = treeColumn;
                } else if (n2 > 0 && event.x - treeColumn.getX() <= 2) {
                    treeColumn2 = treeColumnArray[n2 - 1];
                }
                if (treeColumn2 != null) {
                    treeColumn2.pack();
                    this.resizeColumn = null;
                    if (Math.abs(treeColumn2.getX() + treeColumn2.width - event.x) > 2) {
                        this.setCursor(null);
                    }
                    return;
                }
                Event event2 = new Event();
                event2.widget = treeColumn;
                treeColumn.postEvent(14, event2);
                return;
            }
            ++n2;
        }
    }

    void headerOnMouseDown(Event event) {
        if (event.button != 1) {
            return;
        }
        TreeColumn[] treeColumnArray = this.getOrderedColumns();
        int n = -this.horizontalOffset;
        int n2 = 0;
        while (n2 < treeColumnArray.length) {
            TreeColumn treeColumn = treeColumnArray[n2];
            if (treeColumn.resizable && Math.abs((n += treeColumn.width) - event.x) <= 2) {
                this.resizeColumn = treeColumn;
                this.resizeColumnX = n;
                return;
            }
            if (event.x < n) {
                if (treeColumn.moveable) {
                    int n3 = treeColumn.getX();
                    int n4 = event.x - n3;
                    this.headerHideToolTip();
                    Tracker tracker = new Tracker(this, 0);
                    tracker.setRectangles(new Rectangle[]{new Rectangle(n3, 0, treeColumn.width, this.getHeaderHeight())});
                    if (!tracker.open()) {
                        return;
                    }
                    Rectangle rectangle = tracker.getRectangles()[0];
                    int n5 = rectangle.x + n4;
                    if (n5 < 0) {
                        return;
                    }
                    n = -this.horizontalOffset;
                    int n6 = 0;
                    while (n6 < treeColumnArray.length) {
                        TreeColumn treeColumn2 = treeColumnArray[n6];
                        if (n5 < (n += treeColumn2.width)) {
                            int n7 = treeColumn.getOrderIndex();
                            if (n6 == n7) {
                                Event event2 = new Event();
                                event2.widget = treeColumn;
                                treeColumn.postEvent(13, event2);
                                return;
                            }
                            int n8 = Math.min(n6, n7);
                            int[] nArray = this.getColumnOrder();
                            int[] nArray2 = new int[nArray.length];
                            System.arraycopy(nArray, 0, nArray2, 0, n8);
                            if (n8 == n7) {
                                System.arraycopy(nArray, n7 + 1, nArray2, n7, n6 - n7);
                            } else {
                                System.arraycopy(nArray, n6, nArray2, n6 + 1, n7 - n6);
                            }
                            nArray2[n6] = nArray[n7];
                            int n9 = Math.max(n6, n7);
                            System.arraycopy(nArray, n9 + 1, nArray2, n9 + 1, nArray2.length - n9 - 1);
                            this.setColumnOrder(nArray2);
                            return;
                        }
                        ++n6;
                    }
                    return;
                }
                Event event3 = new Event();
                event3.widget = treeColumn;
                treeColumn.postEvent(13, event3);
                return;
            }
            ++n2;
        }
    }

    void headerOnMouseExit() {
        if (this.resizeColumn != null) {
            return;
        }
        this.setCursor(null);
    }

    void headerOnMouseHover(Event event) {
        this.headerShowToolTip(event.x);
    }

    void headerOnMouseMove(Event event) {
        if (this.resizeColumn == null) {
            int n = 0;
            while (n < this.columns.length) {
                TreeColumn treeColumn = this.columns[n];
                int n2 = treeColumn.getX() + treeColumn.width;
                if (Math.abs(n2 - event.x) <= 2) {
                    if (treeColumn.resizable) {
                        this.setCursor(this.display.getSystemCursor(9));
                    } else {
                        this.setCursor(null);
                    }
                    return;
                }
                ++n;
            }
            this.setCursor(null);
            return;
        }
        if (event.x <= this.resizeColumn.getX()) {
            return;
        }
        GC gC = new GC(this);
        gC.setForeground(this.display.getSystemColor(2));
        int n = this.clientArea.height;
        this.redraw(this.resizeColumnX - 1, 0, 1, n, false);
        this.resizeColumnX = event.x;
        gC.drawLine(this.resizeColumnX - 1, 0, this.resizeColumnX - 1, n);
        gC.dispose();
    }

    void headerOnMouseUp(Event event) {
        if (this.resizeColumn == null) {
            return;
        }
        GC gC = new GC(this);
        this.redraw(this.resizeColumnX - 1, 0, 1, this.clientArea.height, false);
        gC.dispose();
        int n = this.resizeColumnX - this.resizeColumn.getX();
        if (n != this.resizeColumn.width) {
            this.setCursor(null);
            this.updateColumnWidth(this.resizeColumn, n);
        }
        this.resizeColumnX = -1;
        this.resizeColumn = null;
    }

    void headerOnPaint(Event event) {
        TreeColumn[] treeColumnArray = this.getOrderedColumns();
        int n = treeColumnArray.length;
        GC gC = event.gc;
        Rectangle rectangle = gC.getClipping();
        int n2 = -1;
        int n3 = -1;
        if (n > 0) {
            n2 = this.computeColumnIntersect(rectangle.x, 0);
            if (n2 != -1 && (n3 = this.computeColumnIntersect(rectangle.x + rectangle.width, n2)) == -1) {
                n3 = n - 1;
            }
        } else {
            n3 = 0;
            n2 = 0;
        }
        Point point = this.header.getSize();
        this.headerPaintHShadows(gC, 0, 0, point.x, point.y);
        if (n2 == -1) {
            return;
        }
        if (n == 0) {
            return;
        }
        int n4 = n2;
        while (n4 <= n3) {
            this.headerPaintVShadows(gC, treeColumnArray[n4].getX(), 0, treeColumnArray[n4].width, point.y);
            treeColumnArray[n4].paint(gC);
            ++n4;
        }
    }

    void headerPaintHShadows(GC gC, int n, int n2, int n3, int n4) {
        gC.setClipping(n, n2, n3, n4);
        int n5 = n + n3;
        gC.setForeground(this.display.getSystemColor(20));
        gC.drawLine(n, n2, n5, n2);
        gC.setForeground(this.display.getSystemColor(18));
        gC.drawLine(n, n4 - 2, n5, n4 - 2);
        gC.setForeground(this.display.getSystemColor(17));
        gC.drawLine(n, n4 - 1, n5, n4 - 1);
    }

    void headerPaintVShadows(GC gC, int n, int n2, int n3, int n4) {
        gC.setClipping(n, n2, n3, n4);
        int n5 = n + n3;
        gC.setForeground(this.display.getSystemColor(20));
        gC.drawLine(n, n2, n, n2 + n4 - 1);
        gC.setForeground(this.display.getSystemColor(18));
        gC.drawLine(n5 - 2, n2 + 1, n5 - 2, n4 - 2);
        gC.setForeground(this.display.getSystemColor(17));
        gC.drawLine(n5 - 1, n2, n5 - 1, n4 - 1);
    }

    void headerShowToolTip(int n) {
        String string = this.headerGetToolTip(n);
        if (string == null || string.length() == 0) {
            return;
        }
        if (this.toolTipShell == null) {
            this.toolTipShell = new Shell(this.getShell(), 16388);
            this.toolTipLabel = new Label(this.toolTipShell, 0x1000000);
            Display display = this.toolTipShell.getDisplay();
            this.toolTipLabel.setForeground(display.getSystemColor(28));
            this.toolTipLabel.setBackground(display.getSystemColor(29));
            int n2 = 0;
            while (n2 < toolTipEvents.length) {
                this.header.addListener(toolTipEvents[n2], this.toolTipListener);
                ++n2;
            }
        }
        if (this.headerUpdateToolTip(n)) {
            this.toolTipShell.setVisible(true);
        } else {
            this.headerHideToolTip();
        }
    }

    boolean headerUpdateToolTip(int n) {
        String string = this.headerGetToolTip(n);
        if (string == null || string.length() == 0) {
            return false;
        }
        if (string.equals(this.toolTipLabel.getText())) {
            return true;
        }
        this.toolTipLabel.setText(string);
        TreeColumn treeColumn = this.getOrderedColumns()[this.computeColumnIntersect(n, 0)];
        this.toolTipShell.setData(new Integer(treeColumn.getIndex()));
        Point point = this.toolTipLabel.computeSize(-1, -1, true);
        point.x += 2;
        point.y += 2;
        this.toolTipLabel.setSize(point);
        this.toolTipShell.pack();
        Rectangle rectangle = this.toolTipShell.getClientArea();
        this.toolTipLabel.setSize(rectangle.width, rectangle.height);
        Point point2 = this.getDisplay().getCursorLocation();
        int n2 = 21;
        Point point3 = this.toolTipShell.getSize();
        Rectangle rectangle2 = this.getMonitor().getBounds();
        Point point4 = new Point(point2.x, point2.y + n2 + 2);
        point4.x = Math.max(point4.x, rectangle2.x);
        if (point4.x + point3.x > rectangle2.x + rectangle2.width) {
            point4.x = rectangle2.x + rectangle2.width - point3.x;
        }
        if (point4.y + point3.y > rectangle2.y + rectangle2.height) {
            point4.y = point2.y - 2 - point3.y;
        }
        this.toolTipShell.setLocation(point4);
        return true;
    }

    public int indexOf(TreeColumn treeColumn) {
        this.checkWidget();
        if (treeColumn == null) {
            this.error(4);
        }
        if (treeColumn.isDisposed()) {
            this.error(5);
        }
        return treeColumn.getIndex();
    }

    public int indexOf(TreeItem treeItem) {
        this.checkWidget();
        if (treeItem == null) {
            this.error(4);
        }
        if (treeItem.isDisposed()) {
            this.error(5);
        }
        if (treeItem.parentItem != null || treeItem.parent != this) {
            return -1;
        }
        return treeItem.getIndex();
    }

    static void initImages(final Display display) {
        ImageData imageData;
        PaletteData paletteData;
        Object object;
        Object object2;
        PaletteData paletteData2 = new PaletteData(new RGB[]{new RGB(0, 0, 0), new RGB(128, 0, 0), new RGB(0, 128, 0), new RGB(128, 128, 0), new RGB(0, 0, 128), new RGB(128, 0, 128), new RGB(0, 128, 128), new RGB(128, 128, 128), new RGB(192, 192, 192), new RGB(255, 0, 0), new RGB(0, 255, 0), new RGB(255, 255, 0), new RGB(0, 0, 255), new RGB(255, 0, 255), new RGB(0, 255, 255), new RGB(255, 255, 255)});
        if (display.getData(ID_EXPANDED) == null) {
            byte[] byArray = new byte[72];
            byArray[0] = 119;
            byArray[1] = 119;
            byArray[2] = 119;
            byArray[3] = 119;
            byArray[4] = 112;
            byArray[8] = 127;
            byArray[9] = -1;
            byArray[10] = -1;
            byArray[11] = -1;
            byArray[12] = 112;
            byArray[16] = 127;
            byArray[17] = -1;
            byArray[18] = -1;
            byArray[19] = -1;
            byArray[20] = 112;
            byArray[24] = 127;
            byArray[25] = -1;
            byArray[26] = -1;
            byArray[27] = -1;
            byArray[28] = 112;
            byArray[32] = 127;
            byArray[35] = 15;
            byArray[36] = 112;
            byArray[40] = 127;
            byArray[41] = -1;
            byArray[42] = -1;
            byArray[43] = -1;
            byArray[44] = 112;
            byArray[48] = 127;
            byArray[49] = -1;
            byArray[50] = -1;
            byArray[51] = -1;
            byArray[52] = 112;
            byArray[56] = 127;
            byArray[57] = -1;
            byArray[58] = -1;
            byArray[59] = -1;
            byArray[60] = 112;
            byArray[64] = 119;
            byArray[65] = 119;
            byArray[66] = 119;
            byArray[67] = 119;
            byArray[68] = 112;
            object2 = new ImageData(9, 9, 4, paletteData2, 4, byArray);
            ((ImageData)object2).transparentPixel = 15;
            display.setData(ID_EXPANDED, new Image((Device)display, (ImageData)object2));
        }
        if (display.getData(ID_COLLAPSED) == null) {
            byte[] byArray = new byte[72];
            byArray[0] = 119;
            byArray[1] = 119;
            byArray[2] = 119;
            byArray[3] = 119;
            byArray[4] = 112;
            byArray[8] = 127;
            byArray[9] = -1;
            byArray[10] = -1;
            byArray[11] = -1;
            byArray[12] = 112;
            byArray[16] = 127;
            byArray[17] = -1;
            byArray[18] = 15;
            byArray[19] = -1;
            byArray[20] = 112;
            byArray[24] = 127;
            byArray[25] = -1;
            byArray[26] = 15;
            byArray[27] = -1;
            byArray[28] = 112;
            byArray[32] = 127;
            byArray[35] = 15;
            byArray[36] = 112;
            byArray[40] = 127;
            byArray[41] = -1;
            byArray[42] = 15;
            byArray[43] = -1;
            byArray[44] = 112;
            byArray[48] = 127;
            byArray[49] = -1;
            byArray[50] = 15;
            byArray[51] = -1;
            byArray[52] = 112;
            byArray[56] = 127;
            byArray[57] = -1;
            byArray[58] = -1;
            byArray[59] = -1;
            byArray[60] = 112;
            byArray[64] = 119;
            byArray[65] = 119;
            byArray[66] = 119;
            byArray[67] = 119;
            byArray[68] = 112;
            object2 = new ImageData(9, 9, 4, paletteData2, 4, byArray);
            ((ImageData)object2).transparentPixel = 15;
            display.setData(ID_COLLAPSED, new Image((Device)display, (ImageData)object2));
        }
        object2 = new PaletteData(new RGB[]{new RGB(0, 0, 0), new RGB(255, 255, 255)});
        if (display.getData(ID_ARROWDOWN) == null) {
            byte[] byArray = new byte[4];
            byArray[1] = -125;
            byArray[2] = -57;
            byArray[3] = -17;
            object = new ImageData(7, 4, 1, (PaletteData)object2, 1, byArray);
            ((ImageData)object).transparentPixel = 1;
            display.setData(ID_ARROWDOWN, new Image((Device)display, (ImageData)object));
        }
        if (display.getData(ID_ARROWUP) == null) {
            byte[] byArray = new byte[4];
            byArray[0] = -17;
            byArray[1] = -57;
            byArray[2] = -125;
            object = new ImageData(7, 4, 1, (PaletteData)object2, 1, byArray);
            ((ImageData)object).transparentPixel = 1;
            display.setData(ID_ARROWUP, new Image((Device)display, (ImageData)object));
        }
        object = new PaletteData(new RGB[]{new RGB(0, 0, 0), new RGB(252, 3, 251)});
        byte[] byArray = new byte[22];
        byArray[2] = 127;
        byArray[3] = -64;
        byArray[4] = 127;
        byArray[5] = -64;
        byArray[6] = 127;
        byArray[7] = -64;
        byArray[8] = 127;
        byArray[9] = -64;
        byArray[10] = 127;
        byArray[11] = -64;
        byArray[12] = 127;
        byArray[13] = -64;
        byArray[14] = 127;
        byArray[15] = -64;
        byArray[16] = 127;
        byArray[17] = -64;
        byArray[18] = 127;
        byArray[19] = -64;
        byte[] byArray2 = byArray;
        ImageData imageData2 = new ImageData(7, 7, 1, (PaletteData)object, 1, new byte[]{-4, -8, 112, 34, 6, -114, -34});
        imageData2.transparentPixel = 1;
        if (display.getData(ID_CHECKMARK) == null) {
            display.setData(ID_CHECKMARK, new Image((Device)display, imageData2));
        }
        if (display.getData(ID_UNCHECKED) == null) {
            paletteData = new PaletteData(new RGB[]{new RGB(128, 128, 128), new RGB(255, 255, 255)});
            imageData = new ImageData(11, 11, 1, paletteData, 2, byArray2);
            display.setData(ID_UNCHECKED, new Image((Device)display, imageData));
        }
        if (display.getData(ID_GRAYUNCHECKED) == null) {
            paletteData = new PaletteData(new RGB[]{new RGB(128, 128, 128), new RGB(192, 192, 192)});
            imageData = new ImageData(11, 11, 1, paletteData, 2, byArray2);
            display.setData(ID_GRAYUNCHECKED, new Image((Device)display, imageData));
        }
        if (display.getData(ID_CONNECTOR_COLOR) == null) {
            display.setData(ID_CONNECTOR_COLOR, new Color(display, 170, 170, 170));
        }
        display.disposeExec(new Runnable(){

            public void run() {
                Image image;
                Image image2;
                Image image3;
                Image image4;
                Image image5;
                Color color;
                Image image6;
                Image image7 = (Image)display.getData(Tree.ID_EXPANDED);
                if (image7 != null) {
                    image7.dispose();
                }
                if ((image6 = (Image)display.getData(Tree.ID_COLLAPSED)) != null) {
                    image6.dispose();
                }
                if ((color = (Color)display.getData(Tree.ID_CONNECTOR_COLOR)) != null) {
                    color.dispose();
                }
                if ((image5 = (Image)display.getData(Tree.ID_UNCHECKED)) != null) {
                    image5.dispose();
                }
                if ((image4 = (Image)display.getData(Tree.ID_GRAYUNCHECKED)) != null) {
                    image4.dispose();
                }
                if ((image3 = (Image)display.getData(Tree.ID_CHECKMARK)) != null) {
                    image3.dispose();
                }
                if ((image2 = (Image)display.getData(Tree.ID_ARROWDOWN)) != null) {
                    image2.dispose();
                }
                if ((image = (Image)display.getData(Tree.ID_ARROWUP)) != null) {
                    image.dispose();
                }
                display.setData(Tree.ID_EXPANDED, null);
                display.setData(Tree.ID_COLLAPSED, null);
                display.setData(Tree.ID_CONNECTOR_COLOR, null);
                display.setData(Tree.ID_UNCHECKED, null);
                display.setData(Tree.ID_GRAYUNCHECKED, null);
                display.setData(Tree.ID_CHECKMARK, null);
                display.setData(Tree.ID_ARROWDOWN, null);
                display.setData(Tree.ID_ARROWUP, null);
            }
        });
    }

    void makeAvailable(TreeItem treeItem) {
        TreeItem[] treeItemArray;
        int n;
        int n2 = treeItem.parentItem.items.length;
        int n3 = 0;
        if (n2 == 1) {
            n3 = treeItem.parentItem.availableIndex + 1;
        } else {
            n = 0;
            treeItemArray = treeItem.parentItem.items;
            int n4 = 0;
            while (n4 < treeItemArray.length) {
                if (treeItemArray[n4] == treeItem) {
                    n = n4;
                    break;
                }
                ++n4;
            }
            if (n != n2 - 1) {
                n3 = treeItemArray[n + 1].availableIndex;
            } else {
                TreeItem treeItem2 = treeItemArray[n - 1];
                n3 = treeItem2.availableIndex + treeItem2.computeAvailableDescendentCount();
            }
        }
        if (this.availableItemsCount == this.availableItems.length) {
            n = this.drawCount <= 0 ? 4 : Math.max(4, this.availableItems.length * 3 / 2);
            treeItemArray = new TreeItem[this.availableItems.length + n];
            System.arraycopy(this.availableItems, 0, treeItemArray, 0, this.availableItems.length);
            this.availableItems = treeItemArray;
        }
        if (n3 != this.availableItemsCount) {
            System.arraycopy(this.availableItems, n3, this.availableItems, n3 + 1, this.availableItemsCount - n3);
        }
        this.availableItems[n3] = treeItem;
        ++this.availableItemsCount;
        n = n3;
        while (n < this.availableItemsCount) {
            this.availableItems[n].availableIndex = n;
            ++n;
        }
    }

    void makeDescendentsAvailable(TreeItem treeItem, TreeItem[] treeItemArray) {
        int n = treeItem.availableIndex;
        TreeItem[] treeItemArray2 = new TreeItem[this.availableItemsCount + treeItemArray.length - 1];
        System.arraycopy(this.availableItems, 0, treeItemArray2, 0, n);
        System.arraycopy(treeItemArray, 0, treeItemArray2, n, treeItemArray.length);
        int n2 = n + 1;
        System.arraycopy(this.availableItems, n2, treeItemArray2, n + treeItemArray.length, this.availableItemsCount - n2);
        this.availableItems = treeItemArray2;
        this.availableItemsCount = this.availableItems.length;
        int n3 = n;
        while (n3 < this.availableItemsCount) {
            this.availableItems[n3].availableIndex = n3;
            ++n3;
        }
    }

    void makeDescendentsUnavailable(TreeItem treeItem, TreeItem[] treeItemArray) {
        int n = treeItemArray.length;
        TreeItem[] treeItemArray2 = new TreeItem[this.availableItemsCount - n + 1];
        System.arraycopy(this.availableItems, 0, treeItemArray2, 0, treeItem.availableIndex + 1);
        int n2 = treeItem.availableIndex + n;
        System.arraycopy(this.availableItems, n2, treeItemArray2, treeItem.availableIndex + 1, this.availableItemsCount - n2);
        this.availableItems = treeItemArray2;
        this.availableItemsCount = this.availableItems.length;
        int n3 = 1;
        while (n3 < treeItemArray.length) {
            treeItemArray[n3].availableIndex = -1;
            ++n3;
        }
        n3 = treeItem.availableIndex;
        while (n3 < this.availableItemsCount) {
            this.availableItems[n3].availableIndex = n3;
            ++n3;
        }
        n3 = this.selectedItems.length - 1;
        while (n3 >= 0) {
            if (this.selectedItems[n3] != treeItem && this.selectedItems[n3].hasAncestor(treeItem)) {
                this.removeSelectedItem(n3);
            }
            --n3;
        }
        if (this.anchorItem != null && this.anchorItem != treeItem && this.anchorItem.hasAncestor(treeItem)) {
            this.anchorItem = null;
        }
    }

    void onArrowDown(int n) {
        if ((n & 0x60000) == 0) {
            int n2 = this.focusItem.availableIndex + 1;
            if (n2 == this.availableItemsCount) {
                return;
            }
            this.selectItem(this.availableItems[n2], false);
            this.setFocusItem(this.availableItems[n2], true);
            this.redrawItem(n2, true);
            this.showItem(this.availableItems[n2]);
            Event event = new Event();
            event.item = this.availableItems[n2];
            this.postEvent(13, event);
            return;
        }
        if ((this.style & 4) != 0) {
            if ((n & 0x40000) != 0) {
                int n3 = (this.clientArea.height - this.getHeaderHeight()) / this.itemHeight;
                if (this.availableItemsCount <= this.topIndex + n3) {
                    return;
                }
                this.update();
                ++this.topIndex;
                ScrollBar scrollBar = this.getVerticalBar();
                if (scrollBar != null) {
                    scrollBar.setSelection(this.topIndex);
                }
                GC gC = new GC(this);
                gC.copyArea(0, 0, this.clientArea.width, this.clientArea.height, 0, -this.itemHeight);
                gC.dispose();
                return;
            }
            int n4 = this.focusItem.availableIndex + 1;
            if (n4 == this.availableItemsCount) {
                return;
            }
            this.selectItem(this.availableItems[n4], false);
            this.setFocusItem(this.availableItems[n4], true);
            this.redrawItem(n4, true);
            this.showItem(this.availableItems[n4]);
            Event event = new Event();
            event.item = this.availableItems[n4];
            this.postEvent(13, event);
            return;
        }
        if ((n & 0x40000) != 0) {
            if ((n & 0x20000) != 0) {
                int n5 = (this.clientArea.height - this.getHeaderHeight()) / this.itemHeight;
                if (this.availableItemsCount <= this.topIndex + n5) {
                    return;
                }
                this.update();
                ++this.topIndex;
                ScrollBar scrollBar = this.getVerticalBar();
                if (scrollBar != null) {
                    scrollBar.setSelection(this.topIndex);
                }
                GC gC = new GC(this);
                gC.copyArea(0, 0, this.clientArea.width, this.clientArea.height, 0, -this.itemHeight);
                gC.dispose();
                return;
            }
            int n6 = this.focusItem.availableIndex;
            if (n6 == this.availableItemsCount - 1) {
                return;
            }
            TreeItem treeItem = this.availableItems[n6 + 1];
            this.setFocusItem(treeItem, true);
            this.redrawItem(treeItem.availableIndex, true);
            this.showItem(treeItem);
            return;
        }
        int n7 = this.focusItem.availableIndex + 1;
        if (n7 == this.availableItemsCount) {
            return;
        }
        if (this.anchorItem == null) {
            this.anchorItem = this.focusItem;
        }
        if (this.focusItem.availableIndex < this.anchorItem.availableIndex) {
            this.deselectItem(this.focusItem);
            this.redrawItem(this.focusItem.availableIndex, true);
        }
        this.selectItem(this.availableItems[n7], true);
        this.setFocusItem(this.availableItems[n7], true);
        this.redrawItem(n7, true);
        this.showItem(this.availableItems[n7]);
        Event event = new Event();
        event.item = this.availableItems[n7];
        this.postEvent(13, event);
    }

    void onArrowLeft(int n) {
        if ((n & 0x40000) != 0) {
            Object object;
            if (this.horizontalOffset == 0) {
                return;
            }
            int n2 = Math.max(0, this.horizontalOffset - 5);
            this.update();
            GC gC = new GC(this);
            gC.copyArea(0, 0, this.clientArea.width, this.clientArea.height, this.horizontalOffset - n2, 0);
            gC.dispose();
            if (this.header.getVisible()) {
                this.header.update();
                object = this.header.getClientArea();
                gC = new GC(this.header);
                gC.copyArea(0, 0, ((Rectangle)object).width, ((Rectangle)object).height, this.horizontalOffset - n2, 0);
                gC.dispose();
            }
            this.horizontalOffset = n2;
            object = this.getHorizontalBar();
            if (object != null) {
                ((ScrollBar)object).setSelection(this.horizontalOffset);
            }
            return;
        }
        if (this.focusItem.expanded) {
            this.focusItem.setExpanded(false);
            Event event = new Event();
            event.item = this.focusItem;
            this.sendEvent(18, event);
            return;
        }
        TreeItem treeItem = this.focusItem.parentItem;
        if (treeItem == null) {
            return;
        }
        this.selectItem(treeItem, false);
        this.setFocusItem(treeItem, true);
        this.redrawItem(treeItem.availableIndex, true);
        this.showItem(treeItem);
        Event event = new Event();
        event.item = treeItem;
        this.postEvent(13, event);
    }

    void onArrowRight(int n) {
        if ((n & 0x40000) != 0) {
            ScrollBar scrollBar = this.getHorizontalBar();
            if (scrollBar != null) {
                int n2 = this.clientArea.width;
                int n3 = scrollBar.getMaximum();
                if (this.horizontalOffset + n2 == n3) {
                    return;
                }
                if (n3 <= n2) {
                    return;
                }
                int n4 = Math.min(this.horizontalOffset + 5, n3 - n2);
                this.update();
                GC gC = new GC(this);
                gC.copyArea(0, 0, this.clientArea.width, this.clientArea.height, this.horizontalOffset - n4, 0);
                gC.dispose();
                if (this.header.getVisible()) {
                    Rectangle rectangle = this.header.getClientArea();
                    this.header.update();
                    gC = new GC(this.header);
                    gC.copyArea(0, 0, rectangle.width, rectangle.height, this.horizontalOffset - n4, 0);
                    gC.dispose();
                }
                this.horizontalOffset = n4;
                scrollBar.setSelection(this.horizontalOffset);
            }
            return;
        }
        TreeItem[] treeItemArray = this.focusItem.items;
        if (treeItemArray.length == 0) {
            return;
        }
        if (!this.focusItem.expanded) {
            this.focusItem.setExpanded(true);
            Event event = new Event();
            event.item = this.focusItem;
            this.inExpand = true;
            this.sendEvent(17, event);
            this.inExpand = false;
            if (this.isDisposed()) {
                return;
            }
            if (this.focusItem.items.length == 0) {
                this.focusItem.expanded = false;
            }
            return;
        }
        this.selectItem(treeItemArray[0], false);
        this.setFocusItem(treeItemArray[0], true);
        this.redrawItem(treeItemArray[0].availableIndex, true);
        this.showItem(treeItemArray[0]);
        Event event = new Event();
        event.item = treeItemArray[0];
        this.postEvent(13, event);
    }

    void onArrowUp(int n) {
        if ((n & 0x60000) == 0) {
            int n2 = this.focusItem.availableIndex - 1;
            if (n2 < 0) {
                return;
            }
            TreeItem treeItem = this.availableItems[n2];
            this.selectItem(treeItem, false);
            this.setFocusItem(treeItem, true);
            this.redrawItem(n2, true);
            this.showItem(treeItem);
            Event event = new Event();
            event.item = treeItem;
            this.postEvent(13, event);
            return;
        }
        if ((this.style & 4) != 0) {
            if ((n & 0x40000) != 0) {
                if (this.topIndex == 0) {
                    return;
                }
                this.update();
                --this.topIndex;
                ScrollBar scrollBar = this.getVerticalBar();
                if (scrollBar != null) {
                    scrollBar.setSelection(this.topIndex);
                }
                GC gC = new GC(this);
                gC.copyArea(0, 0, this.clientArea.width, this.clientArea.height, 0, this.itemHeight);
                gC.dispose();
                return;
            }
            int n3 = this.focusItem.availableIndex - 1;
            if (n3 < 0) {
                return;
            }
            TreeItem treeItem = this.availableItems[n3];
            this.selectItem(treeItem, false);
            this.setFocusItem(treeItem, true);
            this.redrawItem(n3, true);
            this.showItem(treeItem);
            Event event = new Event();
            event.item = treeItem;
            this.postEvent(13, event);
            return;
        }
        if ((n & 0x40000) != 0) {
            if ((n & 0x20000) != 0) {
                if (this.topIndex == 0) {
                    return;
                }
                this.update();
                --this.topIndex;
                ScrollBar scrollBar = this.getVerticalBar();
                if (scrollBar != null) {
                    scrollBar.setSelection(this.topIndex);
                }
                GC gC = new GC(this);
                gC.copyArea(0, 0, this.clientArea.width, this.clientArea.height, 0, this.itemHeight);
                gC.dispose();
                return;
            }
            int n4 = this.focusItem.availableIndex;
            if (n4 == 0) {
                return;
            }
            TreeItem treeItem = this.availableItems[n4 - 1];
            this.setFocusItem(treeItem, true);
            this.showItem(treeItem);
            this.redrawItem(treeItem.availableIndex, true);
            return;
        }
        int n5 = this.focusItem.availableIndex - 1;
        if (n5 < 0) {
            return;
        }
        if (this.anchorItem == null) {
            this.anchorItem = this.focusItem;
        }
        if (this.anchorItem.availableIndex < this.focusItem.availableIndex) {
            this.deselectItem(this.focusItem);
            this.redrawItem(this.focusItem.availableIndex, true);
        }
        TreeItem treeItem = this.availableItems[n5];
        this.selectItem(treeItem, true);
        this.setFocusItem(treeItem, true);
        this.redrawItem(n5, true);
        this.showItem(treeItem);
        Event event = new Event();
        event.item = treeItem;
        this.postEvent(13, event);
    }

    void onCR() {
        if (this.focusItem == null) {
            return;
        }
        Event event = new Event();
        event.item = this.focusItem;
        this.postEvent(14, event);
    }

    void onDispose(Event event) {
        if (this.isDisposed()) {
            return;
        }
        if (this.ignoreDispose) {
            return;
        }
        this.ignoreDispose = true;
        this.notifyListeners(12, event);
        event.type = 0;
        int n = 0;
        while (n < this.items.length) {
            this.items[n].dispose(false);
            ++n;
        }
        n = 0;
        while (n < this.columns.length) {
            this.columns[n].dispose(false);
            ++n;
        }
        if (this.toolTipShell != null) {
            this.toolTipShell.dispose();
            this.toolTipShell = null;
            this.toolTipLabel = null;
        }
        this.toolTipListener = null;
        this.horizontalOffset = 0;
        this.availableItemsCount = 0;
        this.topIndex = 0;
        this.selectedItems = null;
        this.items = null;
        this.availableItems = null;
        this.orderedColumns = null;
        this.columns = null;
        this.lastClickedItem = null;
        this.insertMarkItem = null;
        this.anchorItem = null;
        this.focusItem = null;
        this.lastSelectionEvent = null;
        this.header = null;
        this.sortColumn = null;
        this.resizeColumn = null;
        this.expanderBounds = null;
    }

    void onEnd(int n) {
        TreeItem treeItem;
        int n2 = this.availableItemsCount - 1;
        if ((n & 0x60000) == 0) {
            if (this.focusItem.availableIndex == n2) {
                return;
            }
            TreeItem treeItem2 = this.availableItems[n2];
            this.selectItem(treeItem2, false);
            this.setFocusItem(treeItem2, true);
            this.redrawItem(n2, true);
            this.showItem(treeItem2);
            Event event = new Event();
            event.item = treeItem2;
            this.postEvent(13, event);
            return;
        }
        if ((this.style & 4) != 0) {
            if ((n & 0x40000) != 0) {
                int n3 = (this.clientArea.height - this.getHeaderHeight()) / this.itemHeight;
                this.setTopItem(this.availableItems[this.availableItemsCount - n3]);
                return;
            }
            if (this.focusItem.availableIndex == n2) {
                return;
            }
            TreeItem treeItem3 = this.availableItems[n2];
            this.selectItem(treeItem3, false);
            this.setFocusItem(treeItem3, true);
            this.redrawItem(n2, true);
            this.showItem(treeItem3);
            Event event = new Event();
            event.item = treeItem3;
            this.postEvent(13, event);
            return;
        }
        if ((n & 0x40000) != 0) {
            if ((n & 0x20000) != 0) {
                this.showItem(this.availableItems[n2]);
                return;
            }
            if (this.focusItem.availableIndex == n2) {
                return;
            }
            TreeItem treeItem4 = this.availableItems[n2];
            this.setFocusItem(treeItem4, true);
            this.showItem(treeItem4);
            this.redrawItem(treeItem4.availableIndex, true);
            return;
        }
        if (this.anchorItem == null) {
            this.anchorItem = this.focusItem;
        }
        if ((treeItem = this.availableItems[n2]) == this.focusItem && treeItem.isSelected()) {
            return;
        }
        int n4 = this.anchorItem.availableIndex;
        int n5 = treeItem.availableIndex;
        TreeItem[] treeItemArray = new TreeItem[n5 - n4 + 1];
        int n6 = 0;
        int n7 = n4;
        while (n7 <= n5) {
            treeItemArray[n6++] = this.availableItems[n7];
            ++n7;
        }
        this.setSelection(treeItemArray, false);
        this.setFocusItem(treeItem, true);
        this.redrawItems(n4, n5, true);
        this.showItem(treeItem);
        Event event = new Event();
        event.item = treeItem;
        this.postEvent(13, event);
    }

    void onFocusIn() {
        this.hasFocus = true;
        if (this.items.length == 0) {
            this.redraw();
            return;
        }
        if (this.focusItem != null) {
            this.redrawItem(this.focusItem.availableIndex, true);
            return;
        }
        TreeItem treeItem = null;
        if (this.selectedItems.length > 0) {
            int n = 0;
            while (n < this.selectedItems.length && treeItem == null) {
                if (this.selectedItems[n].isAvailable()) {
                    treeItem = this.selectedItems[n];
                }
                ++n;
            }
            if (treeItem == null) {
                treeItem = this.availableItems[this.topIndex];
            }
        } else {
            treeItem = this.availableItems[this.topIndex];
        }
        this.setFocusItem(treeItem, false);
        this.redrawItem(treeItem.availableIndex, true);
    }

    void onFocusOut() {
        this.hasFocus = false;
        if (this.items.length == 0) {
            this.redraw();
            return;
        }
        if (this.focusItem != null) {
            this.redrawItem(this.focusItem.availableIndex, true);
        }
    }

    void onHome(int n) {
        TreeItem treeItem;
        if ((n & 0x60000) == 0) {
            if (this.focusItem.availableIndex == 0) {
                return;
            }
            TreeItem treeItem2 = this.availableItems[0];
            this.selectItem(treeItem2, false);
            this.setFocusItem(treeItem2, true);
            this.redrawItem(0, true);
            this.showItem(treeItem2);
            Event event = new Event();
            event.item = treeItem2;
            this.postEvent(13, event);
            return;
        }
        if ((this.style & 4) != 0) {
            if ((n & 0x40000) != 0) {
                this.setTopItem(this.availableItems[0]);
                return;
            }
            if (this.focusItem.availableIndex == 0) {
                return;
            }
            TreeItem treeItem3 = this.availableItems[0];
            this.selectItem(treeItem3, false);
            this.setFocusItem(treeItem3, true);
            this.redrawItem(0, true);
            this.showItem(treeItem3);
            Event event = new Event();
            event.item = treeItem3;
            this.postEvent(13, event);
            return;
        }
        if ((n & 0x40000) != 0) {
            if ((n & 0x20000) != 0) {
                this.setTopItem(this.availableItems[0]);
                return;
            }
            if (this.focusItem.availableIndex == 0) {
                return;
            }
            TreeItem treeItem4 = this.availableItems[0];
            this.setFocusItem(treeItem4, true);
            this.showItem(treeItem4);
            this.redrawItem(treeItem4.availableIndex, true);
            return;
        }
        if (this.anchorItem == null) {
            this.anchorItem = this.focusItem;
        }
        if ((treeItem = this.availableItems[0]) == this.focusItem && treeItem.isSelected()) {
            return;
        }
        int n2 = this.anchorItem.availableIndex;
        int n3 = treeItem.availableIndex;
        TreeItem[] treeItemArray = new TreeItem[n2 + 1];
        int n4 = 0;
        int n5 = n2;
        while (n5 >= 0) {
            treeItemArray[n4++] = this.availableItems[n5];
            --n5;
        }
        this.setSelection(treeItemArray, false);
        this.setFocusItem(treeItem, true);
        this.redrawItems(n2, n3, true);
        this.showItem(treeItem);
        Event event = new Event();
        event.item = treeItem;
        this.postEvent(13, event);
    }

    void onKeyDown(Event event) {
        String string;
        TreeItem treeItem;
        if (this.ignoreKey) {
            this.ignoreKey = false;
            return;
        }
        this.ignoreKey = true;
        this.notifyListeners(event.type, event);
        event.type = 0;
        if (!event.doit) {
            return;
        }
        if (this.focusItem == null) {
            return;
        }
        if ((event.stateMask & 0x20000) == 0 && event.keyCode != 131072) {
            this.anchorItem = null;
        }
        switch (event.keyCode) {
            case 0x1000001: {
                this.onArrowUp(event.stateMask);
                return;
            }
            case 0x1000002: {
                this.onArrowDown(event.stateMask);
                return;
            }
            case 0x1000003: {
                this.onArrowLeft(event.stateMask);
                return;
            }
            case 0x1000004: {
                this.onArrowRight(event.stateMask);
                return;
            }
            case 0x1000005: {
                this.onPageUp(event.stateMask);
                return;
            }
            case 0x1000006: {
                this.onPageDown(event.stateMask);
                return;
            }
            case 0x1000007: {
                this.onHome(event.stateMask);
                return;
            }
            case 0x1000008: {
                this.onEnd(event.stateMask);
                return;
            }
        }
        if (event.character == ' ') {
            this.onSpace();
            return;
        }
        if (event.character == '\r') {
            this.onCR();
            return;
        }
        if ((event.stateMask & 0x40000) != 0) {
            return;
        }
        int n = this.focusItem.availableIndex;
        char c = Character.toLowerCase(event.character);
        int n2 = n + 1;
        while (n2 < this.availableItemsCount) {
            treeItem = this.availableItems[n2];
            string = treeItem.getText(0, false);
            if (string.length() > 0 && Character.toLowerCase(string.charAt(0)) == c) {
                this.selectItem(treeItem, false);
                this.setFocusItem(treeItem, true);
                this.redrawItem(n2, true);
                this.showItem(treeItem);
                Event event2 = new Event();
                event2.item = treeItem;
                this.postEvent(13, event2);
                return;
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < n) {
            treeItem = this.availableItems[n2];
            string = treeItem.getText(0, false);
            if (string.length() > 0 && Character.toLowerCase(string.charAt(0)) == c) {
                this.selectItem(treeItem, false);
                this.setFocusItem(treeItem, true);
                this.redrawItem(n2, true);
                this.showItem(treeItem);
                Event event3 = new Event();
                event3.item = treeItem;
                this.postEvent(13, event3);
                return;
            }
            ++n2;
        }
    }

    void onMouseDoubleClick(Event event) {
        int n;
        if (!this.isFocusControl()) {
            this.setFocus();
        }
        if ((n = (event.y - this.getHeaderHeight()) / this.itemHeight + this.topIndex) < 0 || n >= this.availableItemsCount) {
            return;
        }
        TreeItem treeItem = this.availableItems[n];
        if (treeItem != this.lastClickedItem) {
            return;
        }
        if (treeItem.items.length > 0 && treeItem.getExpanderBounds().contains(event.x, event.y)) {
            return;
        }
        if (!treeItem.getHitBounds().contains(event.x, event.y)) {
            return;
        }
        Event event2 = new Event();
        event2.item = treeItem;
        this.postEvent(14, event2);
    }

    void onMouseDown(Event event) {
        int n;
        if (!this.isFocusControl()) {
            this.forceFocus();
        }
        if ((n = (event.y - this.getHeaderHeight()) / this.itemHeight + this.topIndex) < 0 || n >= this.availableItemsCount) {
            return;
        }
        TreeItem treeItem = this.availableItems[n];
        if (treeItem.items.length > 0 && treeItem.getExpanderBounds().contains(event.x, event.y)) {
            if (event.button != 1) {
                return;
            }
            boolean bl = !treeItem.expanded;
            treeItem.setExpanded(bl);
            Event event2 = new Event();
            event2.item = treeItem;
            if (bl) {
                this.inExpand = true;
                this.sendEvent(17, event2);
                this.inExpand = false;
                if (this.isDisposed()) {
                    return;
                }
                if (treeItem.items.length == 0) {
                    treeItem.expanded = false;
                }
            } else {
                this.sendEvent(18, event2);
            }
            return;
        }
        if ((this.style & 0x20) != 0 && treeItem.getCheckboxBounds().contains(event.x, event.y)) {
            if (event.button != 1) {
                return;
            }
            treeItem.setChecked(!treeItem.checked);
            Event event3 = new Event();
            event3.item = treeItem;
            event3.detail = 32;
            this.postEvent(13, event3);
            return;
        }
        if (!treeItem.getHitBounds().contains(event.x, event.y)) {
            return;
        }
        if ((event.stateMask & 0x20000) == 0 && event.keyCode != 131072) {
            this.anchorItem = null;
        }
        boolean bl = true;
        if (this.lastSelectionEvent != null && this.lastSelectionEvent.item == treeItem) {
            if (event.time - this.lastSelectionEvent.time <= this.display.getDoubleClickTime()) {
                bl = false;
            } else {
                this.lastSelectionEvent = event;
                event.item = treeItem;
            }
        } else {
            this.lastSelectionEvent = event;
            event.item = treeItem;
        }
        if ((this.style & 4) != 0) {
            if (!treeItem.isSelected()) {
                if (event.button == 1) {
                    this.selectItem(treeItem, false);
                    this.setFocusItem(treeItem, true);
                    this.redrawItem(treeItem.availableIndex, true);
                    if (bl) {
                        Event event4 = new Event();
                        event4.item = treeItem;
                        this.postEvent(13, event4);
                    }
                    return;
                }
                if ((event.stateMask & 0x60000) == 0) {
                    this.selectItem(treeItem, false);
                    this.setFocusItem(treeItem, true);
                    this.redrawItem(treeItem.availableIndex, true);
                    if (bl) {
                        Event event5 = new Event();
                        event5.item = treeItem;
                        this.postEvent(13, event5);
                    }
                    return;
                }
            }
            if (event.button == 1) {
                if (bl) {
                    Event event6 = new Event();
                    event6.item = treeItem;
                    this.postEvent(13, event6);
                }
                return;
            }
        }
        if (!treeItem.isSelected()) {
            if (event.button == 1) {
                if ((event.stateMask & 0x60000) == 131072) {
                    if (this.anchorItem == null) {
                        this.anchorItem = this.focusItem;
                    }
                    int n2 = this.anchorItem.availableIndex;
                    int n3 = treeItem.availableIndex;
                    TreeItem[] treeItemArray = new TreeItem[Math.abs(n2 - n3) + 1];
                    int n4 = n2 < n3 ? 1 : -1;
                    int n5 = 0;
                    int n6 = n2;
                    while (n6 != n3) {
                        treeItemArray[n5++] = this.availableItems[n6];
                        n6 += n4;
                    }
                    treeItemArray[n5] = this.availableItems[n3];
                    this.setSelection(treeItemArray, false);
                    this.setFocusItem(treeItem, true);
                    this.redrawItems(Math.min(n2, n3), Math.max(n2, n3), true);
                    if (bl) {
                        Event event7 = new Event();
                        event7.item = treeItem;
                        this.postEvent(13, event7);
                    }
                    return;
                }
                this.selectItem(treeItem, (event.stateMask & 0x40000) != 0);
                this.setFocusItem(treeItem, true);
                this.redrawItem(treeItem.availableIndex, true);
                if (bl) {
                    Event event8 = new Event();
                    event8.item = treeItem;
                    this.postEvent(13, event8);
                }
                return;
            }
            if ((event.stateMask & 0x60000) == 0) {
                this.selectItem(treeItem, false);
                this.setFocusItem(treeItem, true);
                this.redrawItem(treeItem.availableIndex, true);
                if (bl) {
                    Event event9 = new Event();
                    event9.item = treeItem;
                    this.postEvent(13, event9);
                }
                return;
            }
        }
        if (event.button != 1) {
            return;
        }
        if ((event.stateMask & 0x40000) != 0) {
            this.removeSelectedItem(this.getSelectionIndex(treeItem));
            this.setFocusItem(treeItem, true);
            this.redrawItem(treeItem.availableIndex, true);
            if (bl) {
                Event event10 = new Event();
                event10.item = treeItem;
                this.postEvent(13, event10);
            }
            return;
        }
        if ((event.stateMask & 0x20000) != 0) {
            if (this.anchorItem == null) {
                this.anchorItem = this.focusItem;
            }
            int n7 = this.anchorItem.availableIndex;
            int n8 = treeItem.availableIndex;
            TreeItem[] treeItemArray = new TreeItem[Math.abs(n7 - n8) + 1];
            int n9 = n7 < n8 ? 1 : -1;
            int n10 = 0;
            int n11 = n7;
            while (n11 != n8) {
                treeItemArray[n10++] = this.availableItems[n11];
                n11 += n9;
            }
            treeItemArray[n10] = this.availableItems[n8];
            this.setSelection(treeItemArray, false);
            this.setFocusItem(treeItem, true);
            this.redrawItems(Math.min(n7, n8), Math.max(n7, n8), true);
            if (bl) {
                Event event11 = new Event();
                event11.item = treeItem;
                this.postEvent(13, event11);
            }
            return;
        }
        this.selectItem(treeItem, false);
        this.setFocusItem(treeItem, true);
        this.redrawItem(treeItem.availableIndex, true);
        if (bl) {
            Event event12 = new Event();
            event12.item = treeItem;
            this.postEvent(13, event12);
        }
    }

    void onMouseUp(Event event) {
        int n = (event.y - this.getHeaderHeight()) / this.itemHeight + this.topIndex;
        if (n < 0 || n >= this.availableItemsCount) {
            return;
        }
        this.lastClickedItem = this.availableItems[n];
    }

    void onPageDown(int n) {
        int n2;
        int n3 = (this.clientArea.height - this.getHeaderHeight()) / this.itemHeight;
        if ((n & 0x60000) == 0) {
            int n4 = this.focusItem.availableIndex + n3 - 1;
            if ((n4 = Math.min(n4, this.availableItemsCount - 1)) == this.focusItem.availableIndex) {
                return;
            }
            TreeItem treeItem = this.availableItems[n4];
            this.selectItem(treeItem, false);
            this.setFocusItem(treeItem, true);
            this.showItem(treeItem);
            this.redrawItem(treeItem.availableIndex, true);
            return;
        }
        if ((n & 0x60000) == 393216) {
            int n5 = this.topIndex + n3;
            if ((n5 = Math.min(n5, this.availableItemsCount - n3)) == this.topIndex) {
                return;
            }
            this.setTopItem(this.availableItems[n5]);
            return;
        }
        if ((this.style & 4) != 0) {
            if ((n & 0x20000) != 0) {
                int n6 = this.focusItem.availableIndex + n3 - 1;
                if ((n6 = Math.min(n6, this.availableItemsCount - 1)) == this.focusItem.availableIndex) {
                    return;
                }
                TreeItem treeItem = this.availableItems[n6];
                this.selectItem(treeItem, false);
                this.setFocusItem(treeItem, true);
                this.showItem(treeItem);
                this.redrawItem(treeItem.availableIndex, true);
                return;
            }
            int n7 = this.topIndex + n3;
            if ((n7 = Math.min(n7, this.availableItemsCount - n3)) == this.topIndex) {
                return;
            }
            this.setTopItem(this.availableItems[n7]);
            return;
        }
        if ((n & 0x40000) != 0) {
            int n8 = Math.min(this.topIndex + n3 - 1, this.availableItemsCount - 1);
            if (this.focusItem.availableIndex != n8) {
                this.setFocusItem(this.availableItems[n8], true);
                this.redrawItem(n8, true);
            } else {
                int n9 = Math.min(this.availableItemsCount - 1, n8 + n3);
                if (n9 == this.focusItem.availableIndex) {
                    return;
                }
                this.setFocusItem(this.availableItems[n9], true);
                this.showItem(this.availableItems[n9]);
                this.redrawItem(n9, true);
            }
            return;
        }
        if (this.anchorItem == null) {
            this.anchorItem = this.focusItem;
        }
        int n10 = this.anchorItem.availableIndex;
        int n11 = Math.min(this.topIndex + n3 - 1, this.availableItemsCount - 1);
        if (this.focusItem.availableIndex != n11) {
            n2 = n11;
        } else {
            n2 = Math.min(this.availableItemsCount - 1, n11 + n3);
            if (n2 == this.focusItem.availableIndex && this.focusItem.isSelected()) {
                return;
            }
        }
        TreeItem treeItem = this.availableItems[n2];
        TreeItem[] treeItemArray = new TreeItem[Math.abs(n10 - n2) + 1];
        int n12 = n10 < n2 ? 1 : -1;
        int n13 = 0;
        int n14 = n10;
        while (n14 != n2) {
            treeItemArray[n13++] = this.availableItems[n14];
            n14 += n12;
        }
        treeItemArray[n13] = this.availableItems[n2];
        this.setSelection(treeItemArray, false);
        this.setFocusItem(treeItem, true);
        this.showItem(treeItem);
        Event event = new Event();
        event.item = treeItem;
        this.postEvent(13, event);
    }

    void onPageUp(int n) {
        int n2;
        int n3 = (this.clientArea.height - this.getHeaderHeight()) / this.itemHeight;
        if ((n & 0x60000) == 0) {
            int n4 = Math.max(0, this.focusItem.availableIndex - n3 + 1);
            if (n4 == this.focusItem.availableIndex) {
                return;
            }
            TreeItem treeItem = this.availableItems[n4];
            this.selectItem(treeItem, false);
            this.setFocusItem(treeItem, true);
            this.showItem(treeItem);
            this.redrawItem(treeItem.availableIndex, true);
            return;
        }
        if ((n & 0x60000) == 393216) {
            int n5 = Math.max(0, this.topIndex - n3);
            if (n5 == this.topIndex) {
                return;
            }
            this.setTopItem(this.availableItems[n5]);
            return;
        }
        if ((this.style & 4) != 0) {
            if ((n & 0x20000) != 0) {
                int n6 = Math.max(0, this.focusItem.availableIndex - n3 + 1);
                if (n6 == this.focusItem.availableIndex) {
                    return;
                }
                TreeItem treeItem = this.availableItems[n6];
                this.selectItem(treeItem, false);
                this.setFocusItem(treeItem, true);
                this.showItem(treeItem);
                this.redrawItem(treeItem.availableIndex, true);
                return;
            }
            int n7 = Math.max(0, this.topIndex - n3);
            if (n7 == this.topIndex) {
                return;
            }
            this.setTopItem(this.availableItems[n7]);
            return;
        }
        if ((n & 0x40000) != 0) {
            if (this.focusItem.availableIndex != this.topIndex) {
                this.setFocusItem(this.availableItems[this.topIndex], true);
                this.redrawItem(this.topIndex, true);
            } else {
                int n8 = Math.max(0, this.focusItem.availableIndex - n3);
                if (n8 == this.focusItem.availableIndex) {
                    return;
                }
                this.setFocusItem(this.availableItems[n8], true);
                this.showItem(this.availableItems[n8]);
                this.redrawItem(n8, true);
            }
            return;
        }
        if (this.anchorItem == null) {
            this.anchorItem = this.focusItem;
        }
        int n9 = this.anchorItem.availableIndex;
        if (this.focusItem.availableIndex != this.topIndex) {
            n2 = this.topIndex;
        } else {
            n2 = Math.max(0, this.topIndex - n3);
            if (n2 == this.focusItem.availableIndex && this.focusItem.isSelected()) {
                return;
            }
        }
        TreeItem treeItem = this.availableItems[n2];
        TreeItem[] treeItemArray = new TreeItem[Math.abs(n9 - n2) + 1];
        int n10 = n9 < n2 ? 1 : -1;
        int n11 = 0;
        int n12 = n9;
        while (n12 != n2) {
            treeItemArray[n11++] = this.availableItems[n12];
            n12 += n10;
        }
        treeItemArray[n11] = this.availableItems[n2];
        this.setSelection(treeItemArray, false);
        this.setFocusItem(treeItem, true);
        this.showItem(treeItem);
        Event event = new Event();
        event.item = treeItem;
        this.postEvent(13, event);
    }

    void onPaint(Event event) {
        int n;
        TreeColumn treeColumn;
        int n2;
        TreeColumn[] treeColumnArray = this.getOrderedColumns();
        GC gC = event.gc;
        Rectangle rectangle = gC.getClipping();
        int n3 = this.getHeaderHeight();
        int n4 = treeColumnArray.length;
        int n5 = -1;
        int n6 = -1;
        if (n4 > 0) {
            n5 = this.computeColumnIntersect(rectangle.x, 0);
            if (n5 != -1 && (n6 = this.computeColumnIntersect(rectangle.x + rectangle.width, n5)) == -1) {
                n6 = n4 - 1;
            }
        } else {
            n6 = 0;
            n5 = 0;
        }
        int n7 = (rectangle.y - n3) / this.itemHeight + this.topIndex;
        int n8 = -1;
        if (n7 < this.availableItemsCount) {
            n8 = n7 + Compatibility.ceil(rectangle.height, this.itemHeight);
        }
        n7 = Math.max(0, n7);
        n8 = Math.min(n8, this.availableItemsCount - 1);
        gC.setBackground(this.getBackground());
        gC.setClipping(rectangle);
        int n9 = n8 >= 0 ? this.getItemY(this.availableItems[n8]) + this.itemHeight : 0;
        int n10 = Math.max(0, this.clientArea.height - n9);
        if (n10 > 0) {
            this.drawBackground(gC, 0, n9, this.clientArea.width, n10);
        }
        if (this.columns.length > 0 && (n2 = (treeColumn = treeColumnArray[treeColumnArray.length - 1]).getX() + treeColumn.width) < this.clientArea.width) {
            this.drawBackground(gC, n2, 0, this.clientArea.width - n2, this.clientArea.height - n10);
        }
        boolean bl = false;
        int[] nArray = gC.getLineDash();
        int n11 = gC.getLineWidth();
        int n12 = n7;
        while (n12 <= Math.min(n8, this.availableItemsCount - 1)) {
            TreeItem treeItem = this.availableItems[n12];
            if (!treeItem.isDisposed()) {
                if (n5 == -1) {
                    bl = treeItem.paint(gC, null, true) || bl;
                } else if (n4 == 0) {
                    bl = treeItem.paint(gC, null, false) || bl;
                } else {
                    n = n5;
                    while (n <= Math.min(n6, this.columns.length - 1)) {
                        if (!treeItem.isDisposed()) {
                            boolean bl2 = bl = treeItem.paint(gC, treeColumnArray[n], false) || bl;
                        }
                        if (this.isDisposed() || gC.isDisposed()) {
                            return;
                        }
                        ++n;
                    }
                }
            }
            if (this.isDisposed() || gC.isDisposed()) {
                return;
            }
            ++n12;
        }
        gC.setClipping(rectangle);
        gC.setLineWidth(n11);
        if (this.linesVisible) {
            gC.setForeground(this.display.getSystemColor(19));
            gC.setLineDash(nArray);
            if (n4 > 0 && n5 != -1) {
                n12 = n5;
                while (n12 <= n6) {
                    int n13 = treeColumnArray[n12].getX() + treeColumnArray[n12].width - 1;
                    gC.drawLine(n13, rectangle.y, n13, rectangle.y + rectangle.height);
                    ++n12;
                }
            }
            n9 = rectangle.y + rectangle.height;
            n12 = rectangle.x + rectangle.width;
            int n14 = (rectangle.y - n3) / this.itemHeight * this.itemHeight + n3;
            while (n14 <= n9) {
                gC.drawLine(rectangle.x, n14, n12, n14);
                n14 += this.itemHeight;
            }
        }
        if (!bl && this.isFocusControl()) {
            if (this.focusItem != null) {
                Rectangle rectangle2 = this.focusItem.getFocusBounds();
                if (rectangle2.width > 0) {
                    gC.setForeground(this.display.getSystemColor(2));
                    gC.setClipping(rectangle2);
                    if (this.focusItem.isSelected()) {
                        gC.setLineDash(new int[]{2, 2});
                    } else {
                        gC.setLineDash(new int[]{1, 1});
                    }
                    gC.drawFocus(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                }
            } else {
                n12 = n3 + 1;
                int n15 = Math.max(0, this.clientArea.width - 2);
                n = Math.max(0, this.clientArea.height - n3 - 2);
                gC.setForeground(this.display.getSystemColor(2));
                gC.setClipping(1, n12, n15, n);
                gC.setLineDash(new int[]{1, 1});
                gC.drawFocus(1, n12, n15, n);
            }
        }
        if (this.insertMarkItem != null) {
            Rectangle rectangle3 = this.insertMarkItem.getFocusBounds();
            gC.setForeground(this.display.getSystemColor(2));
            gC.setClipping(rectangle3);
            gC.setLineDash(nArray);
            if (this.insertMarkPrecedes) {
                gC.drawLine(rectangle3.x, rectangle3.y, rectangle3.x + rectangle3.width, rectangle3.y);
            } else {
                int n16 = rectangle3.y + rectangle3.height - 1;
                gC.drawLine(rectangle3.x, n16, rectangle3.x + rectangle3.width, n16);
            }
        }
    }

    void onResize(Event event) {
        ScrollBar scrollBar;
        boolean bl;
        int n;
        int n2;
        this.clientArea = this.getClientArea();
        ScrollBar scrollBar2 = this.getVerticalBar();
        if (scrollBar2 != null) {
            int n3 = (this.clientArea.height - this.getHeaderHeight()) / this.itemHeight;
            n2 = Math.min(n3, this.availableItemsCount);
            scrollBar2.setThumb(n2);
            scrollBar2.setPageIncrement(n2);
            n = scrollBar2.getSelection();
            if (n != this.topIndex) {
                this.topIndex = n;
                this.redraw();
            }
            boolean bl2 = bl = n3 < this.availableItemsCount;
            if (bl != scrollBar2.getVisible()) {
                scrollBar2.setVisible(bl);
                this.clientArea = this.getClientArea();
            }
        }
        if ((scrollBar = this.getHorizontalBar()) != null) {
            n2 = scrollBar.getMaximum();
            n = Math.min(this.clientArea.width, n2);
            scrollBar.setThumb(n);
            scrollBar.setPageIncrement(n);
            this.horizontalOffset = scrollBar.getSelection();
            boolean bl3 = bl = this.clientArea.width < n2;
            if (bl != scrollBar.getVisible()) {
                scrollBar.setVisible(bl);
                this.clientArea = this.getClientArea();
            }
        }
        n2 = Math.max(this.fontHeight, this.headerImageHeight) + 2 * this.getHeaderPadding();
        this.header.setSize(this.clientArea.width, n2);
        if (this.availableItemsCount == 0 && this.isFocusControl()) {
            this.redraw();
        }
    }

    void onScrollHorizontal(Event event) {
        Object object;
        ScrollBar scrollBar = this.getHorizontalBar();
        if (scrollBar == null) {
            return;
        }
        int n = scrollBar.getSelection();
        this.update();
        if (this.availableItemsCount > 0) {
            object = new GC(this);
            ((GC)object).copyArea(0, 0, this.clientArea.width, this.clientArea.height, this.horizontalOffset - n, 0);
            ((Resource)object).dispose();
        } else {
            this.redraw();
        }
        if (this.drawCount <= 0 && this.header.isVisible()) {
            this.header.update();
            object = this.header.getClientArea();
            GC gC = new GC(this.header);
            gC.copyArea(0, 0, ((Rectangle)object).width, ((Rectangle)object).height, this.horizontalOffset - n, 0);
            gC.dispose();
        }
        this.horizontalOffset = n;
    }

    void onScrollVertical(Event event) {
        ScrollBar scrollBar = this.getVerticalBar();
        if (scrollBar != null) {
            int n = scrollBar.getSelection();
            this.update();
            GC gC = new GC(this);
            gC.copyArea(0, 0, this.clientArea.width, this.clientArea.height, 0, (this.topIndex - n) * this.itemHeight);
            gC.dispose();
            this.topIndex = n;
        }
    }

    void onSpace() {
        if (this.focusItem == null) {
            return;
        }
        if (!this.focusItem.isSelected()) {
            this.selectItem(this.focusItem, (this.style & 2) != 0);
            this.redrawItem(this.focusItem.availableIndex, true);
        }
        if ((this.style & 0x20) != 0) {
            this.focusItem.setChecked(!this.focusItem.checked);
        }
        this.showItem(this.focusItem);
        Event event = new Event();
        event.item = this.focusItem;
        this.postEvent(13, event);
        if ((this.style & 0x20) == 0) {
            return;
        }
        event = new Event();
        event.item = this.focusItem;
        event.detail = 32;
        this.postEvent(13, event);
    }

    void reassignFocus() {
        if (this.focusItem == null) {
            return;
        }
        if (this.focusItem.parentItem != null) {
            TreeItem treeItem = this.focusItem.parentItem;
            this.setFocusItem(treeItem, false);
            this.showItem(treeItem);
            return;
        }
        int n = this.focusItem.getIndex();
        n = n != 0 ? --n : ++n;
        if (n < this.items.length) {
            TreeItem treeItem = this.items[n];
            this.setFocusItem(treeItem, false);
            this.showItem(treeItem);
        } else {
            this.setFocusItem(null, false);
        }
    }

    public void redraw() {
        this.checkWidget();
        if (this.drawCount <= 0) {
            super.redraw();
        }
    }

    public void redraw(int n, int n2, int n3, int n4, boolean bl) {
        this.checkWidget();
        if (this.drawCount <= 0) {
            super.redraw(n, n2, n3, n4, bl);
        }
    }

    void redrawFromItemDownwards(int n) {
        this.redrawItems(n, this.availableItemsCount - 1, false);
    }

    void redrawItem(int n, boolean bl) {
        if (n == -1) {
            return;
        }
        if (n < this.availableItemsCount && !this.availableItems[n].isInViewport()) {
            return;
        }
        this.redrawItems(n, n, bl);
    }

    void redrawItems(int n, int n2, boolean bl) {
        if (this.drawCount > 0) {
            return;
        }
        int n3 = (n - this.topIndex) * this.itemHeight + this.getHeaderHeight();
        int n4 = (n2 - n + 1) * this.itemHeight;
        if (bl) {
            boolean bl2;
            boolean bl3 = bl2 = this.hooks(40) || this.hooks(42);
            if (!bl2 && this.columns.length > 0) {
                TreeColumn treeColumn;
                if ((this.style & 0x10000) != 0) {
                    TreeColumn[] treeColumnArray = this.getOrderedColumns();
                    treeColumn = treeColumnArray[treeColumnArray.length - 1];
                } else {
                    treeColumn = this.columns[0];
                }
                int n5 = treeColumn.getX() + treeColumn.getWidth();
                if (n5 <= 0) {
                    return;
                }
            }
            n2 = Math.min(n2, this.availableItemsCount - 1);
            int n6 = n;
            while (n6 <= n2) {
                TreeItem treeItem = this.availableItems[n6];
                if (treeItem.isInViewport()) {
                    if (bl2) {
                        this.redraw(0, this.getItemY(treeItem), this.clientArea.width, this.itemHeight, false);
                    } else {
                        Rectangle rectangle = treeItem.getFocusBounds();
                        this.redraw(rectangle.x, n3, rectangle.width, n4, false);
                    }
                }
                ++n6;
            }
        } else {
            this.redraw(0, n3, this.clientArea.width, n4, false);
        }
    }

    public void removeAll() {
        this.checkWidget();
        if (this.items.length == 0) {
            return;
        }
        this.setRedraw(false);
        this.setFocusItem(null, false);
        int n = 0;
        while (n < this.items.length) {
            this.items[n].dispose(false);
            ++n;
        }
        this.selectedItems = NO_ITEMS;
        this.availableItems = NO_ITEMS;
        this.items = this.availableItems;
        this.topIndex = 0;
        this.availableItemsCount = 0;
        this.insertMarkItem = null;
        this.lastClickedItem = null;
        this.anchorItem = null;
        this.lastSelectionEvent = null;
        this.inExpand = false;
        ScrollBar scrollBar = this.getVerticalBar();
        if (scrollBar != null) {
            scrollBar.setMaximum(1);
            scrollBar.setVisible(false);
        }
        if (this.columns.length == 0) {
            this.horizontalOffset = 0;
            ScrollBar scrollBar2 = this.getHorizontalBar();
            if (scrollBar2 != null) {
                scrollBar2.setMaximum(1);
                scrollBar2.setVisible(false);
            }
        }
        this.setRedraw(true);
    }

    String removeMnemonics(String string) {
        char[] cArray = new char[string.length()];
        string.getChars(0, cArray.length, cArray, 0);
        int n = 0;
        int n2 = 0;
        while (n < cArray.length) {
            if (cArray[n] == '&') {
                if (++n == cArray.length) break;
                if (cArray[n] == '&') {
                    cArray[n2++] = cArray[n - 1];
                }
            }
            cArray[n2] = cArray[n];
            ++n;
            ++n2;
        }
        if (n == n2) {
            return string;
        }
        return new String(cArray, 0, n2);
    }

    void removeSelectedItem(int n) {
        TreeItem[] treeItemArray = new TreeItem[this.selectedItems.length - 1];
        System.arraycopy(this.selectedItems, 0, treeItemArray, 0, n);
        System.arraycopy(this.selectedItems, n + 1, treeItemArray, n, treeItemArray.length - n);
        this.selectedItems = treeItemArray;
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        this.removeListener(13, selectionListener);
        this.removeListener(14, selectionListener);
    }

    public void removeTreeListener(TreeListener treeListener) {
        this.checkWidget();
        if (treeListener == null) {
            this.error(4);
        }
        this.removeListener(17, treeListener);
        this.removeListener(18, treeListener);
    }

    public void select(TreeItem treeItem) {
        this.checkWidget();
        if (treeItem == null) {
            this.error(4);
        }
        if (treeItem.isDisposed()) {
            this.error(5);
        }
        this.selectItem(treeItem, (this.style & 2) != 0);
        this.redrawItem(treeItem.availableIndex, true);
    }

    public void selectAll() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        this.selectedItems = new TreeItem[this.availableItemsCount];
        System.arraycopy(this.availableItems, 0, this.selectedItems, 0, this.availableItemsCount);
        this.redraw();
    }

    void selectItem(TreeItem treeItem, boolean bl) {
        TreeItem[] treeItemArray = this.selectedItems;
        if (!bl || (this.style & 4) != 0) {
            this.selectedItems = new TreeItem[]{treeItem};
            int n = 0;
            while (n < treeItemArray.length) {
                if (treeItemArray[n] != treeItem) {
                    this.redrawItem(treeItemArray[n].availableIndex, true);
                }
                ++n;
            }
        } else {
            if (treeItem.isSelected()) {
                return;
            }
            this.selectedItems = new TreeItem[this.selectedItems.length + 1];
            System.arraycopy(treeItemArray, 0, this.selectedItems, 0, treeItemArray.length);
            this.selectedItems[this.selectedItems.length - 1] = treeItem;
        }
    }

    public void setBackground(Color color) {
        this.checkWidget();
        if (color == null) {
            color = this.display.getSystemColor(25);
        }
        super.setBackground(color);
    }

    public void setColumnOrder(int[] nArray) {
        int n;
        this.checkWidget();
        if (nArray == null) {
            this.error(4);
        }
        if (this.columns.length == 0) {
            if (nArray.length != 0) {
                this.error(5);
            }
            return;
        }
        if (nArray.length != this.columns.length) {
            this.error(5);
        }
        boolean bl = false;
        boolean[] blArray = new boolean[this.columns.length];
        int[] nArray2 = this.getColumnOrder();
        int n2 = 0;
        while (n2 < nArray.length) {
            n = nArray[n2];
            if (n < 0 || n >= this.columns.length) {
                this.error(6);
            }
            if (blArray[n]) {
                this.error(5);
            }
            blArray[n] = true;
            if (n != nArray2[n2]) {
                bl = true;
            }
            ++n2;
        }
        if (!bl) {
            return;
        }
        this.headerHideToolTip();
        int[] nArray3 = new int[this.columns.length];
        n = 0;
        while (n < this.columns.length) {
            nArray3[n] = this.columns[n].getX();
            ++n;
        }
        this.orderedColumns = new TreeColumn[nArray.length];
        n = 0;
        while (n < nArray.length) {
            this.orderedColumns[n] = this.columns[nArray[n]];
            ++n;
        }
        if (nArray2[0] != nArray[0]) {
            this.orderedCol0imageWidth = this.columns[nArray[0]].itemImageWidth;
            GC gC = new GC(this);
            int n3 = 0;
            while (n3 < this.items.length) {
                this.items[n3].updateColumnWidth(this.columns[nArray2[0]], gC);
                this.items[n3].updateColumnWidth(this.columns[nArray[0]], gC);
                ++n3;
            }
            gC.dispose();
        }
        int n4 = 0;
        while (n4 < this.orderedColumns.length) {
            TreeColumn treeColumn = this.orderedColumns[n4];
            if (!treeColumn.isDisposed() && treeColumn.getX() != nArray3[treeColumn.getIndex()]) {
                treeColumn.sendEvent(10);
            }
            ++n4;
        }
        this.redraw();
        if (this.drawCount <= 0 && this.header.isVisible()) {
            this.header.redraw();
        }
    }

    void setFocusItem(TreeItem treeItem, boolean bl) {
        if (treeItem == this.focusItem) {
            return;
        }
        TreeItem treeItem2 = this.focusItem;
        this.focusItem = treeItem;
        if (bl && treeItem2 != null) {
            this.redrawItem(treeItem2.availableIndex, true);
        }
    }

    public void setFont(Font font) {
        ScrollBar scrollBar;
        this.checkWidget();
        Font font2 = this.getFont();
        super.setFont(font);
        Font font3 = this.getFont();
        if (font3.equals(font2)) {
            return;
        }
        GC gC = new GC(this);
        this.fontHeight = gC.getFontMetrics().getHeight();
        this.setItemHeight(Math.max(this.fontHeight, this.imageHeight) + 2 * this.getCellPadding());
        Point point = this.header.getSize();
        int n = Math.max(this.fontHeight, this.headerImageHeight) + 2 * this.getHeaderPadding();
        if (point.y != n) {
            this.header.setSize(point.x, n);
        }
        this.header.setFont(font3);
        int n2 = 0;
        while (n2 < this.columns.length) {
            this.columns[n2].updateFont(gC);
            ++n2;
        }
        n2 = 0;
        while (n2 < this.items.length) {
            this.items[n2].updateFont(gC);
            ++n2;
        }
        gC.dispose();
        if (this.drawCount <= 0 && this.header.isVisible()) {
            this.header.redraw();
        }
        if (this.columns.length == 0) {
            this.updateHorizontalBar();
        }
        if ((scrollBar = this.getVerticalBar()) != null) {
            int n3 = (this.clientArea.height - this.getHeaderHeight()) / this.itemHeight;
            if (scrollBar.getThumb() != n3) {
                scrollBar.setThumb(n3);
                scrollBar.setPageIncrement(n3);
            }
            this.topIndex = scrollBar.getSelection();
            scrollBar.setVisible(n3 < scrollBar.getMaximum());
        }
        this.redraw();
    }

    public void setForeground(Color color) {
        this.checkWidget();
        if (color == null) {
            color = this.display.getSystemColor(24);
        }
        super.setForeground(color);
    }

    void setHeaderImageHeight(int n) {
        this.headerImageHeight = n;
        Point point = this.header.getSize();
        int n2 = Math.max(this.fontHeight, this.headerImageHeight) + 2 * this.getHeaderPadding();
        if (point.y != n2) {
            this.header.setSize(point.x, n2);
        }
    }

    public void setHeaderVisible(boolean bl) {
        this.checkWidget();
        if (this.header.getVisible() == bl) {
            return;
        }
        this.headerHideToolTip();
        this.header.setVisible(bl);
        this.updateVerticalBar();
        this.redraw();
    }

    void setImageHeight(int n) {
        this.imageHeight = n;
        this.setItemHeight(Math.max(this.fontHeight, this.imageHeight) + 2 * this.getCellPadding());
    }

    public void setInsertMark(TreeItem treeItem, boolean bl) {
        this.checkWidget();
        if (treeItem != null && treeItem.isDisposed()) {
            this.error(5);
        }
        if (treeItem != null && treeItem.parent != this) {
            return;
        }
        if (treeItem == this.insertMarkItem && bl == this.insertMarkPrecedes) {
            return;
        }
        TreeItem treeItem2 = this.insertMarkItem;
        this.insertMarkItem = treeItem;
        this.insertMarkPrecedes = bl;
        if (treeItem2 != null && treeItem2.availableIndex != -1) {
            this.redrawItem(treeItem2.availableIndex, true);
        }
        if (treeItem != null && treeItem != treeItem2 && treeItem.availableIndex != -1) {
            this.redrawItem(treeItem.availableIndex, true);
        }
    }

    public void setItemCount(int n) {
        int n2;
        int n3;
        this.checkWidget();
        n = Math.max(0, n);
        if (n == this.items.length) {
            return;
        }
        int n4 = this.availableItemsCount;
        if (n < this.items.length) {
            n3 = n > 0 ? this.items[n - 1].availableIndex : 0;
            n2 = this.availableItemsCount - 1;
            this.availableItemsCount = this.items[n].availableIndex;
            int n5 = n;
            while (n5 < this.items.length) {
                this.items[n5].dispose(false);
                ++n5;
            }
            if (n == 0) {
                this.items = NO_ITEMS;
            } else {
                TreeItem[] treeItemArray = new TreeItem[n];
                System.arraycopy(this.items, 0, treeItemArray, 0, n);
                this.items = treeItemArray;
            }
            int n6 = 0;
            int n7 = 0;
            while (n7 < this.selectedItems.length) {
                if (!this.selectedItems[n7].isDisposed()) {
                    ++n6;
                }
                ++n7;
            }
            if (n6 != this.selectedItems.length) {
                TreeItem[] treeItemArray = new TreeItem[n6];
                int n8 = 0;
                int n9 = 0;
                while (n9 < this.selectedItems.length) {
                    TreeItem treeItem = this.selectedItems[n9];
                    if (!treeItem.isDisposed()) {
                        treeItemArray[n8++] = treeItem;
                    }
                    ++n9;
                }
                this.selectedItems = treeItemArray;
            }
            if (this.insertMarkItem != null && this.insertMarkItem.isDisposed()) {
                this.insertMarkItem = null;
            }
            if (this.lastClickedItem != null && this.lastClickedItem.isDisposed()) {
                this.lastClickedItem = null;
            }
            if (this.anchorItem != null && this.anchorItem.isDisposed()) {
                this.anchorItem = null;
            }
            if (this.focusItem != null && this.focusItem.isDisposed()) {
                TreeItem treeItem = n > 0 ? this.items[n - 1] : null;
                this.setFocusItem(treeItem, false);
            }
            if (this.columns.length == 0) {
                this.updateHorizontalBar();
            }
        } else {
            int n10 = n - this.items.length;
            n3 = this.items.length == 0 ? 0 : this.items[this.items.length - 1].availableIndex;
            n2 = this.availableItemsCount + n10 - 1;
            TreeItem[] treeItemArray = new TreeItem[n];
            System.arraycopy(this.items, 0, treeItemArray, 0, this.items.length);
            this.items = treeItemArray;
            if (this.availableItems.length < this.availableItemsCount + n10) {
                TreeItem[] treeItemArray2 = new TreeItem[this.availableItemsCount + n10];
                System.arraycopy(this.availableItems, 0, treeItemArray2, 0, this.availableItemsCount);
                this.availableItems = treeItemArray2;
            }
            int n11 = this.items.length - n10;
            while (n11 < n) {
                TreeItem treeItem;
                this.items[n11] = treeItem = new TreeItem(this, 0, n11, false);
                this.items[n11].availableIndex = this.availableItemsCount;
                this.availableItems[this.availableItemsCount++] = treeItem;
                ++n11;
            }
            if (n4 == 0) {
                this.focusItem = this.availableItems[0];
            }
        }
        this.updateVerticalBar();
        if ((n4 == 0 || this.availableItemsCount == 0) && this.isFocusControl()) {
            this.redraw();
            return;
        }
        this.redrawItems(n3, n2, false);
    }

    boolean setItemHeight(int n) {
        boolean bl;
        boolean bl2 = bl = !this.customHeightSet || this.itemHeight < n;
        if (bl) {
            this.itemHeight = n;
        }
        return bl;
    }

    public void setLinesVisible(boolean bl) {
        this.checkWidget();
        if (this.linesVisible == bl) {
            return;
        }
        this.linesVisible = bl;
        this.redraw();
    }

    public void setMenu(Menu menu) {
        super.setMenu(menu);
        this.header.setMenu(menu);
    }

    public void setRedraw(boolean bl) {
        this.checkWidget();
        if (bl) {
            if (--this.drawCount == 0) {
                if (this.availableItems.length - this.availableItemsCount > 3) {
                    TreeItem[] treeItemArray = new TreeItem[this.availableItemsCount];
                    System.arraycopy(this.availableItems, 0, treeItemArray, 0, this.availableItemsCount);
                    this.availableItems = treeItemArray;
                }
                this.updateVerticalBar();
                this.updateHorizontalBar();
            }
        } else {
            ++this.drawCount;
        }
        super.setRedraw(bl);
        this.header.setRedraw(bl);
    }

    public void setSelection(TreeItem treeItem) {
        this.checkWidget();
        if (treeItem == null) {
            this.error(4);
        }
        this.setSelection(new TreeItem[]{treeItem}, true);
    }

    public void setSelection(TreeItem[] treeItemArray) {
        this.checkWidget();
        if (treeItemArray == null) {
            this.error(4);
        }
        this.setSelection(treeItemArray, true);
    }

    void setSelection(TreeItem[] treeItemArray, boolean bl) {
        if (treeItemArray.length == 0 || (this.style & 4) != 0 && treeItemArray.length > 1) {
            this.deselectAll();
            return;
        }
        TreeItem[] treeItemArray2 = this.selectedItems;
        int n = 0;
        this.selectedItems = new TreeItem[treeItemArray.length];
        int n2 = 0;
        while (n2 < treeItemArray.length) {
            TreeItem treeItem = treeItemArray[n2];
            if (treeItem != null && treeItem.parent == this && !treeItem.isSelected()) {
                this.selectedItems[n++] = treeItem;
            }
            ++n2;
        }
        if (n != treeItemArray.length) {
            TreeItem[] treeItemArray3 = new TreeItem[n];
            System.arraycopy(this.selectedItems, 0, treeItemArray3, 0, n);
            this.selectedItems = treeItemArray3;
        }
        if (this.selectedItems.length == 0) {
            this.deselectAll();
            return;
        }
        int n3 = 0;
        while (n3 < treeItemArray2.length) {
            int n4;
            if (!treeItemArray2[n3].isSelected() && (n4 = treeItemArray2[n3].availableIndex) != -1) {
                this.redrawItem(n4, true);
            }
            ++n3;
        }
        if (bl) {
            this.showItem(this.selectedItems[0]);
            this.setFocusItem(this.selectedItems[0], true);
        }
        n3 = 0;
        while (n3 < this.selectedItems.length) {
            int n5 = this.selectedItems[n3].availableIndex;
            if (n5 != -1) {
                this.redrawItem(n5, true);
            }
            ++n3;
        }
    }

    public void setSortColumn(TreeColumn treeColumn) {
        this.checkWidget();
        if (treeColumn != null && treeColumn.isDisposed()) {
            this.error(5);
        }
        if (treeColumn == this.sortColumn) {
            return;
        }
        if (this.sortColumn != null && !this.sortColumn.isDisposed()) {
            this.sortColumn.setSortDirection(0);
        }
        this.sortColumn = treeColumn;
        if (this.sortColumn != null) {
            this.sortColumn.setSortDirection(this.sortDirection);
        }
    }

    public void setSortDirection(int n) {
        this.checkWidget();
        if (n != 128 && n != 1024 && n != 0) {
            return;
        }
        this.sortDirection = n;
        if (this.sortColumn == null || this.sortColumn.isDisposed()) {
            return;
        }
        this.sortColumn.setSortDirection(this.sortDirection);
    }

    public void setTopItem(TreeItem treeItem) {
        int n;
        this.checkWidget();
        if (treeItem == null) {
            this.error(4);
        }
        if (treeItem.isDisposed()) {
            this.error(5);
        }
        if (treeItem.parent != this) {
            return;
        }
        if (!treeItem.isAvailable()) {
            treeItem.parentItem.expandAncestors();
        }
        if (this.availableItemsCount < (n = (this.clientArea.height - this.getHeaderHeight()) / this.itemHeight)) {
            return;
        }
        int n2 = Math.min(treeItem.availableIndex, this.availableItemsCount - n);
        if (this.topIndex == n2) {
            return;
        }
        this.update();
        int n3 = this.topIndex - n2;
        this.topIndex = n2;
        ScrollBar scrollBar = this.getVerticalBar();
        if (scrollBar != null) {
            scrollBar.setSelection(this.topIndex);
        }
        if (this.drawCount <= 0) {
            GC gC = new GC(this);
            gC.copyArea(0, 0, this.clientArea.width, this.clientArea.height, 0, n3 * this.itemHeight);
            gC.dispose();
        }
    }

    public void showColumn(TreeColumn treeColumn) {
        this.checkWidget();
        if (treeColumn == null) {
            this.error(4);
        }
        if (treeColumn.isDisposed()) {
            this.error(5);
        }
        if (treeColumn.parent != this) {
            return;
        }
        int n = treeColumn.getX();
        int n2 = n + treeColumn.width;
        if (n >= 0 && n2 <= this.clientArea.width) {
            return;
        }
        this.headerHideToolTip();
        int n3 = 0;
        TreeColumn[] treeColumnArray = this.getOrderedColumns();
        int n4 = 0;
        while (n4 < treeColumn.getOrderIndex()) {
            n3 += treeColumnArray[n4].width;
            ++n4;
        }
        this.horizontalOffset = n < this.clientArea.x ? n3 : n3 + treeColumn.width - this.clientArea.width;
        ScrollBar scrollBar = this.getHorizontalBar();
        if (scrollBar != null) {
            scrollBar.setSelection(this.horizontalOffset);
        }
        this.redraw();
        if (this.drawCount <= 0 && this.header.isVisible()) {
            this.header.redraw();
        }
    }

    public void showItem(TreeItem treeItem) {
        this.checkWidget();
        if (treeItem == null) {
            this.error(4);
        }
        if (treeItem.isDisposed()) {
            this.error(5);
        }
        if (treeItem.parent != this) {
            return;
        }
        if (!treeItem.isAvailable()) {
            treeItem.parentItem.expandAncestors();
        }
        int n = treeItem.availableIndex;
        int n2 = (this.clientArea.height - this.getHeaderHeight()) / this.itemHeight;
        if (this.topIndex <= n && n < this.topIndex + n2) {
            return;
        }
        if (n <= this.topIndex) {
            this.setTopItem(treeItem);
        } else {
            n2 = Math.max(n2, 1);
            this.setTopItem(this.availableItems[Math.min(n - n2 + 1, this.availableItemsCount - 1)]);
        }
    }

    public void showSelection() {
        this.checkWidget();
        if (this.selectedItems.length == 0) {
            return;
        }
        this.showItem(this.selectedItems[0]);
    }

    void updateColumnWidth(TreeColumn treeColumn, int n) {
        int n2;
        int n3;
        int n4;
        this.headerHideToolTip();
        int n5 = treeColumn.width;
        int n6 = treeColumn.getX();
        int n7 = n6 + n5 - 1;
        this.update();
        GC gC = new GC(this);
        gC.copyArea(n7, 0, this.clientArea.width - n7, this.clientArea.height, n6 + n - 1, 0);
        if (n > n5) {
            n4 = n - n5 + 1;
            this.redraw(n7 - 1, 0, n4 + 1, this.clientArea.height, false);
        } else {
            n4 = n5 - n + 1;
            this.redraw(this.clientArea.width - n4, 0, n4, this.clientArea.height, false);
        }
        if (this.focusItem != null) {
            this.redrawItem(this.focusItem.availableIndex, true);
        }
        GC gC2 = new GC(this.header);
        if (this.drawCount <= 0 && this.header.getVisible()) {
            Rectangle rectangle = this.header.getClientArea();
            this.header.update();
            gC2.copyArea(--n7, 0, rectangle.width - n7, rectangle.height, n6 + n - 2, 0);
            if (n > n5) {
                n3 = n - n5 + 2;
                this.header.redraw(n7, 0, n3, rectangle.height, false);
            } else {
                n3 = n5 - n + 2;
                this.header.redraw(rectangle.width - n3, 0, n3, rectangle.height, false);
            }
        }
        treeColumn.width = n;
        treeColumn.updateWidth(gC2);
        gC2.dispose();
        int n8 = 0;
        while (n8 < this.items.length) {
            this.items[n8].updateColumnWidth(treeColumn, gC);
            ++n8;
        }
        gC.dispose();
        n8 = 0;
        n3 = 0;
        while (n3 < this.columns.length) {
            n8 += this.columns[n3].width;
            ++n3;
        }
        ScrollBar scrollBar = this.getHorizontalBar();
        if (scrollBar != null) {
            scrollBar.setMaximum(Math.max(1, n8));
            if (scrollBar.getThumb() != this.clientArea.width) {
                scrollBar.setThumb(this.clientArea.width);
                scrollBar.setPageIncrement(this.clientArea.width);
            }
            int n9 = this.horizontalOffset;
            scrollBar.setVisible(this.clientArea.width < n8);
            n2 = scrollBar.getSelection();
            if (n2 != n9) {
                this.horizontalOffset = n2;
                this.redraw();
                if (this.drawCount <= 0 && this.header.getVisible()) {
                    this.header.redraw();
                }
            }
        }
        treeColumn.sendEvent(11);
        TreeColumn[] treeColumnArray = this.getOrderedColumns();
        n2 = treeColumn.getOrderIndex() + 1;
        while (n2 < treeColumnArray.length) {
            if (!treeColumnArray[n2].isDisposed()) {
                treeColumnArray[n2].sendEvent(10);
            }
            ++n2;
        }
        if (this.availableItemsCount == 0) {
            this.redraw();
        }
    }

    void updateHorizontalBar() {
        int n;
        int n2;
        if (this.drawCount > 0) {
            return;
        }
        ScrollBar scrollBar = this.getHorizontalBar();
        if (scrollBar == null) {
            return;
        }
        int n3 = 0;
        if (this.columns.length > 0) {
            n2 = 0;
            while (n2 < this.columns.length) {
                n3 += this.columns[n2].width;
                ++n2;
            }
        } else {
            n2 = 0;
            while (n2 < this.availableItemsCount) {
                Rectangle rectangle = this.availableItems[n2].getCellBounds(0);
                n3 = Math.max(n3, rectangle.x + rectangle.width + this.horizontalOffset);
                ++n2;
            }
        }
        n2 = this.clientArea.width;
        if (n3 != scrollBar.getMaximum()) {
            scrollBar.setMaximum(Math.max(1, n3));
        }
        if ((n = Math.min(n2, n3)) != scrollBar.getThumb()) {
            scrollBar.setThumb(n);
            scrollBar.setPageIncrement(n);
        }
        scrollBar.setVisible(n2 < n3);
        if (n3 < this.horizontalOffset + n) {
            this.horizontalOffset = n3 - n;
            scrollBar.setSelection(this.horizontalOffset);
            this.redraw();
        } else {
            int n4 = scrollBar.getSelection();
            if (n4 != this.horizontalOffset) {
                this.horizontalOffset = n4;
                this.redraw();
            }
        }
    }

    void updateHorizontalBar(int n, int n2) {
        if (this.drawCount > 0) {
            return;
        }
        ScrollBar scrollBar = this.getHorizontalBar();
        if (scrollBar == null) {
            return;
        }
        int n3 = scrollBar.getMaximum();
        if ((n += this.horizontalOffset) > n3) {
            scrollBar.setMaximum(n);
            int n4 = this.clientArea.width;
            int n5 = Math.min(n, n4);
            if (scrollBar.getThumb() != n5) {
                scrollBar.setThumb(n5);
                scrollBar.setPageIncrement(n5);
            }
            scrollBar.setVisible(n4 <= n);
            return;
        }
        int n6 = n - n2;
        if (n6 != n3) {
            int n7 = this.clientArea.width;
            int n8 = Math.min(n3, n7);
            if (scrollBar.getThumb() != n8) {
                scrollBar.setThumb(n8);
                scrollBar.setPageIncrement(n8);
            }
            scrollBar.setVisible(n7 <= n3);
            return;
        }
        this.updateHorizontalBar();
    }

    void updateVerticalBar() {
        int n;
        if (this.drawCount > 0) {
            return;
        }
        ScrollBar scrollBar = this.getVerticalBar();
        if (scrollBar == null) {
            return;
        }
        int n2 = (this.clientArea.height - this.getHeaderHeight()) / this.itemHeight;
        int n3 = Math.max(1, this.availableItemsCount);
        if (n3 != scrollBar.getMaximum()) {
            scrollBar.setMaximum(n3);
        }
        if ((n = Math.min(n2, n3)) != scrollBar.getThumb()) {
            scrollBar.setThumb(n);
            scrollBar.setPageIncrement(n);
        }
        scrollBar.setVisible(n2 < n3);
        if (n3 < this.topIndex + n) {
            this.topIndex = n3 - n;
            scrollBar.setSelection(this.topIndex);
            this.redraw();
        } else {
            int n4 = scrollBar.getSelection();
            if (n4 != this.topIndex) {
                this.topIndex = n4;
                this.redraw();
            }
        }
    }
}

