/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSAttributedString;
import org.eclipse.swt.internal.cocoa.NSColor;
import org.eclipse.swt.internal.cocoa.NSDictionary;
import org.eclipse.swt.internal.cocoa.NSFont;
import org.eclipse.swt.internal.cocoa.NSMutableArray;
import org.eclipse.swt.internal.cocoa.NSNumber;
import org.eclipse.swt.internal.cocoa.NSObject;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRange;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class IME
extends Widget {
    Canvas parent;
    int caretOffset;
    int startOffset;
    int commitCount;
    String text;
    int[] ranges;
    TextStyle[] styles;
    static final int UNDERLINE_THICK = 65536;

    IME() {
    }

    public IME(Canvas canvas, int n) {
        super(canvas, n);
        this.parent = canvas;
        this.createWidget();
    }

    int attributedSubstringFromRange(int n, int n2, int n3) {
        Event event = new Event();
        event.detail = 3;
        this.sendEvent(43, event);
        NSRange nSRange = new NSRange();
        OS.memmove(nSRange, n3, NSRange.sizeof);
        int n4 = nSRange.location;
        int n5 = nSRange.location + nSRange.length;
        if (event.start <= n4 && n4 <= event.end && event.start <= n5 && n5 <= event.end) {
            NSString nSString = NSString.stringWith(event.text.substring(n4 - event.start, n5 - event.start));
            NSAttributedString nSAttributedString = ((NSAttributedString)new NSAttributedString().alloc()).initWithString(nSString, null);
            nSAttributedString.autorelease();
            return nSAttributedString.id;
        }
        return 0;
    }

    int characterIndexForPoint(int n, int n2, int n3) {
        if (!this.isInlineEnabled()) {
            return Integer.MAX_VALUE;
        }
        NSPoint nSPoint = new NSPoint();
        OS.memmove(nSPoint, n3, NSPoint.sizeof);
        NSView nSView = this.parent.view;
        nSPoint = nSView.window().convertScreenToBase(nSPoint);
        nSPoint = nSView.convertPoint_fromView_(nSPoint, null);
        Event event = new Event();
        event.detail = 2;
        event.x = (int)nSPoint.x;
        event.y = (int)nSPoint.y;
        this.sendEvent(43, event);
        int n4 = event.index + event.count;
        return n4 != -1 ? n4 : Integer.MAX_VALUE;
    }

    void createWidget() {
        this.text = "";
        this.startOffset = -1;
        if (this.parent.getIME() == null) {
            this.parent.setIME(this);
        }
    }

    NSRect firstRectForCharacterRange(int n, int n2, int n3) {
        NSRect nSRect = new NSRect();
        Caret caret = this.parent.caret;
        if (caret != null) {
            NSView nSView = this.parent.view;
            NSPoint nSPoint = new NSPoint();
            nSPoint.x = caret.x;
            nSPoint.y = caret.y + caret.height;
            nSPoint = nSView.convertPoint_toView_(nSPoint, null);
            nSPoint = nSView.window().convertBaseToScreen(nSPoint);
            nSRect.x = nSPoint.x;
            nSRect.y = nSPoint.y;
            nSRect.width = caret.width;
            nSRect.height = caret.height;
        }
        return nSRect;
    }

    public int getCaretOffset() {
        this.checkWidget();
        return this.startOffset + this.caretOffset;
    }

    public int getCommitCount() {
        this.checkWidget();
        return this.commitCount;
    }

    public int getCompositionOffset() {
        this.checkWidget();
        return this.startOffset;
    }

    public int[] getRanges() {
        this.checkWidget();
        if (this.ranges == null) {
            return new int[0];
        }
        int[] nArray = new int[this.ranges.length];
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = this.ranges[n] + this.startOffset;
            ++n;
        }
        return nArray;
    }

    public TextStyle[] getStyles() {
        this.checkWidget();
        if (this.styles == null) {
            return new TextStyle[0];
        }
        TextStyle[] textStyleArray = new TextStyle[this.styles.length];
        System.arraycopy(this.styles, 0, textStyleArray, 0, this.styles.length);
        return textStyleArray;
    }

    TextStyle getStyle(NSDictionary nSDictionary) {
        NSArray nSArray = nSDictionary.allKeys();
        int n = nSArray.count();
        TextStyle textStyle = new TextStyle();
        int n2 = 0;
        while (n2 < n) {
            float[] fArray;
            NSObject nSObject;
            NSString nSString = new NSString(nSArray.objectAtIndex(n2));
            if (nSString.isEqualTo(OS.NSBackgroundColorAttributeName)) {
                nSObject = new NSColor(nSDictionary.objectForKey(nSString)).colorUsingColorSpaceName(OS.NSCalibratedRGBColorSpace);
                fArray = new float[]{((NSColor)nSObject).redComponent(), ((NSColor)nSObject).greenComponent(), ((NSColor)nSObject).blueComponent(), ((NSColor)nSObject).alphaComponent()};
                textStyle.background = Color.cocoa_new(this.display, fArray);
            } else if (nSString.isEqualTo(OS.NSForegroundColorAttributeName)) {
                nSObject = new NSColor(nSDictionary.objectForKey(nSString)).colorUsingColorSpaceName(OS.NSCalibratedRGBColorSpace);
                fArray = new float[]{((NSColor)nSObject).redComponent(), ((NSColor)nSObject).greenComponent(), ((NSColor)nSObject).blueComponent(), ((NSColor)nSObject).alphaComponent()};
                textStyle.foreground = Color.cocoa_new(this.display, fArray);
            } else if (nSString.isEqualTo(OS.NSUnderlineColorAttributeName)) {
                nSObject = new NSColor(nSDictionary.objectForKey(nSString)).colorUsingColorSpaceName(OS.NSCalibratedRGBColorSpace);
                fArray = new float[]{((NSColor)nSObject).redComponent(), ((NSColor)nSObject).greenComponent(), ((NSColor)nSObject).blueComponent(), ((NSColor)nSObject).alphaComponent()};
                textStyle.underlineColor = Color.cocoa_new(this.display, fArray);
            } else if (nSString.isEqualTo(OS.NSUnderlineStyleAttributeName)) {
                nSObject = new NSNumber(nSDictionary.objectForKey(nSString));
                switch (((NSNumber)nSObject).intValue()) {
                    case 1: {
                        textStyle.underlineStyle = 0;
                        break;
                    }
                    case 9: {
                        textStyle.underlineStyle = 1;
                        break;
                    }
                    case 2: {
                        textStyle.underlineStyle = 65536;
                    }
                }
                textStyle.underline = ((NSNumber)nSObject).intValue() != 0;
            } else if (nSString.isEqualTo(OS.NSStrikethroughColorAttributeName)) {
                nSObject = new NSColor(nSDictionary.objectForKey(nSString)).colorUsingColorSpaceName(OS.NSCalibratedRGBColorSpace);
                fArray = new float[]{((NSColor)nSObject).redComponent(), ((NSColor)nSObject).greenComponent(), ((NSColor)nSObject).blueComponent(), ((NSColor)nSObject).alphaComponent()};
                textStyle.strikeoutColor = Color.cocoa_new(this.display, fArray);
            } else if (nSString.isEqualTo(OS.NSStrikethroughStyleAttributeName)) {
                nSObject = new NSNumber(nSDictionary.objectForKey(nSString));
                textStyle.strikeout = ((NSNumber)nSObject).intValue() != 0;
            } else if (nSString.isEqualTo(OS.NSFontAttributeName)) {
                nSObject = new NSFont(nSDictionary.objectForKey(nSString));
                nSObject.retain();
                textStyle.font = Font.cocoa_new(this.display, (NSFont)nSObject);
            }
            ++n2;
        }
        return textStyle;
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    public boolean getWideCaret() {
        return false;
    }

    boolean hasMarkedText(int n, int n2) {
        return this.text.length() != 0;
    }

    boolean insertText(int n, int n2, int n3) {
        if (this.startOffset == -1) {
            return true;
        }
        NSString nSString = new NSString(n3);
        if (nSString.isKindOfClass(OS.objc_getClass("NSAttributedString"))) {
            nSString = new NSAttributedString(n3).string();
        }
        int n4 = nSString.length();
        int n5 = this.startOffset + this.text.length();
        this.resetStyles();
        this.caretOffset = this.commitCount = n4;
        Event event = new Event();
        event.detail = 1;
        event.start = this.startOffset;
        event.end = n5;
        event.text = this.text = nSString.getString();
        this.sendEvent(43, event);
        this.text = "";
        this.commitCount = 0;
        this.caretOffset = 0;
        this.startOffset = -1;
        return event.doit;
    }

    boolean isInlineEnabled() {
        return this.hooks(43);
    }

    NSRange markedRange(int n, int n2) {
        NSRange nSRange = new NSRange();
        if (this.startOffset != -1) {
            nSRange.location = this.startOffset;
            nSRange.length = this.text.length();
        } else {
            nSRange.location = Integer.MAX_VALUE;
        }
        return nSRange;
    }

    void resetStyles() {
        if (this.styles != null) {
            int n = 0;
            while (n < this.styles.length) {
                TextStyle textStyle = this.styles[n];
                Font font = textStyle.font;
                if (font != null) {
                    font.handle.release();
                }
                ++n;
            }
        }
        this.styles = null;
        this.ranges = null;
    }

    void releaseParent() {
        super.releaseParent();
        if (this == this.parent.getIME()) {
            this.parent.setIME(null);
        }
    }

    void releaseWidget() {
        super.releaseWidget();
        this.parent = null;
        this.text = null;
        this.resetStyles();
    }

    NSRange selectedRange(int n, int n2) {
        Event event = new Event();
        event.detail = 3;
        this.sendEvent(43, event);
        NSRange nSRange = new NSRange();
        nSRange.location = event.start;
        nSRange.length = event.text.length();
        return nSRange;
    }

    public void setCompositionOffset(int n) {
        this.checkWidget();
        if (n < 0) {
            return;
        }
        if (this.startOffset != -1) {
            this.startOffset = n;
        }
    }

    boolean setMarkedText_selectedRange(int n, int n2, int n3, int n4) {
        Object object;
        Object object2;
        Object object3;
        if (!this.isInlineEnabled()) {
            return true;
        }
        this.resetStyles();
        this.commitCount = 0;
        this.caretOffset = 0;
        int n5 = this.startOffset + this.text.length();
        if (this.startOffset == -1) {
            object3 = new Event();
            ((Event)object3).detail = 3;
            this.sendEvent(43, (Event)object3);
            this.startOffset = ((Event)object3).start;
            n5 = ((Event)object3).end;
        }
        if (((NSObject)(object3 = new NSString(n3))).isKindOfClass(OS.objc_getClass("NSAttributedString"))) {
            Object object4;
            NSAttributedString nSAttributedString = new NSAttributedString(n3);
            object3 = nSAttributedString.string();
            int n6 = ((NSString)object3).length();
            this.styles = new TextStyle[n6];
            this.ranges = new int[n6 * 2];
            object2 = new NSRange();
            object = new NSRange();
            ((NSRange)object2).length = n6;
            int n7 = 0;
            int n8 = OS.malloc(NSRange.sizeof);
            int n9 = 0;
            while (n9 < n6) {
                object4 = nSAttributedString.attributesAtIndex(n9, n8, (NSRange)object2);
                OS.memmove((NSRange)object, n8, NSRange.sizeof);
                n9 = ((NSRange)object).location + ((NSRange)object).length;
                this.ranges[n7 * 2] = ((NSRange)object).location;
                this.ranges[n7 * 2 + 1] = ((NSRange)object).location + ((NSRange)object).length - 1;
                this.styles[n7++] = this.getStyle((NSDictionary)object4);
            }
            OS.free(n8);
            if (n7 != this.styles.length) {
                TextStyle[] textStyleArray = new TextStyle[n7];
                System.arraycopy(this.styles, 0, textStyleArray, 0, textStyleArray.length);
                this.styles = textStyleArray;
                object4 = new int[n7 * 2];
                System.arraycopy(this.ranges, 0, object4, 0, ((Object)object4).length);
                this.ranges = (int[])object4;
            }
        }
        int n10 = ((NSString)object3).length();
        if (this.ranges == null && n10 > 0) {
            this.styles = new TextStyle[]{this.getStyle(this.display.markedAttributes)};
            int[] nArray = new int[2];
            nArray[1] = n10 - 1;
            this.ranges = nArray;
        }
        NSRange nSRange = new NSRange();
        OS.memmove(nSRange, n4, NSRange.sizeof);
        this.caretOffset = nSRange.location;
        object2 = new Event();
        ((Event)object2).detail = 1;
        ((Event)object2).start = this.startOffset;
        ((Event)object2).end = n5;
        ((Event)object2).text = this.text = ((NSString)object3).getString();
        this.sendEvent(43, (Event)object2);
        if (this.isDisposed()) {
            return false;
        }
        if (this.text.length() == 0) {
            object = this.parent.getShell();
            ((Shell)object).keyInputHappened = true;
            this.startOffset = -1;
            this.resetStyles();
        }
        return true;
    }

    int validAttributesForMarkedText(int n, int n2) {
        NSMutableArray nSMutableArray = NSMutableArray.arrayWithCapacity(6);
        nSMutableArray.addObject(new NSString(OS.NSForegroundColorAttributeName()));
        nSMutableArray.addObject(new NSString(OS.NSBackgroundColorAttributeName()));
        nSMutableArray.addObject(new NSString(OS.NSUnderlineStyleAttributeName()));
        nSMutableArray.addObject(new NSString(OS.NSUnderlineColorAttributeName()));
        nSMutableArray.addObject(new NSString(OS.NSStrikethroughStyleAttributeName()));
        nSMutableArray.addObject(new NSString(OS.NSStrikethroughColorAttributeName()));
        return nSMutableArray.id;
    }
}

