/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.DropTargetEffect;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class TreeDropTargetEffect
extends DropTargetEffect {
    static final int SCROLL_HYSTERESIS = 150;
    static final int EXPAND_HYSTERESIS = 1000;
    int currentEffect = 0;
    TreeItem currentItem;
    PaintListener paintListener;
    TreeItem dropSelection = null;
    TreeItem insertItem = null;
    boolean insertBefore = false;
    TreeItem scrollItem;
    long scrollBeginTime;
    TreeItem expandItem;
    long expandBeginTime;

    public TreeDropTargetEffect(Tree tree) {
        super(tree);
    }

    int checkEffect(int n) {
        if ((n & 1) != 0) {
            n = n & 0xFFFFFFFB & 0xFFFFFFFD;
        }
        if ((n & 2) != 0) {
            n &= 0xFFFFFFFB;
        }
        return n;
    }

    public void dragEnter(DropTargetEvent dropTargetEvent) {
        this.insertItem = null;
        this.currentItem = null;
        this.dropSelection = null;
        this.expandBeginTime = 0L;
        this.expandItem = null;
        this.scrollBeginTime = 0L;
        this.scrollItem = null;
    }

    public void dragLeave(DropTargetEvent dropTargetEvent) {
        Tree tree = (Tree)this.control;
        if (this.insertItem != null) {
            tree.setInsertMark(null, false);
            this.insertItem = null;
        }
        if (this.currentItem != null) {
            this.setDropSelection(tree, null);
            this.currentItem = null;
        }
        this.expandBeginTime = 0L;
        this.expandItem = null;
        this.scrollBeginTime = 0L;
        this.scrollItem = null;
    }

    public void dragOver(DropTargetEvent dropTargetEvent) {
        Object object;
        Tree tree = (Tree)this.control;
        int n = this.checkEffect(dropTargetEvent.feedback);
        TreeItem treeItem = (TreeItem)this.getItem(tree, dropTargetEvent.x, dropTargetEvent.y);
        if ((n & 0x10) == 0) {
            this.expandBeginTime = 0L;
            this.expandItem = null;
        } else if (treeItem != null && treeItem.equals(this.expandItem) && this.expandBeginTime != 0L) {
            if (System.currentTimeMillis() >= this.expandBeginTime) {
                if (treeItem.getItemCount() > 0 && !treeItem.getExpanded()) {
                    object = new Event();
                    ((Event)object).x = dropTargetEvent.x;
                    ((Event)object).y = dropTargetEvent.y;
                    ((Event)object).item = treeItem;
                    ((Event)object).time = (int)System.currentTimeMillis();
                    tree.notifyListeners(17, (Event)object);
                    if (treeItem.isDisposed()) {
                        return;
                    }
                    treeItem.setExpanded(true);
                }
                this.expandBeginTime = 0L;
                this.expandItem = null;
            }
        } else {
            this.expandBeginTime = System.currentTimeMillis() + 1000L;
            this.expandItem = treeItem;
        }
        if ((n & 8) == 0) {
            this.scrollBeginTime = 0L;
            this.scrollItem = null;
        } else if (treeItem != null && treeItem.equals(this.scrollItem) && this.scrollBeginTime != 0L) {
            if (System.currentTimeMillis() >= this.scrollBeginTime) {
                object = tree.getClientArea();
                int n2 = tree.getHeaderHeight();
                int n3 = tree.getItemHeight();
                Point point = new Point(dropTargetEvent.x, dropTargetEvent.y);
                point = tree.getDisplay().map(null, (Control)tree, point);
                TreeItem treeItem2 = null;
                if (point.y < ((Rectangle)object).y + n2 + 2 * n3) {
                    treeItem2 = this.previousItem(tree, treeItem);
                }
                if (point.y > ((Rectangle)object).y + ((Rectangle)object).height - 2 * n3) {
                    treeItem2 = this.nextItem(tree, treeItem);
                }
                if (treeItem2 != null) {
                    tree.showItem(treeItem2);
                }
                this.scrollBeginTime = 0L;
                this.scrollItem = null;
            }
        } else {
            this.scrollBeginTime = System.currentTimeMillis() + 150L;
            this.scrollItem = treeItem;
        }
        if ((n & 1) != 0) {
            if (this.currentItem != treeItem || (this.currentEffect & 1) == 0) {
                this.setDropSelection(tree, treeItem);
                this.currentEffect = n;
                this.currentItem = treeItem;
            }
        } else {
            this.setDropSelection(tree, null);
        }
        if ((n & 4) != 0 || (n & 2) != 0) {
            if (this.currentItem != treeItem || (n & 4) != (this.currentEffect & 4) || (n & 2) != (this.currentEffect & 2)) {
                this.setInsertMark(tree, treeItem, (n & 2) != 0);
                this.currentEffect = n;
                this.currentItem = treeItem;
            }
        } else {
            this.setInsertMark(tree, null, false);
        }
    }

    void setDropSelection(Tree tree, TreeItem treeItem) {
        Rectangle rectangle;
        if (treeItem == this.dropSelection) {
            return;
        }
        if (this.dropSelection != null && !this.dropSelection.isDisposed()) {
            rectangle = this.dropSelection.getBounds();
            tree.redraw(rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
        }
        this.dropSelection = treeItem;
        if (this.dropSelection != null && !this.dropSelection.isDisposed()) {
            rectangle = this.dropSelection.getBounds();
            tree.redraw(rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
        }
        if (this.dropSelection == null) {
            if (this.paintListener != null) {
                tree.removePaintListener(this.paintListener);
                this.paintListener = null;
            }
        } else if (this.paintListener == null) {
            this.paintListener = new PaintListener(){

                public void paintControl(PaintEvent paintEvent) {
                    if (TreeDropTargetEffect.this.dropSelection == null || TreeDropTargetEffect.this.dropSelection.isDisposed()) {
                        return;
                    }
                    GC gC = paintEvent.gc;
                    boolean bl = gC.getXORMode();
                    gC.setXORMode(true);
                    Rectangle rectangle = TreeDropTargetEffect.this.dropSelection.getBounds();
                    gC.fillRectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    gC.setXORMode(bl);
                }
            };
            tree.addPaintListener(this.paintListener);
        }
    }

    void setInsertMark(Tree tree, TreeItem treeItem, boolean bl) {
        if (treeItem == this.insertItem && bl == this.insertBefore) {
            return;
        }
        this.insertItem = treeItem;
        this.insertBefore = bl;
        tree.setInsertMark(treeItem, bl);
    }
}

