/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;

public final class FontData {
    public String foundry;
    public String fontFamily;
    public String weight;
    public String slant;
    public String setWidth;
    public String addStyle;
    public int pixels;
    public int points;
    public int horizontalResolution;
    public int verticalResolution;
    public String spacing;
    public int averageWidth;
    public String characterSetRegistry;
    public String characterSetName;
    String lang;
    String country;
    String variant;

    public FontData() {
    }

    public FontData(String string) {
        if (string == null) {
            SWT.error(4);
        }
        int n = 0;
        int n2 = string.indexOf(124);
        if (n2 == -1) {
            SWT.error(4);
        }
        String string2 = string.substring(n, n2);
        try {
            if (Integer.parseInt(string2) != 1) {
                SWT.error(5);
            }
        }
        catch (NumberFormatException numberFormatException) {
            SWT.error(5);
        }
        if ((n2 = string.indexOf(124, n = n2 + 1)) == -1) {
            SWT.error(4);
        }
        String string3 = string.substring(n, n2);
        n = n2 + 1;
        if ((n2 = string.indexOf(124, n)) == -1) {
            SWT.error(4);
        }
        float f = 0.0f;
        try {
            f = Float.parseFloat(string.substring(n, n2));
        }
        catch (NumberFormatException numberFormatException) {
            SWT.error(4);
        }
        n = n2 + 1;
        n2 = string.indexOf(124, n);
        if (n2 == -1) {
            SWT.error(4);
        }
        int n3 = 0;
        try {
            n3 = Integer.parseInt(string.substring(n, n2));
        }
        catch (NumberFormatException numberFormatException) {
            SWT.error(4);
        }
        n = n2 + 1;
        n2 = string.indexOf(124, n);
        if (n2 == -1) {
            this.setName(string3);
            this.setHeight(f);
            this.setStyle(n3);
            return;
        }
        String string4 = string.substring(n, n2);
        n = n2 + 1;
        if ((n2 = string.indexOf(124, n)) == -1) {
            this.setName(string3);
            this.setHeight(f);
            this.setStyle(n3);
            return;
        }
        String string5 = string.substring(n, n2);
        if (string4.equals("MOTIF") && string5.equals("1")) {
            n = n2 + 1;
            n2 = string.length();
            if (n2 == -1) {
                this.setName(string3);
                this.setHeight(f);
                this.setStyle(n3);
                return;
            }
            String string6 = string.substring(n, n2);
            this.setXlfd(string6);
            return;
        }
        this.setName(string3);
        this.setHeight(f);
        this.setStyle(n3);
    }

    public FontData(String string, int n, int n2) {
        int n3;
        if (string == null) {
            SWT.error(4);
        }
        if (n < 0) {
            SWT.error(5);
        }
        if ((n3 = string.indexOf(45)) != -1) {
            this.foundry = string.substring(0, n3);
            this.fontFamily = string.substring(n3 + 1);
        } else {
            this.fontFamily = string;
        }
        this.points = n * 10;
        this.weight = (n2 & 1) != 0 ? "bold" : "medium";
        this.slant = (n2 & 2) != 0 ? "i" : "r";
    }

    FontData(String string, float f, int n) {
        int n2;
        if (string == null) {
            SWT.error(4);
        }
        if (f < 0.0f) {
            SWT.error(5);
        }
        if ((n2 = string.indexOf(45)) != -1) {
            this.foundry = string.substring(0, n2);
            this.fontFamily = string.substring(n2 + 1);
        } else {
            this.fontFamily = string;
        }
        this.points = (int)(f * 10.0f);
        this.weight = (n & 1) != 0 ? "bold" : "medium";
        this.slant = (n & 2) != 0 ? "i" : "r";
    }

    public boolean equals(Object object) {
        return object == this || object instanceof FontData && this.getXlfd().equals(((FontData)object).getXlfd());
    }

    public int getHeight() {
        return this.points / 10;
    }

    float getHeightF() {
        return (float)this.points / 10.0f;
    }

    public String getLocale() {
        String string;
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        char c = '_';
        if (this.lang != null) {
            stringBuffer.append(this.lang);
            stringBuffer.append(c);
        }
        if (this.country != null) {
            stringBuffer.append(this.country);
            stringBuffer.append(c);
        }
        if (this.variant != null) {
            stringBuffer.append(this.variant);
        }
        if ((n = (string = stringBuffer.toString()).length()) > 0 && string.charAt(n - 1) == c) {
            string = string.substring(0, n - 1);
        }
        return string;
    }

    public String getName() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.foundry != null) {
            stringBuffer.append(this.foundry);
            stringBuffer.append("-");
        }
        if (this.fontFamily != null) {
            stringBuffer.append(this.fontFamily);
        }
        return stringBuffer.toString();
    }

    public int getStyle() {
        int n = 0;
        if (this.weight != null && this.weight.equals("bold")) {
            n |= 1;
        }
        if (this.slant != null && this.slant.equals("i")) {
            n |= 2;
        }
        return n;
    }

    String getXlfd() {
        String string = "*";
        String string2 = "*";
        String string3 = "*";
        String string4 = "*";
        String string5 = "*";
        String string6 = "*";
        String string7 = "*";
        String string8 = "*";
        String string9 = "*";
        String string10 = "*";
        String string11 = "*";
        String string12 = "*";
        String string13 = "*";
        String string14 = "*";
        if (this.foundry != null) {
            string14 = this.foundry;
        }
        if (this.fontFamily != null) {
            string13 = this.fontFamily;
        }
        if (this.weight != null) {
            string12 = this.weight;
        }
        if (this.slant != null) {
            string11 = this.slant;
        }
        if (this.setWidth != null) {
            string10 = this.setWidth;
        }
        if (this.addStyle != null) {
            string9 = this.addStyle;
        }
        if (this.pixels != 0) {
            string8 = Integer.toString(this.pixels);
        }
        if (this.points != 0) {
            string7 = Integer.toString(this.points);
        }
        if (this.horizontalResolution != 0) {
            string6 = Integer.toString(this.horizontalResolution);
        }
        if (this.verticalResolution != 0) {
            string5 = Integer.toString(this.verticalResolution);
        }
        if (this.spacing != null) {
            string4 = this.spacing;
        }
        if (this.averageWidth != 0) {
            string3 = Integer.toString(this.averageWidth);
        }
        if (this.characterSetRegistry != null) {
            string2 = this.characterSetRegistry;
        }
        if (this.characterSetName != null) {
            string = this.characterSetName;
        }
        return "-" + string14 + "-" + string13 + "-" + string12 + "-" + string11 + "-" + string10 + "-" + string9 + "-" + string8 + "-" + string7 + "-" + string6 + "-" + string5 + "-" + string4 + "-" + string3 + "-" + string2 + "-" + string;
    }

    public int hashCode() {
        return this.getXlfd().hashCode();
    }

    public static FontData motif_new(String string) {
        FontData fontData = new FontData();
        fontData.setXlfd(string);
        return fontData;
    }

    public void setHeight(int n) {
        if (n < 0) {
            SWT.error(5);
        }
        this.points = n * 10;
    }

    void setHeight(float f) {
        if (f < 0.0f) {
            SWT.error(5);
        }
        this.points = (int)(f * 10.0f);
    }

    public void setName(String string) {
        int n;
        if (string == null) {
            SWT.error(4);
        }
        if ((n = string.indexOf(45)) != -1) {
            this.foundry = string.substring(0, n);
            this.fontFamily = string.substring(n + 1);
        } else {
            this.fontFamily = string;
        }
    }

    public void setLocale(String string) {
        this.variant = null;
        this.country = null;
        this.lang = null;
        if (string != null) {
            int n;
            int n2 = 95;
            int n3 = string.length();
            int n4 = string.indexOf(n2);
            if (n4 == -1) {
                n4 = n = n3;
            } else {
                n = string.indexOf(n2, n4 + 1);
                if (n == -1) {
                    n = n3;
                }
            }
            if (n4 > 0) {
                this.lang = string.substring(0, n4);
            }
            if (n > n4 + 1) {
                this.country = string.substring(n4 + 1, n);
            }
            if (n3 > n + 1) {
                this.variant = string.substring(n + 1);
            }
        }
    }

    public void setStyle(int n) {
        this.weight = (n & 1) != 0 ? "bold" : "medium";
        this.slant = (n & 2) != 0 ? "i" : "r";
        this.averageWidth = 0;
    }

    void setXlfd(String string) {
        String string2;
        int n = 1;
        int n2 = string.indexOf("-", n);
        this.foundry = string.substring(n, n2);
        if (this.foundry.equals("*")) {
            this.foundry = null;
        }
        n = n2 + 1;
        n2 = string.indexOf("-", n);
        this.fontFamily = string.substring(n, n2);
        if (this.fontFamily.equals("*")) {
            this.fontFamily = null;
        }
        n = n2 + 1;
        n2 = string.indexOf("-", n);
        this.weight = string.substring(n, n2);
        if (this.weight.equals("*")) {
            this.weight = null;
        }
        n = n2 + 1;
        n2 = string.indexOf("-", n);
        this.slant = string.substring(n, n2);
        if (this.slant.equals("*")) {
            this.slant = null;
        }
        n = n2 + 1;
        n2 = string.indexOf("-", n);
        this.setWidth = string.substring(n, n2);
        if (this.setWidth.equals("*")) {
            this.setWidth = null;
        }
        n = n2 + 1;
        n2 = string.indexOf("-", n);
        this.addStyle = string.substring(n, n2);
        if (this.addStyle.equals("*")) {
            this.addStyle = null;
        }
        if (!(string2 = string.substring(n = n2 + 1, n2 = string.indexOf("-", n))).equals("") && !string2.equals("*")) {
            this.pixels = Integer.parseInt(string2);
        }
        if (!(string2 = string.substring(n = n2 + 1, n2 = string.indexOf("-", n))).equals("") && !string2.equals("*")) {
            this.points = Integer.parseInt(string2);
        }
        if (!(string2 = string.substring(n = n2 + 1, n2 = string.indexOf("-", n))).equals("") && !string2.equals("*")) {
            this.horizontalResolution = Integer.parseInt(string2);
        }
        if (!(string2 = string.substring(n = n2 + 1, n2 = string.indexOf("-", n))).equals("") && !string2.equals("*")) {
            this.verticalResolution = Integer.parseInt(string2);
        }
        n = n2 + 1;
        n2 = string.indexOf("-", n);
        this.spacing = string.substring(n, n2);
        n = n2 + 1;
        string2 = string.substring(n, n2 = string.indexOf("-", n));
        if (!string2.equals("") && !string2.equals("*")) {
            if (string2.startsWith("~")) {
                string2 = "-" + string2.substring(1);
            }
            this.averageWidth = Integer.parseInt(string2);
        }
        n = n2 + 1;
        n2 = string.indexOf("-", n);
        this.characterSetRegistry = string.substring(n, n2);
        if (this.characterSetRegistry.equals("*")) {
            this.characterSetRegistry = null;
        }
        n = n2 + 1;
        n2 = string.indexOf("-", n);
        this.characterSetName = string.substring(n);
        if (this.characterSetName.equals("*")) {
            this.characterSetName = null;
        }
    }

    public String toString() {
        return "1|" + this.fontFamily + "|" + this.getHeightF() + "|" + this.getStyle() + "|" + "MOTIF|1|" + this.getXlfd();
    }
}

