/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import java.io.InputStream;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.internal.motif.Visual;
import org.eclipse.swt.internal.motif.XColor;
import org.eclipse.swt.internal.motif.XGCValues;
import org.eclipse.swt.internal.motif.XImage;

public final class Image
extends Resource
implements Drawable {
    public int type;
    public int pixmap;
    public int mask;
    int surface;
    int transparentPixel = -1;
    GC memGC;
    byte[] alphaData;
    int alpha = -1;
    int width = -1;
    int height = -1;
    static final int DEFAULT_SCANLINE_PAD = 4;

    Image(Device device) {
        super(device);
    }

    public Image(Device device, int n, int n2) {
        super(device);
        this.init(n, n2);
        this.init();
    }

    public Image(Device device, Image image, int n) {
        super(device);
        int n2;
        device = this.device;
        if (image == null) {
            SWT.error(4);
        }
        if (image.isDisposed()) {
            SWT.error(5);
        }
        int n3 = device.xDisplay;
        this.type = image.type;
        this.mask = 0;
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        OS.XGetGeometry(n3, image.pixmap, nArray, nArray, nArray, nArray2, nArray3, nArray, nArray);
        int n4 = nArray2[0];
        int n5 = nArray3[0];
        int n6 = OS.XDefaultRootWindow(n3);
        if (n != 2 && (image.type == 1 && image.mask != 0 || image.transparentPixel != -1)) {
            if (image.transparentPixel != -1) {
                image.createMask();
            }
            int n7 = OS.XCreatePixmap(n3, n6, n4, n5, 1);
            n2 = OS.XCreateGC(n3, n7, 0, null);
            OS.XCopyArea(n3, image.mask, n7, n2, 0, 0, n4, n5, 0, 0);
            OS.XFreeGC(n3, n2);
            this.mask = n7;
            if (image.transparentPixel != -1 && image.memGC != null) {
                image.destroyMask();
            }
        }
        switch (n) {
            case 0: {
                int[] nArray4 = new int[1];
                OS.XGetGeometry(n3, image.pixmap, nArray, nArray, nArray, nArray, nArray, nArray, nArray4);
                n2 = OS.XCreatePixmap(n3, n6, n4, n5, nArray4[0]);
                int n8 = OS.XCreateGC(n3, n2, 0, null);
                OS.XCopyArea(n3, image.pixmap, n2, n8, 0, 0, n4, n5, 0, 0);
                OS.XFreeGC(n3, n8);
                this.pixmap = n2;
                this.transparentPixel = image.transparentPixel;
                this.alpha = image.alpha;
                if (image.alphaData != null) {
                    this.alphaData = new byte[image.alphaData.length];
                    System.arraycopy(image.alphaData, 0, this.alphaData, 0, this.alphaData.length);
                }
                this.createAlphaMask(n4, n5);
                break;
            }
            case 1: {
                int n9;
                XImage xImage = new XImage();
                int n10 = OS.XGetImage(n3, image.pixmap, 0, 0, n4, n5, -1, 2);
                OS.memmove(xImage, n10, 88);
                byte[] byArray = new byte[xImage.bytes_per_line * xImage.height];
                OS.memmove(byArray, xImage.data, byArray.length);
                int n11 = OS.XCreatePixmap(n3, n6, n4, n5, xImage.depth);
                int n12 = OS.XDefaultVisual(n3, OS.XDefaultScreen(n3));
                int n13 = OS.XDefaultDepthOfScreen(OS.XDefaultScreenOfDisplay(n3));
                int n14 = OS.XCreateImage(n3, n12, n13, 2, 0, 0, n4, n5, xImage.bitmap_pad, 0);
                XImage xImage2 = new XImage();
                OS.memmove(xImage2, n14, 88);
                int n15 = xImage2.bytes_per_line * xImage2.height;
                xImage2.data = n9 = OS.XtMalloc(n15);
                OS.memmove(n14, xImage2, 88);
                byte[] byArray2 = new byte[n15];
                Color color = device.getSystemColor(18);
                Color color2 = device.getSystemColor(22);
                int n16 = color.handle.pixel;
                int n17 = color2.handle.pixel;
                switch (xImage.bits_per_pixel) {
                    case 1: {
                        int n18 = OS.XCreateGC(n3, n6, 0, null);
                        n2 = OS.XCreatePixmap(n3, n6, n4, n5, 1);
                        OS.XCopyArea(n3, image.pixmap, n2, n18, 0, 0, n4, n5, 0, 0);
                        OS.XDestroyImage(n10);
                        OS.XDestroyImage(n14);
                        OS.XFreeGC(n3, n18);
                        return;
                    }
                    case 4: {
                        SWT.error(20);
                        break;
                    }
                    case 8: {
                        int n19 = 0;
                        XColor[] xColorArray = new XColor[256];
                        int n20 = OS.XDefaultColormap(n3, OS.XDefaultScreen(n3));
                        int n21 = 0;
                        while (n21 < xImage.height) {
                            int n22 = 0;
                            while (n22 < xImage.bytes_per_line) {
                                XColor xColor;
                                int n23 = byArray[n19 + n22] & 0xFF;
                                if (xColorArray[n23] == null) {
                                    xColor = new XColor();
                                    xColor.pixel = n23;
                                    OS.XQueryColor(n3, n20, xColor);
                                    xColorArray[n23] = xColor;
                                }
                                xColor = xColorArray[n23];
                                int n24 = xColor.red >> 8 & 0xFF;
                                int n25 = xColor.green >> 8 & 0xFF;
                                int n26 = xColor.blue >> 8 & 0xFF;
                                byArray2[n19 + n22] = n24 * n24 + n25 * n25 + n26 * n26 < 98304 ? (byte)n16 : (byte)n17;
                                ++n22;
                            }
                            n19 += xImage.bytes_per_line;
                            ++n21;
                        }
                        break;
                    }
                    case 16: {
                        int n27 = 0;
                        Visual visual = new Visual();
                        OS.memmove(visual, n12, 32);
                        int n28 = visual.red_mask;
                        int n29 = visual.green_mask;
                        int n30 = visual.blue_mask;
                        int[] nArray5 = new int[1];
                        Image.getOffsetForMask(16, n28, xImage.byte_order, nArray5);
                        int n31 = 24 - nArray5[0];
                        Image.getOffsetForMask(16, n29, xImage.byte_order, nArray5);
                        int n32 = 24 - nArray5[0];
                        Image.getOffsetForMask(16, n30, xImage.byte_order, nArray5);
                        int n33 = 24 - nArray5[0];
                        byte by = (byte)(n16 & 0xFF);
                        byte by2 = (byte)(n16 >> 8 & 0xFF);
                        byte by3 = (byte)(n17 & 0xFF);
                        byte by4 = (byte)(n17 >> 8 & 0xFF);
                        int n34 = 0;
                        while (n34 < xImage.height) {
                            int n35 = 0;
                            int n36 = 0;
                            while (n36 < xImage.bytes_per_line) {
                                int n37 = (byArray[n27 + n35 + 1] & 0xFF) << 8 | byArray[n27 + n35] & 0xFF;
                                int n38 = (n37 & n28) << n31 >> 16;
                                int n39 = (n37 & n29) << n32 >> 16;
                                int n40 = (n37 & n30) << n33 >> 16;
                                if (n38 * n38 + n39 * n39 + n40 * n40 < 98304) {
                                    byArray2[n27 + n35] = by;
                                    byArray2[n27 + n35 + 1] = by2;
                                } else {
                                    byArray2[n27 + n35] = by3;
                                    byArray2[n27 + n35 + 1] = by4;
                                }
                                n35 += xImage.bits_per_pixel / 8;
                                n36 += 2;
                            }
                            n27 += xImage.bytes_per_line;
                            ++n34;
                        }
                        break;
                    }
                    case 24: 
                    case 32: {
                        int n41 = 0;
                        Visual visual = new Visual();
                        OS.memmove(visual, n12, 32);
                        int n42 = visual.red_mask;
                        int n43 = visual.green_mask;
                        int n44 = visual.blue_mask;
                        int[] nArray6 = new int[1];
                        Image.getOffsetForMask(xImage.bits_per_pixel, n42, xImage.byte_order, nArray6);
                        int n45 = nArray6[0];
                        Image.getOffsetForMask(xImage.bits_per_pixel, n43, xImage.byte_order, nArray6);
                        int n46 = nArray6[0];
                        Image.getOffsetForMask(xImage.bits_per_pixel, n44, xImage.byte_order, nArray6);
                        int n47 = nArray6[0];
                        byte by = (byte)color.getRed();
                        byte by5 = (byte)color.getGreen();
                        byte by6 = (byte)color.getBlue();
                        byte by7 = (byte)color2.getRed();
                        byte by8 = (byte)color2.getGreen();
                        byte by9 = (byte)color2.getBlue();
                        int n48 = 0;
                        while (n48 < xImage.height) {
                            int n49 = 0;
                            int n50 = 0;
                            while (n50 < xImage.width) {
                                int n51 = byArray[n41 + n49 + n45] & 0xFF;
                                int n52 = byArray[n41 + n49 + n46] & 0xFF;
                                int n53 = byArray[n41 + n49 + n47] & 0xFF;
                                if (n51 * n51 + n52 * n52 + n53 * n53 < 98304) {
                                    byArray2[n41 + n49 + n45] = by;
                                    byArray2[n41 + n49 + n46] = by5;
                                    byArray2[n41 + n49 + n47] = by6;
                                } else {
                                    byArray2[n41 + n49 + n45] = by7;
                                    byArray2[n41 + n49 + n46] = by8;
                                    byArray2[n41 + n49 + n47] = by9;
                                }
                                n49 += xImage2.bits_per_pixel / 8;
                                ++n50;
                            }
                            n41 += xImage.bytes_per_line;
                            ++n48;
                        }
                        break;
                    }
                    default: {
                        SWT.error(40);
                    }
                }
                OS.memmove(xImage2.data, byArray2, byArray2.length);
                int n54 = OS.XCreateGC(n3, n11, 0, null);
                OS.XPutImage(n3, n11, n54, n14, 0, 0, 0, 0, n4, n5);
                OS.XDestroyImage(n14);
                OS.XDestroyImage(n10);
                OS.XFreeGC(n3, n54);
                this.alpha = image.alpha;
                if (image.alphaData != null) {
                    this.alphaData = new byte[image.alphaData.length];
                    System.arraycopy(image.alphaData, 0, this.alphaData, 0, this.alphaData.length);
                }
                this.createAlphaMask(n4, n5);
                this.pixmap = n11;
                break;
            }
            case 2: {
                ImageData imageData = image.getImageData();
                PaletteData paletteData = imageData.palette;
                ImageData imageData2 = imageData;
                if (!paletteData.isDirect) {
                    RGB[] rGBArray = paletteData.getRGBs();
                    int n55 = 0;
                    while (n55 < rGBArray.length) {
                        if (imageData.transparentPixel != n55) {
                            int n56;
                            RGB rGB = rGBArray[n55];
                            int n57 = rGB.red;
                            int n58 = rGB.green;
                            int n59 = rGB.blue;
                            rGB.green = rGB.blue = (n56 = n57 + n57 + n58 + n58 + n58 + n58 + n58 + n59 >> 3);
                            rGB.red = rGB.blue;
                        }
                        ++n55;
                    }
                    imageData2.palette = new PaletteData(rGBArray);
                } else {
                    RGB[] rGBArray = new RGB[256];
                    int n60 = 0;
                    while (n60 < rGBArray.length) {
                        rGBArray[n60] = new RGB(n60, n60, n60);
                        ++n60;
                    }
                    imageData2 = new ImageData(n4, n5, 8, new PaletteData(rGBArray));
                    imageData2.alpha = imageData.alpha;
                    imageData2.alphaData = imageData.alphaData;
                    imageData2.maskData = imageData.maskData;
                    imageData2.maskPad = imageData.maskPad;
                    if (imageData.transparentPixel != -1) {
                        imageData2.transparentPixel = 254;
                    }
                    int[] nArray7 = new int[n4];
                    int n61 = paletteData.redMask;
                    int n62 = paletteData.greenMask;
                    int n63 = paletteData.blueMask;
                    int n64 = paletteData.redShift;
                    int n65 = paletteData.greenShift;
                    int n66 = paletteData.blueShift;
                    int n67 = 0;
                    while (n67 < n5) {
                        int n68 = n67 * imageData2.bytesPerLine;
                        imageData.getPixels(0, n67, n4, nArray7, 0);
                        int n69 = 0;
                        while (n69 < n4) {
                            int n70 = nArray7[n69];
                            if (n70 != imageData.transparentPixel) {
                                int n71 = n70 & n61;
                                n71 = n64 < 0 ? n71 >>> -n64 : n71 << n64;
                                int n72 = n70 & n62;
                                n72 = n65 < 0 ? n72 >>> -n65 : n72 << n65;
                                int n73 = n70 & n63;
                                n73 = n66 < 0 ? n73 >>> -n66 : n73 << n66;
                                int n74 = n71 + n71 + n72 + n72 + n72 + n72 + n72 + n73 >> 3;
                                if (imageData2.transparentPixel == n74) {
                                    n74 = 255;
                                }
                                imageData2.data[n68] = (byte)n74;
                            } else {
                                imageData2.data[n68] = -2;
                            }
                            ++n68;
                            ++n69;
                        }
                        ++n67;
                    }
                }
                this.init(imageData2);
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.init();
    }

    public Image(Device device, Rectangle rectangle) {
        super(device);
        if (rectangle == null) {
            SWT.error(4);
        }
        this.init(rectangle.width, rectangle.height);
        this.init();
    }

    public Image(Device device, ImageData imageData) {
        super(device);
        this.init(imageData);
        this.init();
    }

    public Image(Device device, ImageData imageData, ImageData imageData2) {
        super(device);
        if (imageData == null) {
            SWT.error(4);
        }
        if (imageData2 == null) {
            SWT.error(4);
        }
        if (imageData.width != imageData2.width || imageData.height != imageData2.height) {
            SWT.error(5);
        }
        imageData2 = ImageData.convertMask(imageData2);
        ImageData imageData3 = new ImageData(imageData.width, imageData.height, imageData.depth, imageData.palette, imageData.scanlinePad, imageData.data);
        imageData3.maskPad = imageData2.scanlinePad;
        imageData3.maskData = imageData2.data;
        this.init(imageData3);
        this.init();
    }

    public Image(Device device, InputStream inputStream) {
        super(device);
        this.init(new ImageData(inputStream));
        this.init();
    }

    public Image(Device device, String string) {
        super(device);
        this.init(new ImageData(string));
        this.init();
    }

    void createAlphaMask(int n, int n2) {
        if (this.device.useXRender && (this.alpha != -1 || this.alphaData != null)) {
            int n3 = this.device.xDisplay;
            int n4 = OS.XDefaultRootWindow(n3);
            this.mask = OS.XCreatePixmap(n3, n4, this.alpha != -1 ? 1 : n, this.alpha != -1 ? 1 : n2, 8);
            if (this.mask == 0) {
                SWT.error(2);
            }
            int n5 = OS.XCreateGC(n3, this.mask, 0, null);
            if (this.alpha != -1) {
                OS.XSetForeground(n3, n5, (this.alpha & 0xFF) << 8 | this.alpha & 0xFF);
                OS.XFillRectangle(n3, this.mask, n5, 0, 0, 1, 1);
            } else {
                int n6 = OS.XGetImage(n3, this.mask, 0, 0, n, n2, -1, 2);
                XImage xImage = new XImage();
                OS.memmove(xImage, n6, 88);
                if (xImage.bytes_per_line == n) {
                    OS.memmove(xImage.data, this.alphaData, this.alphaData.length);
                } else {
                    byte[] byArray = new byte[xImage.bytes_per_line];
                    int n7 = 0;
                    while (n7 < n2) {
                        System.arraycopy(this.alphaData, n * n7, byArray, 0, n);
                        OS.memmove(xImage.data + xImage.bytes_per_line * n7, byArray, xImage.bytes_per_line);
                        ++n7;
                    }
                }
                OS.XPutImage(n3, this.mask, n5, n6, 0, 0, 0, 0, n, n2);
                OS.XDestroyImage(n6);
            }
            OS.XFreeGC(n3, n5);
        }
    }

    void createMask() {
        if (this.mask != 0) {
            return;
        }
        int n = this.device.xDisplay;
        int n2 = OS.XDefaultRootWindow(n);
        int n3 = OS.XDefaultDepthOfScreen(OS.XDefaultScreenOfDisplay(n));
        int n4 = OS.XDefaultVisual(n, OS.XDefaultScreen(n));
        ImageData imageData = this.getImageData().getTransparencyMask();
        int n5 = OS.XCreatePixmap(n, n2, imageData.width, imageData.height, 1);
        XColor[] xColorArray = this.device.xcolors;
        int n6 = OS.XCreateGC(n, n5, 0, null);
        Image.putImage(imageData, 0, 0, imageData.width, imageData.height, 0, 0, imageData.width, imageData.height, n, n4, n3, xColorArray, null, true, n5, n6);
        OS.XFreeGC(n, n6);
        this.mask = n5;
    }

    void createSurface() {
        if (this.surface != 0) {
            return;
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        OS.XGetGeometry(this.device.xDisplay, this.pixmap, nArray, nArray, nArray, nArray2, nArray3, nArray, nArray);
        int n = this.device.xDisplay;
        int n2 = this.pixmap;
        int n3 = OS.XDefaultVisual(n, OS.XDefaultScreen(n));
        this.surface = Cairo.cairo_xlib_surface_create(n, n2, n3, nArray2[0], nArray3[0]);
    }

    void destroy() {
        if (this.memGC != null) {
            this.memGC.dispose();
        }
        int n = this.device.xDisplay;
        if (this.pixmap != 0) {
            OS.XFreePixmap(n, this.pixmap);
        }
        if (this.mask != 0) {
            OS.XFreePixmap(n, this.mask);
        }
        if (this.surface != 0) {
            Cairo.cairo_surface_destroy(this.surface);
        }
        this.mask = 0;
        this.pixmap = 0;
        this.surface = 0;
        this.memGC = null;
    }

    void destroyMask() {
        if (this.mask == 0) {
            return;
        }
        OS.XFreePixmap(this.device.xDisplay, this.mask);
        this.mask = 0;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Image)) {
            return false;
        }
        Image image = (Image)object;
        return this.device == image.device && this.pixmap == image.pixmap;
    }

    public Color getBackground() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (this.transparentPixel == -1) {
            return null;
        }
        XColor xColor = new XColor();
        xColor.pixel = this.transparentPixel;
        int n = this.device.xDisplay;
        int n2 = OS.XDefaultColormap(n, OS.XDefaultScreen(n));
        OS.XQueryColor(n, n2, xColor);
        return Color.motif_new(this.device, xColor);
    }

    public Rectangle getBounds() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (this.width != -1 && this.height != -1) {
            return new Rectangle(0, 0, this.width, this.height);
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        OS.XGetGeometry(this.device.xDisplay, this.pixmap, nArray, nArray, nArray, nArray2, nArray3, nArray, nArray);
        this.width = nArray2[0];
        this.height = nArray3[0];
        return new Rectangle(0, 0, this.width, this.height);
    }

    public ImageData getImageData() {
        int n;
        Object object;
        if (this.isDisposed()) {
            SWT.error(44);
        }
        Rectangle rectangle = this.getBounds();
        int n2 = this.device.xDisplay;
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        int n5 = OS.XGetImage(n2, this.pixmap, 0, 0, n3, n4, -1, 2);
        if (n5 == 0) {
            SWT.error(2);
        }
        XImage xImage = new XImage();
        OS.memmove(xImage, n5, 88);
        PaletteData paletteData = null;
        int n6 = xImage.bytes_per_line * xImage.height;
        byte[] byArray = new byte[n6];
        OS.memmove(byArray, xImage.data, n6);
        switch (xImage.bits_per_pixel) {
            case 1: {
                paletteData = new PaletteData(new RGB[]{new RGB(0, 0, 0), new RGB(255, 255, 255)});
                break;
            }
            case 4: {
                SWT.error(38);
            }
            case 8: {
                int n7;
                object = new byte[256];
                int n8 = 0;
                while (n8 < ((byte[])object).length) {
                    object[n8] = 0;
                    ++n8;
                }
                n8 = 1;
                int n9 = 0;
                int n10 = 0;
                while (n10 < xImage.height) {
                    int n11 = 0;
                    while (n11 < xImage.bytes_per_line) {
                        int n12 = byArray[n9 + n11] & 0xFF;
                        if (n12 != 0 && object[n12] == 0) {
                            object[n12] = (byte)n8++;
                        }
                        byArray[n9 + n11] = object[n12];
                        ++n11;
                    }
                    n9 += xImage.bytes_per_line;
                    ++n10;
                }
                n10 = OS.XDefaultColormap(n2, OS.XDefaultScreen(n2));
                RGB[] rGBArray = new RGB[n8];
                XColor xColor = new XColor();
                n = 0;
                while (n < ((byte[])object).length) {
                    if (n == 0 || object[n] != 0) {
                        xColor.pixel = n;
                        OS.XQueryColor(n2, n10, xColor);
                        n7 = object[n] & 0xFF;
                        rGBArray[n7] = new RGB(xColor.red >> 8 & 0xFF, xColor.green >> 8 & 0xFF, xColor.blue >> 8 & 0xFF);
                    }
                    ++n;
                }
                paletteData = new PaletteData(rGBArray);
                break;
            }
            case 16: {
                int n7;
                if (xImage.byte_order != 1) break;
                n = 0;
                while (n < byArray.length) {
                    n7 = byArray[n];
                    byArray[n] = byArray[n + 1];
                    byArray[n + 1] = n7;
                    n += 2;
                }
                break;
            }
            case 24: {
                break;
            }
            case 32: {
                int n7;
                if (xImage.byte_order != 0) break;
                n = 0;
                while (n < byArray.length) {
                    n7 = byArray[n];
                    byArray[n] = byArray[n + 3];
                    byArray[n + 3] = n7;
                    n7 = byArray[n + 1];
                    byArray[n + 1] = byArray[n + 2];
                    byArray[n + 2] = n7;
                    n += 4;
                }
                break;
            }
            default: {
                SWT.error(38);
            }
        }
        if (paletteData == null) {
            int n13 = OS.XDefaultVisual(n2, OS.XDefaultScreen(n2));
            Visual visual = new Visual();
            OS.memmove(visual, n13, 32);
            paletteData = new PaletteData(visual.red_mask, visual.green_mask, visual.blue_mask);
        }
        object = new ImageData(n3, n4, xImage.bits_per_pixel, paletteData, 4, byArray);
        if (this.transparentPixel == -1 && this.type == 1 && this.mask != 0) {
            int n14 = OS.XGetImage(n2, this.mask, 0, 0, n3, n4, -1, 2);
            if (n14 == 0) {
                SWT.error(2);
            }
            XImage xImage2 = new XImage();
            OS.memmove(xImage2, n14, 88);
            byte[] byArray2 = new byte[xImage2.bytes_per_line * xImage2.height];
            OS.memmove(byArray2, xImage2.data, byArray2.length);
            OS.XDestroyImage(n14);
            int n15 = xImage2.bitmap_pad / 8;
            object.maskPad = 2;
            byArray2 = ImageData.convertPad(byArray2, n3, n4, 1, n15, object.maskPad);
            if (xImage2.bitmap_bit_order == 0) {
                int n16 = 0;
                while (n16 < byArray2.length) {
                    n = byArray2[n16];
                    byArray2[n16] = (byte)((n & 1) << 7 | (n & 2) << 5 | (n & 4) << 3 | (n & 8) << 1 | (n & 0x10) >> 1 | (n & 0x20) >> 3 | (n & 0x40) >> 5 | (n & 0x80) >> 7);
                    ++n16;
                }
            }
            object.maskData = byArray2;
        }
        object.transparentPixel = this.transparentPixel;
        object.alpha = this.alpha;
        if (this.alpha == -1 && this.alphaData != null) {
            object.alphaData = new byte[this.alphaData.length];
            System.arraycopy(this.alphaData, 0, object.alphaData, 0, this.alphaData.length);
        }
        OS.XDestroyImage(n5);
        return object;
    }

    static boolean getOffsetForMask(int n, int n2, int n3, int[] nArray) {
        if (n % 8 != 0) {
            return false;
        }
        switch (n2) {
            case 255: {
                nArray[0] = 0;
                break;
            }
            case 65280: {
                nArray[0] = 1;
                break;
            }
            case 0xFF0000: {
                nArray[0] = 2;
                break;
            }
            case -16777216: {
                nArray[0] = 3;
                break;
            }
            case 31: {
                nArray[0] = 5;
                break;
            }
            case 992: {
                nArray[0] = 10;
                break;
            }
            case 2016: {
                nArray[0] = 11;
                break;
            }
            case 31744: {
                nArray[0] = 15;
                break;
            }
            case 63488: {
                nArray[0] = 16;
                break;
            }
            default: {
                return false;
            }
        }
        if (n == 16) {
            return true;
        }
        if (nArray[0] >= n / 8) {
            return false;
        }
        if (n3 == 1) {
            nArray[0] = n / 8 - 1 - nArray[0];
        }
        return true;
    }

    public int hashCode() {
        return this.pixmap;
    }

    void init(int n, int n2) {
        if (n <= 0 || n2 <= 0) {
            SWT.error(5);
        }
        this.type = 0;
        int n3 = this.device.xDisplay;
        int n4 = OS.XDefaultScreenOfDisplay(n3);
        int n5 = OS.XDefaultDepthOfScreen(n4);
        int n6 = OS.XDefaultScreen(n3);
        int n7 = OS.XDefaultRootWindow(n3);
        int n8 = OS.XCreatePixmap(n3, n7, n, n2, n5);
        if (n8 == 0) {
            SWT.error(2);
        }
        int n9 = OS.XCreateGC(n3, n7, 0, null);
        OS.XSetForeground(n3, n9, OS.XWhitePixel(n3, n6));
        OS.XFillRectangle(n3, n8, n9, 0, 0, n, n2);
        OS.XFreeGC(n3, n9);
        this.pixmap = n8;
    }

    void init(ImageData imageData) {
        if (imageData == null) {
            SWT.error(4);
        }
        int n = this.device.xDisplay;
        int n2 = OS.XDefaultRootWindow(n);
        int n3 = OS.XDefaultDepthOfScreen(OS.XDefaultScreenOfDisplay(n));
        int n4 = OS.XDefaultVisual(n, OS.XDefaultScreen(n));
        int n5 = OS.XCreatePixmap(n, n2, imageData.width, imageData.height, n3);
        if (n5 == 0) {
            SWT.error(2);
        }
        int n6 = OS.XCreateGC(n, n5, 0, null);
        int[] nArray = null;
        if (imageData.transparentPixel != -1) {
            nArray = new int[]{imageData.transparentPixel};
        }
        int n7 = Image.putImage(imageData, 0, 0, imageData.width, imageData.height, 0, 0, imageData.width, imageData.height, n, n4, n3, this.device.xcolors, nArray, false, n5, n6);
        OS.XFreeGC(n, n6);
        if (n7 != 0) {
            OS.XFreePixmap(n, n5);
            SWT.error(n7);
        }
        if (imageData.getTransparencyType() == 2 || imageData.transparentPixel != -1) {
            if (imageData.transparentPixel != -1) {
                this.transparentPixel = nArray[0];
            }
            ImageData imageData2 = imageData.getTransparencyMask();
            int n8 = OS.XCreatePixmap(n, n2, imageData.width, imageData.height, 1);
            n6 = OS.XCreateGC(n, n8, 0, null);
            n7 = Image.putImage(imageData2, 0, 0, imageData2.width, imageData2.height, 0, 0, imageData2.width, imageData2.height, n, n4, n3, this.device.xcolors, null, true, n8, n6);
            OS.XFreeGC(n, n6);
            if (n7 != 0) {
                OS.XFreePixmap(n, n5);
                OS.XFreePixmap(n, n8);
                SWT.error(n7);
            }
            this.mask = n8;
            this.type = imageData.getTransparencyType() == 2 ? 1 : 0;
        } else {
            this.type = 0;
            this.mask = 0;
            this.alpha = imageData.alpha;
            if (imageData.alpha == -1 && imageData.alphaData != null) {
                this.alphaData = new byte[imageData.alphaData.length];
                System.arraycopy(imageData.alphaData, 0, this.alphaData, 0, this.alphaData.length);
            }
            this.createAlphaMask(imageData.width, imageData.height);
        }
        this.pixmap = n5;
    }

    public int internal_new_GC(GCData gCData) {
        int n;
        int n2;
        if (this.pixmap == 0) {
            SWT.error(44);
        }
        if (this.type != 0 || this.memGC != null) {
            SWT.error(5);
        }
        if ((n2 = OS.XCreateGC(n = this.device.xDisplay, this.pixmap, 0, null)) == 0) {
            SWT.error(2);
        }
        if (gCData != null) {
            int n3 = 0x6000000;
            if ((gCData.style & n3) == 0) {
                gCData.style |= 0x2000000;
            }
            gCData.device = this.device;
            gCData.display = n;
            gCData.drawable = this.pixmap;
            gCData.background = this.device.COLOR_WHITE.handle;
            gCData.foreground = this.device.COLOR_BLACK.handle;
            gCData.font = this.device.systemFont;
            gCData.colormap = OS.XDefaultColormap(n, OS.XDefaultScreen(n));
            gCData.image = this;
        }
        return n2;
    }

    public void internal_dispose_GC(int n, GCData gCData) {
        int n2 = 0;
        if (gCData != null) {
            n2 = gCData.display;
        }
        if (n2 == 0 && this.device != null) {
            n2 = this.device.xDisplay;
        }
        if (n2 == 0) {
            SWT.error(2);
        }
        OS.XFreeGC(n2, n);
    }

    public boolean isDisposed() {
        return this.pixmap == 0;
    }

    public static Image motif_new(Device device, int n, int n2, int n3) {
        Image image = new Image(device);
        image.type = n;
        image.pixmap = n2;
        image.mask = n3;
        return image;
    }

    static int putImage(ImageData imageData, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, XColor[] xColorArray, int[] nArray, boolean bl, int n12, int n13) {
        int n14;
        Object object;
        int n15;
        boolean bl2;
        Object object2;
        Object[] objectArray;
        boolean bl3;
        PaletteData paletteData = imageData.palette;
        if ((imageData.depth != 1 && imageData.depth != 2 && imageData.depth != 4 && imageData.depth != 8 || paletteData.isDirect) && imageData.depth != 8 && (imageData.depth != 16 && imageData.depth != 24 && imageData.depth != 32 || !paletteData.isDirect)) {
            return 38;
        }
        boolean bl4 = n7 < 0;
        boolean bl5 = bl3 = n8 < 0;
        if (bl4) {
            n7 = -n7;
            n5 -= n7;
        }
        if (bl3) {
            n8 = -n8;
            n6 -= n8;
        }
        byte[] byArray = null;
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        if (!paletteData.isDirect) {
            objectArray = paletteData.getRGBs();
            int n16 = objectArray.length;
            byArray = new byte[n16];
            byArray2 = new byte[n16];
            byArray3 = new byte[n16];
            int n17 = 0;
            while (n17 < objectArray.length) {
                RGB rGB = objectArray[n17];
                if (rGB != null) {
                    byArray[n17] = (byte)rGB.red;
                    byArray2[n17] = (byte)rGB.green;
                    byArray3[n17] = (byte)rGB.blue;
                }
                ++n17;
            }
        }
        objectArray = null;
        byte[] byArray4 = null;
        byte[] byArray5 = null;
        int n18 = 0;
        int n19 = 0;
        int n20 = 0;
        if (n11 <= 8) {
            if (xColorArray == null) {
                return 38;
            }
            objectArray = new byte[xColorArray.length];
            byArray4 = new byte[xColorArray.length];
            byArray5 = new byte[xColorArray.length];
            int n21 = 0;
            while (n21 < xColorArray.length) {
                object2 = xColorArray[n21];
                if (object2 != null) {
                    objectArray[n21] = (RGB)((byte)(((XColor)object2).red >> 8 & 0xFF));
                    byArray4[n21] = (byte)(((XColor)object2).green >> 8 & 0xFF);
                    byArray5[n21] = (byte)(((XColor)object2).blue >> 8 & 0xFF);
                }
                ++n21;
            }
            bl2 = false;
        } else {
            Visual visual = new Visual();
            OS.memmove(visual, n10, 32);
            n18 = visual.red_mask;
            n19 = visual.green_mask;
            n20 = visual.blue_mask;
            bl2 = true;
        }
        if (nArray != null) {
            Object object3;
            int n22 = 0;
            int n23 = 0;
            n15 = 0;
            if (paletteData.isDirect) {
                object3 = paletteData.getRGB(nArray[0]);
                n22 = object3.red;
                n23 = object3.green;
                n15 = object3.blue;
            } else {
                object3 = paletteData.getRGBs();
                if (nArray[0] < ((RGB[])object3).length) {
                    object = object3[nArray[0]];
                    n22 = ((RGB)object).red;
                    n23 = ((RGB)object).green;
                    n15 = ((RGB)object).blue;
                }
            }
            nArray[0] = ImageData.closestMatch(n11, (byte)n22, (byte)n23, (byte)n15, n18, n19, n20, (byte[])objectArray, byArray4, byArray5);
        }
        if (imageData.depth == 1) {
            int n24;
            int n25 = OS.XCreateImage(n9, n10, 1, 0, 0, 0, n7, n8, imageData.scanlinePad * 8, 0);
            if (n25 == 0) {
                return 2;
            }
            object2 = new XImage();
            OS.memmove((XImage)object2, n25, 88);
            n15 = ((XImage)object2).bytes_per_line * ((XImage)object2).height;
            ((XImage)object2).data = n24 = OS.XtMalloc(n15);
            OS.memmove(n25, (XImage)object2, 88);
            object = new byte[n15];
            ImageData.blit(1, imageData.data, imageData.depth, imageData.bytesPerLine, imageData.getByteOrder(), n, n2, n3, n4, null, null, null, 255, null, 0, n, n2, (byte[])object, ((XImage)object2).bits_per_pixel, ((XImage)object2).bytes_per_line, ((XImage)object2).bitmap_bit_order, 0, 0, n7, n8, null, null, null, bl4, bl3);
            OS.memmove(((XImage)object2).data, (byte[])object, n15);
            int n26 = 1;
            int n27 = 0;
            if (!bl) {
                n26 = 0;
                if (byArray.length > 1) {
                    n26 = ImageData.closestMatch(n11, byArray[1], byArray2[1], byArray3[1], n18, n19, n20, (byte[])objectArray, byArray4, byArray5);
                }
                if (byArray.length > 0) {
                    n27 = ImageData.closestMatch(n11, byArray[0], byArray2[0], byArray3[0], n18, n19, n20, (byte[])objectArray, byArray4, byArray5);
                }
            }
            XGCValues xGCValues = new XGCValues();
            OS.XGetGCValues(n9, n13, 12, xGCValues);
            OS.XSetForeground(n9, n13, n26);
            OS.XSetBackground(n9, n13, n27);
            OS.XPutImage(n9, n12, n13, n25, 0, 0, n5, n6, n7, n8);
            OS.XSetForeground(n9, n13, xGCValues.foreground);
            OS.XSetBackground(n9, n13, xGCValues.background);
            OS.XDestroyImage(n25);
            return 0;
        }
        int n28 = OS.XCreateImage(n9, n10, n11, 2, 0, 0, n7, n8, imageData.scanlinePad * 8, 0);
        if (n28 == 0) {
            return 2;
        }
        object2 = new XImage();
        OS.memmove((XImage)object2, n28, 88);
        n15 = ((XImage)object2).bytes_per_line * ((XImage)object2).height;
        ((XImage)object2).data = n14 = OS.XtMalloc(n15);
        OS.memmove(n28, (XImage)object2, 88);
        object = new byte[n15];
        if (paletteData.isDirect) {
            if (bl2) {
                ImageData.blit(1, imageData.data, imageData.depth, imageData.bytesPerLine, imageData.getByteOrder(), n, n2, n3, n4, paletteData.redMask, paletteData.greenMask, paletteData.blueMask, 255, null, 0, n, n2, (byte[])object, ((XImage)object2).bits_per_pixel, ((XImage)object2).bytes_per_line, ((XImage)object2).byte_order, 0, 0, n7, n8, ((XImage)object2).red_mask, ((XImage)object2).green_mask, ((XImage)object2).blue_mask, bl4, bl3);
            } else {
                ImageData.blit(1, imageData.data, imageData.depth, imageData.bytesPerLine, imageData.getByteOrder(), n, n2, n3, n4, paletteData.redMask, paletteData.greenMask, paletteData.blueMask, 255, null, 0, n, n2, (byte[])object, ((XImage)object2).bits_per_pixel, ((XImage)object2).bytes_per_line, ((XImage)object2).byte_order, 0, 0, n7, n8, (byte[])objectArray, byArray4, byArray5, bl4, bl3);
            }
        } else if (bl2) {
            ImageData.blit(1, imageData.data, imageData.depth, imageData.bytesPerLine, imageData.getByteOrder(), n, n2, n3, n4, byArray, byArray2, byArray3, 255, null, 0, n, n2, (byte[])object, ((XImage)object2).bits_per_pixel, ((XImage)object2).bytes_per_line, ((XImage)object2).byte_order, 0, 0, n7, n8, ((XImage)object2).red_mask, ((XImage)object2).green_mask, ((XImage)object2).blue_mask, bl4, bl3);
        } else {
            ImageData.blit(1, imageData.data, imageData.depth, imageData.bytesPerLine, imageData.getByteOrder(), n, n2, n3, n4, byArray, byArray2, byArray3, 255, null, 0, n, n2, (byte[])object, ((XImage)object2).bits_per_pixel, ((XImage)object2).bytes_per_line, ((XImage)object2).byte_order, 0, 0, n7, n8, (byte[])objectArray, byArray4, byArray5, bl4, bl3);
        }
        OS.memmove(((XImage)object2).data, (byte[])object, n15);
        OS.XPutImage(n9, n12, n13, n28, 0, 0, n5, n6, n7, n8);
        OS.XDestroyImage(n28);
        return 0;
    }

    public void setBackground(Color color) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
        if (this.transparentPixel == -1) {
            return;
        }
        if (this.mask == 0) {
            this.createMask();
        }
        Rectangle rectangle = this.getBounds();
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int n = this.device.xDisplay;
        OS.XGetGeometry(n, this.pixmap, nArray, nArray, nArray, nArray, nArray, nArray, nArray2);
        int n2 = OS.XDefaultRootWindow(n);
        int n3 = OS.XCreatePixmap(n, n2, rectangle.width, rectangle.height, nArray2[0]);
        int n4 = OS.XCreateGC(n, n3, 0, null);
        OS.XSetForeground(n, n4, color.handle.pixel);
        OS.XFillRectangle(n, n3, n4, 0, 0, rectangle.width, rectangle.height);
        OS.XSetClipMask(n, n4, this.mask);
        OS.XCopyArea(n, this.pixmap, n3, n4, 0, 0, rectangle.width, rectangle.height, 0, 0);
        OS.XSetClipMask(n, n4, 0);
        OS.XCopyArea(n, n3, this.pixmap, n4, 0, 0, rectangle.width, rectangle.height, 0, 0);
        OS.XFreePixmap(n, n3);
        OS.XFreeGC(n, n4);
        if (this.memGC != null) {
            this.destroyMask();
        }
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Image {*DISPOSED*}";
        }
        return "Image {" + this.pixmap + "}";
    }
}

