/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.internal.motif.XColor;
import org.eclipse.swt.internal.motif.XConfigureEvent;
import org.eclipse.swt.internal.motif.XExposeEvent;
import org.eclipse.swt.internal.motif.XIconSize;
import org.eclipse.swt.internal.motif.XKeyEvent;
import org.eclipse.swt.internal.motif.XModifierKeymap;
import org.eclipse.swt.internal.motif.XineramaScreenInfo;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.EventTable;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Synchronizer;
import org.eclipse.swt.widgets.Tray;
import org.eclipse.swt.widgets.Widget;

public class Display
extends Device {
    public int xEvent;
    int lastSerial;
    Callback windowCallback;
    int windowProc;
    int shellHandle;
    static String APP_NAME = "SWT";
    static final String SHELL_HANDLE_KEY = "org.eclipse.swt.internal.motif.shellHandle";
    byte[] displayName;
    byte[] appName;
    byte[] appClass;
    Event[] eventQueue;
    XKeyEvent keyEvent = new XKeyEvent();
    EventTable eventTable;
    EventTable filterTable;
    int freeSlot = 0;
    int[] indexTable;
    int[] userData;
    Shell[] shellTable;
    Widget[] widgetTable;
    static final int GROW_SIZE = 1024;
    int focusEvent;
    boolean postFocusOut;
    Combo focusedCombo;
    Font defaultFont;
    Font listFont;
    Font textFont;
    Font buttonFont;
    Font labelFont;
    int buttonBackground;
    int buttonForeground;
    int buttonShadowThickness;
    int compositeBackground;
    int compositeForeground;
    int compositeTopShadow;
    int compositeBottomShadow;
    int compositeBorder;
    int listBackground;
    int listForeground;
    int listSelect;
    int textBackground;
    int textForeground;
    int labelBackground;
    int labelForeground;
    int scrolledInsetX;
    int scrolledInsetY;
    int scrolledMarginX;
    int scrolledMarginY;
    int defaultBackground;
    int defaultForeground;
    int textHighlightThickness;
    int blinkRate;
    XColor COLOR_WIDGET_DARK_SHADOW;
    XColor COLOR_WIDGET_NORMAL_SHADOW;
    XColor COLOR_WIDGET_LIGHT_SHADOW;
    XColor COLOR_WIDGET_HIGHLIGHT_SHADOW;
    XColor COLOR_WIDGET_FOREGROUND;
    XColor COLOR_WIDGET_BACKGROUND;
    XColor COLOR_WIDGET_BORDER;
    XColor COLOR_LIST_FOREGROUND;
    XColor COLOR_LIST_BACKGROUND;
    XColor COLOR_LIST_SELECTION;
    XColor COLOR_LIST_SELECTION_TEXT;
    Color COLOR_INFO_BACKGROUND;
    Menu[] popups;
    int errorPixmap;
    int infoPixmap;
    int questionPixmap;
    int warningPixmap;
    int workingPixmap;
    int errorMask;
    int infoMask;
    int questionMask;
    int warningMask;
    int workingMask;
    Cursor[] cursors = new Cursor[22];
    int leftBorderWidth = 2;
    int rightBorderWidth = 2;
    int topBorderHeight = 2;
    int bottomBorderHeight = 2;
    int leftResizeWidth = 3;
    int rightResizeWidth = 3;
    int topResizeHeight = 3;
    int bottomResizeHeight = 3;
    int leftTitleBorderWidth = 3;
    int rightTitleBorderWidth = 2;
    int topTitleBorderHeight = 26;
    int bottomTitleBorderHeight = 2;
    int leftTitleResizeWidth = 3;
    int rightTitleResizeWidth = 3;
    int topTitleResizeHeight = 26;
    int bottomTitleResizeHeight = 3;
    int leftTitleWidth = 0;
    int rightTitleWidth = 0;
    int topTitleHeight = 23;
    int bottomTitleHeight = 0;
    boolean ignoreTrim;
    Synchronizer synchronizer = new Synchronizer(this);
    Thread thread;
    Runnable[] disposeList;
    Tray tray;
    int[] timerIds;
    Runnable[] timerList;
    Callback timerCallback;
    int timerProc;
    Callback windowTimerCallback;
    int windowTimerProc;
    static int[][] KeyTable = new int[][]{{65513, 65536}, {65514, 65536}, {65511, 65536}, {65512, 65536}, {65505, 131072}, {65506, 131072}, {65507, 262144}, {65508, 262144}, {65362, 0x1000001}, {65431, 0x1000001}, {65364, 0x1000002}, {65433, 0x1000002}, {65361, 0x1000003}, {65430, 0x1000003}, {65363, 0x1000004}, {65432, 0x1000004}, {65365, 0x1000005}, {65434, 0x1000005}, {65366, 0x1000006}, {65435, 0x1000006}, {65360, 0x1000007}, {65429, 0x1000007}, {65367, 0x1000008}, {65436, 0x1000008}, {65379, 0x1000009}, {65438, 0x1000009}, {65288, 8}, {65293, 13}, {65535, 127}, {65439, 127}, {65307, 27}, {65290, 10}, {65289, 9}, {65056, 9}, {65470, 0x100000A}, {65471, 0x100000B}, {65472, 0x100000C}, {65473, 0x100000D}, {65474, 0x100000E}, {65475, 0x100000F}, {65476, 0x1000010}, {65477, 0x1000011}, {65478, 0x1000012}, {65479, 0x1000013}, {65480, 0x1000014}, {65481, 0x1000015}, {65482, 0x1000016}, {65483, 0x1000017}, {65484, 0x1000018}, {65450, 16777258}, {65451, 16777259}, {65421, 0x1000050}, {65453, 16777261}, {65454, 16777262}, {65455, 16777263}, {65456, 0x1000030}, {65457, 0x1000031}, {65458, 16777266}, {65459, 0x1000033}, {65460, 16777268}, {65461, 16777269}, {65462, 16777270}, {65463, 16777271}, {65464, 16777272}, {65465, 16777273}, {65469, 16777277}, {65509, 16777298}, {65407, 16777299}, {65300, 16777300}, {65299, 0x1000055}, {65387, 16777302}, {65377, 16777303}, {65386, 0x1000051}};
    static String numLock;
    static Display Default;
    static Display[] Displays;
    int lastTime;
    int lastButton;
    int clickCount = 1;
    Caret currentCaret;
    Callback caretCallback;
    int caretID;
    int caretProc;
    static boolean DisplayDisposed;
    static final String PACKAGE_PREFIX = "org.eclipse.swt.widgets.";
    Callback mouseHoverCallback;
    int mouseHoverID;
    int mouseHoverProc;
    int mouseHoverHandle;
    int toolTipHandle;
    int dragTranslations;
    int arrowTranslations;
    int tabTranslations;
    Callback checkExposeCallback;
    int checkExposeProc;
    int exposeCount;
    int lastExpose;
    XExposeEvent xExposeEvent = new XExposeEvent();
    Callback checkResizeCallback;
    int checkResizeProc;
    int resizeWidth;
    int resizeHeight;
    int resizeCount;
    int resizeWindow;
    XConfigureEvent xConfigureEvent = new XConfigureEvent();
    Callback focusCallback;
    int focusProc;
    Callback wakeCallback;
    int wakeProc;
    int read_fd;
    int write_fd;
    int inputID;
    byte[] wake_buffer = new byte[1];
    int[] timeout = new int[2];
    byte[] fd_set;
    Object data;
    String[] keys;
    Object[] values;
    static /* synthetic */ Class class$0;

    static {
        Displays = new Display[4];
        DeviceFinder = new Runnable(){

            public void run() {
                Display display = Display.getCurrent();
                if (display == null) {
                    display = Display.getDefault();
                }
                Display.setDevice(display);
            }
        };
    }

    static void setDevice(Device device) {
        CurrentDevice = device;
    }

    public Display() {
        this(null);
    }

    public Display(DeviceData deviceData) {
        super(Display.checkNull(deviceData));
    }

    static DeviceData checkNull(DeviceData deviceData) {
        if (deviceData == null) {
            deviceData = new DeviceData();
        }
        if (deviceData.application_name == null) {
            deviceData.application_name = APP_NAME;
        }
        if (deviceData.application_class == null) {
            deviceData.application_class = APP_NAME;
        }
        return deviceData;
    }

    protected void checkDevice() {
        if (this.thread == null) {
            this.error(24);
        }
        if (this.thread != Thread.currentThread()) {
            this.error(22);
        }
        if (this.isDisposed()) {
            this.error(45);
        }
    }

    void addMouseHoverTimeOut(int n) {
        if (this.mouseHoverID != 0) {
            OS.XtRemoveTimeOut(this.mouseHoverID);
        }
        int n2 = OS.XtDisplayToApplicationContext(this.xDisplay);
        this.mouseHoverID = OS.XtAppAddTimeOut(n2, 400, this.mouseHoverProc, n);
        this.mouseHoverHandle = n;
    }

    void addWidget(int n, Widget widget) {
        int n2;
        if (n == 0) {
            return;
        }
        if (OS.XtIsSubclass(n, OS.shellWidgetClass())) {
            int n3 = 0;
            while (n3 < this.shellTable.length) {
                if (this.shellTable[n3] == null) {
                    this.shellTable[n3] = (Shell)widget;
                    return;
                }
                ++n3;
            }
            Shell[] shellArray = new Shell[this.shellTable.length + 128];
            System.arraycopy(this.shellTable, 0, shellArray, 0, this.shellTable.length);
            shellArray[this.shellTable.length] = (Shell)widget;
            this.shellTable = shellArray;
            return;
        }
        if (this.freeSlot == -1) {
            this.freeSlot = this.indexTable.length;
            n2 = this.freeSlot + 1024;
            int[] nArray = new int[n2];
            Widget[] widgetArray = new Widget[n2];
            System.arraycopy(this.indexTable, 0, nArray, 0, this.freeSlot);
            System.arraycopy(this.widgetTable, 0, widgetArray, 0, this.freeSlot);
            int n4 = this.freeSlot;
            while (n4 < n2 - 1) {
                nArray[n4] = n4 + 1;
                ++n4;
            }
            nArray[n2 - 1] = -1;
            this.indexTable = nArray;
            this.widgetTable = widgetArray;
        }
        this.userData[1] = this.freeSlot + 1;
        OS.XtSetValues(n, this.userData, this.userData.length / 2);
        n2 = this.freeSlot;
        this.freeSlot = this.indexTable[n2];
        this.indexTable[n2] = -2;
        this.widgetTable[n2] = widget;
    }

    public void addFilter(int n, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.filterTable == null) {
            this.filterTable = new EventTable();
        }
        this.filterTable.hook(n, listener);
    }

    public void addListener(int n, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            this.eventTable = new EventTable();
        }
        this.eventTable.hook(n, listener);
    }

    void addPopup(Menu menu) {
        if (this.popups == null) {
            this.popups = new Menu[4];
        }
        int n = this.popups.length;
        int n2 = 0;
        while (n2 < n) {
            if (this.popups[n2] == menu) {
                return;
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < n) {
            if (this.popups[n2] == null) break;
            ++n2;
        }
        if (n2 == n) {
            Menu[] menuArray = new Menu[n + 4];
            System.arraycopy(this.popups, 0, menuArray, 0, n);
            this.popups = menuArray;
        }
        this.popups[n2] = menu;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void asyncExec(Runnable runnable) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (this.isDisposed()) {
                this.error(45);
            }
            this.synchronizer.asyncExec(runnable);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void beep() {
        this.checkDevice();
        OS.XBell(this.xDisplay, 100);
        OS.XFlush(this.xDisplay);
    }

    int caretProc(int n, int n2) {
        this.caretID = 0;
        if (this.currentCaret == null) {
            return 0;
        }
        if (this.currentCaret.blinkCaret()) {
            int n3 = this.currentCaret.blinkRate;
            if (n3 == 0) {
                return 0;
            }
            int n4 = OS.XtDisplayToApplicationContext(this.xDisplay);
            this.caretID = OS.XtAppAddTimeOut(n4, n3, this.caretProc, 0);
        } else {
            this.currentCaret = null;
        }
        return 0;
    }

    int checkExposeProc(int n, int n2, int n3) {
        OS.memmove(this.xExposeEvent, n2, 40);
        if (this.xExposeEvent.window != n3) {
            return 0;
        }
        switch (this.xExposeEvent.type) {
            case 12: 
            case 13: {
                ++this.exposeCount;
                this.lastExpose = n2;
                this.xExposeEvent.count = 1;
                OS.memmove(n2, this.xExposeEvent, 40);
            }
        }
        return 0;
    }

    int checkResizeProc(int n, int n2, int n3) {
        OS.memmove(this.xConfigureEvent, n2, 52);
        if (this.xConfigureEvent.window != this.resizeWindow) {
            return 0;
        }
        switch (this.xConfigureEvent.type) {
            case 22: {
                int n4 = this.xConfigureEvent.width;
                int n5 = this.xConfigureEvent.height;
                if (n4 == this.resizeWidth && n5 == this.resizeHeight) break;
                ++this.resizeCount;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void checkDisplay(Thread thread, boolean bl) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            int n = 0;
            while (n < Displays.length) {
                if (Displays[n] != null) {
                    if (!bl) {
                        SWT.error(20, null, " [multiple displays]");
                    }
                    if (Display.Displays[n].thread == thread) {
                        SWT.error(22);
                    }
                }
                ++n;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    protected void checkSubclass() {
        if (!Display.isValidClass(this.getClass())) {
            this.error(43);
        }
    }

    public void close() {
        this.checkDevice();
        Event event = new Event();
        this.sendEvent(21, event);
        if (event.doit) {
            this.dispose();
        }
    }

    String convertToLf(String string) {
        char c = '\r';
        char c2 = '\n';
        int n = string.length();
        if (n == 0) {
            return string;
        }
        int n2 = string.indexOf(c2, 0);
        if (n2 == -1 || n2 == 0) {
            return string;
        }
        if (string.charAt(n2 - 1) != c) {
            return string;
        }
        n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while (n2 < n) {
            int n3 = string.indexOf(c, n2);
            if (n3 == -1) {
                n3 = n;
            }
            String string2 = string.substring(n2, n3);
            stringBuffer.append(string2);
            n2 = n3 + 2;
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    protected void create(DeviceData deviceData) {
        this.checkSubclass();
        this.thread = Thread.currentThread();
        Display.checkDisplay(this.thread, true);
        this.createDisplay(deviceData);
        Display.register(this);
        if (Default == null) {
            Default = this;
        }
    }

    void createDisplay(DeviceData deviceData) {
        this.xEvent = OS.XtMalloc(96);
        int n = 0;
        if (Default == null) {
            int n2 = OS.__XtDefaultAppContext();
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            OS.XtGetDisplays(n2, nArray, nArray2);
            if (nArray2[0] > 0) {
                OS.memmove(nArray, nArray[0], 4);
                n = nArray[0];
            }
        }
        if (n != 0) {
            this.xDisplay = n;
        } else {
            Object object;
            Object object2;
            String string;
            int[] nArray = new int[1];
            int n3 = OS.XtCreateApplicationContext();
            OS.XtSetLanguageProc(n3, 0, 0);
            int n4 = 0;
            int n5 = 0;
            if (OS.IsLinux && OS.IsDBLocale) {
                string = "*fontList: -*-*-medium-r-*-*-*-120-*-*-*-*-*-*:";
                object2 = Converter.wcsToMbcs(null, string, true);
                n4 = OS.XtMalloc(((Object)object2).length);
                if (n4 != 0) {
                    OS.memmove(n4, (byte[])object2, ((Object)object2).length);
                }
                int[] nArray3 = new int[2];
                nArray3[0] = n4;
                object = nArray3;
                n5 = OS.XtMalloc(((Object)object).length * 4);
                if (n5 != 0) {
                    OS.memmove(n5, (int[])object, ((Object)object).length * 4);
                }
                OS.XtAppSetFallbackResources(n3, n5);
            }
            string = null;
            object2 = APP_NAME;
            object = APP_NAME;
            if (deviceData != null) {
                if (deviceData.display_name != null) {
                    string = deviceData.display_name;
                }
                if (deviceData.application_name != null) {
                    object2 = deviceData.application_name;
                }
                if (deviceData.application_class != null) {
                    object = deviceData.application_class;
                }
            }
            if (string != null) {
                this.displayName = Converter.wcsToMbcs(null, string, true);
            }
            if (object2 != null) {
                this.appName = Converter.wcsToMbcs(null, (String)object2, true);
            }
            if (object != null) {
                this.appClass = Converter.wcsToMbcs(null, (String)object, true);
            }
            this.xDisplay = OS.XtOpenDisplay(n3, this.displayName, this.appName, this.appClass, 0, 0, nArray, 0);
            DisplayDisposed = false;
            if (n5 != 0) {
                OS.XtAppSetFallbackResources(n3, 0);
                OS.XtFree(n5);
            }
            if (n4 != 0) {
                OS.XtFree(n4);
            }
        }
    }

    int createMask(int n) {
        if (n == 0) {
            return 0;
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        OS.XGetGeometry(this.xDisplay, n, nArray, nArray, nArray, nArray2, nArray3, nArray, nArray);
        int n2 = OS.XCreatePixmap(this.xDisplay, n, nArray2[0], nArray3[0], 1);
        int n3 = OS.XCreateGC(this.xDisplay, n2, 0, null);
        if (OS.IsSunOS) {
            OS.XSetBackground(this.xDisplay, n3, 0);
            OS.XSetForeground(this.xDisplay, n3, 1);
        }
        OS.XCopyPlane(this.xDisplay, n, n2, n3, 0, 0, nArray2[0], nArray3[0], 0, 0, 1);
        OS.XFreeGC(this.xDisplay, n3);
        return n2;
    }

    int createPixmap(String string) {
        int n = OS.XDefaultScreenOfDisplay(this.xDisplay);
        int n2 = OS.XBlackPixel(this.xDisplay, OS.XDefaultScreen(this.xDisplay));
        int n3 = OS.XWhitePixel(this.xDisplay, OS.XDefaultScreen(this.xDisplay));
        byte[] byArray = Converter.wcsToMbcs(null, string, true);
        int n4 = OS.XmGetPixmap(n, byArray, n2, n3);
        if (n4 == 2 && (n4 = OS.XmGetPixmap(n, byArray = Converter.wcsToMbcs(null, "default_" + string, true), n2, n3)) == 2) {
            if (OS.IsSunOS) {
                byArray = Converter.wcsToMbcs(null, "/usr/dt/share/include/bitmaps/" + string, true);
                n4 = OS.XmGetPixmap(n, byArray, n2, n3);
                if (n4 == 2) {
                    n4 = 0;
                }
            } else {
                n4 = 0;
            }
        }
        return n4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void deregister(Display display) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            int n = 0;
            while (n < Displays.length) {
                if (display == Displays[n]) {
                    Display.Displays[n] = null;
                }
                ++n;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected void destroy() {
        if (this == Default) {
            Default = null;
        }
        Display.deregister(this);
        this.destroyDisplay();
    }

    void destroyDisplay() {
        if (!OS.IsSunOS) {
            OS.XtDestroyWidget(OS.XmGetXmDisplay(this.xDisplay));
        }
        int n = OS.XtDisplayToApplicationContext(this.xDisplay);
        OS.XtDestroyApplicationContext(n);
        DisplayDisposed = true;
    }

    public void disposeExec(Runnable runnable) {
        this.checkDevice();
        if (this.disposeList == null) {
            this.disposeList = new Runnable[4];
        }
        int n = 0;
        while (n < this.disposeList.length) {
            if (this.disposeList[n] == null) {
                this.disposeList[n] = runnable;
                return;
            }
            ++n;
        }
        Runnable[] runnableArray = new Runnable[this.disposeList.length + 4];
        System.arraycopy(this.disposeList, 0, runnableArray, 0, this.disposeList.length);
        runnableArray[this.disposeList.length] = runnable;
        this.disposeList = runnableArray;
    }

    void error(int n) {
        SWT.error(n);
    }

    boolean filterEvent(Event event) {
        if (this.filterTable != null) {
            this.filterTable.sendEvent(event);
        }
        return false;
    }

    boolean filters(int n) {
        if (this.filterTable == null) {
            return false;
        }
        return this.filterTable.hooks(n);
    }

    boolean filterEvent(int n) {
        char[] cArray;
        OS.memmove(this.keyEvent, n, 60);
        if (this.keyEvent.type != 2) {
            return false;
        }
        if (this.keyEvent.keycode == 0) {
            return false;
        }
        int n2 = this.keyEvent.window;
        if (n2 == 0) {
            return false;
        }
        int n3 = OS.XtWindowToWidget(this.xDisplay, n2);
        if (n3 == 0) {
            return false;
        }
        if ((n3 = OS.XmGetFocusWidget(n3)) == 0) {
            return false;
        }
        Widget widget = this.getWidget(n3);
        if (widget == null) {
            return false;
        }
        char c = '\u0000';
        byte[] byArray = new byte[5];
        int[] nArray = new int[1];
        int n4 = this.keyEvent.state;
        this.keyEvent.state = 0;
        int n5 = OS.XLookupString(this.keyEvent, byArray, byArray.length, nArray, null);
        this.keyEvent.state = n4;
        this.fixKey(nArray, byArray, 0);
        if (n5 != 0 && (cArray = Converter.mbcsToWcs(null, byArray)).length != 0) {
            c = cArray[0];
        }
        nArray[0] = nArray[0] & 0xFFFF;
        if ((nArray[0] == 65293 || nArray[0] == 65421) && this.keyEvent.serial != this.lastSerial) {
            if (OS.XFilterEvent(n, OS.XtWindow(n3))) {
                return true;
            }
            this.lastSerial = this.keyEvent.serial;
        }
        if (OS.IsSunOS) {
            switch (nArray[0]) {
                case 65505: 
                case 65506: 
                case 65507: 
                case 65508: 
                case 65511: 
                case 65512: 
                case 65513: 
                case 65514: {
                    break;
                }
                default: {
                    if (!widget.translateAccelerator(c, nArray[0], this.keyEvent, true)) break;
                    return true;
                }
            }
        }
        if (c != '\u0000' && widget.translateMnemonic(c, nArray[0], this.keyEvent)) {
            return true;
        }
        switch (nArray[0]) {
            case 65289: 
            case 65293: 
            case 65307: 
            case 65361: 
            case 65362: 
            case 65363: 
            case 65364: 
            case 65365: 
            case 65366: 
            case 65421: {
                if (!OS.IsSunOS && widget.translateAccelerator(c, nArray[0], this.keyEvent, true)) {
                    return true;
                }
                if (!widget.translateTraversal(nArray[0], this.keyEvent)) break;
                return true;
            }
        }
        return false;
    }

    public Widget findWidget(int n) {
        this.checkDevice();
        return this.getWidget(n);
    }

    public Widget findWidget(int n, int n2) {
        this.checkDevice();
        return null;
    }

    public Widget findWidget(Widget widget, int n) {
        this.checkDevice();
        return null;
    }

    boolean fixKey(int[] nArray, byte[] byArray, int n) {
        if (OS.IsSunOS && nArray[0] != 0) {
            switch (nArray[0]) {
                case 268828432: {
                    nArray[0] = 65480;
                    byArray[0] = 0;
                    break;
                }
                case 268828433: {
                    nArray[0] = 65481;
                    byArray[0] = 0;
                    break;
                }
                case 65490: {
                    nArray[0] = 65299;
                    break;
                }
                case 65491: {
                    nArray[0] = 65377;
                    break;
                }
                case 65492: {
                    nArray[0] = 65300;
                    break;
                }
                case 65493: {
                    nArray[0] = 65453;
                    break;
                }
                case 65494: {
                    nArray[0] = 65455;
                    break;
                }
                case 65495: {
                    nArray[0] = 65450;
                    break;
                }
                case 65496: {
                    nArray[0] = 65429;
                    break;
                }
                case 65498: {
                    nArray[0] = 65434;
                    break;
                }
                case 65502: {
                    nArray[0] = 65436;
                    break;
                }
                case 65504: {
                    nArray[0] = 65435;
                }
            }
            nArray[0] = nArray[0] & 0xFFFF;
        }
        if (OS.IsHPUX && nArray[0] != 0) {
            switch (nArray[0]) {
                case 65425: {
                    nArray[0] = 65478;
                    break;
                }
                case 65426: {
                    nArray[0] = 65479;
                    break;
                }
                case 65427: {
                    nArray[0] = 65480;
                    break;
                }
                case 65428: {
                    nArray[0] = 65481;
                    break;
                }
                case 268500852: {
                    nArray[0] = 65056;
                }
            }
        }
        switch (nArray[0]) {
            case 65439: {
                byArray[0] = 127;
                break;
            }
            case 65056: {
                byArray[0] = 9;
                break;
            }
            case 32: {
                byArray[0] = 32;
            }
        }
        boolean bl = false;
        int n2 = nArray[0];
        if ((n & 4) != 0) {
            if (n2 >= 0 && n2 <= 127) {
                if (97 <= n2 && n2 <= 122) {
                    n2 -= 32;
                }
                if (64 > n2 || n2 > 95) {
                    byArray[0] = (byte)n2;
                }
                bl = n2 == 64 && byArray[0] == 0;
            } else {
                switch (nArray[0]) {
                    case 65456: {
                        byArray[0] = 48;
                        break;
                    }
                    case 65457: {
                        byArray[0] = 49;
                        break;
                    }
                    case 65458: {
                        byArray[0] = 50;
                        break;
                    }
                    case 65459: {
                        byArray[0] = 51;
                        break;
                    }
                    case 65460: {
                        byArray[0] = 52;
                        break;
                    }
                    case 65461: {
                        byArray[0] = 53;
                        break;
                    }
                    case 65462: {
                        byArray[0] = 54;
                        break;
                    }
                    case 65463: {
                        byArray[0] = 55;
                        break;
                    }
                    case 65464: {
                        byArray[0] = 56;
                        break;
                    }
                    case 65465: {
                        byArray[0] = 57;
                    }
                }
            }
        }
        return bl;
    }

    int focusProc(int n, int n2, int n3, int n4) {
        Widget widget = this.getWidget(n2);
        if (widget == null) {
            return 0;
        }
        return widget.focusProc(n, n2, n3, n4);
    }

    public Shell getActiveShell() {
        this.checkDevice();
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.XGetInputFocus(this.xDisplay, nArray, nArray2);
        int n = nArray[0];
        if (n == 0) {
            return null;
        }
        int n2 = OS.XtWindowToWidget(this.xDisplay, n);
        if (n2 == 0) {
            return null;
        }
        do {
            if (!OS.XtIsSubclass(n2, OS.shellWidgetClass())) continue;
            Widget widget = this.getWidget(n2);
            if (widget instanceof Shell) {
                return (Shell)widget;
            }
            return null;
        } while ((n2 = OS.XtParent(n2)) != 0);
        return null;
    }

    public static Display getCurrent() {
        return Display.findDisplay(Thread.currentThread());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Display findDisplay(Thread thread) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            int n = 0;
            while (n < Displays.length) {
                Display display = Displays[n];
                if (display != null && display.thread == thread) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return display;
                }
                ++n;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return null;
        }
    }

    int getCaretBlinkTime() {
        return this.blinkRate;
    }

    public Control getCursorControl() {
        int n;
        this.checkDevice();
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int n2 = OS.XDefaultRootWindow(this.xDisplay);
        do {
            if (OS.XQueryPointer(this.xDisplay, n2, nArray, nArray2, nArray, nArray, nArray, nArray, nArray) == 0) {
                return null;
            }
            n = nArray2[0];
            if (n == 0) continue;
            n2 = n;
        } while (n != 0);
        int n3 = OS.XtWindowToWidget(this.xDisplay, n2);
        if (n3 == 0) {
            return null;
        }
        do {
            Control control;
            Widget widget;
            if ((widget = this.getWidget(n3)) == null || !(widget instanceof Control) || !(control = (Control)widget).isEnabled()) continue;
            return control;
        } while ((n3 = OS.XtParent(n3)) != 0);
        return null;
    }

    public Point getCursorLocation() {
        this.checkDevice();
        int n = OS.XDefaultRootWindow(this.xDisplay);
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        OS.XQueryPointer(this.xDisplay, n, nArray3, nArray3, nArray, nArray2, nArray3, nArray3, nArray3);
        return new Point(nArray[0], nArray2[0]);
    }

    public Point[] getCursorSizes() {
        Point[] pointArray;
        this.checkDevice();
        int n = OS.XDefaultRootWindow(this.xDisplay);
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.XQueryBestCursor(this.xDisplay, n, 16, 16, nArray, nArray2);
        Point point = new Point(nArray[0], nArray2[0]);
        OS.XQueryBestCursor(this.xDisplay, n, 32, 32, nArray, nArray2);
        if (point.x == nArray[0] && point.y == nArray2[0]) {
            Point[] pointArray2 = new Point[1];
            pointArray = pointArray2;
            pointArray2[0] = point;
        } else {
            Point[] pointArray3 = new Point[2];
            pointArray3[0] = point;
            pointArray = pointArray3;
            pointArray3[1] = new Point(nArray[0], nArray2[0]);
        }
        return pointArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Display getDefault() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (Default == null) {
                Default = new Display();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return Default;
        }
    }

    public Object getData(String string) {
        this.checkDevice();
        if (string == null) {
            this.error(4);
        }
        if (string.equals(SHELL_HANDLE_KEY)) {
            return new Integer(this.shellHandle);
        }
        if (this.keys == null) {
            return null;
        }
        int n = 0;
        while (n < this.keys.length) {
            if (this.keys[n].equals(string)) {
                return this.values[n];
            }
            ++n;
        }
        return null;
    }

    public Object getData() {
        this.checkDevice();
        return this.data;
    }

    public int getDismissalAlignment() {
        this.checkDevice();
        return 16384;
    }

    public int getDoubleClickTime() {
        this.checkDevice();
        return OS.XtGetMultiClickTime(this.xDisplay);
    }

    public Control getFocusControl() {
        this.checkDevice();
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.XGetInputFocus(this.xDisplay, nArray, nArray2);
        int n = nArray[0];
        if (n == 0) {
            return null;
        }
        int n2 = OS.XtWindowToWidget(this.xDisplay, n);
        if (n2 == 0) {
            return null;
        }
        if ((n2 = OS.XmGetFocusWidget(n2)) == 0) {
            return null;
        }
        do {
            Widget widget;
            if ((widget = this.getWidget(n2)) == null || !(widget instanceof Control)) continue;
            Control control = (Control)widget;
            return control.isEnabled() ? control : null;
        } while ((n2 = OS.XtParent(n2)) != 0);
        return null;
    }

    public boolean getHighContrast() {
        this.checkDevice();
        return false;
    }

    public int getIconDepth() {
        return this.getDepth();
    }

    public Point[] getIconSizes() {
        Point point;
        Point point2;
        this.checkDevice();
        int n = OS.XDefaultRootWindow(this.xDisplay);
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int n2 = OS.XGetIconSizes(this.xDisplay, n, nArray, nArray2);
        if (n2 != 0 && nArray2[0] > 0) {
            XIconSize xIconSize = new XIconSize();
            OS.memmove(xIconSize, nArray[0], 24);
            point2 = new Point(xIconSize.min_width, xIconSize.min_height);
            point = new Point(xIconSize.max_width, xIconSize.max_height);
            OS.XFree(nArray[0]);
        } else {
            point2 = new Point(16, 16);
            point = new Point(32, 32);
        }
        return new Point[]{point2, point};
    }

    int getLastEventTime() {
        return OS.XtLastTimestampProcessed(this.xDisplay);
    }

    int getMessageCount() {
        return this.synchronizer.getMessageCount();
    }

    public Monitor[] getMonitors() {
        Object object;
        boolean bl;
        this.checkDevice();
        Monitor[] monitorArray = null;
        if (OS.IsLinux && (bl = OS.XineramaIsActive(this.xDisplay))) {
            object = new int[1];
            int n = OS.XineramaQueryScreens(this.xDisplay, object);
            int n2 = object[0];
            if (n != 0 && n2 > 0) {
                monitorArray = new Monitor[n2];
                XineramaScreenInfo xineramaScreenInfo = new XineramaScreenInfo();
                int n3 = n;
                int n4 = 0;
                while (n4 < n2) {
                    Monitor monitor = new Monitor();
                    OS.memmove(xineramaScreenInfo, n3, 12);
                    n3 += 12;
                    monitor.handle = xineramaScreenInfo.screen_number;
                    monitor.x = xineramaScreenInfo.x_org;
                    monitor.y = xineramaScreenInfo.y_org;
                    monitor.width = xineramaScreenInfo.width;
                    monitor.height = xineramaScreenInfo.height;
                    monitor.clientX = monitor.x;
                    monitor.clientY = monitor.y;
                    monitor.clientWidth = monitor.width;
                    monitor.clientHeight = monitor.height;
                    monitorArray[n4] = monitor;
                    ++n4;
                }
            }
            if (n != 0) {
                OS.XFree(n);
            }
        }
        if (monitorArray == null) {
            Monitor monitor = new Monitor();
            object = this.getBounds();
            monitor.x = object.x;
            monitor.y = object.y;
            monitor.width = object.width;
            monitor.height = object.height;
            monitor.clientX = monitor.x;
            monitor.clientY = monitor.y;
            monitor.clientWidth = monitor.width;
            monitor.clientHeight = monitor.height;
            monitorArray = new Monitor[]{monitor};
        }
        return monitorArray;
    }

    public Monitor getPrimaryMonitor() {
        boolean bl;
        this.checkDevice();
        Monitor monitor = null;
        if (OS.IsLinux && (bl = OS.XineramaIsActive(this.xDisplay))) {
            int[] nArray = new int[1];
            int n = OS.XineramaQueryScreens(this.xDisplay, nArray);
            int n2 = nArray[0];
            if (n != 0 && n2 >= 1) {
                monitor = new Monitor();
                XineramaScreenInfo xineramaScreenInfo = new XineramaScreenInfo();
                OS.memmove(xineramaScreenInfo, n, 12);
                monitor.handle = xineramaScreenInfo.screen_number;
                monitor.x = xineramaScreenInfo.x_org;
                monitor.y = xineramaScreenInfo.y_org;
                monitor.width = xineramaScreenInfo.width;
                monitor.height = xineramaScreenInfo.height;
                monitor.clientX = monitor.x;
                monitor.clientY = monitor.y;
                monitor.clientWidth = monitor.width;
                monitor.clientHeight = monitor.height;
            }
            if (n != 0) {
                OS.XFree(n);
            }
        }
        if (monitor == null) {
            monitor = new Monitor();
            Rectangle rectangle = this.getBounds();
            monitor.x = rectangle.x;
            monitor.y = rectangle.y;
            monitor.width = rectangle.width;
            monitor.height = rectangle.height;
            monitor.clientX = monitor.x;
            monitor.clientY = monitor.y;
            monitor.clientWidth = monitor.width;
            monitor.clientHeight = monitor.height;
        }
        return monitor;
    }

    public Shell[] getShells() {
        this.checkDevice();
        int n = 0;
        int n2 = 0;
        while (n2 < this.shellTable.length) {
            if (this.shellTable[n2] != null) {
                ++n;
            }
            ++n2;
        }
        n2 = 0;
        Shell[] shellArray = new Shell[n];
        int n3 = 0;
        while (n3 < this.shellTable.length) {
            Shell shell = this.shellTable[n3];
            if (shell != null) {
                shellArray[n2++] = shell;
            }
            ++n3;
        }
        return shellArray;
    }

    public Synchronizer getSynchronizer() {
        this.checkDevice();
        return this.synchronizer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Thread getSyncThread() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (this.isDisposed()) {
                this.error(45);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.synchronizer.syncThread;
        }
    }

    public Color getSystemColor(int n) {
        this.checkDevice();
        XColor xColor = null;
        switch (n) {
            case 28: {
                return super.getSystemColor(2);
            }
            case 29: {
                return this.COLOR_INFO_BACKGROUND;
            }
            case 30: {
                return super.getSystemColor(1);
            }
            case 31: {
                return super.getSystemColor(10);
            }
            case 32: {
                return super.getSystemColor(9);
            }
            case 33: {
                return super.getSystemColor(2);
            }
            case 34: {
                return super.getSystemColor(16);
            }
            case 35: {
                return super.getSystemColor(15);
            }
            case 17: {
                xColor = this.COLOR_WIDGET_DARK_SHADOW;
                break;
            }
            case 18: {
                xColor = this.COLOR_WIDGET_NORMAL_SHADOW;
                break;
            }
            case 19: {
                xColor = this.COLOR_WIDGET_LIGHT_SHADOW;
                break;
            }
            case 20: {
                xColor = this.COLOR_WIDGET_HIGHLIGHT_SHADOW;
                break;
            }
            case 22: {
                xColor = this.COLOR_WIDGET_BACKGROUND;
                break;
            }
            case 21: {
                xColor = this.COLOR_WIDGET_FOREGROUND;
                break;
            }
            case 23: {
                xColor = this.COLOR_WIDGET_BORDER;
                break;
            }
            case 24: {
                xColor = this.COLOR_LIST_FOREGROUND;
                break;
            }
            case 25: {
                xColor = this.COLOR_LIST_BACKGROUND;
                break;
            }
            case 26: {
                xColor = this.COLOR_LIST_SELECTION;
                break;
            }
            case 27: {
                xColor = this.COLOR_LIST_SELECTION_TEXT;
                break;
            }
            default: {
                return super.getSystemColor(n);
            }
        }
        if (xColor == null) {
            return super.getSystemColor(2);
        }
        return Color.motif_new(this, xColor);
    }

    public Cursor getSystemCursor(int n) {
        this.checkDevice();
        if (n < 0 || n >= this.cursors.length) {
            return null;
        }
        if (this.cursors[n] == null) {
            this.cursors[n] = new Cursor(this, n);
        }
        return this.cursors[n];
    }

    public Font getSystemFont() {
        this.checkDevice();
        return this.defaultFont;
    }

    public Image getSystemImage(int n) {
        this.checkDevice();
        int n2 = 0;
        int n3 = 0;
        switch (n) {
            case 1: {
                if (this.errorPixmap == 0) {
                    this.errorPixmap = this.createPixmap("xm_error");
                    this.errorMask = this.createMask(this.errorPixmap);
                }
                n2 = this.errorPixmap;
                n3 = this.errorMask;
                break;
            }
            case 2: {
                if (this.infoPixmap == 0) {
                    this.infoPixmap = this.createPixmap("xm_information");
                    this.infoMask = this.createMask(this.infoPixmap);
                }
                n2 = this.infoPixmap;
                n3 = this.infoMask;
                break;
            }
            case 4: {
                if (this.questionPixmap == 0) {
                    this.questionPixmap = this.createPixmap("xm_question");
                    this.questionMask = this.createMask(this.questionPixmap);
                }
                n2 = this.questionPixmap;
                n3 = this.questionMask;
                break;
            }
            case 8: {
                if (this.warningPixmap == 0) {
                    this.warningPixmap = this.createPixmap("xm_warning");
                    this.warningMask = this.createMask(this.warningPixmap);
                }
                n2 = this.warningPixmap;
                n3 = this.warningMask;
                break;
            }
            case 16: {
                if (this.workingPixmap == 0) {
                    this.workingPixmap = this.createPixmap("xm_working");
                    this.workingMask = this.createMask(this.workingPixmap);
                }
                n2 = this.workingPixmap;
                n3 = this.workingMask;
            }
        }
        if (n2 == 0) {
            return null;
        }
        return Image.motif_new(this, 1, n2, n3);
    }

    public Tray getSystemTray() {
        this.checkDevice();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Thread getThread() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (this.isDisposed()) {
                this.error(45);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.thread;
        }
    }

    Widget getWidget(int n) {
        if (n == 0) {
            return null;
        }
        if (OS.XtIsSubclass(n, OS.shellWidgetClass())) {
            int n2 = 0;
            while (n2 < this.shellTable.length) {
                Shell shell = this.shellTable[n2];
                if (shell != null && ((Widget)shell).topHandle() == n) {
                    return shell;
                }
                ++n2;
            }
            return null;
        }
        this.userData[1] = 0;
        OS.XtGetValues(n, this.userData, this.userData.length / 2);
        if (this.userData[1] == 0) {
            return null;
        }
        int n3 = this.userData[1] - 1;
        if (n3 >= 0 && n3 < this.widgetTable.length) {
            return this.widgetTable[n3];
        }
        return null;
    }

    void hideToolTip() {
        if (this.toolTipHandle != 0) {
            int n = OS.XtParent(this.toolTipHandle);
            OS.XtDestroyWidget(n);
        }
        this.toolTipHandle = 0;
    }

    protected void init() {
        super.init();
        this.initializeDisplay();
        this.initializeButton();
        this.initializeComposite();
        this.initializeDialog();
        this.initializeLabel();
        this.initializeList();
        this.initializeScrollBar();
        this.initializeText();
        this.initializeSystemColors();
        this.initializeDefaults();
        this.initializeTranslations();
        this.initializeWidgetTable();
        this.initializeNumLock();
        this.initializePixmaps();
    }

    void initializeButton() {
        int n = OS.topLevelShellWidgetClass();
        int n2 = OS.XtAppCreateShell(this.appName, this.appClass, n, this.xDisplay, null, 0);
        byte[] byArray = Converter.wcsToMbcs(null, "string", true);
        int n3 = OS.XmCreatePushButton(n2, byArray, null, 0);
        OS.XtManageChild(n3);
        OS.XtSetMappedWhenManaged(n2, false);
        OS.XtRealizeWidget(n2);
        int[] nArray = new int[8];
        nArray[0] = OS.XmNforeground;
        nArray[2] = OS.XmNbackground;
        nArray[4] = OS.XmNshadowThickness;
        nArray[6] = OS.XmNfontList;
        int[] nArray2 = nArray;
        OS.XtGetValues(n3, nArray2, nArray2.length / 2);
        this.buttonForeground = nArray2[1];
        this.buttonBackground = nArray2[3];
        this.buttonShadowThickness = nArray2[5];
        this.buttonFont = Font.motif_new(this, OS.XmFontListCopy(nArray2[7]));
        OS.XtDestroyWidget(n2);
    }

    void initializeComposite() {
        int n = OS.topLevelShellWidgetClass();
        int n2 = OS.XtAppCreateShell(this.appName, this.appClass, n, this.xDisplay, null, 0);
        int n3 = OS.XmCreateMainWindow(n2, null, null, 0);
        int[] nArray = new int[]{OS.XmNorientation, 2};
        int n4 = OS.XmCreateScrollBar(n3, null, nArray, nArray.length / 2);
        OS.XtManageChild(n4);
        int[] nArray2 = new int[]{OS.XmNorientation, 1};
        int n5 = OS.XmCreateScrollBar(n3, null, nArray2, nArray2.length / 2);
        OS.XtManageChild(n5);
        OS.XtManageChild(n3);
        int[] nArray3 = new int[]{OS.XmNmarginWidth, 3, OS.XmNmarginHeight, 3};
        int n6 = OS.XmCreateForm(n3, null, nArray3, nArray3.length / 2);
        OS.XtManageChild(n6);
        int[] nArray4 = new int[14];
        nArray4[0] = OS.XmNmarginWidth;
        nArray4[2] = OS.XmNmarginHeight;
        nArray4[4] = OS.XmNresizePolicy;
        nArray4[6] = OS.XmNtopAttachment;
        nArray4[7] = 1;
        nArray4[8] = OS.XmNbottomAttachment;
        nArray4[9] = 1;
        nArray4[10] = OS.XmNleftAttachment;
        nArray4[11] = 1;
        nArray4[12] = OS.XmNrightAttachment;
        nArray4[13] = 1;
        int[] nArray5 = nArray4;
        int n7 = OS.XmCreateDrawingArea(n6, null, nArray5, nArray5.length / 2);
        OS.XtManageChild(n7);
        OS.XmMainWindowSetAreas(n3, 0, 0, n4, n5, n6);
        OS.XtSetMappedWhenManaged(n2, false);
        int n8 = OS.XDefaultScreen(this.xDisplay);
        OS.XtResizeWidget(n2, OS.XDisplayWidth(this.xDisplay, n8), OS.XDisplayHeight(this.xDisplay, n8), 0);
        OS.XtRealizeWidget(n2);
        int[] nArray6 = new int[4];
        nArray6[0] = OS.XmNwidth;
        nArray6[2] = OS.XmNheight;
        int[] nArray7 = nArray6;
        OS.XtGetValues(n3, nArray7, nArray7.length / 2);
        int[] nArray8 = new int[8];
        nArray8[0] = OS.XmNx;
        nArray8[2] = OS.XmNy;
        nArray8[4] = OS.XmNwidth;
        nArray8[6] = OS.XmNheight;
        int[] nArray9 = nArray8;
        OS.XtGetValues(n6, nArray9, nArray9.length / 2);
        int[] nArray10 = new int[18];
        nArray10[0] = OS.XmNx;
        nArray10[2] = OS.XmNy;
        nArray10[4] = OS.XmNwidth;
        nArray10[6] = OS.XmNheight;
        nArray10[8] = OS.XmNforeground;
        nArray10[10] = OS.XmNbackground;
        nArray10[12] = OS.XmNtopShadowColor;
        nArray10[14] = OS.XmNbottomShadowColor;
        nArray10[16] = OS.XmNborderColor;
        int[] nArray11 = nArray10;
        OS.XtGetValues(n7, nArray11, nArray11.length / 2);
        this.scrolledInsetX = nArray11[1] + nArray9[1];
        this.scrolledInsetY = nArray11[3] + nArray9[3];
        this.scrolledMarginX = nArray7[1] - nArray9[1] - nArray11[1] - nArray11[5];
        this.scrolledMarginY = nArray7[3] - nArray9[3] - nArray11[3] - nArray11[7];
        this.compositeForeground = nArray11[9];
        this.compositeBackground = nArray11[11];
        this.compositeTopShadow = nArray11[13];
        this.compositeBottomShadow = nArray11[15];
        this.compositeBorder = nArray11[17];
        OS.XtDestroyWidget(n2);
    }

    void initializeDefaults() {
        this.defaultFont = this.labelFont;
        this.defaultForeground = this.compositeForeground;
        this.defaultBackground = this.compositeBackground;
    }

    void initializeDialog() {
    }

    void initializeDisplay() {
        int[] nArray;
        this.focusCallback = new Callback(this, "focusProc", 4);
        this.focusProc = this.focusCallback.getAddress();
        if (this.focusProc == 0) {
            this.error(3);
        }
        this.windowCallback = new Callback(this, "windowProc", 4);
        this.windowProc = this.windowCallback.getAddress();
        if (this.windowProc == 0) {
            this.error(3);
        }
        this.windowTimerCallback = new Callback(this, "windowTimerProc", 2);
        this.windowTimerProc = this.windowTimerCallback.getAddress();
        if (this.windowTimerProc == 0) {
            this.error(3);
        }
        this.timerCallback = new Callback(this, "timerProc", 2);
        this.timerProc = this.timerCallback.getAddress();
        if (this.timerProc == 0) {
            this.error(3);
        }
        this.caretCallback = new Callback(this, "caretProc", 2);
        this.caretProc = this.caretCallback.getAddress();
        if (this.caretProc == 0) {
            this.error(3);
        }
        this.mouseHoverCallback = new Callback(this, "mouseHoverProc", 2);
        this.mouseHoverProc = this.mouseHoverCallback.getAddress();
        if (this.mouseHoverProc == 0) {
            this.error(3);
        }
        this.checkExposeCallback = new Callback(this, "checkExposeProc", 3);
        this.checkExposeProc = this.checkExposeCallback.getAddress();
        if (this.checkExposeProc == 0) {
            this.error(3);
        }
        this.checkResizeCallback = new Callback(this, "checkResizeProc", 3);
        this.checkResizeProc = this.checkResizeCallback.getAddress();
        if (this.checkResizeProc == 0) {
            this.error(3);
        }
        this.wakeCallback = new Callback(this, "wakeProc", 3);
        this.wakeProc = this.wakeCallback.getAddress();
        if (this.wakeProc == 0) {
            this.error(3);
        }
        if (OS.pipe(nArray = new int[2]) != 0) {
            this.error(2);
        }
        this.read_fd = nArray[0];
        this.write_fd = nArray[1];
        int n = OS.XtDisplayToApplicationContext(this.xDisplay);
        this.inputID = OS.XtAppAddInput(n, this.read_fd, 1, this.wakeProc, 0);
        this.fd_set = new byte[OS.fd_set_sizeof()];
        int n2 = OS.XmGetXmDisplay(this.xDisplay);
        int[] nArray2 = new int[]{OS.XmNenableThinThickness, 1, OS.XmNdragInitiatorProtocolStyle, 5, OS.XmNdragReceiverProtocolStyle, 5};
        OS.XtSetValues(n2, nArray2, nArray2.length / 2);
        int n3 = OS.XDefaultScreen(this.xDisplay);
        int n4 = OS.topLevelShellWidgetClass();
        this.shellHandle = OS.XtAppCreateShell(this.appName, this.appClass, n4, this.xDisplay, null, 0);
        OS.XtSetMappedWhenManaged(this.shellHandle, false);
        OS.XtResizeWidget(this.shellHandle, OS.XDisplayWidth(this.xDisplay, n3), OS.XDisplayHeight(this.xDisplay, n3), 0);
        OS.XtRealizeWidget(this.shellHandle);
    }

    void initializeLabel() {
        int n = OS.topLevelShellWidgetClass();
        int n2 = OS.XtAppCreateShell(this.appName, this.appClass, n, this.xDisplay, null, 0);
        byte[] byArray = Converter.wcsToMbcs(null, "string", true);
        int n3 = OS.XmCreateLabel(n2, byArray, null, 0);
        OS.XtManageChild(n3);
        OS.XtSetMappedWhenManaged(n2, false);
        OS.XtRealizeWidget(n2);
        int[] nArray = new int[6];
        nArray[0] = OS.XmNforeground;
        nArray[2] = OS.XmNbackground;
        nArray[4] = OS.XmNfontList;
        int[] nArray2 = nArray;
        OS.XtGetValues(n3, nArray2, nArray2.length / 2);
        this.labelForeground = nArray2[1];
        this.labelBackground = nArray2[3];
        this.labelFont = Font.motif_new(this, OS.XmFontListCopy(nArray2[5]));
        OS.XtDestroyWidget(n2);
    }

    void initializeList() {
        int n = OS.topLevelShellWidgetClass();
        int n2 = OS.XtAppCreateShell(this.appName, this.appClass, n, this.xDisplay, null, 0);
        int n3 = OS.XmCreateScrolledList(n2, new byte[1], null, 0);
        OS.XtManageChild(n3);
        OS.XtSetMappedWhenManaged(n2, false);
        OS.XtRealizeWidget(n2);
        int[] nArray = new int[10];
        nArray[0] = OS.XmNforeground;
        nArray[2] = OS.XmNbackground;
        nArray[4] = OS.XmNfontList;
        nArray[6] = OS.XmNselectColor;
        nArray[8] = OS.XmNhighlightColor;
        int[] nArray2 = nArray;
        OS.XtGetValues(n3, nArray2, nArray2.length / 2);
        this.listForeground = nArray2[1];
        this.listBackground = nArray2[3];
        this.listFont = Font.motif_new(this, OS.XmFontListCopy(nArray2[5]));
        byte by = (byte)nArray2[7];
        switch (by) {
            case -2: 
            case -1: {
                this.listSelect = this.listForeground;
                break;
            }
            case -3: {
                this.listSelect = nArray2[9];
                break;
            }
            default: {
                this.listSelect = nArray2[7];
            }
        }
        OS.XtDestroyWidget(n2);
    }

    void initializeNumLock() {
        int n = OS.XKeysymToKeycode(this.xDisplay, 65407);
        int n2 = OS.XGetModifierMapping(this.xDisplay);
        XModifierKeymap xModifierKeymap = new XModifierKeymap();
        OS.memmove(xModifierKeymap, n2, 8);
        int n3 = 0;
        while (n3 < 8 * xModifierKeymap.max_keypermod) {
            byte[] byArray = new byte[1];
            OS.memmove(byArray, xModifierKeymap.modifiermap + n3, 1);
            if (byArray[0] == n) {
                int n4 = n3 / xModifierKeymap.max_keypermod;
                switch (n4) {
                    case 3: {
                        numLock = "Mod1";
                        break;
                    }
                    case 4: {
                        numLock = "Mod2";
                        break;
                    }
                    case 5: {
                        numLock = "Mod3";
                        break;
                    }
                    case 6: {
                        numLock = "Mod4";
                        break;
                    }
                    case 7: {
                        numLock = "Mod5";
                        break;
                    }
                    default: {
                        numLock = "Mod2";
                        break;
                    }
                }
                break;
            }
            ++n3;
        }
        OS.XFreeModifiermap(n2);
    }

    void initializePixmaps() {
        int n = OS.XmCreateErrorDialog(this.shellHandle, null, null, 0);
        OS.XtDestroyWidget(n);
    }

    void initializeScrollBar() {
    }

    void initializeSystemColors() {
        int[] nArray = new int[2];
        nArray[0] = OS.XmNcolormap;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.shellHandle, nArray2, nArray2.length / 2);
        int n = nArray2[1];
        this.COLOR_WIDGET_DARK_SHADOW = new XColor();
        this.COLOR_WIDGET_DARK_SHADOW.pixel = this.compositeBottomShadow;
        OS.XQueryColor(this.xDisplay, n, this.COLOR_WIDGET_DARK_SHADOW);
        this.COLOR_WIDGET_NORMAL_SHADOW = new XColor();
        this.COLOR_WIDGET_NORMAL_SHADOW.pixel = this.compositeBottomShadow;
        OS.XQueryColor(this.xDisplay, n, this.COLOR_WIDGET_NORMAL_SHADOW);
        this.COLOR_WIDGET_LIGHT_SHADOW = new XColor();
        this.COLOR_WIDGET_LIGHT_SHADOW.pixel = this.compositeTopShadow;
        OS.XQueryColor(this.xDisplay, n, this.COLOR_WIDGET_LIGHT_SHADOW);
        this.COLOR_WIDGET_HIGHLIGHT_SHADOW = new XColor();
        this.COLOR_WIDGET_HIGHLIGHT_SHADOW.pixel = this.compositeTopShadow;
        OS.XQueryColor(this.xDisplay, n, this.COLOR_WIDGET_HIGHLIGHT_SHADOW);
        this.COLOR_WIDGET_FOREGROUND = new XColor();
        this.COLOR_WIDGET_FOREGROUND.pixel = this.textForeground;
        OS.XQueryColor(this.xDisplay, n, this.COLOR_WIDGET_FOREGROUND);
        this.COLOR_WIDGET_BACKGROUND = new XColor();
        this.COLOR_WIDGET_BACKGROUND.pixel = this.compositeBackground;
        OS.XQueryColor(this.xDisplay, n, this.COLOR_WIDGET_BACKGROUND);
        this.COLOR_WIDGET_BORDER = new XColor();
        this.COLOR_WIDGET_BORDER.pixel = this.compositeBorder;
        OS.XQueryColor(this.xDisplay, n, this.COLOR_WIDGET_BORDER);
        this.COLOR_LIST_FOREGROUND = new XColor();
        this.COLOR_LIST_FOREGROUND.pixel = this.listForeground;
        OS.XQueryColor(this.xDisplay, n, this.COLOR_LIST_FOREGROUND);
        this.COLOR_LIST_BACKGROUND = new XColor();
        this.COLOR_LIST_BACKGROUND.pixel = this.listBackground;
        OS.XQueryColor(this.xDisplay, n, this.COLOR_LIST_BACKGROUND);
        this.COLOR_LIST_SELECTION = new XColor();
        this.COLOR_LIST_SELECTION.pixel = this.listSelect;
        OS.XQueryColor(this.xDisplay, n, this.COLOR_LIST_SELECTION);
        this.COLOR_LIST_SELECTION_TEXT = new XColor();
        this.COLOR_LIST_SELECTION_TEXT.pixel = this.listBackground;
        OS.XQueryColor(this.xDisplay, n, this.COLOR_LIST_SELECTION_TEXT);
        this.COLOR_INFO_BACKGROUND = new Color(this, 255, 255, 225);
    }

    void initializeText() {
        int n = OS.topLevelShellWidgetClass();
        int n2 = OS.XtAppCreateShell(this.appName, this.appClass, n, this.xDisplay, null, 0);
        int n3 = OS.XmCreateScrolledText(n2, new byte[1], null, 0);
        OS.XtManageChild(n3);
        OS.XtSetMappedWhenManaged(n2, false);
        OS.XtRealizeWidget(n2);
        int[] nArray = new int[10];
        nArray[0] = OS.XmNforeground;
        nArray[2] = OS.XmNbackground;
        nArray[4] = OS.XmNfontList;
        nArray[6] = OS.XmNhighlightThickness;
        nArray[8] = OS.XmNblinkRate;
        int[] nArray2 = nArray;
        OS.XtGetValues(n3, nArray2, nArray2.length / 2);
        this.textForeground = nArray2[1];
        this.textBackground = nArray2[3];
        this.textHighlightThickness = nArray2[7];
        this.blinkRate = nArray2[9];
        this.textFont = Font.motif_new(this, OS.XmFontListCopy(nArray2[5]));
        OS.XtDestroyWidget(n2);
    }

    void initializeTranslations() {
        byte[] byArray = Converter.wcsToMbcs(null, "<Key>osfUp:\n<Key>osfDown:\n<Key>osfLeft:\n<Key>osfRight:\u0000");
        this.arrowTranslations = OS.XtParseTranslationTable(byArray);
        byte[] byArray2 = Converter.wcsToMbcs(null, "~Meta ~Alt <Key>Tab:\nShift ~Meta ~Alt <Key>Tab:\u0000");
        this.tabTranslations = OS.XtParseTranslationTable(byArray2);
        byte[] byArray3 = Converter.wcsToMbcs(null, "<Btn2Down>:\u0000");
        this.dragTranslations = OS.XtParseTranslationTable(byArray3);
    }

    void initializeWidgetTable() {
        int[] nArray = new int[2];
        nArray[0] = OS.XmNuserData;
        this.userData = nArray;
        this.indexTable = new int[1024];
        this.shellTable = new Shell[128];
        this.widgetTable = new Widget[1024];
        int n = 0;
        while (n < 1023) {
            this.indexTable[n] = n + 1;
            ++n;
        }
        this.indexTable[1023] = -1;
    }

    public int internal_new_GC(GCData gCData) {
        int n;
        int n2;
        if (this.isDisposed()) {
            SWT.error(45);
        }
        if ((n2 = OS.XCreateGC(this.xDisplay, n = OS.XDefaultRootWindow(this.xDisplay), 0, null)) == 0) {
            SWT.error(2);
        }
        OS.XSetSubwindowMode(this.xDisplay, n2, 1);
        if (gCData != null) {
            int n3 = 0x6000000;
            if ((gCData.style & n3) == 0) {
                gCData.style |= 0x2000000;
            }
            gCData.device = this;
            gCData.display = this.xDisplay;
            gCData.drawable = n;
            gCData.background = this.getSystemColor((int)1).handle;
            gCData.foreground = this.getSystemColor((int)2).handle;
            gCData.font = this.defaultFont;
            gCData.colormap = OS.XDefaultColormap(this.xDisplay, OS.XDefaultScreen(this.xDisplay));
        }
        return n2;
    }

    public void internal_dispose_GC(int n, GCData gCData) {
        OS.XFreeGC(this.xDisplay, n);
    }

    boolean isValidThread() {
        return this.thread == Thread.currentThread();
    }

    static boolean isValidClass(Class clazz) {
        String string = clazz.getName();
        int n = string.lastIndexOf(46);
        return string.substring(0, n + 1).equals(PACKAGE_PREFIX);
    }

    public Point map(Control control, Control control2, Point point) {
        this.checkDevice();
        if (point == null) {
            this.error(4);
        }
        return this.map(control, control2, point.x, point.y);
    }

    public Point map(Control control, Control control2, int n, int n2) {
        short[] sArray;
        short[] sArray2;
        this.checkDevice();
        if (control != null && control.isDisposed()) {
            this.error(5);
        }
        if (control2 != null && control2.isDisposed()) {
            this.error(5);
        }
        Point point = new Point(n, n2);
        if (control == control2) {
            return point;
        }
        if (control != null) {
            sArray2 = new short[1];
            sArray = new short[1];
            OS.XtTranslateCoords(control.handle, (short)n, (short)n2, sArray2, sArray);
            point.x = sArray2[0];
            point.y = sArray[0];
        }
        if (control2 != null) {
            sArray2 = new short[1];
            sArray = new short[1];
            OS.XtTranslateCoords(control2.handle, (short)0, (short)0, sArray2, sArray);
            point.x -= sArray2[0];
            point.y -= sArray[0];
        }
        return point;
    }

    public Rectangle map(Control control, Control control2, Rectangle rectangle) {
        this.checkDevice();
        if (rectangle == null) {
            this.error(4);
        }
        return this.map(control, control2, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public Rectangle map(Control control, Control control2, int n, int n2, int n3, int n4) {
        short[] sArray;
        short[] sArray2;
        this.checkDevice();
        if (control != null && control.isDisposed()) {
            this.error(5);
        }
        if (control2 != null && control2.isDisposed()) {
            this.error(5);
        }
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        if (control == control2) {
            return rectangle;
        }
        if (control != null) {
            sArray2 = new short[1];
            sArray = new short[1];
            OS.XtTranslateCoords(control.handle, (short)n, (short)n2, sArray2, sArray);
            rectangle.x = sArray2[0];
            rectangle.y = sArray[0];
        }
        if (control2 != null) {
            sArray2 = new short[1];
            sArray = new short[1];
            OS.XtTranslateCoords(control2.handle, (short)0, (short)0, sArray2, sArray);
            rectangle.x -= sArray2[0];
            rectangle.y -= sArray[0];
        }
        return rectangle;
    }

    int mouseHoverProc(int n, int n2) {
        this.mouseHoverHandle = 0;
        this.mouseHoverID = 0;
        Widget widget = this.getWidget(n);
        if (widget == null) {
            return 0;
        }
        return widget.hoverProc(n2);
    }

    /*
     * Exception decompiling
     */
    public boolean post(Event var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 9[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    void postEvent(Event event) {
        if (this.eventQueue == null) {
            this.eventQueue = new Event[4];
        }
        int n = 0;
        int n2 = this.eventQueue.length;
        while (n < n2) {
            if (this.eventQueue[n] == null) break;
            ++n;
        }
        if (n == n2) {
            Event[] eventArray = new Event[n2 + 4];
            System.arraycopy(this.eventQueue, 0, eventArray, 0, n2);
            this.eventQueue = eventArray;
        }
        this.eventQueue[n] = event;
    }

    public boolean readAndDispatch() {
        this.checkDevice();
        boolean bl = this.runPopups();
        int n = OS.XtDisplayToApplicationContext(this.xDisplay);
        int n2 = OS.XtAppPending(n);
        if (n2 != 0) {
            bl |= true;
            if ((n2 & 2) != 0) {
                OS.XtAppProcessEvent(n, 2);
                n2 = OS.XtAppPending(n);
            }
            if ((n2 & 4) != 0) {
                OS.XtAppProcessEvent(n, 4);
                n2 = OS.XtAppPending(n);
            }
            if ((n2 & 1) != 0) {
                OS.XtAppNextEvent(n, this.xEvent);
                if (!this.filterEvent(this.xEvent)) {
                    OS.XtDispatchEvent(this.xEvent);
                }
            }
        }
        if (bl) {
            this.runDeferredEvents();
            return true;
        }
        return this.isDisposed() || this.runAsyncMessages(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void register(Display display) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            int n = 0;
            while (n < Displays.length) {
                if (Displays[n] == null) {
                    Display.Displays[n] = display;
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
                ++n;
            }
            Display[] displayArray = new Display[Displays.length + 4];
            System.arraycopy(Displays, 0, displayArray, 0, Displays.length);
            displayArray[Display.Displays.length] = display;
            Displays = displayArray;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected void release() {
        this.sendEvent(12, new Event());
        Shell[] shellArray = this.getShells();
        int n = 0;
        while (n < shellArray.length) {
            Shell shell = shellArray[n];
            if (!shell.isDisposed()) {
                shell.dispose();
            }
            ++n;
        }
        if (this.tray != null) {
            this.tray.dispose();
        }
        this.tray = null;
        while (this.readAndDispatch()) {
        }
        if (this.disposeList != null) {
            n = 0;
            while (n < this.disposeList.length) {
                if (this.disposeList[n] != null) {
                    this.disposeList[n].run();
                }
                ++n;
            }
        }
        this.disposeList = null;
        this.synchronizer.releaseSynchronizer();
        this.synchronizer = null;
        this.releaseDisplay();
        super.release();
    }

    void releaseDisplay() {
        int n = OS.XDefaultScreenOfDisplay(this.xDisplay);
        if (this.errorPixmap != 0) {
            OS.XmDestroyPixmap(n, this.errorPixmap);
            OS.XFreePixmap(this.xDisplay, this.errorMask);
        }
        if (this.infoPixmap != 0) {
            OS.XmDestroyPixmap(n, this.infoPixmap);
            OS.XFreePixmap(this.xDisplay, this.infoMask);
        }
        if (this.questionPixmap != 0) {
            OS.XmDestroyPixmap(n, this.questionPixmap);
            OS.XFreePixmap(this.xDisplay, this.questionMask);
        }
        if (this.warningPixmap != 0) {
            OS.XmDestroyPixmap(n, this.warningPixmap);
            OS.XFreePixmap(this.xDisplay, this.warningMask);
        }
        if (this.workingPixmap != 0) {
            OS.XmDestroyPixmap(n, this.workingPixmap);
            OS.XFreePixmap(this.xDisplay, this.workingMask);
        }
        this.workingPixmap = 0;
        this.warningPixmap = 0;
        this.questionPixmap = 0;
        this.infoPixmap = 0;
        this.errorPixmap = 0;
        this.workingMask = 0;
        this.warningMask = 0;
        this.questionMask = 0;
        this.infoMask = 0;
        this.errorMask = 0;
        int n2 = 0;
        while (n2 < this.cursors.length) {
            if (this.cursors[n2] != null) {
                this.cursors[n2].dispose();
            }
            ++n2;
        }
        this.cursors = null;
        if (this.shellHandle != 0) {
            if (!OS.IsSunOS) {
                OS.XtDestroyWidget(this.shellHandle);
            }
            this.shellHandle = 0;
        }
        if (this.caretID != 0) {
            OS.XtRemoveTimeOut(this.caretID);
        }
        this.caretProc = 0;
        this.caretID = 0;
        this.caretCallback.dispose();
        this.caretCallback = null;
        if (this.timerIds != null) {
            n2 = 0;
            while (n2 < this.timerIds.length) {
                if (this.timerIds[n2] != 0) {
                    OS.XtRemoveTimeOut(this.timerIds[n2]);
                }
                ++n2;
            }
        }
        this.timerIds = null;
        this.timerList = null;
        this.timerProc = 0;
        this.timerCallback.dispose();
        this.timerCallback = null;
        this.windowTimerProc = 0;
        this.windowTimerCallback.dispose();
        this.windowTimerCallback = null;
        if (this.mouseHoverID != 0) {
            OS.XtRemoveTimeOut(this.mouseHoverID);
        }
        this.toolTipHandle = 0;
        this.mouseHoverHandle = 0;
        this.mouseHoverProc = 0;
        this.mouseHoverID = 0;
        this.mouseHoverCallback.dispose();
        this.mouseHoverCallback = null;
        this.windowCallback.dispose();
        this.windowCallback = null;
        this.checkExposeCallback.dispose();
        this.checkExposeCallback = null;
        this.checkExposeProc = 0;
        this.checkResizeCallback.dispose();
        this.checkResizeCallback = null;
        this.checkResizeProc = 0;
        if (this.inputID != 0) {
            OS.XtRemoveInput(this.inputID);
        }
        this.wakeCallback.dispose();
        this.wakeCallback = null;
        this.wakeProc = 0;
        OS.close(this.read_fd);
        OS.close(this.write_fd);
        this.focusCallback.dispose();
        this.focusCallback = null;
        this.focusProc = 0;
        if (this.buttonFont != null) {
            OS.XmFontListFree(this.buttonFont.handle);
            this.buttonFont.handle = 0;
        }
        if (this.labelFont != null) {
            OS.XmFontListFree(this.labelFont.handle);
            this.labelFont.handle = 0;
        }
        if (this.textFont != null) {
            OS.XmFontListFree(this.textFont.handle);
            this.textFont.handle = 0;
        }
        if (this.listFont != null) {
            OS.XmFontListFree(this.listFont.handle);
            this.listFont.handle = 0;
        }
        this.buttonFont = null;
        this.labelFont = null;
        this.textFont = null;
        this.listFont = null;
        this.defaultFont = null;
        if (this.xEvent != 0) {
            OS.XtFree(this.xEvent);
        }
        this.xEvent = 0;
        this.thread = null;
        this.buttonForeground = 0;
        this.buttonBackground = 0;
        this.defaultForeground = 0;
        this.defaultBackground = 0;
        this.COLOR_LIST_SELECTION_TEXT = null;
        this.COLOR_LIST_SELECTION = null;
        this.COLOR_LIST_BACKGROUND = null;
        this.COLOR_LIST_FOREGROUND = null;
        this.COLOR_WIDGET_BORDER = null;
        this.COLOR_WIDGET_BACKGROUND = null;
        this.COLOR_WIDGET_FOREGROUND = null;
        this.COLOR_WIDGET_HIGHLIGHT_SHADOW = null;
        this.COLOR_WIDGET_LIGHT_SHADOW = null;
        this.COLOR_WIDGET_NORMAL_SHADOW = null;
        this.COLOR_WIDGET_DARK_SHADOW = null;
        this.COLOR_INFO_BACKGROUND = null;
        this.popups = null;
        this.focusedCombo = null;
        this.fd_set = null;
        this.wake_buffer = null;
        this.appClass = null;
        this.appName = null;
        this.displayName = null;
        this.keyEvent = null;
        this.filterTable = null;
        this.eventTable = null;
        this.timeout = null;
        this.userData = null;
        this.indexTable = null;
        this.shellTable = null;
        this.widgetTable = null;
        this.xExposeEvent = null;
        this.xConfigureEvent = null;
        this.data = null;
        this.keys = null;
        this.values = null;
    }

    void releaseToolTipHandle(int n) {
        int n2;
        int n3;
        if (this.mouseHoverHandle == n) {
            this.removeMouseHoverTimeOut();
        }
        if (this.toolTipHandle != 0 && n == (n3 = OS.XtParent(n2 = OS.XtParent(this.toolTipHandle)))) {
            this.toolTipHandle = 0;
        }
    }

    void removeMouseHoverTimeOut() {
        if (this.mouseHoverID != 0) {
            OS.XtRemoveTimeOut(this.mouseHoverID);
        }
        this.mouseHoverHandle = 0;
        this.mouseHoverID = 0;
    }

    Widget removeWidget(int n) {
        if (n == 0) {
            return null;
        }
        if (OS.XtIsSubclass(n, OS.shellWidgetClass())) {
            int n2 = 0;
            while (n2 < this.shellTable.length) {
                Shell shell = this.shellTable[n2];
                if (shell != null && ((Widget)shell).topHandle() == n) {
                    this.shellTable[n2] = null;
                    return shell;
                }
                ++n2;
            }
            return null;
        }
        this.userData[1] = 0;
        Widget widget = null;
        OS.XtGetValues(n, this.userData, this.userData.length / 2);
        int n3 = this.userData[1] - 1;
        if (n3 >= 0 && n3 < this.widgetTable.length) {
            widget = this.widgetTable[n3];
            this.widgetTable[n3] = null;
            this.indexTable[n3] = this.freeSlot;
            this.freeSlot = n3;
            this.userData[1] = 0;
            OS.XtSetValues(n, this.userData, this.userData.length / 2);
        }
        return widget;
    }

    void removePopup(Menu menu) {
        if (this.popups == null) {
            return;
        }
        int n = 0;
        while (n < this.popups.length) {
            if (this.popups[n] == menu) {
                this.popups[n] = null;
                return;
            }
            ++n;
        }
    }

    public void removeFilter(int n, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.filterTable == null) {
            return;
        }
        this.filterTable.unhook(n, listener);
        if (this.filterTable.size() == 0) {
            this.filterTable = null;
        }
    }

    public void removeListener(int n, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(n, listener);
    }

    boolean runAsyncMessages(boolean bl) {
        return this.synchronizer.runAsyncMessages(bl);
    }

    boolean runDeferredEvents() {
        boolean bl = false;
        while (this.eventQueue != null) {
            Widget widget;
            Event event = this.eventQueue[0];
            if (event == null) break;
            int n = this.eventQueue.length;
            System.arraycopy(this.eventQueue, 1, this.eventQueue, 0, --n);
            this.eventQueue[n] = null;
            Widget widget2 = event.widget;
            if (widget2 == null || widget2.isDisposed() || (widget = event.item) != null && widget.isDisposed()) continue;
            bl = true;
            widget2.sendEvent(event);
        }
        this.eventQueue = null;
        return bl;
    }

    boolean runFocusOutEvents() {
        if (this.eventQueue == null) {
            return false;
        }
        Event[] eventArray = null;
        int n = 0;
        int n2 = 0;
        int n3 = this.eventQueue.length;
        while (n < n3) {
            Event event = this.eventQueue[n];
            if (event != null && event.type == 16) {
                if (eventArray == null) {
                    eventArray = new Event[n3];
                }
                eventArray[n2++] = event;
                System.arraycopy(this.eventQueue, n + 1, this.eventQueue, n, --n3 - n);
                this.eventQueue[n3] = null;
                continue;
            }
            ++n;
        }
        if (eventArray == null) {
            return false;
        }
        int n4 = 0;
        while (n4 < n2) {
            Widget widget;
            Event event = eventArray[n4];
            Widget widget2 = event.widget;
            if (!(widget2 == null || widget2.isDisposed() || (widget = event.item) != null && widget.isDisposed())) {
                widget2.sendEvent(event);
            }
            ++n4;
        }
        return true;
    }

    boolean runPopups() {
        if (this.popups == null) {
            return false;
        }
        boolean bl = false;
        while (this.popups != null) {
            Menu menu = this.popups[0];
            if (menu == null) break;
            int n = this.popups.length;
            System.arraycopy(this.popups, 1, this.popups, 0, --n);
            this.popups[n] = null;
            this.runDeferredEvents();
            if (!menu.isDisposed()) {
                menu._setVisible(true);
            }
            bl = true;
        }
        this.popups = null;
        return bl;
    }

    void sendEvent(int n, Event event) {
        if (this.eventTable == null && this.filterTable == null) {
            return;
        }
        if (event == null) {
            event = new Event();
        }
        event.display = this;
        event.type = n;
        if (event.time == 0) {
            event.time = this.getLastEventTime();
        }
        if (!this.filterEvent(event) && this.eventTable != null) {
            this.eventTable.sendEvent(event);
        }
    }

    void sendFocusEvent(Control control, int n) {
        if (n == 15) {
            this.focusEvent = 15;
            control.sendEvent(15);
            this.focusEvent = 0;
        } else if (this.postFocusOut) {
            control.postEvent(16);
        } else {
            this.focusEvent = 16;
            control.sendEvent(16);
            this.focusEvent = 0;
        }
    }

    public void setCursorLocation(int n, int n2) {
        this.checkDevice();
        int n3 = OS.XDefaultRootWindow(this.xDisplay);
        OS.XWarpPointer(this.xDisplay, 0, n3, 0, 0, 0, 0, n, n2);
    }

    public void setCursorLocation(Point point) {
        this.checkDevice();
        if (point == null) {
            this.error(4);
        }
        this.setCursorLocation(point.x, point.y);
    }

    public static void setAppName(String string) {
        APP_NAME = string;
    }

    void setCurrentCaret(Caret caret) {
        if (this.caretID != 0) {
            OS.XtRemoveTimeOut(this.caretID);
        }
        this.caretID = 0;
        this.currentCaret = caret;
        if (this.currentCaret != null) {
            int n = this.currentCaret.blinkRate;
            int n2 = OS.XtDisplayToApplicationContext(this.xDisplay);
            this.caretID = OS.XtAppAddTimeOut(n2, n, this.caretProc, 0);
        }
    }

    public void setData(String string, Object object) {
        this.checkDevice();
        if (string == null) {
            this.error(4);
        }
        if (object == null) {
            if (this.keys == null) {
                return;
            }
            int n = 0;
            while (n < this.keys.length && !this.keys[n].equals(string)) {
                ++n;
            }
            if (n == this.keys.length) {
                return;
            }
            if (this.keys.length == 1) {
                this.keys = null;
                this.values = null;
            } else {
                String[] stringArray = new String[this.keys.length - 1];
                Object[] objectArray = new Object[this.values.length - 1];
                System.arraycopy(this.keys, 0, stringArray, 0, n);
                System.arraycopy(this.keys, n + 1, stringArray, n, stringArray.length - n);
                System.arraycopy(this.values, 0, objectArray, 0, n);
                System.arraycopy(this.values, n + 1, objectArray, n, objectArray.length - n);
                this.keys = stringArray;
                this.values = objectArray;
            }
            return;
        }
        if (this.keys == null) {
            this.keys = new String[]{string};
            this.values = new Object[]{object};
            return;
        }
        int n = 0;
        while (n < this.keys.length) {
            if (this.keys[n].equals(string)) {
                this.values[n] = object;
                return;
            }
            ++n;
        }
        String[] stringArray = new String[this.keys.length + 1];
        Object[] objectArray = new Object[this.values.length + 1];
        System.arraycopy(this.keys, 0, stringArray, 0, this.keys.length);
        System.arraycopy(this.values, 0, objectArray, 0, this.values.length);
        stringArray[this.keys.length] = string;
        objectArray[this.values.length] = object;
        this.keys = stringArray;
        this.values = objectArray;
    }

    public void setData(Object object) {
        this.checkDevice();
        this.data = object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSynchronizer(Synchronizer synchronizer) {
        this.checkDevice();
        if (synchronizer == null) {
            this.error(4);
        }
        if (synchronizer == this.synchronizer) {
            return;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            Synchronizer synchronizer2 = this.synchronizer;
            this.synchronizer = synchronizer;
            // ** MonitorExit[var3_2] (shouldn't be in output)
            if (synchronizer2 != null) {
                synchronizer2.runAsyncMessages(true);
            }
            return;
        }
    }

    void setToolTipText(int n, String string) {
        if (this.toolTipHandle == 0) {
            return;
        }
        int n2 = OS.XtParent(this.toolTipHandle);
        int n3 = OS.XtParent(n2);
        if (n != n3) {
            return;
        }
        this.showToolTip(n, string);
    }

    void showToolTip(int n, String string) {
        int n2;
        Object object;
        Object object2;
        int n3;
        int n4 = 0;
        if (string == null) {
            string = "";
        }
        char[] cArray = new char[string.length()];
        string.getChars(0, cArray.length, cArray, 0);
        Widget.fixMnemonic(cArray);
        byte[] byArray = Converter.wcsToMbcs(null, cArray, true);
        if (this.toolTipHandle != 0) {
            n4 = OS.XtParent(this.toolTipHandle);
            n3 = OS.XtParent(n4);
            if (n != n3) {
                return;
            }
            int n5 = OS.XmStringGenerate(byArray, null, 0, null);
            object2 = new int[]{OS.XmNlabelString, n5};
            OS.XtSetValues(this.toolTipHandle, object2, ((int[])object2).length / 2);
            if (n5 != 0) {
                OS.XmStringFree(n5);
            }
        } else {
            n3 = OS.overrideShellWidgetClass();
            int[] nArray = new int[6];
            nArray[0] = OS.XmNmwmDecorations;
            nArray[2] = OS.XmNborderWidth;
            nArray[3] = 1;
            nArray[4] = OS.XmNallowShellResize;
            nArray[5] = 1;
            int[] nArray2 = nArray;
            n4 = OS.XtCreatePopupShell(null, n3, n, nArray2, nArray2.length / 2);
            object2 = this.getSystemColor(28);
            object = this.getSystemColor(29);
            int n6 = object2.handle.pixel;
            n2 = ((Color)object).handle.pixel;
            int[] nArray3 = new int[6];
            nArray3[0] = OS.XmNforeground;
            nArray3[1] = n6;
            nArray3[2] = OS.XmNbackground;
            nArray3[3] = n2;
            nArray3[4] = OS.XmNalignment;
            int[] nArray4 = nArray3;
            this.toolTipHandle = OS.XmCreateLabel(n4, byArray, nArray4, nArray4.length / 2);
            OS.XtManageChild(this.toolTipHandle);
        }
        if (string == null || string.length() == 0) {
            OS.XtPopdown(n4);
        } else {
            n3 = OS.XDefaultRootWindow(this.xDisplay);
            int[] nArray = new int[1];
            object2 = new int[1];
            object = new int[1];
            int[] nArray5 = new int[1];
            OS.XQueryPointer(this.xDisplay, n3, (int[])object, (int[])object, nArray, object2, (int[])object, (int[])object, nArray5);
            n2 = nArray[0] + 16;
            int n7 = object2[0] + 16;
            int n8 = OS.XDefaultScreen(this.xDisplay);
            int n9 = OS.XDisplayWidth(this.xDisplay, n8);
            int n10 = OS.XDisplayHeight(this.xDisplay, n8);
            int[] nArray6 = new int[4];
            nArray6[0] = OS.XmNwidth;
            nArray6[2] = OS.XmNheight;
            int[] nArray7 = nArray6;
            OS.XtGetValues(this.toolTipHandle, nArray7, nArray7.length / 2);
            n2 = Math.max(0, Math.min(n2, n9 - nArray7[1]));
            n7 = Math.max(0, Math.min(n7, n10 - nArray7[3]));
            OS.XtMoveWidget(n4, n2, n7);
            int n11 = 1792;
            if ((nArray5[0] & n11) == 0) {
                OS.XtPopup(n4, 0);
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean sleep() {
        this.checkDevice();
        if (this.getMessageCount() != 0) {
            return true;
        }
        var3_1 = true;
        var4_2 = OS.ConnectionNumber(this.xDisplay);
        var5_3 = OS.XtDisplayToApplicationContext(this.xDisplay);
        var6_4 = var4_2 > this.read_fd ? var4_2 : this.read_fd;
        block3: while (true) {
            OS.FD_ZERO(this.fd_set);
            OS.FD_SET(var4_2, this.fd_set);
            OS.FD_SET(this.read_fd, this.fd_set);
            this.timeout[0] = 0;
            this.timeout[1] = 50000;
            var7_7 = OS.lock;
            var8_8 = var7_7.lock();
            var9_10 = 0;
            while (true) {
                if (var9_10 >= var8_8) {
                    ** try [egrp 0[TRYBLOCK] [0 : 129->150)] { 
lbl20:
                    // 1 sources

                    break;
                }
                var7_7.unlock();
                ++var9_10;
            }
            {
                var1_5 = OS.select(var6_4 + 1, this.fd_set, null, null, this.timeout);
                ** GOTO lbl-1000
            }
lbl26:
            // 1 sources

            catch (Throwable var10_13) {
                var9_11 = null;
                var11_12 = 0;
            }
            while (true) {
                if (var11_12 >= var8_8) {
                    var7_7.unlock();
                    throw var10_13;
                }
                var7_7.lock();
                ++var11_12;
            }
lbl-1000:
            // 1 sources

            {
                var9_9 = null;
                var11_12 = 0;
            }
            while (true) {
                if (var11_12 >= var8_8) {
                    var7_7.unlock();
                    var2_6 = OS.XtAppPending(var5_3);
                    if (var3_1 && var2_6 == 0) {
                        var3_1 = false;
                        OS.XtAppAddTimeOut(var5_3, 1, 0, 0);
                        OS.XtAppProcessEvent(var5_3, 2);
                    }
                    if (var1_5 == 0 && this.getMessageCount() == 0 && var2_6 == 0) continue block3;
                    return OS.FD_ISSET(var4_2, this.fd_set);
                }
                var7_7.lock();
                ++var11_12;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncExec(Runnable runnable) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (this.isDisposed()) {
                this.error(45);
            }
            Synchronizer synchronizer = this.synchronizer;
            // ** MonitorExit[var3_2] (shouldn't be in output)
            synchronizer.syncExec(runnable);
            return;
        }
    }

    int textWidth(String string, Font font) {
        if (string.length() == 0) {
            return 0;
        }
        int n = font.handle;
        String string2 = font.codePage;
        byte[] byArray = Converter.wcsToMbcs(string2, string, true);
        int n2 = OS.XmStringGenerate(byArray, null, 0, null);
        int n3 = OS.XmStringWidth(n, n2);
        OS.XmStringFree(n2);
        return n3;
    }

    public void timerExec(int n, Runnable runnable) {
        int n2;
        int n3;
        this.checkDevice();
        if (runnable == null) {
            this.error(4);
        }
        if (this.timerList == null) {
            this.timerList = new Runnable[4];
        }
        if (this.timerIds == null) {
            this.timerIds = new int[4];
        }
        int n4 = 0;
        while (n4 < this.timerList.length) {
            if (this.timerList[n4] == runnable) break;
            ++n4;
        }
        if (n4 != this.timerList.length) {
            OS.XtRemoveTimeOut(this.timerIds[n4]);
            this.timerList[n4] = null;
            this.timerIds[n4] = 0;
            if (n < 0) {
                return;
            }
        } else {
            if (n < 0) {
                return;
            }
            n4 = 0;
            while (n4 < this.timerList.length) {
                if (this.timerList[n4] == null) break;
                ++n4;
            }
            if (n4 == this.timerList.length) {
                Runnable[] runnableArray = new Runnable[this.timerList.length + 4];
                System.arraycopy(this.timerList, 0, runnableArray, 0, this.timerList.length);
                this.timerList = runnableArray;
                int[] nArray = new int[this.timerIds.length + 4];
                System.arraycopy(this.timerIds, 0, nArray, 0, this.timerIds.length);
                this.timerIds = nArray;
            }
        }
        if ((n3 = OS.XtAppAddTimeOut(n2 = OS.XtDisplayToApplicationContext(this.xDisplay), n, this.timerProc, n4)) != 0) {
            this.timerIds[n4] = n3;
            this.timerList[n4] = runnable;
        }
    }

    int timerProc(int n, int n2) {
        if (this.timerList == null) {
            return 0;
        }
        if (n >= 0 && n < this.timerList.length) {
            Runnable runnable = this.timerList[n];
            this.timerList[n] = null;
            this.timerIds[n] = 0;
            if (runnable != null) {
                runnable.run();
            }
        }
        return 0;
    }

    static int translateKey(int n) {
        int n2 = 0;
        while (n2 < KeyTable.length) {
            if (KeyTable[n2][0] == n) {
                return KeyTable[n2][1];
            }
            ++n2;
        }
        return 0;
    }

    static int untranslateKey(int n) {
        int n2 = 0;
        while (n2 < KeyTable.length) {
            if (KeyTable[n2][1] == n) {
                return KeyTable[n2][0];
            }
            ++n2;
        }
        return 0;
    }

    public void update() {
        this.checkDevice();
        int n = OS.XtMalloc(96);
        int n2 = 1998848;
        OS.XSync(this.xDisplay, false);
        OS.XSync(this.xDisplay, false);
        while (OS.XCheckMaskEvent(this.xDisplay, n2, n)) {
            OS.XtDispatchEvent(n);
        }
        OS.XtFree(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wake() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (this.isDisposed()) {
                this.error(45);
            }
            if (this.thread == Thread.currentThread()) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.wakeThread();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    void wakeThread() {
        while (OS.write(this.write_fd, this.wake_buffer, 1) != 1) {
        }
    }

    int wakeProc(int n, int n2, int n3) {
        while (OS.read(this.read_fd, this.wake_buffer, 1) != 1) {
        }
        return 0;
    }

    static int wcsToMbcs(char c) {
        return Display.wcsToMbcs(c, null);
    }

    static int wcsToMbcs(char c, String string) {
        int n = c & 0xFFFF;
        if (n <= 127) {
            return c;
        }
        byte[] byArray = Converter.wcsToMbcs(string, new char[]{c}, false);
        if (byArray.length == 1) {
            return (char)byArray[0];
        }
        if (byArray.length == 2) {
            return (char)((byArray[0] & 0xFF) << 8 | byArray[1] & 0xFF);
        }
        return 0;
    }

    int windowTimerProc(int n, int n2) {
        Widget widget = this.getWidget(n);
        if (widget == null) {
            return 0;
        }
        return widget.timerProc(n2);
    }

    int windowProc(int n, int n2, int n3, int n4) {
        Widget widget = this.getWidget(n);
        if (widget == null) {
            return 0;
        }
        return widget.windowProc(n, n2, n3, n4);
    }

    String wrapText(String string, Font font, int n) {
        String string2 = "\n";
        string = this.convertToLf(string);
        int n2 = string.length();
        if (n <= 0 || n2 == 0 || n2 == 1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        int n4 = 0;
        while (n3 < n2) {
            boolean bl;
            n4 = string.indexOf(string2, n3);
            boolean bl2 = bl = n4 == -1;
            if (bl) {
                n4 = n2;
            }
            int n5 = n4 + string2.length();
            while (n4 > n3 + 1 && Compatibility.isWhitespace(string.charAt(n4 - 1))) {
                --n4;
            }
            int n6 = n3;
            int n7 = n3;
            int n8 = n3;
            while (n8 < n4) {
                int n9 = n6;
                int n10 = n7;
                n6 = n8;
                while (n8 < n4 && !Compatibility.isWhitespace(string.charAt(n8))) {
                    ++n8;
                }
                n7 = n8 - 1;
                String string3 = string.substring(n3, n7 + 1);
                int n11 = this.textWidth(string3, font);
                while (n8 < n4 && Compatibility.isWhitespace(string.charAt(n8))) {
                    ++n8;
                }
                if (n11 <= n) continue;
                if (n9 == n6) {
                    while (n6 < n7) {
                        string3 = string.substring(n3, n6 + 1);
                        n11 = this.textWidth(string3, font);
                        if (n11 >= n) break;
                        ++n6;
                    }
                    if (n6 == n9) {
                        ++n6;
                    }
                    n10 = n6 - 1;
                }
                string3 = string.substring(n3, n10 + 1);
                stringBuffer.append(string3);
                stringBuffer.append(string2);
                n8 = n6;
                n3 = n6;
                n7 = n6;
            }
            if (n3 < n4) {
                stringBuffer.append(string.substring(n3, n4));
            }
            if (!bl) {
                stringBuffer.append(string2);
            }
            n3 = n5;
        }
        return stringBuffer.toString();
    }
}

