/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.internal.motif.XClientMessageEvent;
import org.eclipse.swt.internal.motif.XConfigureEvent;
import org.eclipse.swt.internal.motif.XFocusChangeEvent;
import org.eclipse.swt.internal.motif.XSizeHints;
import org.eclipse.swt.internal.motif.XWindowAttributes;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.TypedListener;

public class Shell
extends Decorations {
    int shellHandle;
    int focusProxy;
    boolean reparented;
    boolean realized;
    boolean moved;
    boolean resized;
    boolean opened;
    boolean modified;
    boolean center;
    int oldX;
    int oldY;
    int oldWidth;
    int oldHeight;
    Control lastActive;
    static final int MAXIMUM_TRIM = 128;
    static final byte[] WM_DELETE_WINDOW = Converter.wcsToMbcs(null, "WM_DELETE_WINDOW\u0000");
    static final byte[] _NET_WM_STATE = Converter.wcsToMbcs(null, "_NET_WM_STATE\u0000");
    static final byte[] _NET_WM_STATE_MAXIMIZED_VERT = Converter.wcsToMbcs(null, "_NET_WM_STATE_MAXIMIZED_VERT\u0000");
    static final byte[] _NET_WM_STATE_MAXIMIZED_HORZ = Converter.wcsToMbcs(null, "_NET_WM_STATE_MAXIMIZED_HORZ\u0000");
    static final byte[] _NET_WM_STATE_FULLSCREEN = Converter.wcsToMbcs(null, "_NET_WM_STATE_FULLSCREEN\u0000");

    public Shell() {
        this((Display)null);
    }

    public Shell(int n) {
        this((Display)null, n);
    }

    public Shell(Display display) {
        this(display, 1264);
    }

    public Shell(Display display, int n) {
        this(display, null, n, 0, false);
    }

    Shell(Display display, Shell shell, int n, int n2, boolean bl) {
        this.checkSubclass();
        if (display == null) {
            display = Display.getCurrent();
        }
        if (display == null) {
            display = Display.getDefault();
        }
        if (!display.isValidThread()) {
            this.error(22);
        }
        if (shell != null && shell.isDisposed()) {
            this.error(5);
        }
        this.center = shell != null && (n & 0x10000000) != 0;
        this.style = Shell.checkStyle(shell, n);
        this.parent = shell;
        this.display = display;
        if (n2 != 0) {
            if (bl) {
                this.handle = n2;
            } else {
                this.shellHandle = n2;
                this.state |= 0x2000;
            }
        }
        this.createWidget(0);
    }

    public Shell(Shell shell) {
        this(shell, 2144);
    }

    public Shell(Shell shell, int n) {
        this(shell != null ? shell.display : null, shell, n, 0, false);
    }

    static int checkStyle(Shell shell, int n) {
        n = Decorations.checkStyle(n);
        if (((n &= 0xBFFFFFFF) & 0x4000) != 0) {
            n &= 0xFFFFFB0F;
        }
        int n2 = 229376;
        if ((n & 0x10000000) != 0) {
            n &= 0xEFFFFFFF;
            if (((n |= shell == null ? 1264 : 2144) & n2) == 0) {
                n |= shell == null ? 65536 : 32768;
            }
        }
        int n3 = n & ~n2;
        if ((n & 0x20000) != 0) {
            return n3 | 0x20000;
        }
        if ((n & 0x10000) != 0) {
            return n3 | 0x10000;
        }
        if ((n & 0x8000) != 0) {
            return n3 | 0x8000;
        }
        return n3;
    }

    public static Shell motif_new(Display display, int n) {
        return new Shell(display, null, 8, n, true);
    }

    public static Shell internal_new(Display display, int n) {
        return new Shell(display, null, 8, n, false);
    }

    public void addShellListener(ShellListener shellListener) {
        this.checkWidget();
        if (shellListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(shellListener);
        this.addListener(26, typedListener);
        this.addListener(21, typedListener);
        this.addListener(27, typedListener);
        this.addListener(19, typedListener);
        this.addListener(20, typedListener);
    }

    /*
     * Unable to fully structure code
     */
    void adjustTrim() {
        if (this.display.ignoreTrim) {
            return;
        }
        if (OS.XtIsSubclass(this.shellHandle, OS.overrideShellWidgetClass())) {
            return;
        }
        v0 = new int[2];
        v0[0] = OS.XmNoverrideRedirect;
        var1_1 = v0;
        OS.XtGetValues(this.shellHandle, var1_1, var1_1.length / 2);
        if (var1_1[1] != 0) {
            return;
        }
        var2_2 = OS.XtWindow(this.shellHandle);
        if (var2_2 == 0) {
            return;
        }
        var3_3 = OS.XtDisplay(this.shellHandle);
        if (var3_3 == 0) {
            return;
        }
        var4_4 = new int[1];
        var5_5 = new int[1];
        var6_6 = new int[1];
        var7_7 = new int[1];
        var8_8 = var2_2;
        OS.XQueryTree(var3_3, var8_8, var5_5, var6_6, var7_7, var4_4);
        if (var7_7[0] != 0) {
            OS.XFree(var7_7[0]);
        }
        if (var6_6[0] != 0) ** GOTO lbl37
        return;
lbl-1000:
        // 1 sources

        {
            var8_8 = var6_6[0];
            OS.XQueryTree(var3_3, var8_8, var4_4, var6_6, var7_7, var4_4);
            if (var7_7[0] != 0) {
                OS.XFree(var7_7[0]);
            }
            if (var6_6[0] != 0) continue;
            return;
lbl37:
            // 2 sources

            ** while (var6_6[0] != var5_5[0])
        }
lbl38:
        // 1 sources

        if (var2_2 == var8_8) {
            return;
        }
        var9_9 = new int[1];
        var10_10 = new int[1];
        var11_11 = new int[1];
        var12_12 = new int[1];
        var13_13 = new int[1];
        OS.XGetGeometry(var3_3, var8_8, var4_4, var12_12, var13_13, var10_10, var11_11, var9_9, var4_4);
        var14_14 = new int[1];
        var15_15 = new int[1];
        var16_16 = new int[1];
        OS.XGetGeometry(var3_3, var2_2, var4_4, var4_4, var4_4, var15_15, var16_16, var14_14, var4_4);
        var17_17 = new short[1];
        var18_18 = new short[1];
        OS.XtTranslateCoords(this.shellHandle, (short)0, (short)0, var17_17, var18_18);
        var19_19 = var10_10[0] + var9_9[0] * 2 - (var15_15[0] + var14_14[0] * 2);
        var20_20 = var11_11[0] + var9_9[0] * 2 - (var16_16[0] + var14_14[0] * 2);
        var21_21 = var17_17[0] - var12_12[0];
        var22_22 = var18_18[0] - var13_13[0];
        if (var19_19 > 128 || var20_20 > 128) {
            this.display.ignoreTrim = true;
            return;
        }
        var23_23 = false;
        var24_24 = false;
        var25_25 = false;
        if ((this.style & 8) == 0) {
            var23_23 = (this.style & 1248) != 0;
            var24_24 = (this.style & 16) != 0;
            v1 = var25_25 = (this.style & 2048) != 0;
        }
        if (var23_23) {
            if (var24_24) {
                this.display.leftTitleResizeWidth = var21_21;
                this.display.rightTitleResizeWidth = var19_19 - var21_21;
                this.display.topTitleResizeHeight = var22_22;
                this.display.bottomTitleResizeHeight = var20_20 - var22_22;
                return;
            }
            if (var25_25) {
                this.display.leftTitleBorderWidth = var21_21;
                this.display.rightTitleBorderWidth = var19_19 - var21_21;
                this.display.topTitleBorderHeight = var22_22;
                this.display.bottomTitleBorderHeight = var20_20 - var22_22;
                return;
            }
            this.display.leftTitleWidth = var21_21;
            this.display.rightTitleWidth = var19_19 - var21_21;
            this.display.topTitleHeight = var22_22;
            this.display.bottomTitleHeight = var20_20 - var22_22;
            return;
        }
        if (var24_24) {
            this.display.leftResizeWidth = var21_21;
            this.display.rightResizeWidth = var19_19 - var21_21;
            this.display.topResizeHeight = var22_22;
            this.display.bottomResizeHeight = var20_20 - var22_22;
            return;
        }
        if (var25_25) {
            this.display.leftBorderWidth = var21_21;
            this.display.rightBorderWidth = var19_19 - var21_21;
            this.display.topBorderHeight = var22_22;
            this.display.bottomBorderHeight = var20_20 - var22_22;
            return;
        }
    }

    int borderHandle() {
        return this.handle;
    }

    void bringToTop(boolean bl) {
        int n;
        if (this.minimized) {
            return;
        }
        if (!this.isVisible()) {
            return;
        }
        int n2 = OS.XtDisplay(this.shellHandle);
        if (n2 == 0) {
            return;
        }
        int n3 = OS.XtWindow(this.focusProxy != 0 ? this.focusProxy : this.shellHandle);
        if (n3 == 0) {
            return;
        }
        if (!bl) {
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            OS.XGetInputFocus(n2, nArray, nArray2);
            if (nArray[0] == 0) {
                return;
            }
            int n4 = OS.XtWindowToWidget(n2, nArray[0]);
            if (n4 == 0) {
                return;
            }
        }
        if ((n = OS.XtWindow(this.shellHandle)) != 0) {
            OS.XRaiseWindow(n2, n);
        }
        OS.XSetInputFocus(n2, n3, 2, 0);
    }

    void center() {
        if (this.parent == null) {
            return;
        }
        Rectangle rectangle = this.getBounds();
        Rectangle rectangle2 = this.display.map((Control)this.parent, null, this.parent.getClientArea());
        int n = Math.max(rectangle2.x, rectangle2.x + (rectangle2.width - rectangle.width) / 2);
        int n2 = Math.max(rectangle2.y, rectangle2.y + (rectangle2.height - rectangle.height) / 2);
        Rectangle rectangle3 = this.parent.getMonitor().getClientArea();
        n = n + rectangle.width > rectangle3.x + rectangle3.width ? Math.max(rectangle3.x, rectangle3.x + rectangle3.width - rectangle.width) : Math.max(n, rectangle3.x);
        n2 = n2 + rectangle.height > rectangle3.y + rectangle3.height ? Math.max(rectangle3.y, rectangle3.y + rectangle3.height - rectangle.height) : Math.max(n2, rectangle3.y);
        this.setLocation(n, n2);
    }

    void checkOpen() {
        if (!this.opened) {
            this.resized = false;
        }
    }

    public void close() {
        this.checkWidget();
        this.closeWidget();
    }

    void closeWidget() {
        Event event = new Event();
        this.sendEvent(21, event);
        if (event.doit && !this.isDisposed()) {
            this.dispose();
        }
    }

    public Rectangle computeTrim(int n, int n2, int n3, int n4) {
        this.checkWidget();
        Rectangle rectangle = super.computeTrim(n, n2, n3, n4);
        int n5 = 0;
        if ((this.style & 0xCF8) == 0) {
            int[] nArray = new int[2];
            nArray[0] = OS.XmNborderWidth;
            int[] nArray2 = nArray;
            OS.XtGetValues(this.handle, nArray2, nArray2.length / 2);
            n5 = nArray2[1];
        }
        rectangle.x -= this.trimLeft() + n5;
        rectangle.y -= this.trimTop() + n5;
        rectangle.width += this.trimWidth() + n5 * 2;
        rectangle.height += this.trimHeight() + this.imeHeight() + n5 * 2;
        return rectangle;
    }

    void createFocusProxy() {
        if (this.focusProxy != 0) {
            return;
        }
        int[] nArray = new int[]{OS.XmNx, -1, OS.XmNy, -1, OS.XmNwidth, 1, OS.XmNheight, 1};
        this.focusProxy = OS.XmCreateDrawingArea(this.scrolledHandle, null, nArray, nArray.length / 2);
        if (this.focusProxy == 0) {
            this.error(2);
        }
        OS.XtSetMappedWhenManaged(this.focusProxy, false);
        OS.XtManageChild(this.focusProxy);
        OS.XtSetMappedWhenManaged(this.focusProxy, true);
    }

    void createHandle(int n) {
        this.state |= 2;
        if (this.shellHandle == 0) {
            int n2;
            int n3;
            int n4 = 0;
            if ((this.style & 8) == 0) {
                if ((this.style & 0x80) != 0) {
                    n4 |= 0x20;
                }
                if ((this.style & 0x400) != 0) {
                    n4 |= 0x40;
                }
                if ((this.style & 0x10) != 0) {
                    n4 |= 4;
                }
                if ((this.style & 0x800) != 0) {
                    n4 |= 2;
                }
                if ((this.style & 0x40) != 0) {
                    n4 |= 0x10;
                }
                if ((this.style & 0x20) != 0) {
                    n4 |= 8;
                }
                if ((this.style & 0x10) != 0) {
                    n4 |= 2;
                }
            }
            int n5 = 0;
            if ((this.style & 0x8000) != 0) {
                n5 = 1;
            }
            if ((this.style & 0x10000) != 0) {
                n5 = 3;
            }
            if ((this.style & 0x20000) != 0) {
                n5 = 2;
            }
            byte[] byArray = new byte[4];
            byArray[0] = 32;
            byte[] byArray2 = byArray;
            int n6 = OS.XtMalloc(byArray2.length);
            OS.memmove(n6, byArray2, byArray2.length);
            int[] nArray = new int[]{OS.XmNmwmInputMode, n5, OS.XmNmwmDecorations, n4, OS.XmNoverrideRedirect, (this.style & 0x4000) != 0 ? 1 : 0, OS.XmNtitle, n6};
            if (this.isUndecorated()) {
                this.reparented = true;
            }
            byte[] byArray3 = this.display.appClass;
            if (this.parent == null && (this.style & 0x4000) == 0 && n5 != 3) {
                n3 = this.display.xDisplay;
                n2 = OS.applicationShellWidgetClass();
                this.shellHandle = OS.XtAppCreateShell(this.display.appName, byArray3, n2, n3, nArray, nArray.length / 2);
            } else {
                n3 = OS.transientShellWidgetClass();
                n2 = this.display.shellHandle;
                if (this.parent != null) {
                    n2 = this.parent.handle;
                }
                this.shellHandle = OS.XtCreatePopupShell(byArray3, n3, n2, nArray, nArray.length / 2);
            }
            OS.XtFree(n6);
            if (this.shellHandle == 0) {
                this.error(2);
            }
            if (this.handle != 0) {
                OS.XtSetMappedWhenManaged(this.shellHandle, false);
                OS.XtRealizeWidget(this.shellHandle);
                OS.XtSetMappedWhenManaged(this.shellHandle, true);
                n3 = this.display.xDisplay;
                n2 = OS.XtWindow(this.shellHandle);
                if (n2 == 0) {
                    this.error(2);
                }
                OS.XReparentWindow(n3, n2, this.handle, 0, 0);
                this.handle = 0;
            }
            this.createHandle(n, this.shellHandle, true);
        } else {
            int[] nArray = new int[1];
            int[] nArray2 = new int[4];
            nArray2[0] = OS.XmNchildren;
            nArray2[2] = OS.XmNnumChildren;
            int[] nArray3 = nArray2;
            OS.XtGetValues(this.shellHandle, nArray3, nArray3.length / 2);
            if (nArray3[3] < 1) {
                this.error(2);
            }
            OS.memmove(nArray, nArray3[1], 4);
            this.scrolledHandle = nArray[0];
            if (this.scrolledHandle == 0) {
                this.error(2);
            }
            nArray3[3] = 0;
            nArray3[1] = 0;
            OS.XtGetValues(this.scrolledHandle, nArray3, nArray3.length / 2);
            if (nArray3[3] < 4) {
                this.error(2);
            }
            OS.memmove(nArray, nArray3[1] + (nArray3[3] - 1) * 4, 4);
            this.handle = nArray[0];
            if (this.handle == 0) {
                this.error(2);
            }
        }
        if ((this.style & 0xCF8) == 0) {
            int[] nArray = new int[]{OS.XmNborderWidth, 1};
            OS.XtSetValues(this.handle, nArray, nArray.length / 2);
        }
        if ((this.style & 0x4000) == 0) {
            int[] nArray = new int[2];
            nArray[0] = OS.XmNtraversalOn;
            int[] nArray4 = nArray;
            int n7 = OS.XmCreateTextField(this.handle, null, nArray4, nArray4.length / 2);
            if (n7 == 0) {
                this.error(2);
            }
        }
    }

    void deregister() {
        super.deregister();
        this.display.removeWidget(this.shellHandle);
    }

    void destroyWidget() {
        if (OS.XtIsRealized(this.shellHandle)) {
            if (OS.XtIsTopLevelShell(this.shellHandle)) {
                OS.XtUnmapWidget(this.shellHandle);
            } else {
                OS.XtPopdown(this.shellHandle);
            }
        }
        super.destroyWidget();
    }

    public void dispose() {
        Shell shell;
        if (this.isDisposed()) {
            return;
        }
        if (this.parent != null && (shell = this.display.getActiveShell()) == this) {
            Shell shell2 = this.parent.getShell();
            shell2.bringToTop(false);
        }
        super.dispose();
    }

    void enableWidget(boolean bl) {
        super.enableWidget(bl);
        this.enableHandle(bl, this.shellHandle);
    }

    Control findBackgroundControl() {
        return (this.state & 0x10) != 0 || this.backgroundImage != null ? this : null;
    }

    Composite findDeferredControl() {
        return this.layoutCount > 0 ? this : null;
    }

    public void forceActive() {
        this.checkWidget();
        this.bringToTop(true);
    }

    public int getAlpha() {
        this.checkWidget();
        return 255;
    }

    public int getBorderWidth() {
        this.checkWidget();
        int[] nArray = new int[2];
        nArray[0] = OS.XmNborderWidth;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.scrolledHandle, nArray2, nArray2.length / 2);
        return nArray2[1];
    }

    public Rectangle getBounds() {
        this.checkWidget();
        Rectangle rectangle = new Rectangle(0, 0, 0, 0);
        this.getBounds(null, null, rectangle);
        return rectangle;
    }

    void getBounds(Point point, Point point2, Rectangle rectangle) {
        int[] nArray;
        int n;
        int n2;
        int n3 = 0;
        int n4 = 0;
        if (point != null || rectangle != null) {
            if (OS.XtIsRealized(this.shellHandle)) {
                n2 = OS.XtDisplay(this.shellHandle);
                n = OS.XtWindow(this.shellHandle);
                nArray = new int[1];
                int[] nArray2 = new int[1];
                int[] nArray3 = new int[1];
                OS.XSync(n2, false);
                OS.XTranslateCoordinates(n2, n, OS.XDefaultRootWindow(n2), 0, 0, nArray, nArray2, nArray3);
                n3 = nArray[0];
                n4 = nArray2[0];
            } else {
                short[] sArray = new short[1];
                short[] sArray2 = new short[1];
                OS.XtTranslateCoords(this.shellHandle, (short)0, (short)0, sArray, sArray2);
                n3 = sArray[0];
                n4 = sArray2[0];
            }
            if (this.reparented) {
                n3 -= this.trimLeft();
                n4 -= this.trimTop();
            }
        }
        n2 = 0;
        n = 0;
        if (point2 != null || rectangle != null) {
            int[] nArray4 = new int[6];
            nArray4[0] = OS.XmNwidth;
            nArray4[2] = OS.XmNheight;
            nArray4[4] = OS.XmNborderWidth;
            nArray = nArray4;
            OS.XtGetValues(this.shellHandle, nArray, nArray.length / 2);
            int n5 = nArray[5];
            int n6 = this.trimWidth();
            int n7 = this.trimHeight();
            n2 = nArray[1] + n6 + n5 * 2;
            n = nArray[3] + n7 + n5 * 2;
        }
        if (point != null) {
            point.x = n3;
            point.y = n4;
        }
        if (point2 != null) {
            point2.x = n2;
            point2.y = n;
        }
        if (rectangle != null) {
            rectangle.x = n3;
            rectangle.y = n4;
            rectangle.width = n2;
            rectangle.height = n;
        }
    }

    public boolean getFullScreen() {
        int n;
        this.checkWidget();
        int n2 = OS.XtDisplay(this.shellHandle);
        int n3 = OS.XtWindow(this.shellHandle);
        if (n3 != 0 && (n = OS.XInternAtom(n2, _NET_WM_STATE, true)) != 0) {
            int n4;
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            int[] nArray3 = new int[1];
            int[] nArray4 = new int[1];
            int[] nArray5 = new int[1];
            OS.XGetWindowProperty(n2, n3, n, 0, Integer.MAX_VALUE, false, 4, nArray, nArray2, nArray3, nArray4, nArray5);
            boolean bl = false;
            if (nArray[0] != 0 && (n4 = OS.XInternAtom(n2, _NET_WM_STATE_FULLSCREEN, true)) != 0) {
                int[] nArray6 = new int[1];
                int n5 = 0;
                while (n5 < nArray3[0]) {
                    OS.memmove(nArray6, nArray5[0] + n5 * 4, 4);
                    if (nArray6[0] == n4) {
                        bl = true;
                        break;
                    }
                    ++n5;
                }
            }
            if (nArray5[0] != 0) {
                OS.XFree(nArray5[0]);
            }
            return bl;
        }
        return false;
    }

    public int getImeInputMode() {
        this.checkWidget();
        return 0;
    }

    public Point getLocation() {
        this.checkWidget();
        Point point = new Point(0, 0);
        this.getBounds(point, null, null);
        return point;
    }

    public boolean getMaximized() {
        int n;
        this.checkWidget();
        int n2 = OS.XtDisplay(this.shellHandle);
        int n3 = OS.XtWindow(this.shellHandle);
        if (n3 != 0 && (n = OS.XInternAtom(n2, _NET_WM_STATE, true)) != 0) {
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            int[] nArray3 = new int[1];
            int[] nArray4 = new int[1];
            int[] nArray5 = new int[1];
            OS.XGetWindowProperty(n2, n3, n, 0, Integer.MAX_VALUE, false, 4, nArray, nArray2, nArray3, nArray4, nArray5);
            boolean bl = false;
            if (nArray[0] != 0) {
                int n4 = OS.XInternAtom(n2, _NET_WM_STATE_MAXIMIZED_HORZ, true);
                int n5 = OS.XInternAtom(n2, _NET_WM_STATE_MAXIMIZED_VERT, true);
                if (n4 != 0 && n5 != 0) {
                    int[] nArray6 = new int[1];
                    int n6 = 0;
                    while (n6 < nArray3[0]) {
                        OS.memmove(nArray6, nArray5[0] + n6 * 4, 4);
                        if (nArray6[0] == n4 || nArray6[0] == n5) {
                            bl = true;
                            break;
                        }
                        ++n6;
                    }
                }
            }
            if (nArray5[0] != 0) {
                OS.XFree(nArray5[0]);
            }
            return bl;
        }
        return super.getMaximized();
    }

    public Point getMinimumSize() {
        this.checkWidget();
        int[] nArray = new int[4];
        nArray[0] = OS.XmNminWidth;
        nArray[2] = OS.XmNminHeight;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.shellHandle, nArray2, nArray2.length / 2);
        int n = Math.max(1, Math.max(0, nArray2[1]) + this.trimWidth());
        int n2 = Math.max(1, Math.max(0, nArray2[3]) + this.trimHeight());
        return new Point(n, n2);
    }

    public boolean getModified() {
        this.checkWidget();
        return this.modified;
    }

    public Region getRegion() {
        this.checkWidget();
        return this.region;
    }

    public Shell getShell() {
        this.checkWidget();
        return this;
    }

    public Shell[] getShells() {
        Shell[] shellArray;
        this.checkWidget();
        int n = 0;
        Shell[] shellArray2 = this.display.getShells();
        int n2 = 0;
        while (n2 < shellArray2.length) {
            shellArray = shellArray2[n2];
            while ((shellArray = shellArray.parent) != null && shellArray != this) {
            }
            if (shellArray == this) {
                ++n;
            }
            ++n2;
        }
        n2 = 0;
        shellArray = new Shell[n];
        int n3 = 0;
        while (n3 < shellArray2.length) {
            Composite composite = shellArray2[n3];
            while ((composite = composite.parent) != null && composite != this) {
            }
            if (composite == this) {
                shellArray[n2++] = shellArray2[n3];
            }
            ++n3;
        }
        return shellArray;
    }

    public Point getSize() {
        this.checkWidget();
        Point point = new Point(0, 0);
        this.getBounds(null, point, null);
        return point;
    }

    public boolean getVisible() {
        this.checkWidget();
        if (!OS.XtIsRealized(this.handle)) {
            return false;
        }
        int n = OS.XtDisplay(this.handle);
        if (n == 0) {
            return false;
        }
        int n2 = OS.XtWindow(this.handle);
        if (n2 == 0) {
            return false;
        }
        XWindowAttributes xWindowAttributes = new XWindowAttributes();
        OS.XGetWindowAttributes(n, n2, xWindowAttributes);
        if (xWindowAttributes.map_state == 2 && this.reparented) {
            return true;
        }
        int[] nArray = new int[2];
        nArray[0] = OS.XmNmappedWhenManaged;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.shellHandle, nArray2, nArray2.length / 2);
        return this.minimized && xWindowAttributes.map_state == 1 && nArray2[1] != 0;
    }

    boolean hasBorder() {
        return false;
    }

    void hookEvents() {
        super.hookEvents();
        int n = this.display.windowProc;
        OS.XtInsertEventHandler(this.shellHandle, 131072, false, n, 27, 1);
        if (OS.XtIsSubclass(this.shellHandle, OS.overrideShellWidgetClass())) {
            return;
        }
        OS.XtInsertEventHandler(this.shellHandle, 0x200000, false, n, 5, 1);
        int[] nArray = new int[]{OS.XmNdeleteResponse, 2};
        OS.XtSetValues(this.shellHandle, nArray, nArray.length / 2);
        int n2 = OS.XtDisplay(this.shellHandle);
        if (n2 != 0) {
            int n3 = OS.XmInternAtom(n2, WM_DELETE_WINDOW, false);
            OS.XmAddWMProtocolCallback(this.shellHandle, n3, n, 30);
        }
    }

    int imeHeight() {
        if (!OS.IsDBLocale) {
            return 0;
        }
        int[] nArray = new int[2];
        nArray[0] = OS.XmNheight;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.shellHandle, nArray2, nArray2.length / 2);
        int[] nArray3 = new int[2];
        nArray3[0] = OS.XmNheight;
        int[] nArray4 = nArray3;
        OS.XtGetValues(this.scrolledHandle, nArray4, nArray4.length / 2);
        return nArray2[1] - nArray4[1];
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled();
    }

    boolean isModal() {
        this.checkWidget();
        int[] nArray = new int[2];
        nArray[0] = OS.XmNmwmInputMode;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.shellHandle, nArray2, nArray2.length / 2);
        return nArray2[1] != -1 && nArray2[1] != 0;
    }

    boolean isUndecorated() {
        return (this.style & 0xCF0) == 0 || (this.style & 0x4008) != 0;
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible();
    }

    void manageChildren() {
        if ((this.state & 0x2000) != 0) {
            return;
        }
        OS.XtSetMappedWhenManaged(this.shellHandle, false);
        super.manageChildren();
        int n = 0;
        int n2 = 0;
        if (OS.IsLinux) {
            Monitor monitor = this.getMonitor();
            Rectangle rectangle = monitor.getClientArea();
            n = rectangle.width * 5 / 8;
            n2 = rectangle.height * 5 / 8;
        } else {
            int n3 = OS.XtDisplay(this.shellHandle);
            if (n3 == 0) {
                return;
            }
            n = OS.XDisplayWidth(n3, OS.XDefaultScreen(n3)) * 5 / 8;
            n2 = OS.XDisplayHeight(n3, OS.XDefaultScreen(n3)) * 5 / 8;
        }
        OS.XtResizeWidget(this.shellHandle, n, n2, 0);
    }

    public void open() {
        this.checkWidget();
        this.bringToTop(false);
        this.setVisible(true);
        if (this.isDisposed()) {
            return;
        }
        if (!this.restoreFocus() && !this.traverseGroup(true)) {
            this.setFocus();
        }
    }

    public boolean print(GC gC) {
        this.checkWidget();
        if (gC == null) {
            this.error(4);
        }
        if (gC.isDisposed()) {
            this.error(5);
        }
        return false;
    }

    void propagateWidget(boolean bl) {
        super.propagateWidget(bl);
        int n = this.cursor != null && !bl ? this.cursor.handle : 0;
        this.propagateHandle(bl, this.shellHandle, n);
    }

    void realizeWidget() {
        if (this.realized) {
            return;
        }
        OS.XtRealizeWidget(this.shellHandle);
        this.realizeChildren();
        this.realized = true;
    }

    void register() {
        super.register();
        this.display.addWidget(this.shellHandle, this);
    }

    void releaseChildren(boolean bl) {
        Shell[] shellArray = this.getShells();
        int n = 0;
        while (n < shellArray.length) {
            Shell shell = shellArray[n];
            if (shell != null && !shell.isDisposed()) {
                shell.release(false);
            }
            ++n;
        }
        super.releaseChildren(bl);
    }

    void releaseHandle() {
        super.releaseHandle();
        this.shellHandle = 0;
    }

    void releaseParent() {
    }

    void releaseWidget() {
        super.releaseWidget();
        this.lastActive = null;
    }

    public void removeShellListener(ShellListener shellListener) {
        this.checkWidget();
        if (shellListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(26, shellListener);
        this.eventTable.unhook(21, shellListener);
        this.eventTable.unhook(27, shellListener);
        this.eventTable.unhook(19, shellListener);
        this.eventTable.unhook(20, shellListener);
    }

    public void setActive() {
        this.checkWidget();
        this.bringToTop(false);
    }

    void setActiveControl(Control control) {
        if (control != null && control.isDisposed()) {
            control = null;
        }
        if (this.lastActive != null && this.lastActive.isDisposed()) {
            this.lastActive = null;
        }
        if (this.lastActive == control) {
            return;
        }
        Control[] controlArray = control == null ? new Control[]{} : control.getPath();
        Control[] controlArray2 = this.lastActive == null ? new Control[]{} : this.lastActive.getPath();
        this.lastActive = control;
        int n = 0;
        int n2 = Math.min(controlArray.length, controlArray2.length);
        while (n < n2) {
            if (controlArray[n] != controlArray2[n]) break;
            ++n;
        }
        int n3 = controlArray2.length - 1;
        while (n3 >= n) {
            if (!controlArray2[n3].isDisposed()) {
                if (this.display.postFocusOut) {
                    controlArray2[n3].postEvent(27);
                } else {
                    controlArray2[n3].sendEvent(27);
                }
            }
            --n3;
        }
        n3 = controlArray.length - 1;
        while (n3 >= n) {
            if (!controlArray[n3].isDisposed()) {
                controlArray[n3].sendEvent(26);
            }
            --n3;
        }
    }

    public void setAlpha(int n) {
        this.checkWidget();
    }

    public void setImeInputMode(int n) {
        this.checkWidget();
    }

    boolean setBounds(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        Object object;
        if (this.getMaximized()) {
            boolean bl3;
            object = this.getBounds();
            boolean bl4 = !bl || ((Rectangle)object).x == n && ((Rectangle)object).y == n2;
            boolean bl5 = bl3 = !bl2 || ((Rectangle)object).width == n3 && ((Rectangle)object).height == n4;
            if (bl4 && bl3) {
                return false;
            }
        }
        if (bl2) {
            int[] nArray = new int[4];
            nArray[0] = OS.XmNminWidth;
            nArray[2] = OS.XmNminHeight;
            object = nArray;
            OS.XtGetValues(this.shellHandle, (int[])object, ((Object)object).length / 2);
            n3 = Math.max(1, Math.max((int)object[1], n3 - this.trimWidth()));
            n4 = Math.max(1, Math.max((int)object[3], n4 - this.trimHeight()));
            this.updateResizable(n3, n4);
        }
        if (bl && bl2) {
            OS.XtConfigureWidget(this.shellHandle, n, n2, n3, n4, 0);
        } else {
            if (bl) {
                OS.XtMoveWidget(this.shellHandle, n, n2);
            }
            if (bl2) {
                OS.XtResizeWidget(this.shellHandle, n3, n4, 0);
            }
        }
        if (this.redrawWindow != 0) {
            int n5 = OS.XtDisplay(this.handle);
            OS.XResizeWindow(n5, this.redrawWindow, n3, n4);
        }
        if (bl && (this.oldX != n || this.oldY != n2)) {
            this.moved = true;
            this.oldX = n + this.trimLeft();
            this.oldY = n2 + this.trimTop();
            this.sendEvent(10);
            if (this.isDisposed()) {
                return false;
            }
        }
        if (bl2 && (n3 != this.oldWidth || n4 != this.oldHeight)) {
            this.resized = true;
            this.oldWidth = n3;
            this.oldHeight = n4;
            this.sendEvent(11);
            if (this.isDisposed()) {
                return false;
            }
            if (this.layout != null) {
                this.markLayout(false, false);
                this.updateLayout(false);
            }
        }
        return bl || bl2;
    }

    public void setEnabled(boolean bl) {
        this.checkWidget();
        if (bl == this.getEnabled()) {
            return;
        }
        super.setEnabled(bl);
        if (bl && this == this.display.getActiveShell() && !this.restoreFocus()) {
            this.traverseGroup(false);
        }
    }

    public void setFullScreen(boolean bl) {
        this.checkWidget();
        if (!OS.XtIsRealized(this.handle)) {
            this.realizeWidget();
        }
        int n = OS.XtDisplay(this.shellHandle);
        int n2 = OS.XtWindow(this.shellHandle);
        if (n2 == 0) {
            return;
        }
        int n3 = OS.XInternAtom(n, _NET_WM_STATE, true);
        if (n3 == 0) {
            return;
        }
        int n4 = OS.XInternAtom(n, _NET_WM_STATE_FULLSCREEN, true);
        if (n4 == 0) {
            return;
        }
        XClientMessageEvent xClientMessageEvent = new XClientMessageEvent();
        xClientMessageEvent.type = 33;
        xClientMessageEvent.send_event = 1;
        xClientMessageEvent.display = n;
        xClientMessageEvent.window = n2;
        xClientMessageEvent.message_type = n3;
        xClientMessageEvent.format = 32;
        xClientMessageEvent.data[0] = bl ? 1 : 0;
        xClientMessageEvent.data[1] = n4;
        XWindowAttributes xWindowAttributes = new XWindowAttributes();
        OS.XGetWindowAttributes(n, n2, xWindowAttributes);
        int n5 = OS.XRootWindowOfScreen(xWindowAttributes.screen);
        int n6 = OS.XtMalloc(96);
        OS.memmove(n6, xClientMessageEvent, 48);
        OS.XSendEvent(n, n5, false, 0x180000, n6);
        OS.XSync(n, false);
        OS.XtFree(n6);
    }

    public void setMaximized(boolean bl) {
        this.checkWidget();
        super.setMaximized(bl);
        if (!OS.XtIsRealized(this.handle)) {
            this.realizeWidget();
        }
        int n = OS.XtDisplay(this.shellHandle);
        int n2 = OS.XtWindow(this.shellHandle);
        if (n2 == 0) {
            return;
        }
        int n3 = OS.XInternAtom(n, _NET_WM_STATE, true);
        if (n3 == 0) {
            return;
        }
        int n4 = OS.XInternAtom(n, _NET_WM_STATE_MAXIMIZED_HORZ, true);
        int n5 = OS.XInternAtom(n, _NET_WM_STATE_MAXIMIZED_VERT, true);
        if (n4 == 0 || n5 == 0) {
            return;
        }
        XClientMessageEvent xClientMessageEvent = new XClientMessageEvent();
        xClientMessageEvent.type = 33;
        xClientMessageEvent.send_event = 1;
        xClientMessageEvent.display = n;
        xClientMessageEvent.window = n2;
        xClientMessageEvent.message_type = n3;
        xClientMessageEvent.format = 32;
        xClientMessageEvent.data[0] = bl ? 1 : 0;
        xClientMessageEvent.data[1] = n4;
        xClientMessageEvent.data[2] = n5;
        XWindowAttributes xWindowAttributes = new XWindowAttributes();
        OS.XGetWindowAttributes(n, n2, xWindowAttributes);
        int n6 = OS.XRootWindowOfScreen(xWindowAttributes.screen);
        int n7 = OS.XtMalloc(96);
        OS.memmove(n7, xClientMessageEvent, 48);
        OS.XSendEvent(n, n6, false, 0x180000, n7);
        OS.XSync(n, false);
        OS.XtFree(n7);
    }

    public void setMinimized(boolean bl) {
        this.checkWidget();
        if (bl == this.minimized) {
            return;
        }
        int[] nArray = new int[4];
        nArray[0] = OS.XmNiconic;
        nArray[2] = OS.XmNinitialState;
        int[] nArray2 = nArray;
        OS.XtGetValues(this.shellHandle, nArray2, nArray2.length / 2);
        if (nArray2[1] != 0 != this.minimized) {
            nArray2[1] = this.minimized ? 1 : 0;
            OS.XtSetValues(this.shellHandle, nArray2, nArray2.length / 2);
        }
        super.setMinimized(bl);
        nArray2[1] = bl ? 1 : 0;
        nArray2[3] = bl ? 3 : 1;
        OS.XtSetValues(this.shellHandle, nArray2, nArray2.length / 2);
        int n = OS.XtDisplay(this.handle);
        if (n != 0) {
            OS.XSync(n, false);
        }
        if (!bl) {
            int[] nArray3 = new int[2];
            nArray3[0] = OS.XmNmappedWhenManaged;
            int[] nArray4 = nArray3;
            OS.XtGetValues(this.shellHandle, nArray4, nArray4.length / 2);
            if (nArray4[1] != 0) {
                do {
                    this.display.update();
                } while (!this.isVisible());
                this.setActive();
            }
        }
    }

    public void setMinimumSize(int n, int n2) {
        this.checkWidget();
        int[] nArray = new int[]{OS.XmNminWidth, Math.max(n, this.trimWidth()) - this.trimWidth(), OS.XmNminHeight, Math.max(n2, this.trimHeight()) - this.trimHeight()};
        OS.XtSetValues(this.shellHandle, nArray, nArray.length / 2);
    }

    public void setMinimumSize(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        this.setMinimumSize(point.x, point.y);
    }

    public void setModified(boolean bl) {
        this.checkWidget();
        this.modified = bl;
    }

    void setParentTraversal() {
    }

    public void setRegion(Region region) {
        this.checkWidget();
        if ((this.style & 8) == 0) {
            return;
        }
        if (region != null && region.isDisposed()) {
            this.error(5);
        }
        super.setRegion(region);
    }

    public void setText(String string) {
        byte[] byArray;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        super.setText(string);
        if (string.length() == 0) {
            string = " ";
        }
        byte[] byArray2 = byArray = Converter.wcsToMbcs(null, string, true);
        int n = byArray.length - 1;
        if (n % 4 != 0) {
            byArray2 = new byte[(n + 3) / 4 * 4];
            System.arraycopy(byArray, 0, byArray2, 0, n);
        }
        int n2 = OS.XtMalloc(byArray2.length + 1);
        OS.memmove(n2, byArray2, byArray2.length);
        int[] nArray = new int[]{OS.XmNtitle, n2, OS.XmNiconName, n2};
        OS.XtSetValues(this.shellHandle, nArray, nArray.length / 2);
        OS.XtFree(n2);
    }

    public void setVisible(boolean bl) {
        this.checkWidget();
        this.realizeWidget();
        if (bl) {
            Point point;
            int n;
            if (this.center && !this.moved) {
                this.center();
                if (this.isDisposed()) {
                    return;
                }
            }
            this.sendEvent(22);
            if (this.isDisposed()) {
                return;
            }
            OS.XtSetMappedWhenManaged(this.shellHandle, true);
            if (OS.XtIsTopLevelShell(this.shellHandle)) {
                OS.XtMapWidget(this.shellHandle);
            } else {
                OS.XtPopup(this.shellHandle, 0);
            }
            boolean bl2 = false;
            Shell shell = this.parent != null ? this.parent.getShell() : null;
            do {
                this.display.update();
                if (this.isDisposed()) {
                    return;
                }
                boolean bl3 = bl2 = this.minimized || shell != null && shell.minimized;
            } while (!this.isVisible() && !bl2);
            if (!bl2) {
                this.adjustTrim();
            }
            if ((this.style & (n = 98304)) != 0) {
                OS.XUngrabPointer(this.display.xDisplay, 0);
            }
            this.opened = true;
            if (!this.moved) {
                this.moved = true;
                point = this.getLocation();
                this.oldX = point.x + this.trimLeft();
                this.oldY = point.x + this.trimTop();
                this.sendEvent(10);
                if (this.isDisposed()) {
                    return;
                }
            }
            if (!this.resized) {
                this.resized = true;
                point = this.getSize();
                this.oldWidth = point.x - this.trimWidth();
                this.oldHeight = point.y - this.trimHeight();
                this.sendEvent(11);
                if (this.isDisposed()) {
                    return;
                }
                if (this.layout != null) {
                    this.markLayout(false, false);
                    this.updateLayout(false);
                }
            }
        } else {
            Shell shell;
            if (this.parent != null && (shell = this.display.getActiveShell()) == this) {
                Shell shell2 = this.parent.getShell();
                shell2.bringToTop(false);
            }
            OS.XtSetMappedWhenManaged(this.shellHandle, false);
            if (OS.XtIsTopLevelShell(this.shellHandle)) {
                OS.XtUnmapWidget(this.shellHandle);
            } else {
                OS.XtPopdown(this.shellHandle);
            }
            int n = OS.XtDisplay(this.shellHandle);
            if (n == 0) {
                return;
            }
            int n2 = OS.XtWindow(this.shellHandle);
            if (n2 == 0) {
                return;
            }
            OS.XWithdrawWindow(n, n2, OS.XDefaultScreen(n));
            this.sendEvent(23);
        }
    }

    void setZOrder(Control control, boolean bl) {
        this.setZOrder(control, bl, false);
    }

    int topHandle() {
        return this.shellHandle;
    }

    boolean traverseEscape() {
        if (this.parent == null) {
            return false;
        }
        if (!this.isVisible() || !this.isEnabled()) {
            return false;
        }
        this.close();
        return true;
    }

    int trimHeight() {
        if ((this.style & 8) != 0) {
            return 0;
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        bl = (this.style & 0x4E0) != 0;
        bl2 = (this.style & 0x10) != 0;
        boolean bl4 = bl3 = (this.style & 0x800) != 0;
        if (bl) {
            if (bl2) {
                return this.display.topTitleResizeHeight + this.display.bottomTitleResizeHeight;
            }
            if (bl3) {
                return this.display.topTitleBorderHeight + this.display.bottomTitleBorderHeight;
            }
            return this.display.topTitleHeight + this.display.bottomTitleHeight;
        }
        if (bl2) {
            return this.display.topResizeHeight + this.display.bottomResizeHeight;
        }
        if (bl3) {
            return this.display.topBorderHeight + this.display.bottomBorderHeight;
        }
        return 0;
    }

    int trimLeft() {
        if ((this.style & 8) != 0) {
            return 0;
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        bl = (this.style & 0x4E0) != 0;
        bl2 = (this.style & 0x10) != 0;
        boolean bl4 = bl3 = (this.style & 0x800) != 0;
        if (bl) {
            if (bl2) {
                return this.display.leftTitleResizeWidth;
            }
            if (bl3) {
                return this.display.leftTitleBorderWidth;
            }
            return this.display.leftTitleWidth;
        }
        if (bl2) {
            return this.display.leftResizeWidth;
        }
        if (bl3) {
            return this.display.leftBorderWidth;
        }
        return 0;
    }

    int trimTop() {
        if ((this.style & 8) != 0) {
            return 0;
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        bl = (this.style & 0x4E0) != 0;
        bl2 = (this.style & 0x10) != 0;
        boolean bl4 = bl3 = (this.style & 0x800) != 0;
        if (bl) {
            if (bl2) {
                return this.display.topTitleResizeHeight;
            }
            if (bl3) {
                return this.display.topTitleBorderHeight;
            }
            return this.display.topTitleHeight;
        }
        if (bl2) {
            return this.display.topResizeHeight;
        }
        if (bl3) {
            return this.display.topBorderHeight;
        }
        return 0;
    }

    int trimWidth() {
        if ((this.style & 8) != 0) {
            return 0;
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        bl = (this.style & 0x4E0) != 0;
        bl2 = (this.style & 0x10) != 0;
        boolean bl4 = bl3 = (this.style & 0x800) != 0;
        if (bl) {
            if (bl2) {
                return this.display.leftTitleResizeWidth + this.display.rightTitleResizeWidth;
            }
            if (bl3) {
                return this.display.leftTitleBorderWidth + this.display.rightTitleBorderWidth;
            }
            return this.display.leftTitleWidth + this.display.rightTitleWidth;
        }
        if (bl2) {
            return this.display.leftResizeWidth + this.display.rightResizeWidth;
        }
        if (bl3) {
            return this.display.leftBorderWidth + this.display.rightBorderWidth;
        }
        return 0;
    }

    void updateResizable(int n, int n2) {
        if ((this.style & 0x10) != 0) {
            return;
        }
        if (!OS.XtIsRealized(this.shellHandle)) {
            return;
        }
        XSizeHints xSizeHints = new XSizeHints();
        xSizeHints.flags = 52;
        xSizeHints.min_width = xSizeHints.max_width = n;
        xSizeHints.min_height = xSizeHints.max_height = n2;
        OS.XSetWMNormalHints(OS.XtDisplay(this.shellHandle), OS.XtWindow(this.shellHandle), xSizeHints);
    }

    int WM_DELETE_WINDOW(int n, int n2, int n3) {
        if (!this.isEnabled()) {
            return 0;
        }
        Composite composite = this.parent;
        while (composite != null && !composite.getShell().isModal()) {
            composite = composite.parent;
        }
        if (composite == null) {
            Shell[] shellArray = this.getShells();
            int n4 = 0;
            while (n4 < shellArray.length) {
                Shell shell = shellArray[n4];
                if (shell != this && shell.isModal() && shell.isVisible()) {
                    shell.bringToTop(false);
                    return 0;
                }
                ++n4;
            }
        }
        this.closeWidget();
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    int XFocusChange(int n, int n2, int n3, int n4) {
        XFocusChangeEvent xFocusChangeEvent = new XFocusChangeEvent();
        OS.memmove(xFocusChangeEvent, n3, 28);
        int n5 = OS.XtWindowToWidget(xFocusChangeEvent.display, xFocusChangeEvent.window);
        if (n5 != this.shellHandle) {
            return super.XFocusChange(n, n2, n3, n4);
        }
        if (xFocusChangeEvent.mode != 0) {
            return 0;
        }
        if (xFocusChangeEvent.type == 9 && xFocusChangeEvent.detail == 2 && this.focusProxy != 0) {
            int n6 = OS.XtWindow(this.focusProxy);
            int n7 = OS.XtDisplay(this.focusProxy);
            OS.XSetInputFocus(n7, n6, 2, 0);
        }
        switch (xFocusChangeEvent.detail) {
            case 3: 
            case 4: {
                switch (xFocusChangeEvent.type) {
                    case 9: {
                        if (this.display.postFocusOut) {
                            this.postEvent(26);
                            return 0;
                        }
                        this.sendEvent(26);
                        return 0;
                    }
                    case 10: {
                        Display display = this.display;
                        if (display.postFocusOut) {
                            this.postEvent(27);
                        } else {
                            this.sendEvent(27);
                        }
                        Combo combo = display.focusedCombo;
                        display.focusedCombo = null;
                        if (combo == null || combo == this || combo.isDisposed()) return 0;
                        display.sendFocusEvent(combo, 16);
                    }
                }
                return 0;
            }
        }
        return 0;
    }

    int XStructureNotify(int n, int n2, int n3, int n4) {
        XConfigureEvent xConfigureEvent = new XConfigureEvent();
        OS.memmove(xConfigureEvent, n3, 52);
        int n5 = OS.XtWindowToWidget(xConfigureEvent.display, xConfigureEvent.window);
        if (n5 != this.shellHandle) {
            return super.XStructureNotify(n, n2, n3, n4);
        }
        switch (xConfigureEvent.type) {
            case 21: {
                this.reparented = true;
                this.adjustTrim();
                break;
            }
            case 22: {
                int[] nArray = new int[1];
                int[] nArray2 = new int[1];
                int[] nArray3 = new int[1];
                OS.XTranslateCoordinates(xConfigureEvent.display, xConfigureEvent.window, OS.XDefaultRootWindow(xConfigureEvent.display), 0, 0, nArray, nArray2, nArray3);
                if (!this.moved || this.oldX != nArray[0] || this.oldY != nArray2[0]) {
                    this.moved = true;
                    this.oldX = nArray[0];
                    this.oldY = nArray2[0];
                    this.sendEvent(10);
                    if (this.isDisposed()) {
                        return 0;
                    }
                }
                this.updateResizable(xConfigureEvent.width, xConfigureEvent.height);
                if (!this.resized || this.oldWidth != xConfigureEvent.width || this.oldHeight != xConfigureEvent.height) {
                    int n6 = OS.XtMalloc(96);
                    this.display.resizeWindow = xConfigureEvent.window;
                    this.display.resizeWidth = xConfigureEvent.width;
                    this.display.resizeHeight = xConfigureEvent.height;
                    this.display.resizeCount = 0;
                    int n7 = this.display.checkResizeProc;
                    OS.XCheckIfEvent(xConfigureEvent.display, n6, n7, 0);
                    OS.XtFree(n6);
                    if (this.display.resizeCount == 0) {
                        this.resized = true;
                        this.oldWidth = xConfigureEvent.width;
                        this.oldHeight = xConfigureEvent.height;
                        this.sendEvent(11);
                        if (this.isDisposed()) {
                            return 0;
                        }
                        if (this.layout != null) {
                            this.markLayout(false, false);
                            this.updateLayout(false);
                        }
                    }
                }
                return 0;
            }
            case 18: {
                int[] nArray = new int[2];
                nArray[0] = OS.XmNmappedWhenManaged;
                int[] nArray4 = nArray;
                OS.XtGetValues(this.shellHandle, nArray4, nArray4.length / 2);
                if (nArray4[1] != 0) {
                    this.minimized = true;
                    this.sendEvent(19);
                }
                return 0;
            }
            case 19: {
                if (this.minimized) {
                    this.minimized = false;
                    this.sendEvent(20);
                }
                return 0;
            }
        }
        return 0;
    }
}

