/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.geomap.internal;

import java.net.URL;
import java.net.URLConnection;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.nebula.widgets.geomap.internal.GeoMapHelper;
import org.eclipse.nebula.widgets.geomap.internal.TileRef;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Display;

class AsyncImage
extends AtomicReference<ImageData>
implements Runnable {
    private final GeoMapHelper geoMapHelper;
    private final TileRef tile;
    private final String tileUrl;
    private volatile long stamp;
    private Image image = null;
    private Runnable removeTileFromCacheRunnable = new Runnable(){

        @Override
        public void run() {
            AsyncImage.this.geoMapHelper.cache.remove(AsyncImage.this.tile);
        }
    };
    private Runnable tileUpdatedRunnable = new Runnable(){

        @Override
        public void run() {
            AsyncImage.this.geoMapHelper.tileUpdated(AsyncImage.this.tile);
        }
    };

    AsyncImage(GeoMapHelper geoMapHelper, TileRef tile, String tileUrl) {
        this.geoMapHelper = geoMapHelper;
        this.stamp = this.geoMapHelper.zoomStamp.longValue();
        this.tile = tile;
        this.tileUrl = tileUrl;
        this.geoMapHelper.executor.execute(new FutureTask<Boolean>(this, Boolean.TRUE));
    }

    @Override
    public void run() {
        if (this.stamp != this.geoMapHelper.zoomStamp.longValue()) {
            try {
                if (!this.geoMapHelper.getDisplay().isDisposed()) {
                    this.geoMapHelper.getDisplay().asyncExec(this.removeTileFromCacheRunnable);
                }
            }
            catch (SWTException sWTException) {
                // empty catch block
            }
            return;
        }
        try {
            URLConnection con = new URL(this.tileUrl).openConnection();
            con.setRequestProperty("User-Agent", "org.eclipse.nebula.widgets.geomap.GeoMap");
            this.set(new ImageData(con.getInputStream()));
            try {
                if (!this.geoMapHelper.getDisplay().isDisposed()) {
                    this.geoMapHelper.getDisplay().asyncExec(this.tileUpdatedRunnable);
                }
            }
            catch (SWTException sWTException) {}
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Image getImage(Display display) {
        this.checkThread(display);
        if (this.image == null && this.get() != null) {
            this.image = new Image((Device)display, (ImageData)this.get());
        }
        return this.image;
    }

    public void dispose() {
        this.checkThread(this.geoMapHelper.getDisplay());
        if (this.image != null) {
            this.image.dispose();
            this.image = null;
        }
    }

    private void checkThread(Display display) {
        if (display.getThread() != Thread.currentThread()) {
            throw new IllegalStateException("Wrong thread to pick up the image");
        }
    }
}

