/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.geomap.internal;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.MessageFormat;

public abstract class URLService {
    private String url;
    private String urlFormat;

    protected void parseUrl(String url, String defaultUrlFormat) {
        int pos = url.indexOf("{");
        if (pos > 0) {
            this.url = url.substring(0, pos);
            this.urlFormat = url.substring(pos);
        } else {
            this.url = url;
            this.urlFormat = defaultUrlFormat;
        }
    }

    protected URLService() {
    }

    protected URLService(String url, String urlFormat) {
        this.url = url;
        this.urlFormat = urlFormat;
    }

    protected abstract Object[] getURLFormatArguments(Object var1);

    protected String getServiceURL(Object ref, String urlFormat, Object[] formatArguments) {
        Object[] encodedArgs = new String[formatArguments.length];
        int i = 0;
        while (i < encodedArgs.length) {
            encodedArgs[i] = formatArguments[i].toString().trim();
            try {
                encodedArgs[i] = URLEncoder.encode((String)encodedArgs[i], "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            ++i;
        }
        return String.valueOf(this.url) + MessageFormat.format(urlFormat, encodedArgs);
    }

    protected String getServiceURL(Object ref) {
        return this.urlFormat != null ? this.getServiceURL(ref, this.urlFormat, this.getURLFormatArguments(ref)) : null;
    }

    public String toString() {
        return this.url;
    }

    public String getURL() {
        return this.url;
    }
}

