/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.geomap.jface;

import java.util.Stack;
import org.eclipse.nebula.widgets.geomap.jface.SearchServer;
import org.xml.sax.Attributes;

public class GoogleMapsSearchServer
extends SearchServer {
    public GoogleMapsSearchServer() {
        super("http://maps.googleapis.com/maps/api/geocode/xml?", "address={0}&sensor=false");
    }

    @Override
    protected Object startElement(String qName, Stack<String> path, Attributes attributes, Stack<Object> objects) {
        if ("result".equals(qName)) {
            objects.push(new SearchResult());
        }
        return null;
    }

    @Override
    protected Object characters(String qName, Stack<String> path, char[] ch, int start, int length, Stack<Object> objects) {
        if (objects.size() > 0 && objects.peek() instanceof SearchResult) {
            SearchResult result = (SearchResult)objects.peek();
            if ("type".equals(qName) && "result".equals(path.peek())) {
                String s = new String(ch, start, length).trim();
                if (result.category == null) {
                    result.category = s;
                } else {
                    result.type = s;
                }
            } else if ("formatted_address".equals(qName) && "result".equals(path.peek())) {
                result.setText(new String(ch, start, length));
            } else if ("short_name".equals(qName) && result.getName() == null) {
                result.setName(new String(ch, start, length));
            } else if ("lng".equals(qName) && "location".equals(path.peek())) {
                result.setLon(new String(ch, start, length).trim());
            } else if ("lat".equals(qName) && "location".equals(path.peek())) {
                result.setLat(new String(ch, start, length).trim());
            }
        }
        return null;
    }

    @Override
    protected Object endElement(String qName, Stack<String> path, Stack<Object> objects) {
        SearchResult result;
        if ("result".equals(qName) && objects.size() > 0 && objects.peek() instanceof SearchResult && (result = (SearchResult)objects.peek()).getLonLat() != null) {
            return result;
        }
        return null;
    }

    public static final class SearchResult
    extends SearchServer.Result {
        private String type;
        private String category;

        public String getType() {
            return this.type;
        }

        public String getCategory() {
            return this.category;
        }

        @Override
        public String toString() {
            return "SearchResult [text=" + this.getText() + ", location=" + this.getLonLat() + ", type=" + this.type + ", category=" + this.category + "]";
        }
    }
}

