/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.roundedcheckbox;

import org.eclipse.nebula.widgets.opal.commons.SelectionListenerUtil;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;

public class RoundedCheckbox
extends Canvas {
    private static final int DEFAULT_WIDTH = 20;
    private static final int DEFAULT_HEIGHT = 20;
    private boolean selected;
    private boolean grayed;
    private Color unselectedColor;
    private Color selectionBackground;
    private Color selectionForeground;
    private Color hoverColor;
    private final Color disabledColor = this.getAndDisposeColor(204, 204, 204);
    private GC gc;
    private boolean cursorInside;

    public RoundedCheckbox(Composite parent, int style) {
        super(parent, RoundedCheckbox.checkStyle(style) | 0x20000000);
        this.selectionBackground = this.getAndDisposeColor(0, 122, 255);
        this.selectionForeground = this.getAndDisposeColor(255, 255, 255);
        this.unselectedColor = this.getDisplay().getSystemColor(2);
        this.hoverColor = this.getAndDisposeColor(56, 143, 188);
        this.addListener(9, e -> {
            this.gc = e.gc;
            this.drawElement();
        });
        this.addListener(4, e -> this.onClick(e));
        this.addListener(2, e -> this.onKeyPress(e));
        this.addListener(6, e -> {
            this.cursorInside = true;
            this.redraw();
        });
        this.addListener(7, e -> {
            this.cursorInside = false;
            this.redraw();
        });
    }

    private static int checkStyle(int style) {
        if ((style & 0x800) != 0) {
            return style & 0xFFFFF7FF;
        }
        return 0;
    }

    private void drawElement() {
        this.gc.setAdvanced(true);
        this.gc.setAntialias(1);
        Color previousForeground = this.gc.getForeground();
        Color previousBackground = this.gc.getBackground();
        if (!this.selected) {
            this.drawUnselected();
        } else if (this.grayed) {
            this.drawGrayed();
        } else {
            this.drawTicker();
        }
        this.gc.setBackground(previousBackground);
        this.gc.setForeground(previousForeground);
    }

    private void drawUnselected() {
        Rectangle rect = this.getClientArea();
        Color color = this.isEnabled() ? (this.cursorInside ? this.hoverColor : this.unselectedColor) : this.disabledColor;
        this.gc.setForeground(color);
        this.gc.setLineWidth(1);
        this.gc.drawOval(2, 2, rect.width - 4, rect.height - 4);
    }

    private void drawGrayed() {
        Rectangle rect = this.getClientArea();
        Color color = this.isEnabled() ? (this.cursorInside ? this.hoverColor : this.selectionBackground) : this.disabledColor;
        this.gc.setForeground(color);
        this.gc.setLineWidth(1);
        this.gc.drawOval(2, 2, rect.width - 4, rect.height - 4);
        this.gc.setBackground(color);
        this.gc.fillOval(5, 5, rect.width - 9, rect.height - 9);
    }

    private void drawTicker() {
        Rectangle rect = this.getClientArea();
        Color color = this.isEnabled() ? (this.cursorInside ? this.hoverColor : this.selectionBackground) : this.disabledColor;
        this.gc.setBackground(color);
        this.gc.fillOval(2, 2, rect.width - 4, rect.height - 4);
        this.gc.setForeground(this.selectionForeground);
        this.gc.setLineWidth(2);
        int centerX = rect.width / 2;
        int centerY = rect.height / 2;
        this.gc.drawLine(5, centerY, 8, centerY + 4);
        this.gc.drawLine(8, centerY + 4, centerX + 5, centerY - 3);
    }

    private void onClick(Event e) {
        Rectangle rect = this.getClientArea();
        int centerX = (rect.width - rect.x) / 2;
        int centerY = (rect.height - rect.y) / 2;
        int distance = (int)Math.sqrt(Math.abs(e.x - centerX ^ 2 - (e.y - centerY) ^ 2));
        if (distance < rect.width - 4 && SelectionListenerUtil.fireSelectionListeners((Control)this, (Event)e)) {
            this.setSelection(!this.selected);
        }
    }

    private void onKeyPress(Event e) {
        if (e.character == ' ' || e.character == '+') {
            this.setSelection(!this.selected);
        }
    }

    private Color getAndDisposeColor(int r, int g, int b) {
        Color color = new Color((Device)this.getDisplay(), r, g, b);
        this.addDisposeListener(e -> {
            if (!color.isDisposed()) {
                color.dispose();
            }
        });
        return color;
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        SelectionListenerUtil.addSelectionListener((Control)this, (SelectionListener)listener);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        wHint = wHint != -1 ? DPIUtil.autoScaleUp((int)wHint) : wHint;
        hHint = hHint != -1 ? DPIUtil.autoScaleUp((int)hHint) : hHint;
        return DPIUtil.autoScaleDown((Point)this.computeSizePixels(wHint, hHint, changed));
    }

    private Point computeSizePixels(int wHint, int hHint, boolean changed) {
        int width = 20;
        int height = 20;
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        int border = this.getBorderWidth();
        return new Point(width += border * 2, height += border * 2);
    }

    public boolean getGrayed() {
        this.checkWidget();
        return this.grayed;
    }

    public Color getHoverColor() {
        this.checkWidget();
        return this.hoverColor;
    }

    public Color getSelectedBackgroundColor() {
        this.checkWidget();
        return this.selectionBackground;
    }

    public Color getSelectedForegroundColor() {
        this.checkWidget();
        return this.selectionForeground;
    }

    public boolean getSelection() {
        this.checkWidget();
        return this.selected;
    }

    public Color getUnselectedColor() {
        this.checkWidget();
        return this.unselectedColor;
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        SelectionListenerUtil.removeSelectionListener((Control)this, (SelectionListener)listener);
    }

    public void setGrayed(boolean grayed) {
        this.checkWidget();
        this.grayed = grayed;
        this.redraw();
        this.update();
    }

    public void setHoverColor(Color color) {
        this.checkWidget();
        this.hoverColor = color == null ? this.getAndDisposeColor(56, 143, 188) : color;
    }

    public void setSelectedBackgroundColor(Color color) {
        this.checkWidget();
        this.selectionBackground = color == null ? this.getAndDisposeColor(0, 122, 255) : color;
    }

    public void setSelectedForegroundColor(Color color) {
        this.checkWidget();
        this.selectionForeground = color == null ? this.getAndDisposeColor(255, 255, 255) : color;
    }

    public void setSelection(boolean selected) {
        this.checkWidget();
        this.selected = selected;
        this.redraw();
        this.update();
    }

    public void setUnselectedColor(Color color) {
        this.checkWidget();
        this.unselectedColor = color == null ? this.getAndDisposeColor(204, 204, 204) : color;
    }
}

