/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.opal.preferencewindow;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.nebula.widgets.opal.preferencewindow.PWContainer;
import org.eclipse.nebula.widgets.opal.preferencewindow.PWRow;
import org.eclipse.nebula.widgets.opal.preferencewindow.PWRowGroup;
import org.eclipse.nebula.widgets.opal.preferencewindow.PWTab;
import org.eclipse.nebula.widgets.opal.preferencewindow.widgets.PWWidget;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class PWGroup
extends PWRowGroup {
    private final String label;
    private final boolean hasBorder;
    private final List<PWRow> children;

    public PWGroup(boolean hasBorder) {
        this(null, hasBorder);
    }

    public PWGroup(String label) {
        this(label, true);
    }

    public PWGroup(String label, boolean hasBorder) {
        this.label = label;
        this.hasBorder = hasBorder;
        this.children = new ArrayList<PWRow>();
    }

    @Override
    public PWContainer add(PWContainer element) {
        if (!(element instanceof PWRow)) {
            throw new UnsupportedOperationException("Can only add a PWRow.");
        }
        this.children.add((PWRow)element);
        return this;
    }

    @Override
    public PWContainer add(PWWidget widget) {
        PWRow row = new PWRow();
        row.add(widget);
        this.children.add(row);
        return this;
    }

    @Override
    public void build(Composite parent) {
        Group composite;
        if (this.hasBorder) {
            composite = new Group(parent, 0);
            if (this.label != null && !this.label.trim().equals("")) {
                composite.setText(this.label);
            }
        } else {
            composite = new Composite(parent, 2048);
        }
        int numCol = this.computeNumberOfColumns();
        composite.setLayout((Layout)new GridLayout(numCol, false));
        composite.setLayoutData((Object)new GridData(1, 4, false, false, this.parentNumberOfColums, 1));
        for (PWRow row : this.children) {
            row.setParentNumberOfColumns(numCol);
            row.build((Composite)composite);
        }
    }

    private int computeNumberOfColumns() {
        int numberOfColumns = 1;
        for (PWRow row : this.children) {
            numberOfColumns = Math.max(numberOfColumns, row.getNumberOfColums());
        }
        return numberOfColumns;
    }

    @Override
    protected void checkParent(PWContainer parent) {
        if (parent instanceof PWTab) {
            return;
        }
        throw new UnsupportedOperationException("Bad parent, should be only PWTab ");
    }

    @Override
    public void enableOrDisable() {
        if (this.enabler == null) {
            return;
        }
        boolean enabled = this.enabler.isEnabled();
        for (PWRow row : this.children) {
            this.enableOrDisable(row, enabled);
        }
    }

    private void enableOrDisable(PWRow row, boolean enabled) {
        for (PWWidget widget : row.widgets) {
            boolean widgetEnable = widget.enableOrDisable();
            for (Control c : widget.getControls()) {
                if (c.isDisposed()) continue;
                c.setEnabled(enabled && widgetEnable);
            }
        }
    }
}

