/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.opal.launcher;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.nebula.widgets.opal.commons.SWTGraphicUtil;
import org.eclipse.nebula.widgets.opal.commons.SelectionListenerUtil;
import org.eclipse.nebula.widgets.opal.launcher.LauncherItem;
import org.eclipse.nebula.widgets.opal.launcher.LauncherLabel;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public class Launcher
extends Composite {
    private final List<LauncherItem> items = new ArrayList<LauncherItem>();
    private boolean needRedraw = true;
    private int selection = -1;
    private Color itemBackgroundColor;
    private Color selectedItemBackgroundColor;
    private int numberOfColumns = -1;
    private boolean singleClickSelection = false;

    public Launcher(Composite parent, int style) {
        super(parent, style | 0x800);
        this.setBackground(this.getDisplay().getSystemColor(1));
        this.addListener(11, event -> this.drawLauncher());
        this.addListener(2, event -> this.handleKeyPressedEvent(event));
        Font original = super.getFont();
        Font defaultFont = new Font((Device)this.getDisplay(), original.getFontData()[0].getName(), 18, 1);
        this.setFont(defaultFont);
        SWTGraphicUtil.addDisposer((Widget)this, (Resource[])new Resource[]{defaultFont});
    }

    public void addItem(String title, Image image) {
        this.checkWidget();
        this.items.add(new LauncherItem(title, image));
        this.needRedraw = true;
    }

    private void addListenerToLabel(LauncherLabel label) {
        label.addListener(2, event -> this.handleKeyPressedEvent(event));
        label.addListener(4, event -> this.handleClickEvent(event));
        label.addListener(8, event -> this.handleDoubleClickEvent(event));
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        SelectionListenerUtil.addSelectionListener((Control)this, (SelectionListener)listener);
    }

    private void changeColor(int index, boolean isSelected) {
        if (index != -1 && this.items.get((int)index).label != null) {
            Color selectedItemColor = this.selectedItemBackgroundColor == null ? this.getDisplay().getSystemColor(19) : this.selectedItemBackgroundColor;
            Color itemColor = this.itemBackgroundColor == null ? this.getDisplay().getSystemColor(1) : this.itemBackgroundColor;
            this.items.get((int)index).label.setBackground(isSelected ? selectedItemColor : itemColor);
        }
    }

    private void createButtons() {
        if (this.numberOfColumns == -1) {
            this.numberOfColumns = this.items.size() / 2;
        }
        GridLayout gridLayout = new GridLayout(this.numberOfColumns, true);
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        this.setLayout((Layout)gridLayout);
        Point widthHeightHint = new Point(0, 0);
        for (LauncherItem item : this.items) {
            this.createItem(item);
            Point itemSize = item.label.computeSize(-1, -1);
            widthHeightHint.x = Math.max(widthHeightHint.x, itemSize.x);
            widthHeightHint.y = Math.max(widthHeightHint.y, itemSize.y);
        }
        for (LauncherItem item : this.items) {
            GridData gd = (GridData)item.label.getLayoutData();
            gd.widthHint = widthHeightHint.x;
            gd.heightHint = widthHeightHint.y;
        }
    }

    private void createItem(LauncherItem item) {
        LauncherLabel label = this.createLauncherLabel(item);
        this.addListenerToLabel(label);
    }

    private LauncherLabel createLauncherLabel(LauncherItem item) {
        LauncherLabel label = new LauncherLabel(this, 0);
        label.setText(item.title);
        label.setImage(item.image);
        label.setBackground(this.itemBackgroundColor == null ? this.getDisplay().getSystemColor(1) : this.itemBackgroundColor);
        GridData gd = new GridData(4, 4, false, false);
        label.setLayoutData(gd);
        item.label = label;
        label.setFont(this.getFont());
        return label;
    }

    private void disposePreviousContent() {
        Control[] controlArray = this.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            c.dispose();
            ++n2;
        }
    }

    private void drawLauncher() {
        if (!this.needRedraw) {
            return;
        }
        this.disposePreviousContent();
        this.createButtons();
        this.pack();
        this.needRedraw = false;
    }

    public int getSelection() {
        this.checkWidget();
        return this.selection;
    }

    private void handleClickEvent(Event event) {
        int i = 0;
        while (i < this.items.size()) {
            LauncherItem item = this.items.get(i);
            if (item.label != null && ((Object)((Object)item.label)).equals(event.widget)) {
                if (this.selection != i) {
                    this.changeColor(this.selection, false);
                    this.selection = i;
                    this.changeColor(this.selection, true);
                }
                if (this.singleClickSelection) {
                    this.startAnimation(i, event);
                }
                return;
            }
            ++i;
        }
    }

    private void handleDoubleClickEvent(Event event) {
        int i = 0;
        while (i < this.items.size()) {
            LauncherItem item = this.items.get(i);
            if (item.label != null && ((Object)((Object)item.label)).equals(event.widget)) {
                if (this.selection != i) {
                    this.changeColor(this.selection, false);
                    this.selection = i;
                    this.changeColor(this.selection, true);
                }
                if (!this.singleClickSelection) {
                    this.startAnimation(i, event);
                }
                return;
            }
            ++i;
        }
    }

    private void handleKeyPressedEvent(Event event) {
        switch (event.keyCode) {
            case 0x1000003: {
                if (this.selection == -1) {
                    this.selection = 0;
                    this.changeColor(this.selection, true);
                    return;
                }
                if (this.selection % 2 == 0) break;
                this.changeColor(this.selection, false);
                --this.selection;
                this.changeColor(this.selection, true);
                break;
            }
            case 0x1000001: {
                if (this.selection == -1) {
                    this.selection = 0;
                    this.changeColor(this.selection, true);
                    return;
                }
                if (this.selection < 2) break;
                this.changeColor(this.selection, false);
                this.selection -= 2;
                this.changeColor(this.selection, true);
                break;
            }
            case 0x1000004: {
                if (this.selection == -1) {
                    this.selection = 0;
                    this.changeColor(this.selection, true);
                    return;
                }
                if (this.selection % 2 != 0) break;
                this.changeColor(this.selection, false);
                ++this.selection;
                this.changeColor(this.selection, true);
                break;
            }
            case 0x1000002: {
                if (this.selection == -1) {
                    this.selection = 0;
                    this.changeColor(this.selection, true);
                    return;
                }
                if (this.selection > this.items.size() - 2) break;
                this.changeColor(this.selection, false);
                this.selection += 2;
                this.changeColor(this.selection, true);
                break;
            }
            case 0x1000007: {
                this.changeColor(this.selection, false);
                this.selection = 0;
                this.changeColor(this.selection, true);
                break;
            }
            case 0x1000008: {
                this.changeColor(this.selection, false);
                this.selection = this.items.size() - 1;
                this.changeColor(this.selection, true);
            }
        }
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        SelectionListenerUtil.removeSelectionListener((Control)this, (SelectionListener)listener);
    }

    private void startAnimation(int index, final Event event) {
        final LauncherLabel label = this.items.get((int)index).label;
        this.getDisplay().timerExec(0, new Runnable(){

            @Override
            public void run() {
                if (label.incrementAnimation()) {
                    Launcher.this.getDisplay().timerExec(20, (Runnable)this);
                } else {
                    SelectionListenerUtil.fireSelectionListeners((Control)Launcher.this, (Event)event);
                }
            }
        });
    }

    public Color getItemBackgroundColor() {
        this.checkWidget();
        return this.itemBackgroundColor;
    }

    public void setItemBackgroundColor(Color color) {
        this.checkWidget();
        this.itemBackgroundColor = color;
    }

    public Color getSelectedItemBackgroundColor() {
        this.checkWidget();
        return this.selectedItemBackgroundColor;
    }

    public void setSelectedItemBackgroundColor(Color color) {
        this.checkWidget();
        this.selectedItemBackgroundColor = color;
    }

    public int getNumberOfColumns() {
        this.checkWidget();
        return this.numberOfColumns;
    }

    public void setNumberOfColumns(int numberOfColumns) {
        this.checkWidget();
        this.numberOfColumns = numberOfColumns;
        this.drawLauncher();
    }

    public boolean isSingleClickSelection() {
        this.checkWidget();
        return this.singleClickSelection;
    }

    public void setSingleClickSelection(boolean singleClickSelection) {
        this.checkWidget();
        this.singleClickSelection = singleClickSelection;
    }
}

