/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.oscilloscope.css;

import org.eclipse.e4.ui.css.core.dom.properties.ICSSPropertyHandler;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.core.impl.dom.Measure;
import org.eclipse.nebula.widgets.oscilloscope.css.OscilloscopeElement;
import org.eclipse.nebula.widgets.oscilloscope.multichannel.Oscilloscope;
import org.eclipse.swt.graphics.Color;
import org.w3c.dom.css.CSSValue;

public class OscilloscopePropertyHandler
implements ICSSPropertyHandler {
    public boolean applyCSSProperty(Object element, String property, CSSValue value, String pseudo, CSSEngine engine) throws Exception {
        Color newColor;
        int size;
        Measure m;
        Oscilloscope osc = (Oscilloscope)((OscilloscopeElement)((Object)element)).getNativeWidget();
        if ("grid-square-size".equals(property) && value.getCssValueType() == 1) {
            m = (Measure)value;
            size = Math.round(m.getFloatValue((short)0));
            osc.setGridSquareSize(size);
        }
        if ("grid-line-width".equals(property) && value.getCssValueType() == 1) {
            m = (Measure)value;
            size = Math.round(m.getFloatValue((short)0));
            osc.setGridLineWidth(size);
        }
        if ("grid-color".equals(property) && value.getCssValueType() == 1) {
            newColor = (Color)engine.convert(value, Color.class, (Object)osc.getDisplay());
            osc.setGridForeground(newColor);
        }
        if ("grid-background-color".equals(property) && value.getCssValueType() == 1) {
            newColor = (Color)engine.convert(value, Color.class, (Object)osc.getDisplay());
            osc.setGridBackground(newColor);
        }
        if (property != null && property.startsWith("channel-color-") && value.getCssValueType() == 1) {
            newColor = (Color)engine.convert(value, Color.class, (Object)osc.getDisplay());
            osc.setForeground(this.extractChannel(property), newColor);
        }
        if (property != null && property.startsWith("channel-active-color-") && value.getCssValueType() == 1) {
            newColor = (Color)engine.convert(value, Color.class, (Object)osc.getDisplay());
            osc.getDispatcher(this.extractChannel(property)).setActiveForegoundColor(newColor);
        }
        if (property != null && property.startsWith("channel-inactive-color-") && value.getCssValueType() == 1) {
            newColor = (Color)engine.convert(value, Color.class, (Object)osc.getDisplay());
            osc.getDispatcher(this.extractChannel(property)).setInactiveForegoundColor(newColor);
        }
        return true;
    }

    private int extractChannel(String property) {
        if (property.endsWith("-")) {
            return 0;
        }
        int position = property.lastIndexOf("-");
        String extract = property.substring(position + 1);
        try {
            return Integer.valueOf(extract);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public String retrieveCSSProperty(Object element, String property, String pseudo, CSSEngine engine) throws Exception {
        return null;
    }
}

