/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.xviewer.example;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.nebula.widgets.xviewer.edit.DefaultXViewerControlFactory;
import org.eclipse.nebula.widgets.xviewer.edit.XViewerControlFactory;
import org.eclipse.nebula.widgets.xviewer.edit.XViewerConverter;
import org.eclipse.nebula.widgets.xviewer.edit.XViewerEditAdapter;
import org.eclipse.nebula.widgets.xviewer.edit.XViewerMultiEditAdapter;
import org.eclipse.nebula.widgets.xviewer.example.MyDefaultCustomizations;
import org.eclipse.nebula.widgets.xviewer.example.MyXViewer;
import org.eclipse.nebula.widgets.xviewer.example.MyXViewerContentProvider;
import org.eclipse.nebula.widgets.xviewer.example.MyXViewerConverter;
import org.eclipse.nebula.widgets.xviewer.example.MyXViewerFactory;
import org.eclipse.nebula.widgets.xviewer.example.MyXViewerLabelProvider;
import org.eclipse.nebula.widgets.xviewer.example.images.MyImageCache;
import org.eclipse.nebula.widgets.xviewer.example.model.ISomeTask;
import org.eclipse.nebula.widgets.xviewer.example.model.SomeTask;
import org.eclipse.nebula.widgets.xviewer.util.XViewerDisplay;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class MyXViewerTest {
    static MyXViewer myXviewer;
    private static Date date;

    static {
        date = new Date();
    }

    public static void main(String[] args) {
        Display Display_1 = Display.getCurrent();
        boolean displayCreated = false;
        if (Display_1 == null) {
            Display_1 = Display.getDefault();
            displayCreated = true;
        } else {
            Display_1 = Display.getDefault();
        }
        Shell Shell_1 = new Shell(Display_1, 1264);
        Shell_1.setText("XViewer Test");
        Shell_1.setBounds(0, 0, 1000, 500);
        Shell_1.setLayout((Layout)new GridLayout());
        Shell_1.setLayoutData((Object)new GridData(1840));
        Composite toolBarComposite = new Composite((Composite)Shell_1, 0);
        toolBarComposite.setLayout((Layout)new GridLayout(2, false));
        toolBarComposite.setLayoutData((Object)new GridData(768));
        XViewerDisplay.setStandaloneXViewer((boolean)true, (Display)Display_1);
        myXviewer = new MyXViewer(Shell_1, 67586);
        myXviewer.getTree().setLayoutData((Object)new GridData(1808));
        myXviewer.setContentProvider((IContentProvider)new MyXViewerContentProvider());
        myXviewer.setLabelProvider((IBaseLabelProvider)new MyXViewerLabelProvider(myXviewer));
        DefaultXViewerControlFactory cFactory = new DefaultXViewerControlFactory();
        MyXViewerConverter converter = new MyXViewerConverter();
        myXviewer.setXViewerEditAdapter((XViewerEditAdapter)new XViewerMultiEditAdapter((XViewerControlFactory)cFactory, (XViewerConverter)converter));
        MyXViewerTest.createTaskActionBar(toolBarComposite);
        ArrayList<ISomeTask> tasks = new ArrayList<ISomeTask>();
        int x = 0;
        while (x < 1) {
            tasks.addAll(MyXViewerTest.getTestTasks());
            ++x;
        }
        myXviewer.setInputXViewer(tasks);
        Shell_1.open();
        while (!Shell_1.isDisposed()) {
            if (Display_1.readAndDispatch()) continue;
            Display_1.sleep();
        }
        if (displayCreated) {
            Display_1.dispose();
        }
    }

    public static void createTaskActionBar(Composite parent) {
        Composite actionComp = new Composite(parent, 0);
        actionComp.setLayout((Layout)new GridLayout());
        actionComp.setLayoutData((Object)new GridData(3));
        ToolBar toolBar = new ToolBar(actionComp, 0x820000);
        GridData gd = new GridData(768);
        toolBar.setLayoutData((Object)gd);
        ToolItem refreshItem = new ToolItem(toolBar, 8);
        refreshItem.setImage(MyImageCache.getImage("refresh.gif"));
        refreshItem.setToolTipText("Refresh");
        refreshItem.addListener(13, e -> {
            ArrayList<ISomeTask> tasks = new ArrayList<ISomeTask>();
            int x = 0;
            while (x < 1) {
                tasks.addAll(MyXViewerTest.getTestTasks());
                ++x;
            }
            myXviewer.setInputXViewer(tasks);
        });
        Action dropDownAction = myXviewer.getCustomizeAction();
        new ActionContributionItem((IAction)dropDownAction).fill(toolBar, 0);
        ToolItem descriptionItem = new ToolItem(toolBar, 8);
        descriptionItem.setImage(MyImageCache.getImage("descriptionView.gif"));
        descriptionItem.setToolTipText("Show Description View");
        descriptionItem.addListener(13, e -> {
            myXviewer.getCustomizeMgr().loadCustomization(MyDefaultCustomizations.getDescriptionCustomization());
            myXviewer.refresh();
        });
        ToolItem completeItem = new ToolItem(toolBar, 8);
        completeItem.setImage(MyImageCache.getImage("completionView.gif"));
        completeItem.setToolTipText("Show Completion View");
        completeItem.addListener(13, e -> {
            myXviewer.getCustomizeMgr().loadCustomization(MyDefaultCustomizations.getCompletionCustomization());
            myXviewer.refresh();
        });
        ToolItem refreshSingleColumn = new ToolItem(toolBar, 8);
        refreshSingleColumn.setImage(MyImageCache.getImage("columnRefresh.gif"));
        refreshSingleColumn.setToolTipText("Example of Refreshing a Single Column");
        refreshSingleColumn.addListener(13, e -> {
            List items = (List)myXviewer.getInput();
            for (Object item : items) {
                SomeTask task = (SomeTask)item;
                task.setTaskType(ISomeTask.TaskType.Refreshed);
            }
            String columnId = MyXViewerFactory.Task_Type.getId();
            myXviewer.refreshColumn(columnId);
        });
    }

    private static Date getDate() {
        date = new Date(date.getTime() + 0x6DDD00L);
        return date;
    }

    private static List<ISomeTask> getTestTasks() {
        ArrayList<ISomeTask> tasks = new ArrayList<ISomeTask>();
        SomeTask task = new SomeTask(ISomeTask.RunDb.Test_Db, ISomeTask.TaskType.Backup, MyXViewerTest.getDate(), "org.eclipse.osee.test1", "10:03", "run to test this", "Suite A", "mark@eclipse.com", 50, 50000L);
        tasks.add(task);
        int x = 0;
        while (x < 5) {
            task.addChild(new SomeTask(ISomeTask.RunDb.Test_Db, ISomeTask.TaskType.Backup, MyXViewerTest.getDate(), "org.eclipse.osee.test33", "10:03", "run to test isit this - child " + x, "Suite A", "mark@eclipse.com", 50, 9223336854775807L));
            ++x;
        }
        tasks.add(new SomeTask(ISomeTask.RunDb.Production_Db, ISomeTask.TaskType.Data_Exchange, MyXViewerTest.getDate(), "org.eclipse.osee.test2", "9:22", "run to test that", "Suite B", "john@eclipse.com", 0, 50000L));
        tasks.add(new SomeTask(ISomeTask.RunDb.Production_Db, ISomeTask.TaskType.Backup, MyXViewerTest.getDate(), "org.eclipse.osee.test4", "8:23", "in this world", "Suite A", "john@eclipse.com", 50, 50000L));
        tasks.add(new SomeTask(ISomeTask.RunDb.Test_Db, ISomeTask.TaskType.Backup, MyXViewerTest.getDate(), "org.eclipse.osee.test3", "23:01", "now is the time", "Suite B", "mike@eclipse.com", 30, Long.MAX_VALUE));
        tasks.add(new SomeTask(ISomeTask.RunDb.Production_Db, ISomeTask.TaskType.Db_Health, MyXViewerTest.getDate(), "org.eclipse.osee.test5", "7:32", "may be never", "Suite A", "steve@eclipse.com", 10, 50000L));
        tasks.add(new SomeTask(ISomeTask.RunDb.Test_Db, ISomeTask.TaskType.Data_Exchange, MyXViewerTest.getDate(), "org.eclipse.osee.test14", "6:11", "", "Suite A", "steve@eclipse.com", 95, 50000L));
        tasks.add(new SomeTask(ISomeTask.RunDb.Production_Db, ISomeTask.TaskType.Backup, MyXViewerTest.getDate(), "org.eclipse.osee.test6", "5:13", "run to test this", "Suite B", "john@eclipse.com", 80, 50000L));
        tasks.add(new SomeTask(ISomeTask.RunDb.Test_Db, ISomeTask.TaskType.Db_Health, MyXViewerTest.getDate(), "org.eclipse.osee.test12", "23:15", "", "Suite A", "mike@eclipse.com", 90, 50000L));
        tasks.add(new SomeTask(ISomeTask.RunDb.Production_Db, ISomeTask.TaskType.Backup, MyXViewerTest.getDate(), "org.eclipse.osee.test13", "4:01", "run to test this", "Suite B", "steve@eclipse.com", 100, 50000L));
        tasks.add(new SomeTask(ISomeTask.RunDb.Production_Db, ISomeTask.TaskType.Data_Exchange, MyXViewerTest.getDate(), "org.eclipse.osee.test11", "3:16", "run to test this", "Suite A", "steve@eclipse.com", 53, 50000000000L));
        tasks.add(new SomeTask(ISomeTask.RunDb.Test_Db, ISomeTask.TaskType.Backup, MyXViewerTest.getDate(), "org.eclipse.osee.test10", "5:01", "run to test this", "Suite C", "mike@eclipse.com", 0, 50000L));
        tasks.add(new SomeTask(ISomeTask.RunDb.Production_Db, ISomeTask.TaskType.Data_Exchange, MyXViewerTest.getDate(), "org.eclipse.osee.test9", "4:27", "run to test this", "Suite C", "steve@eclipse.com", 90, 50000L));
        tasks.add(new SomeTask(ISomeTask.RunDb.Production_Db, ISomeTask.TaskType.Regression, MyXViewerTest.getDate(), "org.eclipse.osee.test7", "2:37", "run to test this", "Suite C", "john@eclipse.com", 20, 50000L));
        int num = 10;
        for (String str : Arrays.asList("Now", "Cat", "Dog", "Tree", "Bike", "Sun", "Moon", "Grass", "Can", "Car", "Truck", "Block", "Earth", "Mars", "Venus", "Requirements visualization", "Requirements management", "Feature management", "Modeling", "Design", "Project Management", "Change management", "Configuration Management", "Software Information Management", "Build management", "Testing", "Release Management", "Software Deployment", "Issue management", "Monitoring and reporting", "Workflow")) {
            tasks.add(new SomeTask(ISomeTask.RunDb.Test_Db, ISomeTask.TaskType.Db_Health, MyXViewerTest.getDate(), "org.eclipse.osee." + str, "24:" + num++, String.valueOf(str) + " will run to test this", "Suite C" + num++, String.valueOf(str.toLowerCase().replaceAll(" ", ".")) + "@eclipse.com", 20, 340000L));
        }
        return tasks;
    }
}

