/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.visualization.xygraph.linearscale;

import java.util.ArrayList;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.nebula.visualization.xygraph.linearscale.IScaleProvider;
import org.eclipse.nebula.visualization.xygraph.linearscale.ITicksProvider;
import org.eclipse.nebula.visualization.xygraph.linearscale.LinearScaleTicks;
import org.eclipse.nebula.visualization.xygraph.linearscale.Range;
import org.eclipse.swt.graphics.Font;

public class LinearScaleTickLabels
extends Figure {
    protected static final String MINUS = "-";
    private ITicksProvider ticks;
    private IScaleProvider scale;

    public LinearScaleTickLabels(IScaleProvider linearScale) {
        this(linearScale, new LinearScaleTicks(linearScale));
    }

    public LinearScaleTickLabels(IScaleProvider linearScale, ITicksProvider ticks) {
        this.scale = linearScale;
        this.ticks = ticks;
        this.setFont(this.scale.getFont());
        this.setForegroundColor(this.scale.getForegroundColor());
    }

    public ITicksProvider getTicksProvider() {
        return this.ticks;
    }

    protected void setTicksProvider(ITicksProvider ticks) {
        this.ticks = ticks;
    }

    public int getGridStepInPixel() {
        if (this.ticks instanceof LinearScaleTicks) {
            return ((LinearScaleTicks)this.ticks).getGridStepInPixels();
        }
        return -1;
    }

    public ArrayList<Integer> getTickLabelPositions() {
        if (this.ticks != null) {
            return new ArrayList<Integer>(this.ticks.getPositions());
        }
        return null;
    }

    public ArrayList<Boolean> getTickVisibilities() {
        if (this.ticks != null) {
            return new ArrayList<Boolean>(this.ticks.getVisibilities());
        }
        return null;
    }

    protected void drawXTick(Graphics graphics) {
        graphics.setFont(this.scale.getFont());
        int i = 0;
        while (i < this.ticks.getPositions().size()) {
            if (this.ticks.isVisible(i)) {
                String text = this.ticks.getLabel(i);
                int fontWidth = FigureUtilities.getTextExtents((String)text, (Font)this.getFont()).width;
                int x = (int)Math.ceil((double)this.ticks.getLabelPosition(i) - (double)fontWidth / 2.0);
                graphics.drawText(text, x, 0);
            }
            ++i;
        }
    }

    protected void drawYTick(Graphics graphics) {
        graphics.setFont(this.scale.getFont());
        int fontHeight = this.ticks.getMaxHeight();
        int i = 0;
        while (i < this.ticks.getPositions().size()) {
            if (this.ticks.getLabels().isEmpty()) break;
            if (this.ticks.isVisible(i)) {
                String label = this.ticks.getLabel(i);
                int x = 0;
                if (this.ticks.getLabel(0).startsWith(MINUS) && !label.startsWith(MINUS)) {
                    x += FigureUtilities.getTextExtents((String)MINUS, (Font)this.getFont()).width;
                }
                int y = (int)Math.ceil((double)(this.scale.getLength() - this.ticks.getPosition(i)) - (double)fontHeight / 2.0);
                graphics.drawText(label, x, y);
            }
            ++i;
        }
    }

    protected void paintClientArea(Graphics graphics) {
        graphics.translate(this.bounds.x, this.bounds.y);
        graphics.setFont(this.getFont());
        if (this.scale.isHorizontal()) {
            this.drawXTick(graphics);
        } else {
            this.drawYTick(graphics);
        }
        super.paintClientArea(graphics);
    }

    public boolean isShowMinLabel() {
        return this.ticks.isShowMinLabel();
    }

    public void setShowMinLabel(boolean showMinLabel) {
        this.ticks.setShowMinLabel(showMinLabel);
    }

    public boolean isShowMaxLabel() {
        return this.ticks.isShowMaxLabel();
    }

    public void setShowMaxLabel(boolean showMaxLabel) {
        this.ticks.setShowMaxLabel(showMaxLabel);
    }

    public int getTickLabelMaxLength() {
        return this.ticks.getMaxWidth();
    }

    public int getTickLabelMaxHeight() {
        return this.ticks.getMaxHeight();
    }

    public IScaleProvider getScale() {
        return this.scale;
    }

    public void setScale(IScaleProvider scale) {
        this.scale = scale;
    }

    public Range update(int length) {
        Range range = this.scale.getScaleRange();
        return this.ticks.update(range.getLower(), range.getUpper(), length);
    }
}

