/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.compositetable;

import org.eclipse.nebula.widgets.compositetable.AbstractGridRowLayout;
import org.eclipse.nebula.widgets.compositetable.ColumnControlListener;
import org.eclipse.nebula.widgets.compositetable.CompositeTableLayout;
import org.eclipse.nebula.widgets.compositetable.GridRowLayout;
import org.eclipse.nebula.widgets.compositetable.HeaderLayout;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public class ResizableGridRowLayout
extends GridRowLayout {
    private AbstractGridRowLayout delegate = null;
    private int[] columnOrder;
    private Composite control;

    @Override
    protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
        this.control = composite;
        this.getLayoutDelegate(composite);
        return super.computeSize(composite, wHint, hHint, flushCache);
    }

    @Override
    protected void layout(Composite composite, boolean flushCache) {
        this.control = composite;
        this.getLayoutDelegate(composite);
        super.layout(composite, flushCache);
    }

    @Override
    public int[] getWeights() {
        if (this.delegate == null) {
            return super.getWeights();
        }
        return this.delegate.getWeights();
    }

    @Override
    public AbstractGridRowLayout setWeights(int[] weights) {
        if (this.delegate == null) {
            return super.setWeights(weights);
        }
        return this.delegate.setWeights(weights);
    }

    @Override
    public int getSumOfAllWeights() {
        if (this.delegate == null) {
            return super.getSumOfAllWeights();
        }
        return this.delegate.getSumOfAllWeights();
    }

    @Override
    public boolean isFittingHorizontally() {
        if (this.delegate == null) {
            return super.isFittingHorizontally();
        }
        return this.delegate.isFittingHorizontally();
    }

    @Override
    public AbstractGridRowLayout setFittingHorizontally(boolean fittingHorizontally) {
        if (this.delegate == null) {
            return super.setFittingHorizontally(fittingHorizontally);
        }
        return this.delegate.setFittingHorizontally(fittingHorizontally);
    }

    @Override
    protected Widget getColumnAt(Composite rowOrHeader, int offset) {
        if (this.columnOrder == null) {
            return super.getColumnAt(rowOrHeader, offset);
        }
        Control[] children = rowOrHeader.getChildren();
        return children[this.columnOrder[offset]];
    }

    private CompositeTableLayout getLayoutDelegate(Composite composite) {
        if (this.delegate != null) {
            return this.delegate;
        }
        this.findHeader(composite);
        if (this.delegate != null) {
            return this.delegate;
        }
        this.createNullLayout(composite);
        return this.delegate;
    }

    private void createNullLayout(Composite composite) {
        int numChildren = composite.getChildren().length;
        this.delegate = new GridRowLayout(new int[numChildren], true);
    }

    private void findHeader(Composite row) {
        Control[] children = row.getParent().getChildren();
        int i = 0;
        while (i < children.length) {
            Composite child;
            Layout layout;
            if (children[i] instanceof Composite && (layout = (child = (Composite)children[i]).getLayout()) instanceof HeaderLayout) {
                this.delegate = (HeaderLayout)layout;
                this.addListenersToDelegate(row, (HeaderLayout)layout);
                return;
            }
            ++i;
        }
    }

    private void addListenersToDelegate(Composite row, HeaderLayout delegate) {
        delegate.addColumnControlListener(new GridColumnControlListener(row));
    }

    private class GridColumnControlListener
    extends ColumnControlListener {
        private final Composite row;
        private int savedResizedColNum;
        private int savedResizedColWidth;
        private int savedColToRightOfResizedColWidth;
        boolean runnableQueueIsClear = true;

        public GridColumnControlListener(Composite row) {
            this.row = row;
        }

        @Override
        public void columnMoved(int[] newColumnOrder) {
            ResizableGridRowLayout.this.columnOrder = newColumnOrder;
            ResizableGridRowLayout.this.control.layout(true);
        }

        @Override
        public void columnResized(int resizedColumnPosition, int resizedColumnWidth, int columnToTheRightOfResizedColumnWidth) {
            this.savedResizedColNum = resizedColumnPosition;
            this.savedResizedColWidth = resizedColumnWidth;
            this.savedColToRightOfResizedColWidth = columnToTheRightOfResizedColumnWidth;
            if (this.runnableQueueIsClear) {
                this.runnableQueueIsClear = false;
                this.row.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (GridColumnControlListener.this.row.isDisposed()) {
                            return;
                        }
                        GridColumnControlListener.this.row.getChildren();
                        Control resizedColumn = (Control)ResizableGridRowLayout.this.getColumnAt(GridColumnControlListener.this.row, GridColumnControlListener.this.savedResizedColNum);
                        Point resizedColumnSize = resizedColumn.getSize();
                        int adjustedResizedColumnWidth = GridColumnControlListener.this.savedResizedColWidth - 4;
                        int resizedColumnWidthChange = adjustedResizedColumnWidth - resizedColumnSize.x;
                        resizedColumn.setSize(adjustedResizedColumnWidth, resizedColumnSize.y);
                        Control columnToTheRightOfResizedColumn = (Control)ResizableGridRowLayout.this.getColumnAt(GridColumnControlListener.this.row, GridColumnControlListener.this.savedResizedColNum + 1);
                        Rectangle rightBounds = columnToTheRightOfResizedColumn.getBounds();
                        columnToTheRightOfResizedColumn.setBounds(rightBounds.x + resizedColumnWidthChange, rightBounds.y, GridColumnControlListener.this.savedColToRightOfResizedColWidth, rightBounds.height);
                        GridColumnControlListener.this.runnableQueueIsClear = true;
                    }
                });
            }
        }
    }
}

