/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.formattedtext;

import org.eclipse.nebula.widgets.formattedtext.AbstractFormatter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.VerifyEvent;

public class MaskFormatter
extends AbstractFormatter {
    private static final char P_DIGIT = '#';
    private static final char P_ALPHANUM = 'A';
    private static final char P_UPPERCASE = 'U';
    private static final char P_LOWERCASE = 'L';
    private static final char P_UHEXDIGIT = 'X';
    private static final char P_LHEXDIGIT = 'x';
    protected String editPattern;
    protected StringBuffer editValue;
    protected int positions;
    protected int count = 0;

    public MaskFormatter(String editPattern) {
        if (editPattern == null) {
            SWT.error((int)4);
        }
        this.editPattern = editPattern;
        this.editValue = new StringBuffer(editPattern.length());
        int i = 0;
        while (i < editPattern.length()) {
            char c = editPattern.charAt(i);
            if (c != '#' && c != 'A' && c != 'U' && c != 'L' && c != 'X' && c != 'x') {
                this.editValue.append(c);
            } else {
                this.editValue.append(' ');
                ++this.positions;
            }
            ++i;
        }
    }

    protected void clearText(int start, int len) {
        int i = start;
        while (i < start + len && i < this.editValue.length()) {
            char c = this.editPattern.charAt(i);
            if (c == '#' || c == 'A' || c == 'U' || c == 'L' || c == 'X' || c == 'x') {
                if (this.editValue.charAt(i) != ' ') {
                    --this.count;
                }
                this.editValue.setCharAt(i, ' ');
            }
            ++i;
        }
    }

    @Override
    public String getDisplayString() {
        return this.getEditString();
    }

    @Override
    public String getEditString() {
        return this.editValue.toString();
    }

    @Override
    public Object getValue() {
        StringBuffer value = new StringBuffer(this.editValue.length());
        int i = 0;
        while (i < this.editValue.length()) {
            char c = this.editPattern.charAt(i);
            if (c == '#' || c == 'A' || c == 'U' || c == 'L' || c == 'X' || c != 'x') {
                value.append(this.editValue.charAt(i));
            }
            ++i;
        }
        return value.toString();
    }

    public Class<String> getValueType() {
        return String.class;
    }

    protected int insertText(String txt, int start) {
        int i = start;
        int j = 0;
        block8: while (i < this.editPattern.length() && j < txt.length()) {
            char p = this.editPattern.charAt(i);
            char c = txt.charAt(j);
            int o = this.editValue.charAt(i);
            switch (p) {
                case '#': {
                    if (Character.isDigit(c)) {
                        this.editValue.setCharAt(i, c);
                        break;
                    }
                    SWT.error((int)5);
                    break;
                }
                case 'U': {
                    if (Character.isLetterOrDigit(c)) {
                        this.editValue.setCharAt(i, Character.toUpperCase(c));
                        break;
                    }
                    SWT.error((int)5);
                    break;
                }
                case 'L': {
                    if (Character.isLetterOrDigit(c)) {
                        this.editValue.setCharAt(i, Character.toLowerCase(c));
                        break;
                    }
                    SWT.error((int)5);
                    break;
                }
                case 'A': {
                    if (Character.isLetterOrDigit(c)) {
                        this.editValue.setCharAt(i, c);
                        break;
                    }
                    SWT.error((int)5);
                    break;
                }
                case 'X': {
                    if (this.isHexDigit(c)) {
                        this.editValue.setCharAt(i, Character.toUpperCase(c));
                        break;
                    }
                    SWT.error((int)5);
                    break;
                }
                case 'x': {
                    if (this.isHexDigit(c)) {
                        this.editValue.setCharAt(i, Character.toLowerCase(c));
                        break;
                    }
                    SWT.error((int)5);
                    break;
                }
                default: {
                    if (p != c) {
                        if (Character.isLetterOrDigit(c)) {
                            ++i;
                            continue block8;
                        }
                        SWT.error((int)5);
                    }
                    o = 42;
                }
            }
            if (o == 32 && c != ' ') {
                ++this.count;
            }
            ++i;
            ++j;
        }
        return i;
    }

    @Override
    public boolean isEmpty() {
        return this.count == 0;
    }

    @Override
    public boolean isValid() {
        return this.count == 0 || this.count == this.positions;
    }

    @Override
    public void setValue(Object value) {
        if (value instanceof String) {
            this.insertText((String)value, 0);
            this.updateText(this.editValue.toString(), 0);
        } else if (value == null) {
            this.clearText(0, this.editValue.length());
        } else {
            SWT.error((int)5);
        }
    }

    public void verifyText(VerifyEvent e) {
        if (this.ignore) {
            return;
        }
        e.doit = false;
        if (e.keyCode == 8 || e.keyCode == 127) {
            this.clearText(e.start, e.end > e.start ? e.end - e.start : 1);
            this.updateText(this.editValue.toString(), e.start);
        } else {
            char c;
            int p;
            try {
                p = this.insertText(e.text, e.start);
                if (e.end - e.start > e.text.length()) {
                    this.clearText(e.start + e.text.length(), e.end - e.start - e.text.length());
                }
            }
            catch (IllegalArgumentException iae) {
                this.beep();
                p = e.start;
            }
            while (p < this.editPattern.length() && (c = this.editPattern.charAt(p)) != '#' && c != 'A' && c != 'U' && c != 'L' && c != 'X' && c != 'x') {
                ++p;
            }
            this.updateText(this.editValue.toString(), p);
        }
    }

    protected boolean isHexDigit(char ch) {
        boolean test = false;
        try {
            test = (double)Character.digit(ch, 16) > -1.0;
        }
        catch (Exception e) {
            return false;
        }
        return test;
    }
}

