/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.geomap.jface.example;

import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.nebula.examples.AbstractExampleTab;
import org.eclipse.nebula.widgets.geomap.OsmTileServer;
import org.eclipse.nebula.widgets.geomap.PointD;
import org.eclipse.nebula.widgets.geomap.TileServer;
import org.eclipse.nebula.widgets.geomap.jface.GeoMapViewer;
import org.eclipse.nebula.widgets.geomap.jface.GoogleMapsSearchServer;
import org.eclipse.nebula.widgets.geomap.jface.IToolTipProvider;
import org.eclipse.nebula.widgets.geomap.jface.LabelImageProvider;
import org.eclipse.nebula.widgets.geomap.jface.Located;
import org.eclipse.nebula.widgets.geomap.jface.LocationProvider;
import org.eclipse.nebula.widgets.geomap.jface.OsmSearchServer;
import org.eclipse.nebula.widgets.geomap.jface.SearchServer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class GeoMapViewerExampleTab
extends AbstractExampleTab {
    private GeoMapViewer geoMapViewer;
    private ListViewer contentViewer;
    private SearchServer[] searchServers = new SearchServer[]{new OsmSearchServer(), new GoogleMapsSearchServer()};
    private String[] searchServerNames = new String[]{"OSM Nomination", "Google Maps"};
    private ContributorLocation[] contributorLocations = new ContributorLocation[]{new ContributorLocation("Hallvard Traetteberg", new PointD(10.4234, 63.4242), "Trondheim, Norway", true), new ContributorLocation("Stepan Rutz", new PointD(6.8222, 50.9178), "Frechen, Germany", false), new ContributorLocation("Wim Jongman", new PointD(4.641, 52.3894), "Haarlem, Netherlands", true), new ContributorLocation("Dirk Fauth", new PointD(9.1858, 48.7775), "Stuttgart, Germany", true), new ContributorLocation("Tom Schindl", new PointD(11.4, 47.2671), "Innsbruck, Austria", true), new ContributorLocation("Matthew Hall", new PointD(-111.97, 40.54), "Riverton, Utah, USA", true), new ContributorLocation("Justin Dolezy", new PointD(-0.34, 51.48), "Richmond, Surrey, UK", true), new ContributorLocation("Edwin Park", new PointD(-74.07, 40.76), "Hoboken, New Jersey, USA", true), new ContributorLocation("Mickael Istria", new PointD(5.7349, 45.1872), "Grenoble, France", true)};
    private LabelImageProvider labelProvider = new LabelImageProvider(){
        private RGB contributorColor = new RGB(255, 250, 200);
        private RGB committerColor = new RGB(200, 255, 200);

        public Image getImage(Object element) {
            if (element instanceof SearchServer.Result) {
                this.setFillColor(this.committerColor);
            } else if (element instanceof ContributorLocation) {
                this.setFillColor(((ContributorLocation)((Object)element)).committer ? this.committerColor : this.contributorColor);
            }
            return super.getImage(element);
        }

        public String getText(Object element) {
            if (element instanceof SearchServer.Result) {
                return ((SearchServer.Result)element).getName();
            }
            if (element instanceof ContributorLocation) {
                ContributorLocation contributorLocation = (ContributorLocation)((Object)element);
                return contributorLocation.name;
            }
            return null;
        }

        public Object getToolTip(Object element) {
            if (element instanceof SearchServer.Result) {
                SearchServer.Result result = (SearchServer.Result)element;
                PointD lonLat = result.getLonLat();
                return String.valueOf(result.getText()) + " @ " + lonLat.x + "," + lonLat.y;
            }
            if (element instanceof ContributorLocation) {
                return ((ContributorLocation)((Object)element)).toString();
            }
            return null;
        }
    };

    public Control createControl(Composite parent) {
        this.geoMapViewer = new GeoMapViewer(parent, 0);
        this.configureMapViewer();
        return this.geoMapViewer.getControl();
    }

    public String[] createLinks() {
        return new String[]{"<a href=\"http://www.eclipse.org/nebula/widgets/geomap/geomap.php\">GeoMap Home Page</a>", "<a href=\"http://www.eclipse.org/nebula/widgets/geomap/snippets.php\">Snippets</a>", "<a href=\"https://bugs.eclipse.org/bugs/buglist.cgi?query_format=advanced&short_desc_type=allwordssubstr&short_desc=&classification=Technology&product=Nebula&component=GeoMap&long_desc_type=allwordssubstr&long_desc=&bug_file_loc_type=allwordssubstr&bug_file_loc=&status_whiteboard_type=allwordssubstr&status_whiteboard=&keywords_type=allwords&keywords=&emailtype1=substring&email1=&emailtype2=substring&email2=&bugidtype=include&bug_id=&votes=&chfieldfrom=&chfieldto=Now&chfieldvalue=&cmdtype=doit&order=Reuse+same+sort+as+last+time&field0-0-0=noop&type0-0-0=noop&value0-0-0=\">Bugs</a>"};
    }

    public void createParameters(Composite parent) {
        GridLayoutFactory.swtDefaults().margins(0, 0).numColumns(1).applyTo(parent);
        Group group = new Group(parent, 0);
        group.setText("Interaction");
        group.setLayoutData((Object)new GridData(4, 4, false, false));
        group.setLayout((Layout)new GridLayout(2, false));
        Label tileServerLabel = new Label((Composite)group, 0);
        tileServerLabel.setText("Tile server: ");
        tileServerLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        final Combo tileServerControl = new Combo((Composite)group, 0);
        tileServerControl.setItems(new String[]{"http://tile.openstreetmap.org/{0}/{1}/{2}.png", "http://mt1.google.com/vt/lyrs=m@129&hl=en&s=Galileo&z={0}&x={1}&y={2}"});
        tileServerControl.setLayoutData((Object)new GridData(4, 4, false, false));
        tileServerControl.select(0);
        tileServerControl.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String selection = tileServerControl.getItem(tileServerControl.getSelectionIndex());
                GeoMapViewerExampleTab.this.geoMapViewer.getGeoMap().setTileServer(new TileServer(selection, 15));
            }
        });
        Label moveSelectionModeLabel = new Label((Composite)group, 0);
        moveSelectionModeLabel.setText("Move selection mode: ");
        moveSelectionModeLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        final Combo moveSelectionModeControl = new Combo((Composite)group, 8);
        moveSelectionModeControl.setItems(new String[]{"Cannot move selection", "Allow, check readonly on mouse down", "Allow, just try to set new location"});
        moveSelectionModeControl.setLayoutData((Object)new GridData(4, 4, false, false));
        moveSelectionModeControl.select(1);
        moveSelectionModeControl.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GeoMapViewerExampleTab.this.geoMapViewer.setMoveSelectionMode(moveSelectionModeControl.getSelectionIndex());
            }
        });
        Label clipRuleLabel = new Label((Composite)group, 0);
        clipRuleLabel.setText("Clip rule: ");
        clipRuleLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        final Combo clipRuleControl = new Combo((Composite)group, 8);
        clipRuleControl.setItems(new String[]{"Don't clip", "Clip on element position", "Clip in image bounds"});
        clipRuleControl.setLayoutData((Object)new GridData(4, 4, false, false));
        clipRuleControl.select(1);
        clipRuleControl.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GeoMapViewerExampleTab.this.geoMapViewer.setClipRule(clipRuleControl.getSelectionIndex());
            }
        });
        this.addLabel("Search: ", (Composite)group);
        final Text searchText = new Text((Composite)group, 384);
        searchText.setLayoutData((Object)new GridData(4, 4, false, false));
        this.addLabel("With: ", (Composite)group);
        final Combo searchServerControl = new Combo((Composite)group, 8);
        searchServerControl.setItems(this.searchServerNames);
        searchServerControl.setLayoutData((Object)new GridData(4, 4, false, false));
        searchServerControl.select(0);
        searchText.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                if (e.detail == 256) {
                    GeoMapViewerExampleTab.this.setViewerInputs((Object[])GeoMapViewerExampleTab.this.contributorLocations);
                } else {
                    GeoMapViewerExampleTab.this.doSearch(searchText.getText(), searchServerControl.getSelectionIndex());
                }
            }
        });
        this.addLabel("Contents: ", (Composite)group).setLayoutData((Object)new GridData(16384, 128, false, false));
        this.contentViewer = new ListViewer((Composite)group, 0);
        this.contentViewer.getControl().setLayoutData((Object)new GridData(16384, 128, false, true, 1, 1));
        this.contentViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.contentViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                String text = GeoMapViewerExampleTab.this.labelProvider.getText(element);
                if (GeoMapViewerExampleTab.this.labelProvider instanceof IToolTipProvider) {
                    text = String.valueOf(text) + " (" + GeoMapViewerExampleTab.this.labelProvider.getToolTip(element) + ")";
                }
                return text;
            }
        });
        this.contentViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                GeoMapViewerExampleTab.this.geoMapViewer.setSelection(event.getSelection(), true);
            }
        });
        this.setViewerInputs((Object[])this.contributorLocations);
    }

    private void doSearch(String search, int selectionIndex) {
        SearchServer server = this.searchServers[selectionIndex];
        Object[] results = server.doSearch(search);
        if (results != null) {
            this.setViewerInputs(results);
        }
    }

    public void reveal() {
        this.setViewerInputs((Object[])this.contributorLocations);
    }

    private void setViewerInputs(Object[] results) {
        if (this.geoMapViewer != null && this.geoMapViewer.getContentProvider() != null) {
            this.geoMapViewer.setInput((Object)results);
            this.geoMapViewer.revealAll();
        }
        if (this.contentViewer != null && this.contentViewer.getContentProvider() != null) {
            this.contentViewer.setInput((Object)results);
        }
    }

    private Label addLabel(String text, Composite composite) {
        Label label = new Label(composite, 0);
        label.setText(text);
        label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        return label;
    }

    public boolean getInitialHorizontalFill() {
        return true;
    }

    public boolean getInitialVerticalFill() {
        return true;
    }

    private void configureMapViewer() {
        this.geoMapViewer.getGeoMap().setTileServer((TileServer)OsmTileServer.TILESERVERS[0]);
        this.geoMapViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.geoMapViewer.setLocationProvider(new LocationProvider(){

            public PointD getLonLat(Object element) {
                if (element instanceof Located) {
                    return ((Located)element).getLonLat();
                }
                return null;
            }

            public boolean setLonLat(Object element, double lon, double lat) {
                if (element instanceof Located) {
                    ((Located)element).setLonLat(lon, lat);
                    return true;
                }
                return false;
            }
        });
        this.geoMapViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.geoMapViewer.getControl().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                GeoMapViewerExampleTab.this.setViewerInputs((Object[])GeoMapViewerExampleTab.this.contributorLocations);
            }
        });
    }

    private static class ContributorLocation
    extends Located.Static {
        public final String name;
        public PointD location;
        public final String locationText;
        public final boolean committer;

        public ContributorLocation(String name, PointD location, String locationText, boolean committer) {
            this.name = name;
            this.location = location;
            this.locationText = locationText;
            this.committer = committer;
        }

        public String toString() {
            return String.valueOf(this.name) + ", " + this.locationText + " @ " + this.location.x + ", " + this.location.y;
        }

        public PointD getLonLat() {
            return this.location;
        }
    }
}

