/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.geomap.internal;

import org.eclipse.nebula.widgets.geomap.internal.GeoMapHelper;
import org.eclipse.nebula.widgets.geomap.internal.GeoMapHelperListener;
import org.eclipse.nebula.widgets.geomap.internal.GeoMapPositioned;
import org.eclipse.nebula.widgets.geomap.internal.InternalGeoMapListener;
import org.eclipse.nebula.widgets.geomap.internal.TileRef;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

public class InternalGeoMap
extends Canvas
implements GeoMapPositioned,
GeoMapHelperListener {
    protected GeoMapHelper geoMapHelper;

    void redraw(TileRef tile) {
        this.redraw();
    }

    protected InternalGeoMap(Composite parent, int style, Point mapPosition, int zoom, int cacheSize) {
        super(parent, 0x20000000 | style);
        this.geoMapHelper = new GeoMapHelper(parent.getDisplay(), mapPosition, zoom, cacheSize);
        this.geoMapHelper.addGeoMapHelperListener(this);
        this.addDisposeListener(e -> this.geoMapHelper.dispose());
        this.addPaintListener(e -> this.paintControl(e));
    }

    @Override
    public void tileUpdated(TileRef tileRef) {
        if (!this.isDisposed()) {
            this.redraw();
        }
    }

    private void paintControl(PaintEvent e) {
        this.geoMapHelper.paint(e.gc, new Rectangle(e.x, e.y, e.width, e.height), this.getSize());
    }

    public void addInternalGeoMapListener(InternalGeoMapListener listener) {
        this.geoMapHelper.addInternalGeoMapListener(listener);
    }

    public void removeInternalGeoMapListener(InternalGeoMapListener listener) {
        this.geoMapHelper.removeInternalGeoMapListener(listener);
    }

    @Override
    public Point getMapPosition() {
        return this.geoMapHelper.getMapPosition();
    }

    @Override
    public void setMapPosition(int x, int y) {
        this.geoMapHelper.setMapPosition(x, y);
        this.redraw();
    }

    @Override
    public int getZoom() {
        return this.geoMapHelper.getZoom();
    }

    @Override
    public int getMinZoom() {
        return this.geoMapHelper.getMinZoom();
    }

    @Override
    public int getMaxZoom() {
        return this.geoMapHelper.getMaxZoom();
    }

    @Override
    public void setZoom(int zoom) {
        if (zoom == this.getZoom()) {
            return;
        }
        this.geoMapHelper.setZoom(zoom);
        this.redraw();
    }
}

