/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.opal.calculator;

import org.eclipse.nebula.widgets.opal.calculator.CalculatorButtonsComposite;

public class CalculatorButtonsBehaviourEngine {
    private final CalculatorButtonsComposite composite;

    public CalculatorButtonsBehaviourEngine(CalculatorButtonsComposite composite) {
        this.composite = composite;
    }

    public void processBackSpace() {
        if (this.composite.isReadyToEnterNewNumber()) {
            return;
        }
        String content = this.getContent();
        if (content.length() < 2) {
            return;
        }
        String newContent = content.substring(0, content.length() - 2);
        this.setContent(newContent.length() == 0 ? "0" : newContent);
        this.composite.setReadyToEnterNewNumber(false);
    }

    private String getContent() {
        return this.composite.getDisplayArea().getText();
    }

    private void setContent(String newContent) {
        this.composite.getDisplayArea().setText(newContent);
        this.composite.fireModifyListeners();
    }

    public void clearResult() {
        this.setContent("0");
    }

    public void addDecimalPoint() {
        if (this.composite.isReadyToEnterNewNumber()) {
            return;
        }
        String content = this.getContent();
        if (content.indexOf(46) > 0) {
            return;
        }
        String newContent = String.valueOf(content) + ".";
        this.setContent(newContent);
    }

    public void addDigitToDisplay(int digit) {
        String newContent;
        String content = this.getContent();
        if (this.composite.isReadyToEnterNewNumber()) {
            this.setContent(String.valueOf(digit));
            return;
        }
        if (content.length() == 1) {
            if (digit == 0) {
                return;
            }
            newContent = this.getContent().equals("0") ? String.valueOf(digit) : String.valueOf(content) + String.valueOf(digit);
        } else {
            newContent = String.valueOf(content) + String.valueOf(digit);
        }
        this.setContent(newContent);
    }
}

