/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.opal.checkboxgroup;

import org.eclipse.nebula.widgets.opal.commons.SWTGraphicUtil;
import org.eclipse.nebula.widgets.opal.commons.SelectionListenerUtil;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;

public class CheckBoxGroup
extends Canvas
implements PaintListener {
    protected Button button;
    private final Composite content;
    private boolean transparent = false;

    public CheckBoxGroup(Composite parent, int style) {
        super(parent, style);
        super.setLayout((Layout)new GridLayout());
        this.createCheckBoxButton();
        this.content = new Composite((Composite)this, style);
        this.content.setLayoutData((Object)new GridData(4, 4, true, true));
        this.addPaintListener(this);
    }

    private void createCheckBoxButton() {
        this.button = new Button((Composite)this, 32);
        GridData gdButton = new GridData(1, 2, true, false);
        gdButton.horizontalIndent = 15;
        this.button.setLayoutData((Object)gdButton);
        this.button.setSelection(true);
        this.button.setBackground(this.getBackground());
        this.button.pack();
        this.button.addListener(13, e -> {
            e.doit = SelectionListenerUtil.fireSelectionListeners((Control)this, (Event)e);
            if (!e.doit) {
                return;
            }
            if (this.button.getSelection()) {
                this.activate();
            } else {
                this.deactivate();
            }
        });
    }

    public void activate() {
        this.button.setSelection(true);
        SWTGraphicUtil.enableAllChildrenWidgets((Control)this.content);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        SelectionListenerUtil.addSelectionListener((Control)this, (SelectionListener)listener);
    }

    public void deactivate() {
        this.button.setSelection(false);
        SWTGraphicUtil.disableAllChildrenWidgets((Control)this.content);
    }

    public boolean isActivated() {
        return this.button.getSelection();
    }

    public Layout getLayout() {
        return this.content.getLayout();
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        SelectionListenerUtil.removeSelectionListener((Control)this, (SelectionListener)listener);
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.button.setBackground(color);
    }

    public boolean setFocus() {
        return this.content.setFocus();
    }

    public void setLayout(Layout layout) {
        this.content.setLayout(layout);
    }

    public String getText() {
        return this.button.getText();
    }

    public void setText(String text) {
        this.button.setText(text);
    }

    public Font getFont() {
        return this.button.getFont();
    }

    public void setFont(Font font) {
        this.button.setFont(font);
    }

    public Composite getContent() {
        return this.content;
    }

    public boolean isTransparent() {
        return this.transparent;
    }

    public void setTransparent(boolean transparent) {
        this.transparent = transparent;
        if (transparent) {
            this.setBackgroundMode(1);
            this.content.setBackgroundMode(1);
        }
    }

    public void paintControl(PaintEvent paintEvent) {
        if (paintEvent.widget == this) {
            this.drawWidget(paintEvent.gc);
        }
    }

    private void drawWidget(GC gc) {
        Rectangle rect = this.getClientArea();
        int margin = (int)((double)this.button.getSize().y * 1.5);
        int startY = margin / 2;
        gc.setForeground(this.getDisplay().getSystemColor(18));
        gc.drawRoundRectangle(1, startY, rect.width - 2, rect.height - startY - 2, 2, 2);
        gc.setForeground(this.getDisplay().getSystemColor(19));
        gc.drawRoundRectangle(2, startY + 1, rect.width - 4, rect.height - startY - 4, 2, 2);
    }

    public void setSelection(boolean selection) {
        if (selection) {
            this.activate();
        } else {
            this.deactivate();
        }
    }

    public boolean getSelection() {
        return this.isActivated();
    }
}

