/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.tiles;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.nebula.widgets.tiles.DecoratorColor;
import org.eclipse.nebula.widgets.tiles.DecoratorInteger;
import org.eclipse.nebula.widgets.tiles.DecoratorString;
import org.eclipse.nebula.widgets.tiles.Filter;
import org.eclipse.nebula.widgets.tiles.Frame;
import org.eclipse.nebula.widgets.tiles.FrameStatic;
import org.eclipse.nebula.widgets.tiles.FrameTransitionFunction;
import org.eclipse.nebula.widgets.tiles.Tile;
import org.eclipse.nebula.widgets.tiles.Tiles;
import org.eclipse.swt.graphics.Color;

class FrameDynamic<T>
extends Frame<T> {
    private final FrameStatic<T> source;
    private final FrameStatic<T> target;
    private final int defaultWidthSource;
    private final int defaultHeightSource;
    private final int defaultWidthTarget;
    private final int defaultHeightTarget;
    private final Map<T, Tile<T>> targetMap = new HashMap<T, Tile<T>>();
    private final Map<T, Tile<T>> sourceMap = new HashMap<T, Tile<T>>();
    private final List<T> list = new ArrayList<T>();
    private final List<Tile<T>> rendered = new ArrayList<Tile<T>>();
    private Color background;
    private final FrameTransitionFunction transition = new FrameTransitionFunction(1.0, 0.25, 0.0, 0.75);
    protected int time = 0;
    private long previous = 0L;

    FrameDynamic(Tiles<T> tiles, FrameStatic<T> source, FrameStatic<T> target) {
        super(tiles);
        this.source = source;
        this.target = target;
        this.defaultWidthSource = source.getTiles() != null && !source.getTiles().isEmpty() ? source.getTiles().get((int)0).width : 0;
        this.defaultHeightSource = source.getTiles() != null && !source.getTiles().isEmpty() ? source.getTiles().get((int)0).height : 0;
        this.defaultWidthTarget = target.getTiles() != null && !target.getTiles().isEmpty() ? target.getTiles().get((int)0).width : 0;
        this.defaultHeightTarget = target.getTiles() != null && !target.getTiles().isEmpty() ? target.getTiles().get((int)0).height : 0;
        HashSet all = new HashSet();
        for (Tile<T> t : target.getTiles()) {
            this.targetMap.put(t.item, t);
            if (!all.add(t.item)) continue;
            this.list.add(t.item);
        }
        for (Tile<T> t : source.getTiles()) {
            this.sourceMap.put(t.item, t);
            if (!all.add(t.item)) continue;
            this.list.add(t.item);
        }
        this.source.getDecoratorLineWidth().use();
        this.source.getDecoratorLineStyle().use();
        this.source.getDecoratorForegroundColor().use();
        this.source.getDecoratorBackgroundColor().use();
        this.source.getDecoratorLineColor().use();
        this.source.getDecoratorLabel().use();
        this.target.getDecoratorLineWidth().use();
        this.target.getDecoratorLineStyle().use();
        this.target.getDecoratorForegroundColor().use();
        this.target.getDecoratorBackgroundColor().use();
        this.target.getDecoratorLineColor().use();
        this.target.getDecoratorLabel().use();
        this.update();
    }

    @Override
    public void dispose() {
        this.source.getDecoratorLineWidth().free();
        this.source.getDecoratorLineStyle().free();
        this.source.getDecoratorForegroundColor().free();
        this.source.getDecoratorBackgroundColor().free();
        this.source.getDecoratorLineColor().free();
        this.source.getDecoratorLabel().free();
        this.source.dispose();
        this.target.getDecoratorLineWidth().free();
        this.target.getDecoratorLineStyle().free();
        this.target.getDecoratorForegroundColor().free();
        this.target.getDecoratorBackgroundColor().free();
        this.target.getDecoratorLineColor().free();
        this.target.getDecoratorLabel().free();
        this.target.dispose();
    }

    @Override
    public Color getBackground() {
        return this.background;
    }

    public FrameStatic<T> getSource() {
        return this.source;
    }

    public FrameStatic<T> getTarget() {
        return this.target;
    }

    @Override
    public List<Tile<T>> getTiles() {
        return this.rendered;
    }

    public void tick() {
        if (this.previous == 0L) {
            this.previous = System.currentTimeMillis();
        } else {
            this.time = (int)((long)this.time + (System.currentTimeMillis() - this.previous));
            if (this.time > this.tiles.getAnimationSettings().getDuration()) {
                this.tiles.removeFrame();
            }
        }
    }

    @Override
    public void update() {
        double duration = this.tiles.getAnimationSettings().getDuration();
        double factor = (double)this.time / duration;
        factor = factor <= 1.0 ? factor : 1.0;
        factor = this.transition.bezier(factor, duration);
        this.background = this.target.getBackground();
        this.rendered.clear();
        for (T element : this.list) {
            this.rendered.add(this.blend(this.sourceMap.get(element), this.targetMap.get(element), factor));
        }
    }

    private Tile<T> blend(Tile<T> source, Tile<T> target, double factor) {
        String label;
        Color backgroundColor;
        Color foregroundColor;
        Color lineColor;
        int lineStyle;
        int lineWidth;
        Object element;
        double sourcey;
        double sourcex;
        double sourceheight;
        double sourcewidth;
        double targety;
        double targetx;
        double targetheight;
        double targetwidth;
        if (target != null) {
            targetwidth = target.width;
            targetheight = target.height;
            targetx = target.x;
            targety = target.y;
        } else {
            targetwidth = this.defaultWidthTarget;
            targetheight = this.defaultHeightTarget;
            targetx = -this.defaultWidthTarget;
            targety = -this.defaultHeightTarget;
        }
        if (source != null) {
            sourcewidth = source.width;
            sourceheight = source.height;
            sourcex = source.x;
            sourcey = source.y;
        } else {
            sourcewidth = this.defaultWidthSource;
            sourceheight = this.defaultHeightSource;
            sourcex = -this.defaultWidthSource;
            sourcey = -this.defaultHeightSource;
        }
        if (target != null) {
            element = target.item;
            lineWidth = target.lineWidth;
            lineStyle = target.lineStyle;
            lineColor = target.lineColor;
            foregroundColor = target.foregroundColor;
            backgroundColor = target.backgroundColor;
            label = target.label;
        } else {
            element = source.item;
            lineWidth = source.lineWidth;
            lineStyle = source.lineStyle;
            lineColor = source.lineColor;
            foregroundColor = source.foregroundColor;
            backgroundColor = source.backgroundColor;
            label = source.label;
        }
        if (sourcex != targetx) {
            targetx = sourcex * (1.0 - factor) + targetx * factor;
        }
        if (sourcey != targety) {
            targety = sourcey * (1.0 - factor) + targety * factor;
        }
        if (sourcewidth != targetwidth) {
            targetwidth = sourcewidth * (1.0 - factor) + targetwidth * factor;
        }
        if (sourceheight != targetheight) {
            targetheight = sourceheight * (1.0 - factor) + targetheight * factor;
        }
        return new Tile(element, (int)targetx, (int)targety, (int)targetwidth, (int)targetheight, label, lineWidth, lineStyle, lineColor, foregroundColor, backgroundColor);
    }

    @Override
    protected Comparator<T> getComparator() {
        return this.target.getComparator();
    }

    @Override
    protected DecoratorColor<T> getDecoratorBackgroundColor() {
        return this.target.getDecoratorBackgroundColor();
    }

    @Override
    protected DecoratorColor<T> getDecoratorForegroundColor() {
        return this.target.getDecoratorForegroundColor();
    }

    @Override
    protected DecoratorString<T> getDecoratorLabel() {
        return this.target.getDecoratorLabel();
    }

    @Override
    protected DecoratorColor<T> getDecoratorLineColor() {
        return this.target.getDecoratorLineColor();
    }

    @Override
    protected DecoratorInteger<T> getDecoratorLineStyle() {
        return this.target.getDecoratorLineStyle();
    }

    @Override
    protected DecoratorInteger<T> getDecoratorLineWidth() {
        return this.target.getDecoratorLineWidth();
    }

    @Override
    protected Filter<T> getFilter() {
        return this.target.getFilter();
    }

    @Override
    protected List<T> getItems() {
        return new ArrayList<T>(this.target.getItems());
    }
}

