/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.treemapper.examples;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.nebula.widgets.treemapper.examples.XMLNodesComparator;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMTreeContentProvider
implements ITreeContentProvider {
    private Node root;

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.root = (Node)newInput;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof Document) {
            return this.getChildren(((Document)inputElement).getDocumentElement());
        }
        return new Object[]{this.root};
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof Node) {
            return this.getChildren((Node)parentElement);
        }
        return null;
    }

    private Object[] getChildren(Node node) {
        ArrayList<Node> res = new ArrayList<Node>();
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            res.add(children.item(i));
            ++i;
        }
        Collections.sort(res, new XMLNodesComparator());
        return res.toArray();
    }

    public Object getParent(Object element) {
        if (element instanceof Node) {
            return ((Node)element).getParentNode();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof Node) {
            return ((Node)element).getChildNodes().getLength() > 0;
        }
        return false;
    }
}

