/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.opal.starrating.snippets;

import org.eclipse.nebula.widgets.opal.starrating.StarRating;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class StarRatingSnippet {
    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setText("StarRating Snippet");
        shell.setLayout((Layout)new GridLayout(2, false));
        StarRatingSnippet.createHorizontal(shell, true);
        StarRatingSnippet.createHorizontal(shell, false);
        Composite composite = new Composite((Composite)shell, 0);
        composite.setLayout((Layout)new GridLayout(8, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        StarRatingSnippet.createVertical(composite, true);
        StarRatingSnippet.createVertical(composite, false);
        shell.pack();
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    private static void createHorizontal(Shell shell, boolean enabled) {
        StarRating.SIZE[] sIZEArray = StarRating.SIZE.values();
        int n = sIZEArray.length;
        int n2 = 0;
        while (n2 < n) {
            StarRating.SIZE size = sIZEArray[n2];
            Label label = new Label((Composite)shell, 0);
            label.setText("Horizontal " + (enabled ? "enabled" : "disabled") + " size=" + size.toString());
            label.setLayoutData((Object)new GridData(3, 1, false, false));
            StarRating sr = new StarRating((Composite)shell, 0);
            GridData gd = new GridData(1, 1, false, false);
            sr.setLayoutData((Object)gd);
            sr.setSizeOfStars(size);
            sr.setEnabled(enabled);
            sr.setMaxNumberOfStars(5 + (enabled ? 1 : 0));
            ++n2;
        }
    }

    private static void createVertical(Composite composite, boolean enabled) {
        StarRating.SIZE[] sIZEArray = StarRating.SIZE.values();
        int n = sIZEArray.length;
        int n2 = 0;
        while (n2 < n) {
            StarRating.SIZE size = sIZEArray[n2];
            Label label = new Label(composite, 0);
            label.setText("Vertical " + (enabled ? "enabled" : "disabled") + " size=" + size.toString());
            label.setLayoutData((Object)new GridData(3, 1, false, false));
            StarRating sr = new StarRating(composite, 2560);
            sr.setLayoutData((Object)new GridData(1, 1, false, false));
            sr.setSizeOfStars(size);
            sr.setEnabled(enabled);
            sr.setMaxNumberOfStars(5 + (enabled ? 1 : 0));
            ++n2;
        }
    }
}

