/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.paperclips.core.internal.util;

import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.nebula.paperclips.core.PaperClips;
import org.eclipse.nebula.paperclips.core.internal.util.SWTUtil;
import org.eclipse.nebula.paperclips.core.internal.util.Util;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;

public class ResourcePool {
    private static Map<Device, ResourcePool> devices = new WeakHashMap<Device, ResourcePool>();
    private final Device device;
    private final Map<FontData, Font> fonts;
    private final Map<RGB, Color> colors;

    public static synchronized ResourcePool forDevice(Device device) {
        Util.notNull(device);
        ResourcePool.notDisposed(device);
        ResourcePool sharedGraphics = devices.get(device);
        if (sharedGraphics == null) {
            sharedGraphics = new ResourcePool(device);
            devices.put(device, sharedGraphics);
        }
        return sharedGraphics;
    }

    private static void notDisposed(Device device) {
        if (device.isDisposed()) {
            PaperClips.error(45);
        }
    }

    private ResourcePool(Device device) {
        this.device = device;
        this.fonts = new HashMap<FontData, Font>();
        this.colors = new HashMap<RGB, Color>();
    }

    public Font getFont(FontData fontData) {
        if (fontData == null) {
            return null;
        }
        ResourcePool.notDisposed(this.device);
        Font font = this.fonts.get(fontData);
        if (font == null) {
            font = new Font(this.device, fontData);
            this.fonts.put(SWTUtil.copy(fontData), font);
        }
        return font;
    }

    public Color getColor(RGB rgb) {
        if (rgb == null) {
            return null;
        }
        ResourcePool.notDisposed(this.device);
        Color color = this.colors.get(rgb);
        if (color == null) {
            color = new Color(this.device, rgb);
            this.colors.put(SWTUtil.copy(rgb), color);
        }
        return color;
    }
}

