/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.paperclips.widgets;

import org.eclipse.nebula.paperclips.core.PaperClips;
import org.eclipse.nebula.paperclips.core.Print;
import org.eclipse.nebula.paperclips.core.PrintIterator;
import org.eclipse.nebula.paperclips.core.PrintPiece;
import org.eclipse.nebula.paperclips.widgets.PrintPieceCanvas;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class PrintViewer {
    private final ScrolledComposite sc;
    private final PrintPieceCanvas canvas;
    private Print print;
    private int canvasWidth;
    private BackgroundUpdater backgroundUpdater;

    public PrintViewer(Composite parent, int style) {
        this.sc = new ScrolledComposite(parent, style | 0x200 | 0x100);
        this.sc.setExpandHorizontal(true);
        this.sc.setExpandVertical(true);
        this.sc.addListener(11, event -> {
            if (this.sc.getClientArea().width != this.canvasWidth) {
                this.updateCanvas();
            }
        });
        this.canvas = new PrintPieceCanvas((Composite)this.sc, 0x20000000);
        this.sc.setContent((Control)this.canvas);
    }

    public Control getControl() {
        return this.sc;
    }

    public void setPrint(Print print) {
        this.print = print;
        this.updateCanvas();
    }

    public Print getPrint() {
        return this.print;
    }

    void updateCanvas() {
        if (this.print == null) {
            this.sc.setMinSize(0, 0);
            this.canvas.setPrintPiece(null);
            return;
        }
        GC gc = null;
        try {
            PrintPiece piece;
            boolean printIsVerticallyGreedy;
            gc = new GC((Drawable)this.canvas);
            PrintIterator iterator = this.print.iterator((Device)this.canvas.getDisplay(), gc);
            this.sc.setMinWidth(iterator.minimumSize().x);
            int canvasWidth = Math.max(iterator.minimumSize().x, this.sc.getClientArea().width);
            if (this.canvasWidth == canvasWidth) {
                return;
            }
            this.canvasWidth = canvasWidth;
            if (this.backgroundUpdater != null) {
                this.backgroundUpdater.cancelled = true;
                this.backgroundUpdater = null;
            }
            boolean bl = printIsVerticallyGreedy = (piece = PaperClips.next((PrintIterator)iterator, (int)canvasWidth, (int)Integer.MAX_VALUE)) != null && piece.getSize().y == Integer.MAX_VALUE;
            if (printIsVerticallyGreedy) {
                this.backgroundUpdater = new BackgroundUpdater();
                this.sc.getDisplay().timerExec(50, (Runnable)this.backgroundUpdater);
            }
            this.setPrintPiece(piece, !printIsVerticallyGreedy);
        }
        finally {
            if (gc != null) {
                gc.dispose();
            }
        }
    }

    private void setPrintPiece(PrintPiece piece, boolean updateMinHeight) {
        if (updateMinHeight) {
            this.sc.setMinHeight(piece == null ? 0 : piece.getSize().y);
        }
        this.canvas.setPrintPiece(piece);
    }

    private class BackgroundUpdater
    implements Runnable {
        private boolean cancelled = false;
        private int minHeight;
        private int maxHeight;
        private PrintIterator iterator;
        private PrintPiece piece;

        private BackgroundUpdater() {
        }

        @Override
        public void run() {
            if (this.cancelled || PrintViewer.this.print == null) {
                return;
            }
            GC gc = null;
            try {
                gc = new GC((Drawable)PrintViewer.this.canvas);
                this.iterator = PrintViewer.this.print.iterator((Device)PrintViewer.this.canvas.getDisplay(), gc);
                this.piece = PrintViewer.this.canvas.getPrintPiece();
                this.determineValidHeightRange();
                this.binarySearchRangeForSmallestValidHeight();
                PrintViewer.this.setPrintPiece(this.piece, true);
            }
            finally {
                if (gc != null) {
                    gc.dispose();
                }
            }
        }

        private void determineValidHeightRange() {
            PrintPiece testPiece;
            this.minHeight = this.iterator.preferredSize().y;
            this.maxHeight = Math.max(this.minHeight, 4096);
            while (true) {
                PrintIterator testIter = this.iterator.copy();
                testPiece = PaperClips.next((PrintIterator)testIter, (int)PrintViewer.this.canvasWidth, (int)this.maxHeight);
                int factor = 4;
                if (testPiece == null) {
                    this.minHeight = this.maxHeight + 1;
                    this.maxHeight = this.minHeight * 4;
                    continue;
                }
                if (!testIter.hasNext()) break;
                testPiece.dispose();
                this.minHeight = this.maxHeight + 1;
                this.maxHeight = this.minHeight * 4;
            }
            this.piece.dispose();
            this.piece = testPiece;
        }

        private void binarySearchRangeForSmallestValidHeight() {
            while (this.minHeight < this.maxHeight) {
                int testHeight = this.minHeight + (this.maxHeight - this.minHeight) / 2;
                PrintIterator testIter = this.iterator.copy();
                PrintPiece testPiece = PaperClips.next((PrintIterator)testIter, (int)PrintViewer.this.canvasWidth, (int)testHeight);
                if (testPiece == null) {
                    this.minHeight = testHeight + 1;
                    continue;
                }
                if (testIter.hasNext()) {
                    testPiece.dispose();
                    this.minHeight = testHeight + 1;
                    continue;
                }
                this.maxHeight = Math.min(testHeight, testPiece.getSize().y);
                this.piece.dispose();
                this.piece = testPiece;
            }
        }
    }
}

