/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.opal.breadcrumb.snippets;

import org.eclipse.nebula.widgets.opal.breadcrumb.Breadcrumb;
import org.eclipse.nebula.widgets.opal.breadcrumb.BreadcrumbItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class BreadcrumbSnippet {
    private static Image[] images;

    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setText("BreakCrumb Snippet");
        shell.setLayout((Layout)new GridLayout(2, false));
        BreadcrumbSnippet.createImages();
        BreadcrumbSnippet.createLabelsBreadCrumb(shell);
        BreadcrumbSnippet.createButtonsBreadCrumb(shell);
        BreadcrumbSnippet.createButtonsIconsBreadCrumb(shell);
        BreadcrumbSnippet.createToggleButtonsBreadCrumb(shell);
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    private static void createImages() {
        images = new Image[5];
        String[] fileNames = new String[]{"add.png", "bell.png", "feed.png", "house.png", "script.png"};
        int i = 0;
        while (i < 5) {
            Image image;
            BreadcrumbSnippet.images[i] = image = new Image((Device)Display.getCurrent(), BreadcrumbSnippet.class.getResourceAsStream(fileNames[i]));
            ++i;
        }
    }

    private static void createLabelsBreadCrumb(Shell shell) {
        Label label = new Label((Composite)shell, 0);
        label.setText("Label breadcrumb:");
        label.setLayoutData((Object)new GridData(3, 2, false, false));
        BreadcrumbSnippet.createBreadcrumb(shell, 2048, 0x1000000, false);
        new Label((Composite)shell, 0);
        BreadcrumbSnippet.createBreadcrumb(shell, 0, 0x1000000, false);
    }

    private static void createBreadcrumb(Shell shell, int breadCrumbArgument, int itemArgument, boolean showImages) {
        Breadcrumb bc = new Breadcrumb((Composite)shell, breadCrumbArgument);
        bc.setLayoutData((Object)new GridData(1, 2, false, false));
        int i = 1;
        while (i < 5) {
            BreadcrumbItem item = new BreadcrumbItem(bc, itemArgument);
            item.setText("Label " + String.valueOf(i));
            if (showImages) {
                item.setImage(images[i]);
                item.setSelectionImage(images[i]);
            }
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    System.out.println("Click !");
                }
            });
            ++i;
        }
    }

    private static void createButtonsBreadCrumb(Shell shell) {
        Label label = new Label((Composite)shell, 0);
        label.setText("Buttons breadcrumb:");
        label.setLayoutData((Object)new GridData(3, 2, false, false));
        BreadcrumbSnippet.createBreadcrumb(shell, 2048, 0x1000008, false);
        new Label((Composite)shell, 0);
        BreadcrumbSnippet.createBreadcrumb(shell, 0, 0x1000008, false);
    }

    private static void createButtonsIconsBreadCrumb(Shell shell) {
        Label label = new Label((Composite)shell, 0);
        label.setText("Buttons breadcrumb:");
        label.setLayoutData((Object)new GridData(3, 2, false, false));
        BreadcrumbSnippet.createBreadcrumb(shell, 2048, 0x1000008, true);
        new Label((Composite)shell, 0);
        BreadcrumbSnippet.createBreadcrumb(shell, 0, 0x1000008, true);
    }

    private static void createToggleButtonsBreadCrumb(Shell shell) {
        Label label = new Label((Composite)shell, 0);
        label.setText("Toggle buttons breadcrumb:");
        label.setLayoutData((Object)new GridData(3, 2, false, false));
        BreadcrumbSnippet.createBreadcrumb(shell, 2048, 0x1000002, false);
        new Label((Composite)shell, 0);
        BreadcrumbSnippet.createBreadcrumb(shell, 0, 0x1000002, false);
    }
}

