/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.picture.example;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.nebula.examples.AbstractExampleTab;
import org.eclipse.nebula.widgets.picture.PictureControl;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.osgi.framework.Bundle;

public class PictureExampleTab
extends AbstractExampleTab {
    private static final String BUNDLE = "org.eclipse.nebula.widgets.picture.example";

    public Control createControl(Composite parent) {
        Composite body = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        body.setLayout((Layout)layout);
        Label label = new Label(body, 0);
        label.setText("Photo:");
        GridData gridData = new GridData();
        gridData.verticalAlignment = 128;
        label.setLayoutData((Object)gridData);
        Image defaultImage = this.getDefaultPicture((Device)body.getDisplay());
        PictureControl photoControl = this.createPictureControl(parent, defaultImage);
        photoControl.setLayoutData((Object)new GridData(768));
        return body;
    }

    private PictureControl createPictureControl(Composite parent, Image defaultImage) {
        PictureControl photoControl = new PictureControl(parent);
        if (defaultImage != null) {
            photoControl.setDefaultImage(defaultImage);
        }
        return photoControl;
    }

    public void createParameters(Composite parent) {
    }

    public String[] createLinks() {
        String[] links = new String[]{"For mor information please read <a href=\"http://angelozerr.wordpress.com/2012/01/06/nebula_picture/\" >Picture Control Article</a>"};
        return links;
    }

    private Image getDefaultPicture(Device device) {
        try {
            String path = FileLocator.getBundleFile((Bundle)Platform.getBundle((String)BUNDLE)).getPath();
            String EMPTY_PHOTO = path + "/EmptyPhoto.jpg";
            return new Image(device, (InputStream)new FileInputStream(new File(EMPTY_PHOTO)));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

