/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.timeline;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.nebula.widgets.timeline.ICursor;
import org.eclipse.nebula.widgets.timeline.ITimeline;
import org.eclipse.nebula.widgets.timeline.ITimelineEvent;
import org.eclipse.nebula.widgets.timeline.ITimelinePackage;
import org.eclipse.nebula.widgets.timeline.figures.detail.cursor.CursorFigure;
import org.eclipse.nebula.widgets.timeline.jface.TimelineViewer;
import org.eclipse.nebula.widgets.timeline.listeners.ICursorListener;
import org.eclipse.swt.widgets.Display;

public class TimelineDataBinding
extends AdapterImpl
implements ICursorListener,
ISelectionChangedListener {
    private static final long DEFAULT_DISPLAY_UPDATE_DELAY = 300L;
    private final TimelineViewer fViewer;
    private final ITimeline fModel;
    private ViewerRefreshJob fViewerRefresher = null;
    private volatile boolean fIgnoreModelChanges = false;
    private final long fDisplayUpdateDelay;

    public TimelineDataBinding(TimelineViewer viewer, ITimeline model, long displayUpdateDelay) {
        this.fViewer = viewer;
        this.fModel = model;
        this.fDisplayUpdateDelay = displayUpdateDelay;
        this.fViewer.getControl().getRootFigure().addCursorListener(this);
        this.fViewer.addSelectionChangedListener(this);
        this.fModel.eAdapters().add((Object)this);
    }

    public TimelineDataBinding(TimelineViewer viewer, ITimeline model) {
        this(viewer, model, 300L);
    }

    @Override
    public synchronized void notifyCursorCreated(ICursor cursor, CursorFigure figure) {
        this.fIgnoreModelChanges = true;
        this.fModel.getCursors().add((Object)cursor);
        this.fIgnoreModelChanges = false;
    }

    @Override
    public synchronized void notifyCursorDeleted(ICursor cursor) {
        this.fIgnoreModelChanges = true;
        this.fModel.getCursors().remove((Object)cursor);
        this.fIgnoreModelChanges = false;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.fIgnoreModelChanges = true;
        if (event.getStructuredSelection().isEmpty()) {
            this.fModel.setSelectedEvent(null);
        } else if (event.getStructuredSelection().getFirstElement() instanceof ITimelineEvent) {
            this.fModel.setSelectedEvent((ITimelineEvent)event.getStructuredSelection().getFirstElement());
        }
        this.fIgnoreModelChanges = false;
    }

    private synchronized void refreshElement(EObject element) {
        if (!this.fIgnoreModelChanges) {
            this.getUIRefreshJob().addElementForRefresh(element);
        }
    }

    private synchronized void updateElement(EObject element) {
        if (!this.fIgnoreModelChanges) {
            this.getUIRefreshJob().addElementForUpdate(element);
        }
    }

    private synchronized void updateSelection() {
        if (!this.fIgnoreModelChanges) {
            this.getUIRefreshJob().forceSelectionUpdate();
        }
    }

    private ViewerRefreshJob getUIRefreshJob() {
        if (this.fViewerRefresher == null) {
            this.fViewerRefresher = new ViewerRefreshJob();
        }
        return this.fViewerRefresher;
    }

    public void notifyChanged(Notification msg) {
        if (!msg.isTouch()) {
            if (msg.getEventType() == 3) {
                Object value = msg.getNewValue();
                if (value instanceof Notifier) {
                    ((Notifier)value).eAdapters().add((Object)this);
                }
                this.refreshElement((EObject)msg.getNotifier());
            } else if (msg.getEventType() == 4) {
                Object value = msg.getOldValue();
                if (value instanceof Notifier) {
                    ((Notifier)value).eAdapters().remove((Object)this);
                }
                this.refreshElement((EObject)msg.getNotifier());
            } else if (msg.getEventType() == 1) {
                if (msg.getNotifier() instanceof ITimeline && msg.getFeature().equals(ITimelinePackage.eINSTANCE.getTimeline_SelectedEvent())) {
                    this.updateSelection();
                }
                this.updateElement((EObject)msg.getNotifier());
            }
        }
    }

    private class ViewerRefreshJob
    extends Job {
        private final List<EObject> fElementsToRefresh;
        private final List<EObject> fElementsToUpdate;
        private volatile boolean fSelectionUpdate;

        public ViewerRefreshJob() {
            super("Refresh timeline control");
            this.fElementsToRefresh = new ArrayList<EObject>();
            this.fElementsToUpdate = new ArrayList<EObject>();
            this.fSelectionUpdate = false;
            this.setSystem(true);
        }

        public void forceSelectionUpdate() {
            this.fSelectionUpdate = true;
            this.schedule(TimelineDataBinding.this.fDisplayUpdateDelay);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addElementForUpdate(EObject element) {
            List<EObject> list = this.fElementsToUpdate;
            synchronized (list) {
                if (!this.fElementsToUpdate.contains(element)) {
                    this.fElementsToUpdate.add(element);
                    this.schedule(TimelineDataBinding.this.fDisplayUpdateDelay);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addElementForRefresh(EObject element) {
            List<EObject> list = this.fElementsToRefresh;
            synchronized (list) {
                if (!this.fElementsToRefresh.contains(element) && !this.containsParent(element, this.fElementsToRefresh)) {
                    this.fElementsToRefresh.add(element);
                    this.schedule(TimelineDataBinding.this.fDisplayUpdateDelay);
                }
            }
        }

        public IStatus run(IProgressMonitor monitor) {
            IStatus[] result = new IStatus[]{Status.CANCEL_STATUS};
            Display.getDefault().syncExec(() -> {
                ArrayList<EObject> elementsToUpdate;
                ArrayList<EObject> elementsToRefresh;
                List<EObject> list = this.fElementsToRefresh;
                synchronized (list) {
                    elementsToRefresh = new ArrayList<EObject>(this.fElementsToRefresh);
                    this.fElementsToRefresh.clear();
                }
                List<EObject> list2 = this.fElementsToUpdate;
                synchronized (list2) {
                    elementsToUpdate = new ArrayList<EObject>(this.fElementsToUpdate);
                    this.fElementsToUpdate.clear();
                }
                this.minimizeElements(elementsToRefresh, elementsToRefresh);
                this.minimizeElements(elementsToUpdate, elementsToRefresh);
                elementsToUpdate.removeAll(elementsToRefresh);
                for (EObject element : elementsToRefresh) {
                    if (monitor.isCanceled()) {
                        iStatusArray[0] = Status.CANCEL_STATUS;
                        return;
                    }
                    TimelineDataBinding.this.fViewer.refresh(element);
                }
                for (EObject element : elementsToUpdate) {
                    if (monitor.isCanceled()) {
                        iStatusArray[0] = Status.CANCEL_STATUS;
                        return;
                    }
                    TimelineDataBinding.this.fViewer.update(element, null);
                }
                if (this.fSelectionUpdate) {
                    this.fSelectionUpdate = false;
                    ITimelineEvent selectedEvent = TimelineDataBinding.this.fModel.getSelectedEvent();
                    TimelineDataBinding.this.fViewer.setSelection((ISelection)(selectedEvent != null ? new StructuredSelection((Object)selectedEvent) : StructuredSelection.EMPTY));
                }
                iStatusArray[0] = Status.OK_STATUS;
            });
            return result[0];
        }

        private void minimizeElements(Collection<EObject> candidates, Collection<EObject> elementsToRefresh) {
            ArrayList<EObject> copy = new ArrayList<EObject>(candidates);
            while (!copy.isEmpty()) {
                EObject candidate = (EObject)copy.remove(0);
                if (!this.containsParent(candidate, elementsToRefresh)) continue;
                candidates.remove(candidate);
            }
        }

        private boolean containsParent(EObject element, Collection<EObject> scheduledElements) {
            EObject parent = element.eContainer();
            while (parent != null) {
                if (scheduledElements.contains(parent)) {
                    return true;
                }
                parent = parent.eContainer();
            }
            return false;
        }
    }
}

