/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.timeline.figures.detail;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.BorderLayout;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.nebula.widgets.timeline.TimeBaseConverter;
import org.eclipse.nebula.widgets.timeline.Timing;
import org.eclipse.nebula.widgets.timeline.figures.RootFigure;
import org.eclipse.nebula.widgets.timeline.figures.detail.TimeAxisFigure;
import org.eclipse.nebula.widgets.timeline.figures.detail.track.TracksFigure;
import org.eclipse.nebula.widgets.timeline.figures.detail.track.TracksLayer;
import org.eclipse.nebula.widgets.timeline.jface.ITimelineStyleProvider;
import org.eclipse.nebula.widgets.timeline.listeners.DetailAreaListener;

public class DetailFigure
extends Figure {
    private static final int MIN_STEP_SIZE = 120;
    private static final List<Integer> STEP_SIZE_CANDIDATES = Arrays.asList(1, 2, 5, 10, 20, 25, 50, 100);

    public DetailFigure(ITimelineStyleProvider styleProvider) {
        BorderLayout layout = new BorderLayout();
        layout.setHorizontalSpacing(0);
        layout.setVerticalSpacing(0);
        this.setLayoutManager((LayoutManager)layout);
        this.add((IFigure)new TracksFigure(styleProvider), BorderLayout.CENTER);
        this.add((IFigure)new TimeAxisFigure(styleProvider), BorderLayout.BOTTOM);
        new DetailAreaListener(this);
    }

    public Map<Double, Integer> getMarkerPositions() {
        TimeBaseConverter timeViewDetails = RootFigure.getTimeViewDetails((IFigure)this);
        HashMap<Double, Integer> markerPositions = new HashMap<Double, Integer>();
        for (Double eventTime : this.getEventTimeMarkerPositions()) {
            markerPositions.put(eventTime, (int)Math.round(timeViewDetails.toDetailCoordinates(new Timing(eventTime)).getTimestamp()));
        }
        return markerPositions;
    }

    private List<Double> getEventTimeMarkerPositions() {
        long startValue;
        ArrayList<Double> positions = new ArrayList<Double>();
        TimeBaseConverter timeViewDetails = RootFigure.getTimeViewDetails((IFigure)this);
        Timing visibleEventArea = timeViewDetails.getVisibleEventArea();
        double stepSize = this.getStepSize();
        long pos = startValue = (long)((Math.floor(visibleEventArea.left() / stepSize) + 1.0) * stepSize);
        while ((double)pos < visibleEventArea.right()) {
            positions.add(Double.valueOf(pos));
            pos = (long)((double)pos + stepSize);
        }
        return positions;
    }

    private double getStepSize() {
        TimeBaseConverter timeViewDetails = RootFigure.getTimeViewDetails((IFigure)this);
        double steps = Math.max(1, RootFigure.getFigure((IFigure)this, TracksLayer.class).getBounds().width() / 120);
        double stepSizeInEventTime = timeViewDetails.getVisibleEventArea().getDuration() / steps;
        double factor = 1.0;
        while (stepSizeInEventTime >= 100.0) {
            stepSizeInEventTime /= 10.0;
            factor *= 10.0;
        }
        long preliminarySize = Math.round(stepSizeInEventTime);
        int niceStepSize = STEP_SIZE_CANDIDATES.stream().filter(c -> (long)c.intValue() >= preliminarySize).findFirst().get();
        return (double)niceStepSize * factor;
    }
}

