/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.nosql.entities;

import ee.jakarta.tck.nosql.entities.Money;
import ee.jakarta.tck.nosql.entities.MoneyConverter;
import jakarta.nosql.Column;
import jakarta.nosql.Convert;
import jakarta.nosql.Entity;
import jakarta.nosql.Id;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import net.datafaker.Faker;

@Entity
public class Fruit {
    @Id
    private String id;
    @Column
    private String name;
    @Column
    @Convert(value=MoneyConverter.class)
    private Money price;
    @Column
    private Long quantity;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Money getPrice() {
        return this.price;
    }

    public void setPrice(Money price) {
        this.price = price;
    }

    public Long getQuantity() {
        return this.quantity;
    }

    public void setQuantity(Long quantity) {
        this.quantity = quantity;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Fruit fruit = (Fruit)o;
        return Objects.equals(this.id, fruit.id);
    }

    public int hashCode() {
        return Objects.hashCode(this.id);
    }

    public String toString() {
        return "Fruit{id='" + this.id + "', name='" + this.name + "', price=" + String.valueOf(this.price) + ", quantity=" + this.quantity + "}";
    }

    public static Fruit of(Faker faker) {
        Fruit fruit = new Fruit();
        fruit.setId(UUID.randomUUID().toString());
        fruit.setName(faker.food().fruit());
        fruit.setPrice(Money.of(faker));
        fruit.setQuantity(ThreadLocalRandom.current().nextLong(0L, 1000L));
        return fruit;
    }
}

