/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otequinox.turbo;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.objectteams.otequinox.turbo.AspectPermission;
import org.eclipse.objectteams.otequinox.turbo.OTStorageHook;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;

public class ForcedExportsRegistry {
    private static final String FORCED_EXPORTS_DENIED = "otequinox.forced.exports.denied";
    private static final String FORCED_EXPORTS_GRANTED = "otequinox.forced.exports.granted";
    private static final String XFRIENDS = "x-friends:=";
    private static HashMap<String, String> grantedForcedExports = null;
    private static HashMap<String, String> deniedForcedExports = null;
    static FrameworkLog fwLog;

    public static void install(FrameworkLog log) {
        fwLog = log;
        ForcedExportsRegistry.readForcedExports();
    }

    static void logError(String message, Throwable e) {
        fwLog.log(new FrameworkLogEntry(ForcedExportsRegistry.class.getName(), message, 4, e, null));
    }

    static void logError(String message) {
        fwLog.log(new FrameworkLogEntry(ForcedExportsRegistry.class.getName(), message, 4, null, null));
    }

    private static void readForcedExports() {
        deniedForcedExports = new HashMap();
        grantedForcedExports = new HashMap();
        ForcedExportsRegistry.readForcedExportsFromProperty(FORCED_EXPORTS_DENIED, AspectPermission.DENY);
        ForcedExportsRegistry.readForcedExportsFromProperty(FORCED_EXPORTS_GRANTED, AspectPermission.GRANT);
    }

    private static void readForcedExportsFromProperty(String propKey, AspectPermission perm) {
        String value = System.getProperty(propKey);
        if (value != null) {
            if (value.length() > 0 && value.charAt(0) == '@') {
                int pos = 1;
                while (pos < value.length()) {
                    String fileName;
                    int comma = value.indexOf(44, pos);
                    if (comma > -1) {
                        fileName = value.substring(pos, comma);
                        pos = comma + 1;
                    } else {
                        fileName = value.substring(pos);
                        pos = value.length();
                    }
                    ForcedExportsRegistry.parseForcedExportsFile(new File(fileName), perm);
                }
            } else {
                ForcedExportsRegistry.parseForcedExports(value, perm);
            }
        }
    }

    public static void parseForcedExportsFile(File file, int perm) {
        ForcedExportsRegistry.parseForcedExportsFile(file, AspectPermission.values()[perm]);
    }

    private static synchronized void parseForcedExportsFile(File file, AspectPermission perm) {
        StringBuffer newVal = new StringBuffer();
        try {
            FileInputStream fis = new FileInputStream(file);
            Throwable throwable = null;
            Object var5_7 = null;
            try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)fis, "UTF8"));){
                String line;
                boolean afterClosingBrace = false;
                while ((line = br.readLine()) != null) {
                    if ((line = line.trim()).length() <= 0 || line.charAt(0) == '#') continue;
                    char lastReadChar = line.charAt(line.length() - 1);
                    if (afterClosingBrace && lastReadChar != ',') {
                        newVal.append(',');
                    }
                    afterClosingBrace = lastReadChar == ']';
                    newVal.append(line);
                }
                if (newVal.length() > 0) {
                    ForcedExportsRegistry.parseForcedExports(newVal.toString(), perm);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            fwLog.log(new FrameworkLogEntry(OTStorageHook.class.getName(), "failed to read forcedExports file " + file.getName(), 4, (Throwable)e, null));
        }
    }

    private static void parseForcedExports(String value, AspectPermission perm) {
        HashMap<String, String> map = ForcedExportsRegistry.getForcedExportsMap(perm);
        if (map == null) {
            return;
        }
        int pos = 0;
        String[] values = new String[2];
        while (true) {
            pos = ForcedExportsRegistry.getForcedExportForOneBase(value, pos, values);
            String plugin = values[0];
            String pack = values[1];
            if (map.containsKey(plugin)) {
                String oldPack = map.get(plugin);
                pack = String.valueOf(oldPack) + ',' + pack;
            }
            map.put(plugin, pack);
            if (pos >= value.length()) break;
            if (value.charAt(pos) != ',') {
                ForcedExportsRegistry.throwSyntaxError(value, pos, "missing ','");
            }
            ++pos;
        }
    }

    private static int getForcedExportForOneBase(String spec, int start, String[] values) {
        int close;
        int open = spec.indexOf(91, start);
        if (open == -1) {
            ForcedExportsRegistry.throwSyntaxError(spec, start, "missing '['");
        }
        if ((close = spec.indexOf(93, start)) == -1) {
            ForcedExportsRegistry.throwSyntaxError(spec, open, "missing ']'");
        }
        values[0] = spec.substring(start, open);
        values[1] = spec.substring(open + 1, close);
        return close + 1;
    }

    private static void throwSyntaxError(String spec, int pos, String string) {
        throw new RuntimeException("Illegal syntax in 'forcedExports' directive at position " + pos + " (not counting whitespace): " + string + "\n value is:\n" + spec);
    }

    private static HashMap<String, String> getForcedExportsMap(AspectPermission perm) {
        switch (perm) {
            case GRANT: {
                return grantedForcedExports;
            }
            case DENY: {
                return deniedForcedExports;
            }
            case UNDEFINED: {
                return null;
            }
        }
        throw new IncompatibleClassChangeError("enum " + AspectPermission.class.getName() + " has changed unexpectedly.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getGrantedForcedExportsByBase(String baseBundleId) {
        Class<OTStorageHook> clazz = OTStorageHook.class;
        synchronized (OTStorageHook.class) {
            if (grantedForcedExports == null) {
                ForcedExportsRegistry.readForcedExports();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            String exports = grantedForcedExports.get(baseBundleId);
            if (exports != null && !exports.contains(XFRIENDS)) {
                grantedForcedExports.remove(baseBundleId);
                ForcedExportsRegistry.logError("config.ini: missing x-friends directive in forced export of " + exports);
                return null;
            }
            return exports;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String[]> getForcedExportsByAspect(String aspectBundleId, int perm) {
        Class<OTStorageHook> clazz = OTStorageHook.class;
        synchronized (OTStorageHook.class) {
            if (grantedForcedExports == null) {
                ForcedExportsRegistry.readForcedExports();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            ArrayList<String[]> result = new ArrayList<String[]>(5);
            HashMap<String, String> map = ForcedExportsRegistry.getForcedExportsMap(AspectPermission.values()[perm]);
            if (map == null) {
                return result;
            }
            block3: for (Map.Entry<String, String> entry : map.entrySet()) {
                String export = entry.getValue();
                int start = 0;
                while (start >= 0 && start < export.length()) {
                    int pos;
                    if (start > 0) {
                        if (export.charAt(start) == ',') {
                            ++start;
                        } else {
                            ForcedExportsRegistry.logError("Error parsing forced exports: " + export + ", comma expected at position " + start);
                        }
                    }
                    if ((pos = export.indexOf(";x-friends:=", start)) == -1) continue block3;
                    String packageName = export.substring(start, pos);
                    ArrayList<String> aspectBundles = new ArrayList<String>();
                    start = ForcedExportsRegistry.scanAspectBundles(export, pos + XFRIENDS.length() + 1, aspectBundles);
                    for (String aspect : aspectBundles) {
                        if (!aspect.equals(aspectBundleId)) continue;
                        result.add(new String[]{entry.getKey(), packageName});
                    }
                }
            }
            return result;
        }
    }

    private static int scanAspectBundles(String export, int pos, List<String> result) {
        String termChars = ",]";
        if (export.charAt(pos) == '\"') {
            ++pos;
            termChars = "\"";
        }
        int start = pos;
        while (pos < export.length()) {
            char c = export.charAt(pos);
            switch (c) {
                case '\"': 
                case ',': 
                case ']': {
                    String next = export.substring(start, pos);
                    result.add(next);
                    start = pos + 1;
                    if (termChars.indexOf(c) == -1) break;
                    return start;
                }
            }
            ++pos;
        }
        ForcedExportsRegistry.logError("Unterminated forced exports: " + export);
        if (pos > start) {
            result.add(export.substring(start));
        }
        return export.length();
    }
}

